document.addEventListener("DOMContentLoaded", () => {
  const decos = document.querySelectorAll(".deco");
  const vagues = Array.from(document.querySelectorAll(".vague"));
  if (!decos.length && !vagues.length) return;

  // Séparer les vagues "background" (CSS) et les vagues "éléments" (img, svg) que l'on peut transformer en JS
  const vaguesWithBg = vagues.filter(v => {
    try {
      const bg = getComputedStyle(v).backgroundImage;
      return bg && bg !== 'none';
    } catch (e) {
      return false;
    }
  });

  const vaguesNoBg = vagues.filter(v => !vaguesWithBg.includes(v));

  // Si certaines vagues ont un background, on supprime toute transform inline résiduelle
  vaguesWithBg.forEach(v => {
    v.style.transform = ""; // reset si ancien JS a laissé une transform inline
  });

  let lastScrollY = window.scrollY;
  let rotation = 0;
  let ticking = false;

  function update() {
    ticking = false;
    const currentScrollY = window.scrollY;
    const delta = currentScrollY - lastScrollY;

    // --- Rotation des .deco (inchangé) ---
    rotation += delta * 0.5;
    decos.forEach(deco => {
      deco.style.transform = `rotate(${rotation}deg)`;
    });

    // --- Déplacement horizontal des .vague qui SONT des éléments (img/svg) ---
    // On n'applique PAS de transform JS sur les vagues qui ont un background (CSS gère ces dernières).
    const waveSpeed = 0.5;
    const translateX = currentScrollY * waveSpeed;
    vaguesNoBg.forEach(vague => {
      vague.style.transform = `translateX(${translateX}px)`;
    });

    lastScrollY = currentScrollY;
  }

  function onScroll() {
    if (!ticking) {
      window.requestAnimationFrame(update);
      ticking = true;
    }
  }

  window.addEventListener("scroll", onScroll, { passive: true });

const faqSections = document.querySelectorAll(".schema-faq .schema-faq-section");

faqSections.forEach(section => {
  const question = section.querySelector(".schema-faq-question");
  if (!question) return;

  question.addEventListener("click", () => {
    section.classList.toggle("is-open");
  });
});


  
});
