<?php
/**
 * Activation / Deactivation
 *
 * @version     1.0
 * @package     Booking Calendar
 * @subpackage  Activation / Deactivation
 * @category    Functions
 * @author      wpdevelop
 *
 * @web-site    https://wpbookingcalendar.com/
 * @email       info@wpbookingcalendar.com
 * @modified    2025-06-06
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}                                             // Exit if accessed directly


/** Activation  & Deactivation  of Booking Calendar  */
class WPBC_BookingInstallPro {


	/**
	 * Init option
	 *
	 * @var array
	 */
	private $init_option;


	/**
	 * Constructor
	 */
	public function __construct() {

		add_action( 'init', array( $this, 'init' ) );
		// $this->init();
	}

	public function init() {

		if ( ! class_exists( 'WPBC_Action_Scheduler_Compatibility' ) ) {
			return;
		}

		add_bk_action( 'wpdev_booking_activate_user', array( $this, 'wpbc_activate' ) );  // Hook  for MU User activation.

		$this->init_option = array(
			'option-version_num'                 => 'booking_pro_version_num',
			'option-is_delete_if_deactive'       => 'booking_is_delete_if_deactive',
			'option-activation_process'          => 'booking_pro_activation_process',
			'transient-wpbc_activation_redirect' => '_booking_pro_activation_redirect',
			'message-delete_data'                => '<strong>' . 'Warning!' . '</strong> ' . 'All booking data will be deleted when the plugin is deactivated.' . '<br />' . sprintf( 'If you want to save your booking data, please uncheck the %s"Delete booking data"%s at the', '<strong>', '</strong>' ) . '<a href="' . esc_url( admin_url( add_query_arg( array( 'page' => 'wpbc-settings' ), 'admin.php' ) ) ) . '&scroll_to_section=wpbc_general_settings_uninstall_tab"> ' . 'settings page' . '.' . ' </a>',
			'link_settings'                      => '<a class="wpbc_plugins_links__settings" href="' . esc_url( admin_url( add_query_arg( array( 'page' => 'wpbc-settings' ), 'admin.php' ) ) ) . '">' . "Settings" . '</a>',
			'link_whats_new'                     => '<a title="' . "Check new functionality in this plugin update." . '" href="' . esc_url( admin_url( add_query_arg( array( 'page' => 'wpbc-about' ), 'index.php' ) ) ) . '">' . "What's New" . '</a>',
			'link_faq'                           => '<a title="FAQ" href="https://wpbookingcalendar.com/faq/">FAQ</a>',
			'link_up'                            => '<a title="Check Pro functionality" href="https://wpbookingcalendar.com/features/#link_up" style="color: rgb(0, 163, 42);font-weight:700;">Get Pro</a>',
			'link_upgrade'                       => '<a title="Upgrade to higher version" href="' . esc_url( admin_url( add_query_arg( array(
					'page' => 'wpbc-settings',
					'tab'  => 'upgrade',
				), 'admin.php' ) ) ) . '" style="color: rgb(0, 163, 42);font-weight:700;">Get More</a>',
		);


		// WordPress > Plugins > "Activate" link.
		register_activation_hook( WPBC_PRO_FILE, array( $this, 'wpbc_activate_initial' ) );

		// WordPress > Plugins > "Deactivate" link.
		register_deactivation_hook( WPBC_PRO_FILE, array( $this, 'wpbc_deactivate' ) );

		// Upgrade during bulk upgrade of plugins.
		add_filter( 'upgrader_post_install', array( $this, 'wpbc_install_in_bulk_upgrade' ), 10, 2 );

		// Settings link at the plugin page.
		add_filter( 'plugin_action_links', array( $this, 'plugin_links' ), 10, 2 );

		// Warning message in plugin info.
		add_filter( 'plugin_row_meta', array( $this, 'plugin_row_meta' ), 10, 4 );

		add_filter( 'all_plugins', array( 'WPBC_BookingInstallPro', 'modify_plugin_description' ) );

		$this->check_if_need_to_update();                                                                  // Check upgrade, if was no activation process

	}


	public static function modify_plugin_description( $all_plugins ) {

		if ( isset( $all_plugins['booking-calendar-com/booking-calendar-com.php'] ) ) {
			/**
			 * [Name] => Booking Calendar Pro
			 * [PluginURI] => https://wpbookingcalendar.com/demo/
			 * [Version] => 11.0.1
			 * [Description] => Premium version of Booking Calendar plugin.
			 * [Author] => wpdevelop, oplugins
			 * [AuthorURI] => https://wpbookingcalendar.com/
			 * [TextDomain] => booking
			 * [DomainPath] => /languages/
			 * [Network] =>
			 * [RequiresWP] =>
			 * [RequiresPHP] =>
			 * [UpdateURI] =>
			 * [RequiresPlugins] => booking
			 * [Title] => Booking Calendar Pro
			 * [AuthorName] => wpdevelop, oplugins
			 */

			if ( function_exists( 'wpbc_get_plugin_version_title' ) ) {
				$all_plugins['booking-calendar-com/booking-calendar-com.php']['Name'] .= ' - ' . wpbc_get_plugin_version_title();
			}

			// $all_plugins['booking-calendar-com/booking-calendar-com.php']['Description'] = __( 'To get started, just go to <a href="admin.php?page=akismet-key-config">your Akismet Settings page</a> to set up your API key.', 'akismet' );
		}

		return $all_plugins;
	}


	/** Check if was updated from lower to  high version */
	public function is_update_from_lower_to_high_version() {

		$is_make_activation = false;

		// Check  conditions for different version about Upgrade
		if ( ( class_exists( 'wpdev_bk_personal' ) ) && ( ! wpbc_is_table_exists( 'bookingtypes' ) ) ) {
			$is_make_activation = true;
		}
		if ( ( ! $is_make_activation ) && ( class_exists( 'wpdev_bk_biz_s' ) ) && ( wpbc_is_field_in_table_exists( 'bookingtypes', 'cost' ) == 0 ) ) {
			$is_make_activation = true;
		}
		// FixIn: 9.9.0.13.
		if ( ( ! $is_make_activation ) && ( class_exists( 'wpdev_bk_biz_m' ) ) && ( ! wpbc_is_table_exists( 'booking_seasons' ) ) ) {
			$is_make_activation = true;
		}
		if ( ( ! $is_make_activation ) && ( class_exists( 'wpdev_bk_biz_l' ) ) && ( ! wpbc_is_table_exists( 'booking_coupons' ) ) ) {
			$is_make_activation = true;
		}
		if ( ( ! $is_make_activation ) && ( class_exists( 'wpdev_bk_multiuser' ) ) && ( wpbc_is_field_in_table_exists( 'booking_coupons', 'users' ) == 0 ) ) {
			$is_make_activation = true;
		}

		return $is_make_activation;
	}


	// -----------------------------------------------------------------------------------------------------------------
	// Update info of plugin at the plugins section.
	// -----------------------------------------------------------------------------------------------------------------

    /** Update info of plugin at the plugins section */
	function plugin_row_meta( $plugin_meta, $plugin_file, $plugin_data, $context ) {

		$this_plugin = plugin_basename( WPBC_PRO_FILE );

		if ( $plugin_file === $this_plugin ) {

			$is_delete_if_deactive = get_bk_option( $this->init_option['option-is_delete_if_deactive'] );

			if ( 'On' === $is_delete_if_deactive ) { ?>
				<div class="plugin-update-tr">
					<div class="update-message notice inline notice-warning notice-altNO"
						 style="font-size: 1em;line-height: 2em;margin:0 5px 10px;border-left: 3px solid #dd7000;"><?php
						// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						echo $this->init_option['message-delete_data']; ?></div>
				</div>
				<?php
			}

			if ( function_exists( 'wpbc_get_plugin_version_title' ) ) {
				$version = wpbc_get_plugin_version_title();
			} else {
				$version = ' --- ';
			}


			$plugin_meta[0] .= ' | ' . __( 'Version type', 'booking' ) . ': <strong>' . ucfirst( $version ) . '</strong>';

			/*
			[$plugin_meta] => Array
				(
					[0] => Version 2.8.35
					[1] => By wpdevelop
					[2] => Visit plugin site
				)

			[$plugin_file] => booking/WPBC.php
			[$plugin_data] => Array
				(
					[Name] => Booking Calendar
					[PluginURI] => https://wpbookingcalendar.com/demo/
					[Version] => 2.8.35
					[Description] => Online booking and availability checking service for your site.
					[Author] => wpdevelop
					[AuthorURI] => https://wpbookingcalendar.com/
					[TextDomain] =>
					[DomainPath] =>
					[Network] =>
					[Title] => Booking Calendar
					[AuthorName] => wpdevelop
				)

			[$context] => all
			/**/

			// Echo plugin description here.
			return $plugin_meta;

		} else {
			return $plugin_meta;
		}
	}


	/**
	 * Adds Settings link to plugins settings.
	 *
	 * @param array  $links - array  of links.
	 * @param string $file  - file plugin basename.
	 *
	 * @return array|mixed
	 */
	public function plugin_links( $links, $file ) {

		$this_plugin = plugin_basename( WPBC_PRO_FILE );

		if ( $file === $this_plugin ) {

			 //. esc_url( admin_url( add_query_arg( array( 'page' => 'wpbc-about' ), 'index.php' ) ) ) //.
			array_unshift(
				$links,
				'<a class="wpbc_plugins_links__start_tour" title="' . esc_attr( __( 'Request Update', 'booking' ) ) . '" href="' . esc_url( 'https://wpbookingcalendar.com/request-update/' ) . '">' . esc_attr__( 'Request Update', 'booking' ) . '</a>'
			);


			if ( ! class_exists( 'wpdev_bk_personal' ) ) {
				array_unshift( $links, $this->init_option['link_up'] );
			} elseif ( ! class_exists( 'wpdev_bk_multiuser' ) ) {
				array_unshift( $links, $this->init_option['link_upgrade'] );
			}
		}

		return $links;
	}


	/**
	 * Check  about ability to upgrade, if was no activation  process
	 *
	 * @return void
	 */
	private function check_if_need_to_update() {

		if ( is_admin() ) {

			$wpbc_version_num = get_option( $this->init_option['option-version_num'] );

			if ( false === $wpbc_version_num ) {
				$wpbc_version_num = '0';
			}

			$is_make_activation = false;

			if ( version_compare( WPBC_PRO_VERSION_NUM, $wpbc_version_num ) > 0 ) {

				$is_make_activation = true;

			} else {

				// Check if we was update from free to paid or from lower to higher versions, and do not make normal activation. In this case we need to make update.
				$is_make_activation = $this->is_update_from_lower_to_high_version();

			}

			// Add hook  for initial activation.
			if ( $is_make_activation ) {
				// add_action( 'plugins_loaded', array( $this, 'wpbc_activate_initial' ), 1050 ); //.

				// because this function  called on  the hook: 'init'  that  executed after  the  'plugins_loaded'.
				$this->wpbc_activate_initial();
			}
		}
	}


	/**
	 * Upgrade during bulk upgrade of plugins
	 *
	 * @param type $return_val
	 * @param type $hook_extra
	 *
	 * @return type
	 */
	public function wpbc_install_in_bulk_upgrade( $return_val, $hook_extra ) {

		if ( is_wp_error( $return_val ) ) {
			return $return_val;
		}

		if ( isset( $hook_extra ) ) {
			if ( isset( $hook_extra['plugin'] ) ) {
				$file_name = basename( WPBC_PRO_FILE );
				$pos       = strpos( $hook_extra['plugin'], trim( $file_name ) );
				if ( false !== $pos ) {
					$this->wpbc_activate();
				}
			}
		}

		return $return_val;
	}


	/**
	 * User clicked on "Activate" link at Plugins Menu.
	 *
	 * @return type
	 */
	public function wpbc_activate_initial() {

		// Activate the plugin.
		$this->wpbc_activate();

		// Bail if this demo or activating from network, or bulk.
		if ( is_network_admin() || isset( $_GET['activate-multi'] ) || wpbc_is_this_demo() ) {  // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
			return;
		}

		// Add the transient to redirect - Showing Welcome screen.
		set_transient( $this->init_option['transient-wpbc_activation_redirect'], true, 30 );
	}

	// -----------------------------------------------------------------------------------------------------------------

	/**
	 * Run Activate
	 */
	public function wpbc_activate() {


		WPBC_Action_Scheduler_Compatibility::raise_memory_limit();
		WPBC_Action_Scheduler_Compatibility::raise_time_limit( 300 );
		update_bk_option( $this->init_option['option-activation_process'], 'On' );


		make_bk_action( 'wpbc_before_activation' );

		wpbc_load_translation();

		make_bk_action( 'wpbc_other_versions_activation' );

		// -------------------------------------------------------------------------------------------------------------
		// Examples in demos
		// -------------------------------------------------------------------------------------------------------------
		$is_demo = wpbc_is_this_demo();
		if ( $is_demo ) {
			wpbc_pro_create_examples_4_demo();
		}


		// Fill Development server by initial bookings.
		if (
			( defined( 'WP_BK_BETA_DATA_FILL' ) ) &&
			( WP_BK_BETA_DATA_FILL > 0 ) &&
			( isset( $_SERVER['HTTP_HOST'] ) ) &&
			(
				( 'beta' === $_SERVER['HTTP_HOST'] ) ||
				( 'freetest.wpbookingcalendar.com' === $_SERVER['HTTP_HOST'] )
			)
		) {
			$types_array = array();
			for ( $i = 0; $i < WP_BK_BETA_DATA_FILL; $i++ ) {
				foreach ( range( 1, 12 ) as $types_el ) {
					$types_array[] = $types_el;
				}
			}
			wpbc_pro_create_examples_4_demo( $types_array );
		}

		update_bk_option( $this->init_option['option-version_num'], WPBC_PRO_VERSION_NUM );
		update_bk_option( $this->init_option['option-activation_process'], 'Off' );
	}


	/**
	 * Run Deactivate
	 */
	public function wpbc_deactivate() {

		WPBC_Action_Scheduler_Compatibility::raise_memory_limit();
		WPBC_Action_Scheduler_Compatibility::raise_time_limit( 300 );

		$is_delete_if_deactive = get_bk_option( $this->init_option['option-is_delete_if_deactive'] ); // check.

		if ( 'On' === $is_delete_if_deactive ) {

			//make_bk_action( 'wpbc_deactivation' );                              // F I N I S H.
			make_bk_action( 'wpbc_other_versions_deactivation' );

			delete_bk_option( $this->init_option['option-version_num'] );

			delete_bk_option( $this->init_option['option-activation_process'] );
		}
	}

}


// <editor-fold     defaultstate="collapsed"                        desc=" Examples Data for Demos "  >

function wpbc_pro_create_examples_4_demo( $my_bk_types = array() ){

	global $wpdb;
	$version = wpbc_get_plugin_version_type();

        if (class_exists('wpdev_bk_multiuser')) {

	        if ( empty( $my_bk_types ) ) {
		        $my_bk_types = array( 13, 14, 15, 16, 17 );	// The booking resources with these IDs are exist in the Demo sites
	        } else {
		        shuffle( $my_bk_types );
	        }

			// Get NUMBER of Bookings.
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
			$bookings_count = $wpdb->get_results( "SELECT COUNT(*) as count FROM {$wpdb->prefix}booking as bk WHERE bk.trash != 1" );

          if (count($bookings_count)>0)   $bookings_count = $bookings_count[0]->count ;
          if ($bookings_count>=20) return;

			if ( ( ( defined( 'WP_BK_BETA_DATA_FILL_AS' ) ) && ( 'BL' === WP_BK_BETA_DATA_FILL_AS ) ) && ( isset( $_SERVER['HTTP_HOST'] ) ) && ( 'beta' === $_SERVER['HTTP_HOST'] ) ) {
				update_bk_option( 'booking_range_selection_time_is_active', 'On' );
				update_bk_option( 'booking_range_selection_start_time', '14:00' );
				update_bk_option( 'booking_range_selection_end_time', '12:00' );

				update_bk_option( 'booking_is_delete_if_deactive', 'On');
			}

			$max_num_bookings = 5;                                                        // How many bookings exist  per resource
          foreach ($my_bk_types as $resource_id) {                                     // Loop all resources
                $bk_type  = $resource_id;                                              // Booking Resource

	          if ( ( ( defined( 'WP_BK_BETA_DATA_FILL_AS' ) ) && ( 'BL' === WP_BK_BETA_DATA_FILL_AS ) ) && ( isset( $_SERVER['HTTP_HOST'] ) ) && ( 'beta' === $_SERVER['HTTP_HOST'] ) ) {
		          $min_days = 3;
		          $max_days = 7;
	          } else {
		          $min_days = 1;        // FixIn: 10.0.0.51.
		          $max_days = 1;        // FixIn: 10.0.0.51.
	          }

	          $evry_one         = $max_days + wp_rand( 1, 5 );                                                  // Multiplier of interval between 2 dates of different bookings
	          $days_start_shift = wp_rand( $max_days, ( 90 * $max_days ) );//(ceil($max_num_bookings/2)) * $max_days;           // How long far ago we are start bookings

	          // Fill Development server by initial bookings
	          if ( ( ( defined( 'WP_BK_BETA_DATA_FILL' ) ) && ( WP_BK_BETA_DATA_FILL > 0 ) ) && ( isset( $_SERVER['HTTP_HOST'] ) ) && ( 'beta' === $_SERVER['HTTP_HOST'] ) ) {
		          $evry_one         = $min_days + wp_rand( 1, 7 );//3*$max_days+wp_rand(1,7);                                                  // Multiplier of interval between 2 dates of different bookings
		          $days_start_shift = wp_rand( 2 * $max_days, ( 5 * $max_days ) );  //wp_rand(2*$max_days,(5*$max_days));//(ceil($max_num_bookings/2)) * $max_days;           // How long far ago we are start bookings
	          }

	          for ( $i = 0; $i < $max_num_bookings; $i ++ ) {

                $is_appr  = wp_rand(0,1);                                                  // Pending | Approved
                $num_days = wp_rand($min_days,$max_days);                                  // Max Number of Dates for specific booking

                $second_name = wpbc_pro_get_initial_values_4_demo('second_name');
                $city =  wpbc_pro_get_initial_values_4_demo('city');
	            if ( ( ( defined( 'WP_BK_BETA_DATA_FILL_AS' ) ) && ( 'BL' === WP_BK_BETA_DATA_FILL_AS ) ) && ( isset( $_SERVER['HTTP_HOST'] ) ) && ( 'beta' === $_SERVER['HTTP_HOST'] ) ) {
		            $start_time = '14:00';
		            $end_time   = '12:00';
	            } else {
		            $range_time = wpbc_pro_get_initial_values_4_demo( 'rangetime' );        // FixIn: 10.0.0.51.
		            $start_time = $range_time[0];        // FixIn: 10.0.0.51.
		            $end_time   = $range_time[1];        // FixIn: 10.0.0.51.
	            }

                $form  = '';
                	$form .= 'selectbox-one^rangetime'.$bk_type.'^'.$start_time.' - '.$end_time.'~';
                $form .= 'text^name'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('name').'~';
                $form .= 'text^secondname'.$bk_type.'^'.$second_name.'~';
                $form .= 'text^email'.$bk_type.'^'.$second_name.'.example@wpbookingcalendar.com~';
                $form .= 'text^address'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('adress').'~';
                $form .= 'text^city'.$bk_type.'^'.$city[0].'~';
                $form .= 'text^postcode'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('postcode').'~';
                $form .= 'text^country'.$bk_type.'^'.$city[1].'~';
                $form .= 'text^phone'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('phone').'~';
                $form .= 'selectbox-one^visitors'.$bk_type.'^1~';
                //$form .= 'checkbox^children'.$bk_type.'[]^0~';
                $form .= 'textarea^details'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('info').'~';
                $form .= 'coupon^coupon'.$bk_type.'^ ';


                $wp_bk_querie = "INSERT INTO {$wpdb->prefix}booking ( form, booking_type, cost, hash, modification_date ) VALUES
                                                   ( '".$form."', ".$bk_type .", ".wp_rand(0,1000).", MD5('". time() . '_' . wp_rand(1000,1000000)."'), " . wpbc_sql_date_math_expr_explicit('', 'now') . " ) ;";
				// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
				$wpdb->query( $wp_bk_querie );
                $temp_id = $wpdb->insert_id;

                $wp_queries_sub = "INSERT INTO {$wpdb->prefix}bookingdates (
                                     booking_id,
                                     booking_date,
                                     approved
                                    ) VALUES ";
                for ($d_num = 0; $d_num < $num_days; $d_num++) {
                    $my_interval = ( $i*$evry_one + $d_num);

	                if ( ( ( defined( 'WP_BK_BETA_DATA_FILL_AS' ) ) && ( 'BL' === WP_BK_BETA_DATA_FILL_AS ) ) && ( isset( $_SERVER['HTTP_HOST'] ) ) && ( 'beta' === $_SERVER['HTTP_HOST'] ) ) {

		                if ( 'On' !== get_bk_option( 'booking_range_selection_time_is_active' ) ) {
			                $wp_queries_sub .= "( " . $temp_id . ", DATE_ADD(CURDATE(), INTERVAL  -" . $days_start_shift . " day) + INTERVAL " . $my_interval . " day  ," . $is_appr . " ),";
		                } else {
			                if ( $d_num == 0 ) {                                       // Check In
				                $wp_queries_sub .= "( " . $temp_id . ", DATE_ADD(CURDATE(), INTERVAL  -" . $days_start_shift . " day) + INTERVAL \"" . $my_interval . " " . $start_time . ":01\" DAY_SECOND  ," . $is_appr . " ),";
			                } elseif ( $d_num == ( $num_days - 1 ) ) {                   // Check Out
				                $wp_queries_sub .= "( " . $temp_id . ", DATE_ADD(CURDATE(), INTERVAL -" . $days_start_shift . " day) + INTERVAL \"" . $my_interval . " " . $end_time . ":02\" DAY_SECOND  ," . $is_appr . " ),";
			                } else {
				                $wp_queries_sub .= "( " . $temp_id . ", DATE_ADD(CURDATE(), INTERVAL  -" . $days_start_shift . " day) + INTERVAL " . $my_interval . " day  ," . $is_appr . " ),";
			                }
		                }
	                } else {
		                $wp_queries_sub .= "( " . $temp_id . ", DATE_ADD(CURDATE(), INTERVAL -" . $days_start_shift . " DAY) + INTERVAL \"" . $my_interval . " " . $start_time . ":01\" DAY_SECOND  ," . $is_appr . " ),";        	// FixIn: 10.0.0.51.
		                $wp_queries_sub .= "( " . $temp_id . ", DATE_ADD(CURDATE(), INTERVAL -" . $days_start_shift . " DAY) + INTERVAL \"" . $my_interval . " " . $end_time . ":02\" DAY_SECOND  ," . $is_appr . " ),";        	// FixIn: 10.0.0.51.
	                }
                }
                $wp_queries_sub = substr($wp_queries_sub,0,-1) . ";";

				// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
				$wpdb->query( $wp_queries_sub );
             }
          }
        } else if ( $version == 'free' ) {
             if (empty($my_bk_types))   $my_bk_types=array(1,1);
             else                       shuffle($my_bk_types);

             for ($i = 0; $i < count($my_bk_types); $i++) {

				 $bk_type  = 1;
				 $is_appr  = wp_rand( 0, 1 );
				 $evry_one = 2;
				 if ( ( isset( $_SERVER['HTTP_HOST'] ) ) && ( ( 'beta' === $_SERVER['HTTP_HOST'] ) || ( 'freetest.wpbookingcalendar.com' === $_SERVER['HTTP_HOST'] ) ) ) {
					 $evry_one         = wp_rand( 1, 21 );
					 $num_days         = wp_rand( 1, 10 );
					 $days_start_shift = - 1 * wp_rand( 0, 28 );
				 }


                $second_name = wpbc_pro_get_initial_values_4_demo('second_name');
                $form  = '';
                $form .= 'text^name'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('name').'~';
                $form .= 'text^secondname'.$bk_type.'^'.$second_name.'~';
                $form .= 'text^email'.$bk_type.'^'.$second_name.'.example@wpbookingcalendar.com~';
                $form .= 'text^phone'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('phone').'~';
                $form .= 'textarea^details'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('info');

                $wp_bk_querie = "INSERT INTO {$wpdb->prefix}booking ( form, modification_date ) VALUES ( '".$form."', " . wpbc_sql_date_math_expr_explicit('', 'now') . "  ) ;";
				// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
				$wpdb->query( $wp_bk_querie );
                $temp_id = $wpdb->insert_id;
                $wp_queries_sub = "INSERT INTO {$wpdb->prefix}bookingdates (
                                     booking_id,
                                     booking_date,
                                     approved
                                    ) VALUES ";

                if ( ( 'beta' === $_SERVER['HTTP_HOST'] ) || ( 'freetest.wpbookingcalendar.com' === $_SERVER['HTTP_HOST'] ) ) {
                    for ($d_num = 0; $d_num < $num_days; $d_num++) {
						$wp_queries_sub .= "( " . $temp_id . ", " . wpbc_sql_date_math_expr_explicit( "+ INTERVAL " . ( $days_start_shift + 2 * ( $i + 1 ) * $evry_one + $d_num ) . " DAY", 'curdate' ) . " ," . $is_appr . " ),";
                    }
                    $wp_queries_sub = substr($wp_queries_sub,0,-1) . ";";
                } else {
					$wp_queries_sub .= "( " . $temp_id . ", " . wpbc_sql_date_math_expr_explicit( "+ INTERVAL " . ( 2 * ( $i + 1 ) * $evry_one + 2 ) . " DAY", 'curdate' ) . " ," . $is_appr . " ),
                                        ( " . $temp_id . ", " . wpbc_sql_date_math_expr_explicit( "+ INTERVAL " . ( 2 * ( $i + 1 ) * $evry_one + 3 ) . " DAY", 'curdate' ) . "  ," . $is_appr . " ),
                                        ( " . $temp_id . ", " . wpbc_sql_date_math_expr_explicit( "+ INTERVAL " . ( 2 * ( $i + 1 ) * $evry_one + 4 ) . " DAY", 'curdate' ) . " ," . $is_appr . " );";
                }
				// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
				$wpdb->query( $wp_queries_sub );
             }
        } else if ( $version == 'personal' ) {
                $max_num_bookings = 8;                                                  // How many bookings exist
            for ($i = 0; $i < $max_num_bookings; $i++) {

                $bk_type  = wp_rand(1,4);                                                  // Booking Resource
                $min_days = 1;
                $max_days = 7;
                $is_appr  = wp_rand(0,1);                                                  // Pending | Approved
                $evry_one = $max_days;                                                  // Multiplier of interval between 2 dates of different bookings
                $num_days = wp_rand($min_days,$max_days);                                  // Max Number of Dates for specific booking
                $days_start_shift = -1 * (ceil($max_num_bookings/2)) * $max_days;       // How long far ago we are start bookings

                $second_name = wpbc_pro_get_initial_values_4_demo('second_name');
                $form  = '';
                $form .= 'text^name'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('name').'~';
                $form .= 'text^secondname'.$bk_type.'^'.$second_name.'~';
                $form .= 'text^email'.$bk_type.'^'.$second_name.'.example@wpbookingcalendar.com~';
                $form .= 'text^phone'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('phone').'~';
                $form .= 'selectbox-one^visitors'.$bk_type.'^'.wp_rand(1,4).'~';
                $form .= 'selectbox-one^children'.$bk_type.'^'.wp_rand(0,3).'~';
                $form .= 'textarea^details'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('info');

                $wp_bk_querie = "INSERT INTO {$wpdb->prefix}booking ( form, booking_type, hash,  modification_date ) VALUES
                                                   ( '".$form."', ".$bk_type .", MD5('". time() . '_' . wp_rand(1000,1000000)."'), " . wpbc_sql_date_math_expr_explicit('', 'now') . " ) ;";
				// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
				$wpdb->query( $wp_bk_querie );
                $temp_id = $wpdb->insert_id;

                $wp_queries_sub = "INSERT INTO {$wpdb->prefix}bookingdates (
                                     booking_id,
                                     booking_date,
                                     approved
                                    ) VALUES ";
                for ($d_num = 0; $d_num < $num_days; $d_num++) {
                    $wp_queries_sub .= "( ". $temp_id .", CURDATE()+ INTERVAL ".($days_start_shift + $i*$evry_one + $d_num)." day  ,". $is_appr." ),";
                }
                $wp_queries_sub = substr($wp_queries_sub,0,-1) . ";";
				// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
				$wpdb->query( $wp_queries_sub );
             }
        } else if ( $version == 'biz_s' ) {
                $max_num_bookings = 8;                                                  // How many bookings exist
            for ($i = 0; $i < $max_num_bookings; $i++) {

                $bk_type  = wp_rand(1,4);                                                  // Booking Resource
                $min_days = 1;
                $max_days = 1;
                $is_appr  = wp_rand(0,1);                                                  // Pending | Approved
                $evry_one = $max_days;                                                  // Multiplier of interval between 2 dates of different bookings
                $num_days = wp_rand($min_days,$max_days);                                  // Max Number of Dates for specific booking
                $days_start_shift = (ceil($max_num_bookings/4)) * $max_days;       // How long far ago we are start bookings

                $second_name = wpbc_pro_get_initial_values_4_demo('second_name');
                $city =  wpbc_pro_get_initial_values_4_demo('city');
                $range_time = wpbc_pro_get_initial_values_4_demo('rangetime');
                $start_time = $range_time[0];
                $end_time   = $range_time[1];

                $form  = '';
                $form .= 'selectbox-one^rangetime'.$bk_type.'^'.$start_time.' - '.$end_time.'~';
                $form .= 'text^name'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('name').'~';
                $form .= 'text^secondname'.$bk_type.'^'.$second_name.'~';
                $form .= 'text^email'.$bk_type.'^'.$second_name.'.example@wpbookingcalendar.com~';
                $form .= 'text^address'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('adress').'~';
                $form .= 'text^city'.$bk_type.'^'.$city[0].'~';
                $form .= 'text^postcode'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('postcode').'~';
                $form .= 'text^country'.$bk_type.'^'.$city[1].'~';
                $form .= 'text^phone'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('phone').'~';
                $form .= 'selectbox-one^visitors'.$bk_type.'^'.wp_rand(1,4).'~';
                $form .= 'checkbox^children'.$bk_type.'[]^'.wp_rand(0,3).'~';
                $form .= 'textarea^details'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('info');

                $wp_bk_querie = "INSERT INTO {$wpdb->prefix}booking ( form, booking_type, cost, hash, modification_date ) VALUES
                                                   ( '".$form."', ".$bk_type .", ".wp_rand(0,1000).", MD5('". time() . '_' . wp_rand(1000,1000000)."'), " . wpbc_sql_date_math_expr_explicit('', 'now') . " ) ;";
				// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
				$wpdb->query( $wp_bk_querie );
                $temp_id = $wpdb->insert_id;

                $wp_queries_sub = "INSERT INTO {$wpdb->prefix}bookingdates (
                                     booking_id,
                                     booking_date,
                                     approved
                                    ) VALUES ";
                for ($d_num = 0; $d_num < $num_days; $d_num++) {
                    $my_interval = ( $i*$evry_one + $d_num);
//                        $wp_queries_sub .= "( ". $temp_id .", CURDATE()+ INTERVAL \"".($days_start_shift + $i*$evry_one + $d_num)." ".$start_time.":01\" DAY_SECOND  ,". $is_appr." ),";
//                        $wp_queries_sub .= "( ". $temp_id .", CURDATE()+ INTERVAL \"".($days_start_shift + $i*$evry_one + $d_num)." ".$end_time  .":02\" DAY_SECOND  ,". $is_appr." ),";
                    $wp_queries_sub .= "( ". $temp_id .", DATE_ADD(CURDATE(), INTERVAL -".$days_start_shift." DAY) + INTERVAL \"".$my_interval." ".$start_time.":01\" DAY_SECOND  ,". $is_appr." ),";
                    $wp_queries_sub .= "( ". $temp_id .", DATE_ADD(CURDATE(), INTERVAL -".$days_start_shift." DAY) + INTERVAL \"".$my_interval." ".$end_time.":02\" DAY_SECOND  ,". $is_appr." ),";
                }
                $wp_queries_sub = substr($wp_queries_sub,0,-1) . ";";
				// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
				$wpdb->query( $wp_queries_sub );
             }
        } else if ( $version == 'biz_m' ) {
                $max_num_bookings = 8;                                                  // How many bookings exist
            for ($i = 0; $i < $max_num_bookings; $i++) {

                $bk_type  = wp_rand(1,4);                                                  // Booking Resource
                $min_days = 3;
                $max_days = 7;
                $is_appr  = wp_rand(0,1);                                                  // Pending | Approved
                $evry_one = $max_days;                                                  // Multiplier of interval between 2 dates of different bookings
                $num_days = wp_rand($min_days,$max_days);                                  // Max Number of Dates for specific booking
                $days_start_shift =  (ceil($max_num_bookings/2)) * $max_days;       // How long far ago we are start bookings

                $second_name = wpbc_pro_get_initial_values_4_demo('second_name');
                $city =  wpbc_pro_get_initial_values_4_demo('city');
                $start_time = '14:00';
                $end_time   = '12:00';

                $form  = '';
                $form .= 'text^name'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('name').'~';
                $form .= 'text^secondname'.$bk_type.'^'.$second_name.'~';
                $form .= 'text^email'.$bk_type.'^'.$second_name.'.example@wpbookingcalendar.com~';
                $form .= 'text^address'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('adress').'~';
                $form .= 'text^city'.$bk_type.'^'.$city[0].'~';
                $form .= 'text^postcode'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('postcode').'~';
                $form .= 'text^country'.$bk_type.'^'.$city[1].'~';
                $form .= 'text^phone'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('phone').'~';
                $form .= 'selectbox-one^visitors'.$bk_type.'^'.wp_rand(1,4).'~';
                $form .= 'checkbox^children'.$bk_type.'[]^'.wp_rand(0,3).'~';
                $form .= 'textarea^details'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('info').'~';
                $form .= 'text^starttime'.$bk_type.'^'.$start_time.'~';
                $form .= 'text^endtime'.$bk_type.'^'.$end_time;

                $wp_bk_querie = "INSERT INTO {$wpdb->prefix}booking ( form, booking_type, cost, hash, modification_date ) VALUES
                                                   ( '".$form."', ".$bk_type .", ".wp_rand(0,1000).", MD5('". time() . '_' . wp_rand(1000,1000000)."'), " . wpbc_sql_date_math_expr_explicit('', 'now') . " ) ;";
				// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
				$wpdb->query( $wp_bk_querie );
                $temp_id = $wpdb->insert_id;

                $wp_queries_sub = "INSERT INTO {$wpdb->prefix}bookingdates (
                                     booking_id,
                                     booking_date,
                                     approved
                                    ) VALUES ";
                for ($d_num = 0; $d_num < $num_days; $d_num++) {
                    $my_interval = ( $i*$evry_one + $d_num);
                    if ($d_num == 0) {                                       // Check In
                        $wp_queries_sub .= "( ". $temp_id .", DATE_ADD(CURDATE(), INTERVAL  -".$days_start_shift." day) + INTERVAL \"".$my_interval." ".$start_time.":01\" DAY_SECOND  ,". $is_appr." ),";
                    } elseif ($d_num == ($num_days-1) ) {                   // Check Out
                        $wp_queries_sub .= "( ". $temp_id .", DATE_ADD(CURDATE(), INTERVAL -".$days_start_shift." day) + INTERVAL \"".$my_interval." ".$end_time.":02\" DAY_SECOND  ,". $is_appr." ),";
                    } else {
                        $wp_queries_sub .= "( ". $temp_id .", DATE_ADD(CURDATE(), INTERVAL  -".$days_start_shift." day) + INTERVAL ".$my_interval." day  ,". $is_appr." ),";
                    }
                }
                $wp_queries_sub = substr($wp_queries_sub,0,-1) . ";";
				// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
				$wpdb->query( $wp_queries_sub );
             }

        } else if ( $version == 'biz_l' ) {
                $max_num_bookings = 12;                                                  // How many bookings exist
            for ($res_groups = 0; $res_groups < 2; $res_groups++)
            for ($i = 0; $i < $max_num_bookings; $i++) {
                if($res_groups)
                    $bk_type  = wp_rand(1,6);                                                  // Booking Resource
                else $bk_type  = wp_rand(7,12);                                                  // Booking Resource
                $min_days = 2;
                $max_days = 7;
                $is_appr  = wp_rand(0,1);                                                  // Pending | Approved
                $evry_one = $max_days;                                                  // Multiplier of interval between 2 dates of different bookings
                $num_days = wp_rand($min_days,$max_days);                                  // Max Number of Dates for specific booking
                $days_start_shift =  (ceil($max_num_bookings/2)) * $max_days;       // How long far ago we are start bookings

                $second_name = wpbc_pro_get_initial_values_4_demo('second_name');
                $city =  wpbc_pro_get_initial_values_4_demo('city');
                $start_time = '14:00';
                $end_time   = '12:00';


                $form  = '';
                $form .= 'text^name'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('name').'~';
                $form .= 'text^secondname'.$bk_type.'^'.$second_name.'~';
                $form .= 'text^email'.$bk_type.'^'.$second_name.'.example@wpbookingcalendar.com~';
                $form .= 'text^address'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('adress').'~';
                $form .= 'text^city'.$bk_type.'^'.$city[0].'~';
                $form .= 'text^postcode'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('postcode').'~';
                $form .= 'text^country'.$bk_type.'^'.$city[1].'~';
                $form .= 'text^phone'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('phone').'~';
                $form .= 'selectbox-one^visitors'.$bk_type.'^1~';
                //$form .= 'checkbox^children'.$bk_type.'[]^0~';
                $form .= 'textarea^details'.$bk_type.'^'.wpbc_pro_get_initial_values_4_demo('info').'~';
                $form .= 'coupon^coupon'.$bk_type.'^ ';

                $wp_bk_querie = "INSERT INTO {$wpdb->prefix}booking ( form, booking_type, cost, hash, modification_date ) VALUES
                                                   ( '".$form."', ".$bk_type .", ".wp_rand(0,1000).", MD5('". time() . '_' . wp_rand(1000,1000000)."'), " . wpbc_sql_date_math_expr_explicit('', 'now') . " ) ;";
				// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
				$wpdb->query( $wp_bk_querie );
                $temp_id = $wpdb->insert_id;

                $wp_queries_sub = "INSERT INTO {$wpdb->prefix}bookingdates (
                                     booking_id,
                                     booking_date,
                                     approved
                                    ) VALUES ";
                for ($d_num = 0; $d_num < $num_days; $d_num++) {
                    $my_interval = ( $i*$evry_one + $d_num);

                    $wp_queries_sub .= "( ". $temp_id .", DATE_ADD(CURDATE(), INTERVAL  -".$days_start_shift." day) + INTERVAL ".$my_interval." day  ,". $is_appr." ),";
                }
                $wp_queries_sub = substr($wp_queries_sub,0,-1) . ";";
				// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
				$wpdb->query( $wp_queries_sub );
             }
        }
}


function wpbc_pro_get_initial_values_4_demo( $type ) {
    $names = array('Jacob', 'Michael', 'Daniel', 'Anthony', 'William', 'Emma', 'Sophia', 'Kamila', 'Isabella', 'Jack', 'Daniel', 'Matthew',
            'Olivia', 'Emily', 'Grace', 'Jessica', 'Joshua', 'Harry', 'Thomas', 'Oliver', 'Jack' );
    $second_names = array(  'Smith', 'Johnson', 'Widams', 'Brown', 'Jones', 'Miller', 'Davis', 'Garcia', 'Rodriguez', 'Wilyson', 'Gonzalez', 'Gomez',
            'Taylor', 'Bron', 'Wilson', 'Davies', 'Robinson', 'Evans', 'Walker', 'Jackson', 'Clarke' );
    $city =    array( 'New York', 'Los Angeles', 'Chicago', 'Houston', 'Phoenix', 'San Antonio', 'San Diego', 'San Jose', 'Detroit',
            'San Francisco', 'Jacksonville', 'Austin',
            'London', 'Birmingham', 'Leeds', 'Glasgow', 'Sheffield', 'Bradford', 'Edinburgh', 'Liverpool', 'Manchester' );
    $adress =   array('30 Mortensen Avenue', '144 Hitchcock Rd', '222 Lincoln Ave', '200 Lincoln Ave', '65 West Alisal St',
            '426 Work St', '65 West Alisal Street', '159 Main St', '305 Jonoton Avenue', '423 Caiptown Rd', '34 Linoro Ave',
            '50 Voro Ave', '15 East St', '226 Middle St', '35 West Town Street', '59 Other St', '50 Merci Ave', '15 Dolof St',
            '226 Gordon St', '35 Sero Street', '59 Exit St' );
    $country = array( 'US' ,'US' ,'US' ,'US' ,'US' ,'US' ,'US' ,'US' ,'US' ,'US' ,'US' ,'US' ,'UK','UK','UK','UK','UK','UK','UK','UK','UK' );

    $range_times = array( array("10:00","12:00"), array("12:00","14:00"), array("14:00","16:00"), array("16:00","18:00"), array("18:00","20:00") );

    switch ($type) {
        case 'rangetime':
            return $range_times[ wp_rand(0 , (count($range_times)-1) ) ] ;
            break;
        case 'name':
            return $names[ wp_rand(0 , (count($names)-1) ) ] ;
            break;
        case 'second_name':
            return $second_names[ wp_rand(0 , (count($second_names)-1) ) ] ;
            break;
        case 'adress':
            return $adress[ wp_rand(0 , (count($adress)-1) ) ] ;
            break;
        case 'city':
            $city_num = wp_rand(0 , (count($city)-1) )  ;
            return array( $city[$city_num], $country[$city_num]) ;
            break;
        case 'postcode':
            return (wp_rand(0,9).wp_rand(0,9).wp_rand(0,9).wp_rand(0,9).wp_rand(0,9));
            break;
        case 'phone':
            return (wp_rand(0,9).wp_rand(0,9).wp_rand(0,9).'-'.wp_rand(0,9).wp_rand(0,9).'-'.wp_rand(0,9).wp_rand(0,9)) ;
            break;
        case 'starttime':
            return ('0'.wp_rand(0,9) . ':' .wp_rand(1,3).'0' );
            break;
        case 'endtime':
            return (wp_rand(12,23) . ':' .wp_rand(1,3).'0' );
            break;
        case 'visitors':
            return wp_rand(1,4);
            break;
        default:
            return '';
            break;
    }

}


function wpbc_pro_set_default_initial_values( $evry_one = 1 ) {
    global $wpdb;
    $names = array(  'Jacob', 'Michael', 'Daniel', 'Anthony', 'William', 'Emma', 'Sophia', 'Kamila', 'Isabella', 'Jack', 'Daniel', 'Matthew',
            'Olivia', 'Emily', 'Grace', 'Jessica', 'Joshua', 'Harry', 'Thomas', 'Oliver', 'Jack' );
    $second_names = array(  'Smith', 'Johnson', 'Widams', 'Brown', 'Jones', 'Miller', 'Davis', 'Garcia', 'Rodriguez', 'Wilyson', 'Gonzalez', 'Gomez',
            'Taylor', 'Bron', 'Wilson', 'Davies', 'Robinson', 'Evans', 'Walker', 'Jackson', 'Clarke' );
    $city =    array(       'New York', 'Los Angeles', 'Chicago', 'Houston', 'Phoenix', 'San Antonio', 'San Diego', 'San Jose', 'Detroit',
            'San Francisco', 'Jacksonville', 'Austin',
            'London', 'Birmingham', 'Leeds', 'Glasgow', 'Sheffield', 'Bradford', 'Edinburgh', 'Liverpool', 'Manchester' );
    $adress =   array(      '30 Mortensen Avenue', '144 Hitchcock Rd', '222 Lincoln Ave', '200 Lincoln Ave', '65 West Alisal St',
            '426 Work St', '65 West Alisal Street', '159 Main St', '305 Jonoton Avenue', '423 Caiptown Rd', '34 Linoro Ave',
            '50 Voro Ave', '15 East St', '226 Middle St', '35 West Town Street', '59 Other St', '50 Merci Ave', '15 Dolof St',
            '226 Gordon St', '35 Sero Street', '59 Exit St' );
    $country = array( 'US' ,'US' ,'US' ,'US' ,'US' ,'US' ,'US' ,'US' ,'US' ,'US' ,'US' ,'US' ,'UK','UK','UK','UK','UK','UK','UK','UK','UK' );
    $info = array(    '  ' ,'  ' ,'  ' ,'  ' ,'  ' ,'  ' ,'  ' ,'  ' ,'  ' ,'  ' ,'  ' ,'  ' ,'  ','  ','  ','  ','  ','  ','  ','  ','  ' );

    for ($i = 0; $i < count($names); $i++) {
        if ( ($i % $evry_one) !==0 ) {
            continue;
        }
        $bk_type = wp_rand(1,4);
        $is_appr = wp_rand(0,1);

        $start_time = '0'.wp_rand(0,9) . ':' .wp_rand(1,3).'0' ;
        $end_time     = wp_rand(12,23) . ':' .wp_rand(1,3).'0' ;

        $form = 'text^starttime'.$bk_type.'^'.$start_time.'~';
        $form .='text^endtime'.$bk_type.'^'.$end_time.'~';
        $form .='text^name'.$bk_type.'^'.$names[$i].'~';
        $form .='text^secondname'.$bk_type.'^'.$second_names[$i].'~';
        $form .='text^email'.$bk_type.'^'.$second_names[$i].'.example@wpbookingcalendar.com~';
        $form .='text^address'.$bk_type.'^'.$adress[$i].'~';
        $form .='text^city'.$bk_type.'^'.$city[$i].'~';
        $form .='text^postcode'.$bk_type.'^'.wp_rand(0,9).wp_rand(0,9).wp_rand(0,9).wp_rand(0,9).wp_rand(0,9).'~';
        $form .='text^country'.$bk_type.'^'.$country[$i].'~';
        $form .='text^phone'.$bk_type.'^'.wp_rand(0,9).wp_rand(0,9).wp_rand(0,9).'-'.wp_rand(0,9).wp_rand(0,9).'-'.wp_rand(0,9).wp_rand(0,9).'~';
        $form .='selectbox-one^visitors'.$bk_type.'^'.wp_rand(0,9).'~';
        $form .='checkbox^children'.$bk_type.'[]^false~';
        $form .='textarea^details'.$bk_type.'^'.$info[$i];

        $wp_bk_querie = "INSERT INTO {$wpdb->prefix}booking ( form, booking_type, cost, hash ) VALUES
                                           ( '".$form."', ".$bk_type .", ".wp_rand(0,1000).", MD5('". time() . '_' . wp_rand(1000,1000000)."') ) ;";
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
        $wpdb->query( $wp_bk_querie );

		$temp_id = $wpdb->insert_id;
		$start_time_arr = explode( ':', $start_time );
		$end_time_arr   = explode( ':', $end_time );
        $wp_queries_sub = "INSERT INTO {$wpdb->prefix}bookingdates (
                             booking_id,
                             booking_date,
                             approved
                            ) VALUES                                  
                            ( " . $temp_id . ", " . wpbc_sql_date_math_expr_explicit( "+ INTERVAL '" . ( ( ( 2 * ( $i + 1 ) * $evry_one + 2 ) * 24 ) + intval( $start_time_arr[0] ) ) . ':' . $start_time_arr[1] . ":01' HOUR_SECOND", 'curdate' ) . " ," . $is_appr . " ),
                            ( " . $temp_id . ", " . wpbc_sql_date_math_expr_explicit( "+ INTERVAL " . ( 2 * ( $i + 1 ) * $evry_one + 3 ) . " DAY", 'curdate' ) . "  ," . $is_appr . " ),
                            ( " . $temp_id . ", " . wpbc_sql_date_math_expr_explicit( "+ INTERVAL '" . ( ( ( 2 * ( $i + 1 ) * $evry_one + 4 ) * 24 ) + intval( $end_time_arr[0] ) ) . ':' . $end_time_arr[1] . ":02' HOUR_SECOND", 'curdate' ) . " ," . $is_appr . " );";
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
		$wpdb->query( $wp_queries_sub );
    }
}

// </editor-fold>
