/**
 *  >= Business Medium ...
 */

	/**
	 * Save initial values of days selection for later use in conditional day logic.   Load it,  when  start the page.
	 *
	 * @param resource_id
	 */
	function wpbc__conditions__SAVE_INITIAL__days_selection_params__bm( resource_id ){

		// Save it only ONCE initial values of variables:  ...
		if (  _wpbc.calendar__is_defined( resource_id ) ){

			_wpbc.calendar__set_param_value( resource_id, 'saved_variable___days_select_initial'
				, {
					'dynamic__days_min'     	: _wpbc.calendar__get_param_value( resource_id, 'dynamic__days_min' ),
					'dynamic__days_max'     	: _wpbc.calendar__get_param_value( resource_id, 'dynamic__days_max' ),
					'dynamic__days_specific'	: _wpbc.calendar__get_param_value( resource_id, 'dynamic__days_specific' ),
					'dynamic__week_days__start'	: _wpbc.calendar__get_param_value( resource_id, 'dynamic__week_days__start' ),

					'fixed__days_num'      		: _wpbc.calendar__get_param_value( resource_id, 'fixed__days_num' ),
					'fixed__week_days__start'  	: _wpbc.calendar__get_param_value( resource_id, 'fixed__week_days__start' )
				}
			);
		}
	}


	/**
	 * Define First selected date for start conditional dates selection
	 *
	 * @param  all_dates				date object | string
	 * @param resource_id				int | string  e.g. '1'
	 * @returns {boolean}
	 */
	function wpbc__conditions__for_range_days__first_date__bm( all_dates, resource_id ){

		if ( '' == all_dates ) { return false; }                   						// If no days selections so then skip all.

		if (    ( 'dynamic' != _wpbc.calendar__get_param_value( resource_id, 'days_select_mode' ) )
			 && ( 'fixed'   != _wpbc.calendar__get_param_value( resource_id, 'days_select_mode' ) )
		) { return false; }                   				// This conditional logic is possible only if the range days selection

		var selected_first_day = all_dates;

		if ( typeof (all_dates) == 'object' ){  	// H I G H L I G H T   		// If this parameter is object (Date), then we  highlight the dates

			all_dates = document.getElementById( 'date_booking' + resource_id ).value;      // Get dates from the textarea date booking to ''
			if ( all_dates != '' ){                                                  		// If some date is selected
				var first_date = get_first_day_of_selection( all_dates );            		// So we are NOT MAKE changing of highlighting if its was first click.
				var last_date  = get_last_day_of_selection( all_dates );
				if (
						( 'fixed' !== _wpbc.calendar__get_param_value( resource_id, 'days_select_mode' ) )
					&&  ( first_date == last_date )
				){    // FixIn: 8.4.4.8.
					return false;
				}
			}
		} else {                                	// S E L E C T
			var first_date = get_first_day_of_selection( all_dates );
			var last_date  = get_last_day_of_selection( all_dates );
			if ( first_date != last_date ){
				return false;									// We are clicked second time
			}
			var date_sections = first_date.split( "." );
			selected_first_day = new Date;
			selected_first_day.setFullYear( parseInt( date_sections[ 2 ] - 0 ), parseInt( date_sections[ 1 ] - 1 ), parseInt( date_sections[ 0 ] - 0 ) );
		}

		wpbc__conditions__set_NUMBER_OF_DAYS_TO_SELECT__depend_on_date__bm( selected_first_day, resource_id );
	}


	/**
	 *  Update dates selection parameters ( NUMBER_OF_DAYS_TO_SELECT) depends on belong current date to specific week day or season
	 *
	 * @param selected_first_date		date, which  we check for conditions
	 * @param resource_id				booking resource ID
	 * @returns {boolean}
	 */
	function wpbc__conditions__set_NUMBER_OF_DAYS_TO_SELECT__depend_on_date__bm( selected_first_date, resource_id ){

		var is_condition_applied = false;

		var class_day      = wpbc__get__td_class_date(  selected_first_date );
		var sql_class_date = wpbc__get__sql_class_date( selected_first_date );

		if ( jQuery( '#calendar_booking' + resource_id + ' .datepick-days-cell.cal4date-' + class_day ).length <= 0 ){
			return false;  // This date is not exist :( Why ?
		}
		var css_classes_date_arr = jQuery( '#calendar_booking' + resource_id + ' .datepick-days-cell.cal4date-' + class_day ).attr( 'class' ).split( /\s+/ );


		/**
		 * S E A S O N     C O N D I T I O N S    -    2.0
		 *
		 *	 		_wpbc.calendar__get_param_value(3,'conditions')['select-day']['season'] [0]['for'] = 'september_2023'	<- season name to check
		 *	 		_wpbc.calendar__get_param_value(3,'conditions')['select-day']['season'] [0]['value'] = '3,4,5'			<- number of days to  select
		 */
		var conditions = _wpbc.calendar__get_param_value( resource_id, 'conditions' );
		var single_css_date_class;
		var days_arr;
		if (
			   ( null !== conditions )
			&& ( 'undefined' !== typeof (conditions[ 'select-day' ]) )
			&& ( 'undefined' !== typeof (conditions[ 'select-day' ]['season']) )
			&& ( conditions[ 'select-day' ][ 'season' ].length > 0 )
		){
			for ( var i = 0; i < css_classes_date_arr.length; i++ ){

				single_css_date_class = css_classes_date_arr[i];

				// S E A S O N    F I L T E R    C O N D I T I O N S     - checking
				if ( single_css_date_class.indexOf( 'wpdevbk_season_' ) >= 0 ){

					single_css_date_class = single_css_date_class.replace( 'wpdevbk_season_', '' );

					for ( var j = 0; j < conditions[ 'select-day' ][ 'season' ].length; j++ ){

						if ( single_css_date_class === conditions[ 'select-day' ][ 'season' ][ j ][ 'for' ] ){			// Ok season in condition == season in a day

							days_arr = conditions[ 'select-day' ][ 'season' ][ j ][ 'value' ].split( ',' );

							// Update real vars
							_wpbc.calendar__set_param_value( resource_id, 'dynamic__days_specific', days_arr );
							_wpbc.calendar__set_param_value( resource_id, 'dynamic__days_min', 		days_arr[ 0 ] );
							_wpbc.calendar__set_param_value( resource_id, 'dynamic__days_max', 		days_arr[ (days_arr.length - 1) ] );
							_wpbc.calendar__set_param_value( resource_id, 'fixed__days_num', 		days_arr[ 0 ] );

							is_condition_applied = true;
						}
					}
				}
			}
		}


		/**
		 * W E E K D A Y S     C O N D I T I O N S    -    2.0
		 *
		 *	 		_wpbc.calendar__get_param_value(3,'conditions')['select-day']['weekday'] [0]['for'] = '5'			<- number of Week day
		 *	 		_wpbc.calendar__get_param_value(3,'conditions')['select-day']['weekday'] [0]['value'] = '3,7'		<- number of days to  select
		 */
		if (
			   ( null !== conditions )
			&& ( 'undefined' !== typeof (conditions[ 'select-day' ]) )
			&& ( 'undefined' !== typeof (conditions[ 'select-day' ]['weekday']) )
			&& ( conditions[ 'select-day' ][ 'weekday' ].length > 0 )
		){

			for ( var j = 0; j < conditions[ 'select-day' ][ 'weekday' ].length; j++ ){

				if ( selected_first_date.getDay() == conditions[ 'select-day' ][ 'weekday' ][ j ][ 'for' ] ){			// Ok weekday condition == a week day of day

					days_arr = conditions[ 'select-day' ][ 'weekday' ][ j ][ 'value' ].split( ',' );

					// Update real vars
					_wpbc.calendar__set_param_value( resource_id, 'dynamic__days_specific', days_arr );
					_wpbc.calendar__set_param_value( resource_id, 'dynamic__days_min', 		days_arr[ 0 ] );
					_wpbc.calendar__set_param_value( resource_id, 'dynamic__days_max', 		days_arr[ (days_arr.length - 1) ] );
					_wpbc.calendar__set_param_value( resource_id, 'fixed__days_num', 		days_arr[ 0 ] );

					is_condition_applied = true;
				}
			}
		}


		/**
		 * D A T E S     C O N D I T I O N S    -    New
		 *
		 *	 		_wpbc.calendar__get_param_value(3,'conditions')['select-day']['date'][0]['for'] = '2023-08-22'		<- Date
		 *	 		_wpbc.calendar__get_param_value(3,'conditions')['select-day']['date'][0]['value'] = '3,7'			<- number of days to  select
		 */
		if (
			   ( null !== conditions )
			&& ( 'undefined' !== typeof (conditions[ 'select-day' ]) )
			&& ( 'undefined' !== typeof (conditions[ 'select-day' ]['date']) )
			&& ( conditions[ 'select-day' ][ 'date' ].length > 0 )
		){

			for ( var j = 0; j < conditions[ 'select-day' ][ 'date' ].length; j++ ){

				if ( sql_class_date == conditions[ 'select-day' ][ 'date' ][ j ][ 'for' ] ){							// Ok date condition == a  date of selected day

					days_arr = conditions[ 'select-day' ][ 'date' ][ j ][ 'value' ].split( ',' );

					// Update real vars
					_wpbc.calendar__set_param_value( resource_id, 'dynamic__days_specific', days_arr );
					_wpbc.calendar__set_param_value( resource_id, 'dynamic__days_min', 		days_arr[ 0 ] );
					_wpbc.calendar__set_param_value( resource_id, 'dynamic__days_max', 		days_arr[ (days_arr.length - 1) ] );
					_wpbc.calendar__set_param_value( resource_id, 'fixed__days_num', 		days_arr[ 0 ] );

					is_condition_applied = true;
				}
			}
		}


		// Reset to the global,  if conditional parameters was not applied
		if ( false === is_condition_applied ) {

			var saved_variable___days_select_initial = _wpbc.calendar__get_param_value( resource_id, 'saved_variable___days_select_initial' );

			// Update real vars
			_wpbc.calendar__set_param_value( resource_id, 'dynamic__days_specific', saved_variable___days_select_initial['dynamic__days_specific'] );
			_wpbc.calendar__set_param_value( resource_id, 'dynamic__days_min', 	    saved_variable___days_select_initial['dynamic__days_min'] );
			_wpbc.calendar__set_param_value( resource_id, 'dynamic__days_max', 	    saved_variable___days_select_initial['dynamic__days_max'] );
			_wpbc.calendar__set_param_value( resource_id, 'fixed__days_num', 	    saved_variable___days_select_initial['fixed__days_num'] );
		}

	}


	/**
	 * Update dates selection parameters ( START_WEEK_DAY)  depends on  belong current date to  specific   season
	 *
	 * @param resource_id				int
	 * @param selected_first_date		JS date
	 * @param is_start_or_end			'start' | 'end'
	 * @returns {boolean}
	 */
	function wpbc__conditions__set_START_WEEK_DAY__depend_on_season__bm( resource_id, selected_first_date, is_start_or_end ){

		if ( 'start' == is_start_or_end ){

			var class_day        = wpbc__get__td_class_date(  selected_first_date );
			// var sql_class_date = wpbc__get__sql_class_date( selected_first_date );

			if ( jQuery( '#calendar_booking' + resource_id + ' .datepick-days-cell.cal4date-' + class_day ).length <= 0 ){
				return false;  // This date is not exist :( Why ?
			}
			var css_classes_date_arr = jQuery( '#calendar_booking' + resource_id + ' .datepick-days-cell.cal4date-' + class_day ).attr( 'class' ).split( /\s+/ );


			/**
			 * START_WEEK_DAY  from  S E A S O N    -    2.0
			 *
			 *	 		_wpbc.calendar__get_param_value(3,'conditions')['start-day']['season'][0]['for'] = 'september_2023'		<- season name to check
			 *	 		_wpbc.calendar__get_param_value(3,'conditions')['start-day']['season'][0]['value']  = '2,5,6'			<- Week Days to  start  selection
			 */
			var conditions = _wpbc.calendar__get_param_value( resource_id, 'conditions' );
			var single_css_date_class;
			var days_arr;
			if (
				   ( null !== conditions )
				&& ( 'undefined' !== typeof (conditions[ 'start-day' ]) )
				&& ( 'undefined' !== typeof (conditions[ 'start-day' ]['season']) )
				&& ( conditions[ 'start-day' ][ 'season' ].length > 0 )
			){
				for ( var i = 0; i < css_classes_date_arr.length; i++ ){

					single_css_date_class = css_classes_date_arr[i];

					// S E A S O N    F I L T E R    C O N D I T I O N S     - checking
					if ( single_css_date_class.indexOf( 'wpdevbk_season_' ) >= 0 ){

						single_css_date_class = single_css_date_class.replace( 'wpdevbk_season_', '' );

						for ( var j = 0; j < conditions[ 'start-day' ][ 'season' ].length; j++ ){

							if ( single_css_date_class === conditions[ 'start-day' ][ 'season' ][ j ][ 'for' ] ){			// Ok season in condition == season in a day

								days_arr = conditions[ 'start-day' ][ 'season' ][ j ][ 'value' ].split( ',' );

								// Update real vars
								_wpbc.calendar__set_param_value( resource_id, 'dynamic__week_days__start' , days_arr );
								_wpbc.calendar__set_param_value( resource_id, 'fixed__week_days__start'   , days_arr );
							}
						}
					}
				}
			}
		}


		// START_WEEK_DAY  Back to INITIAL params
		if ( 'end' == is_start_or_end ){

			var saved_variable___days_select_initial = _wpbc.calendar__get_param_value( resource_id, 'saved_variable___days_select_initial' );
			_wpbc.calendar__set_param_value( resource_id, 'dynamic__week_days__start', saved_variable___days_select_initial[ 'dynamic__week_days__start' ] );
			_wpbc.calendar__set_param_value( resource_id, 'fixed__week_days__start',   saved_variable___days_select_initial[ 'fixed__week_days__start' ] );
		}

	}


/**
 * Calendar Day Cell Bottom  -  Get daily cost for specific date
 *
 * usually  used for showing daily cost in bottom  of calendar date cell
 *
 * @param param_calendar_id         {string}    ID of calendar - booking resource
 * @param my_thisDateTime           {Date}      JavaScript date
 * @returns                         {string}    Cost  - formatted - like  "$ 95.99"
 */
function wpbc_show_day_cost_in_date_bottom( param_calendar_id, my_thisDateTime ) {

	var resource_id = parseInt( param_calendar_id.replace( "calendar_booking", '' ) );

	// console.log( _wpbc.bookings_in_calendar__get( resource_id ) );		// for debug

	// 1. Get child booking resources  or single booking resource  that  exist  in dates :	[1] | [1,14,15,17]
	// var child_resources_arr = wpbc_clone_obj( _wpbc.booking__get_param_value( resource_id, 'resources_id_arr__in_dates' ) );

	// '2023-08-21'
	var sql_date = wpbc__get__sql_class_date( new Date( my_thisDateTime ) );

    var hint__in_day__cost = '';

    var get_for_date_obj = _wpbc.bookings_in_calendar__get_for_date( resource_id, sql_date );

    if ( false !== get_for_date_obj ){

        if (
               (undefined != get_for_date_obj[ 'summary' ])
            && (undefined != get_for_date_obj[ 'summary' ].hint__in_day__cost)
        ){
            hint__in_day__cost = get_for_date_obj[ 'summary' ].hint__in_day__cost;		// "25.00£"
        }

    }

    return hint__in_day__cost;
}


/**
 * Admin Panel - Booking > Settings > Form page -- Delete custom  form
 *
 * @param form_name
 * @param user_id
 * @returns {boolean}
 */
function wpbc_delete_custom_booking_form( form_name, user_id ){

    wpbc_admin_show_message_processing( 'deleting' ); 
    
    jQuery.ajax({                                           // Start Ajax Sending        
        url: wpbc_url_ajax,
        type:'POST',
        success: function (data, textStatus){if( textStatus == 'success')   jQuery('#ajax_respond').html( data );},
        error:function (XMLHttpRequest, textStatus, errorThrown){window.status = 'Ajax sending Error status:'+ textStatus;alert(XMLHttpRequest.status + ' ' + XMLHttpRequest.statusText);if (XMLHttpRequest.status == 500) {alert('Please check at this page according this error:' + ' https://wpbookingcalendar.com/faq/#ajax-sending-error');}},
        // beforeSend: someFunction,
        data:{
            action : 'DELETE_BK_FORM',        
            formname : form_name,
            user_id: user_id,
            wpbc_nonce: document.getElementById('wpbc_admin_panel_nonce').value 
        }
    });
    return false;
}


/**
 * Admin Panel - Booking > Settings > Form page -- Change custom  form
 *
 * @param selectObj
 */
function wpbc_change_custom_booking_form_in_url__and_reload(selectObj){

     var idx = selectObj.selectedIndex;     
     var my_form = selectObj.options[idx].value;

     var loc = location.href;
     if (loc.substr((loc.length-1),1)=='#') {
         loc = loc.substr(0,(loc.length-1) );
     }
          
     if ( loc.indexOf('booking_form=') == -1 ) {
        loc = loc + '&booking_form=' +my_form;}
     else { // Alredy have this paremeter at URL
         var start = loc.indexOf('&booking_form=');
         var fin = loc.indexOf('&', (start+15));
         if (fin == -1) {loc = loc.substr(0,start) + '&booking_form=' +my_form;} // at the end of row
         else { // at the middle of the row
              var loc1 = loc.substr(0,start) + '&booking_form=' +my_form;//alert(loc)
              loc = loc1 + loc.substr(fin);
         }
     }
     location.href = loc;
}


/**
 * Show mini Spin Loaders in All Hint Elements in specific booking form
 *
 * @param resource_id
 */
function wpbc__spin_loader__mini__in_all_elements_of_booking_form__show( resource_id ){

	var submit_form = document.getElementById( 'booking_form' + resource_id );
	var element;
	var i;
	var count;

	if ( submit_form != null ){

		count = submit_form.elements.length;

		for ( i = 0; i < count; i++ ){
			element = submit_form.elements[ i ];
			// Calculation in process ...

			wpbc__spin_loader__mini__show( 'bookinghint_' + element.id, {'show_here': {'where': 'inside'}} );
			wpbc__spin_loader__mini__show( 'class_bookinghint_' + element.id, {
																				'show_here': {
																								'where'  : 'inside',
																								'jq_node': '.bookinghint_' + element.id
																							}
																			} );

		}
	}
}


/**
 * Get Values from  all form  fields in booking form  and convert it to String
 *
 * @param resource_id
 * @returns {string}
 */
function wpbc_get__booking_form__fields_val__as_string( resource_id ) {

	var submit_form = document.getElementById( 'booking_form' + resource_id );
	var formdata = '';

	if ( submit_form != null ) {

		var form_fields_count = submit_form.elements.length;
		var inp_value;
		var element;
		var el_type;

		// Serialize form here
		for ( var i = 0; i < form_fields_count; i++ ) {

			element = submit_form.elements[ i ];

			// Skip buttons and hidden elements and calendar textarea
			if (
				(element.type !== 'button') &&
				(element.type !== 'hidden') &&
				(element.name !== ('date_booking' + resource_id)) &&
				(element.name !== ('captcha_input' + resource_id) )
			){

				// Element Value ---------------------------------------------------------------------------------------
				if ( element.type == 'checkbox' ) {

					if ( '' === element.value ) {
						inp_value = element.checked;
					} else {
						inp_value = (element.checked) ? element.value : '';
					}

				} else if ( element.type == 'radio' ) {

					if ( element.checked ) {
						inp_value = element.value;
					} else {
						continue;
					}

				} else {
					inp_value = element.value;
				}

				// Get value in select-box of multiple selection
				if ( (element.type == 'selectbox-multiple') || (element.type == 'select-multiple') ) {
					inp_value = jQuery( '[name="' + element.name + '"]' ).val();
					if ( (inp_value == null) || (inp_value.toString() == '') ) {
						inp_value = '';
					}
				}

				// Element Type ----------------------------------------------------------------------------------------
				el_type = element.type;

				el_type = (element.className.indexOf( 'wpdev-validates-as-email' )  !== -1) ? 'email'  : el_type;
				el_type = (element.className.indexOf( 'wpdev-validates-as-coupon' ) !== -1) ? 'coupon' : el_type;
				el_type = ('select-one' == el_type) 	 ? 'selectbox-one' 		: el_type;
				el_type = ('select-multiple' == el_type) ? 'selectbox-multiple' : el_type;


				// Next field element
				if ( formdata !== '' ) {
					formdata += '~';
				}
				formdata += el_type + '^' + element.name + '^' + inp_value;
			}
		}
	}

	return formdata;
}


/**
 * Send Ajax Request to show cost/dates == H I N T S == in the booking form
 *
 * @param resource_id
 * @returns {boolean}
 */
function wpbc_send_ajax__show_cost_hints( resource_id ){

	jQuery( ".booking_form_div" ).trigger( "before_show_cost_hints", [resource_id] );

	// It's means that we get cost hint clicking at additional calendar
	if ( document.getElementById( 'parent_of_additional_calendar' + resource_id ) !== null ) {
		resource_id = document.getElementById( 'parent_of_additional_calendar' + resource_id ).value; // Get parent bk type from additional calendar
	}

	if ( 0 === jQuery( '#booking_form' + resource_id ).find( '.wpbc_field_hint' ).length ) {							// FixIn: 9.9.0.20.
		return false;
	}

	var all_dates = jQuery( '#date_booking' + resource_id ).val();
	var formdata = wpbc_get__booking_form__fields_val__as_string( resource_id );

	// Calculation in process ...  Spinner start
	wpbc__spin_loader__mini__in_all_elements_of_booking_form__show( resource_id );

	// Known Hint shortcodes
	var elements_arr = [
		'booking_hint',
		'estimate_booking_day_cost_hint',
		'estimate_booking_night_cost_hint',
		'additional_booking_hint',
		'original_booking_hint',
		'deposit_booking_hint',
		'coupon_discount_booking_hint',
		'balance_booking_hint',
		'cancel_date_hint_tip',
		'pre_checkin_date_hint_tip',
		'check_in_date_hint_tip',
		'check_out_date_hint_tip',
		'check_out_plus1day_hint_tip',
		'start_time_hint_tip',
		'end_time_hint_tip',
		'selected_dates_hint_tip',
		'selected_timedates_hint_tip',
		'selected_short_dates_hint_tip',
		'selected_short_timedates_hint_tip',
		'days_number_hint_tip',
		'nights_number_hint_tip'
	];

	for ( let el_i = 0; el_i < elements_arr.length; el_i++ ) {
		wpbc__spin_loader__micro__show__inside( elements_arr[ el_i ] + resource_id,
										  '#' + elements_arr[ el_i ] + resource_id +
										 ',.' + elements_arr[ el_i ] + resource_id );
	}

	if ( 'dynamic' === _wpbc.calendar__get_param_value( resource_id, 'days_select_mode' ) ) {
		var inst = wpbc_calendar__get_inst( resource_id );
		jQuery( '.wpbc_select_check_out_date_message' ).remove();
		if (
			   ( null !== inst )
			&& (inst.stayOpen === true)
		) {
			// jQuery('#date_booking' + resource_id).after(  '<div class="wpbc_select_check_out_date_message wpbc_front_end__message_container_left0"><div class="wpbc_front_end__message wpbc_fe_message_info">' + 'Please click on check out day to finish days selection' + '</div></div>');

			// Comment these 2 lines,  if we need to  show cost  hints,  if selected only 1 day
			jQuery( '.wpbc_ajax_loader,.wpbc_field_hint' ).html( '...' );
			return false;
		}
	}

	var my_booking_form_name = '';
	if ( document.getElementById( 'booking_form_type' + resource_id ) != undefined ) {
		my_booking_form_name = document.getElementById( 'booking_form_type' + resource_id ).value;
	}

	var ajax_type_action = 'CALCULATE_THE_COST';

    jQuery.ajax({                                           															// Start Ajax Sending
		url    : wpbc_url_ajax,
		type   : 'POST',
		success: function ( data, textStatus ) {
			if ( textStatus == 'success' ) {
				jQuery( '#ajax_respond_insert' + resource_id ).html( data );
			}
			jQuery( ".booking_form_div" ).trigger( "after_show_cost_hints", [resource_id] );
		},
        error: function (XMLHttpRequest, textStatus, errorThrown){window.status = 'Ajax sending Error status:'+ textStatus;alert(XMLHttpRequest.status + ' ' + XMLHttpRequest.statusText);if (XMLHttpRequest.status == 500) {alert('Please check at this page according this error:' + ' https://wpbookingcalendar.com/faq/#ajax-sending-error');}},
		data: {
			action             : ajax_type_action,
			form               : formdata,
			all_dates          : all_dates,
			bk_type            : resource_id,
			booking_form_type  : my_booking_form_name,
			wpdev_active_locale: _wpbc.get_other_param( 'locale_active' ),
			wpbc_nonce         : document.getElementById( 'wpbc_nonce' + ajax_type_action + resource_id ).value
		}
    });
	jQuery( ".booking_form_div" ).trigger( "show_cost_hints", [resource_id] );        									// FixIn: 7.0.1.53.
	jQuery( ".booking_form_div" ).trigger( "wpbc_booking_date_or_option_selected", [resource_id] );
	return false;
}


// FixIn: 10.8.1.3.
/**
 * Send request after few seconds (usually after 0,25 sec)
 * Closure function. It's useful for not sending too many Ajax requests...
 *
 *  $resource_id=4;
 * 	wpbc_show_cost_hints_after_few_seconds( $resource_id );																// Send after 0.25 seconds
 * 	wpbc_show_cost_hints_after_few_seconds( $resource_id, 0 );															// Immediate Send
 */
var wpbc_show_cost_hints_after_few_seconds = function (){

	var closed_timer = 0;

	return function ( resource_id, timer_delay ){

		// Get default value of "timer_delay",  if parameter was not passed into the function.
		timer_delay = typeof timer_delay !== 'undefined' ? timer_delay : 250;

		clearTimeout( closed_timer );		// Clear previous timer

		// Start new Timer
		closed_timer = setTimeout( wpbc_send_ajax__show_cost_hints.bind(  null, resource_id ), timer_delay );
	}
}();

// Legacy function  support.
function showCostHintInsideBkForm(resource_id) {
	wpbc_show_cost_hints_after_few_seconds( resource_id );
}