<?php
/**
 * Main file for Booking Calendar Personal.
 *
 * This is a COMMERCIAL SCRIPT. We cannot guarantee the functionality and support of the Booking Calendar if any files have been modified by anyone other than wpdevelop.
 *
 * @package     Booking Calendar.
 * @author      wpdevelop, oplugins
 * @web-site    https://wpbookingcalendar.com/
 * @email       info@wpbookingcalendar.com
 *
 * @modified    2009-09-01
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! defined( 'IS_USE_WPDEV_BK_CACHE' ) ) {
	define( 'IS_USE_WPDEV_BK_CACHE', true ); // FixIn: 9.9.0.13.
}

require_once WPBC_PRO_PLUGIN_DIR . '/inc/_ps/includes/booking_resources/resource_functions.php';  // Resources Functions.
require_once WPBC_PRO_PLUGIN_DIR . '/inc/_ps/includes/booking_resources/resource_property.php';   // Resources Meta - Properties of booking resources.  // FixIn: 9.9.0.13.

require_once(WPBC_PRO_PLUGIN_DIR. '/inc/_ps/hash/wpbc-hash.php' );       													// Class for hash generating and checking.		//FixIn: 8.4.7.20.1
require_once(WPBC_PRO_PLUGIN_DIR. '/inc/_ps/hash/wpbc-hash-functions.php' );    											// 1 Way Hash Functions 						//FixIn: 8.4.7.20.1


if ( ( ! defined( 'WPBC_NEW_FORM_BUILDER' ) ) || ( false === WPBC_NEW_FORM_BUILDER ) ){
	require_once WPBC_PRO_PLUGIN_DIR . '/inc/_ps/includes/booking_form/class-wpbc-form-shortcode-engine.php';
	require_once WPBC_PRO_PLUGIN_DIR . '/inc/_ps/includes/booking_form/class-wpbc-form-shortcode-engine-adapter.php';
}


require_once(WPBC_PRO_PLUGIN_DIR. '/inc/_ps/class/wpbc-settings-table.php' );       										// Abstract Settings Table Class

require_once(WPBC_PRO_PLUGIN_DIR. '/inc/_ps/admin/wpbc-resources-cache.php' );            									// Caching booking resources.
require_once(WPBC_PRO_PLUGIN_DIR. '/inc/_ps/admin/wpbc-resources-table.php' );            									// Class for showing Table of booking resources in Setting pages

require_once(WPBC_PRO_PLUGIN_DIR. '/inc/_ps/flex_table/wpbc_flextable.php' );       										// Abstract Settings FlexTable Class				// FixIn: 9.9.0.7.
require_once(WPBC_PRO_PLUGIN_DIR. '/inc/_ps/flex_table/wpbc_flextable_resources.php' );       								// Class for showing FlexTable of booking resources // FixIn: 9.9.0.7.
require_once(WPBC_PRO_PLUGIN_DIR. '/inc/_ps/flex_table/wpbc_flextable__reused_ui.php' );       								// Common reused UI elements in Flex Tables			// FixIn: 10.0.0.17.

require_once(WPBC_PRO_PLUGIN_DIR. '/inc/_ps/lib_p.php' );
require_once(WPBC_PRO_PLUGIN_DIR. '/inc/_ps/p-toolbar.php' );

require_once(WPBC_PRO_PLUGIN_DIR. '/inc/_ps/wpbc-booking-select-widget.php' );												// FixIn: 9.6.3.5.
require_once( WPBC_PRO_PLUGIN_DIR . '/inc/_ps/admin/page-resources.php' );          										//TODO: Finish this !

require_once(WPBC_PRO_PLUGIN_DIR. '/inc/_ps/form/class-wpbc-form-help.php' );
require_once(WPBC_PRO_PLUGIN_DIR. '/inc/_ps/wpbc-form-templates.php' );
//require_once(WPBC_PRO_PLUGIN_DIR. '/inc/_ps/includes/booking_form/form_templates.php' );									// Booking Form  Templates // FixIn: 10.6.2.1.


require_once( WPBC_PRO_PLUGIN_DIR . '/inc/_ps/includes/booking_form/flex_toolbar__booking_form.php' );                      // Toolbar for Booking Form

$is_use_simgple_form = get_bk_option( 'booking_is_use_simple_booking_form' );											// FixIn: 8.1.1.12.
if ( 'On' === $is_use_simgple_form ) {
	require_once( WPBC_PLUGIN_DIR . '/includes/page-form-simple/page-form-simple.php' );         // Booking Form Free
} else {
	require_once( WPBC_PRO_PLUGIN_DIR . '/inc/_ps/admin/page-settings-form.php' );	// Form
}

require_once( WPBC_PLUGIN_DIR . '/core/admin/page-email-new-admin.php' );       // Email - New Admin
require_once( WPBC_PLUGIN_DIR . '/core/admin/page-email-new-visitor.php' );     // Email - New Visitor
require_once( WPBC_PLUGIN_DIR . '/core/admin/page-email-deny.php' );            // Email - Deny
require_once( WPBC_PLUGIN_DIR . '/core/admin/page-email-approved.php' );        // Email - Approved
require_once( WPBC_PRO_PLUGIN_DIR . '/inc/_ps/admin/page-email-edit.php' );         // Email - Edit
require_once( WPBC_PLUGIN_DIR . '/core/admin/page-email-trash.php' );           // Email - Trash
require_once( WPBC_PLUGIN_DIR . '/core/admin/page-email-deleted.php' );           // Email - Trash

	require_once( WPBC_PLUGIN_DIR . '/core/admin/page-ics-general.php' );		// General ICS Help Settings page		// FixIn: 8.1.1.10.
	require_once( WPBC_PLUGIN_DIR . '/core/admin/page-ics-import.php' );		// Import ICS Help Settings page		//FixIn: 8.0
	require_once( WPBC_PLUGIN_DIR . '/core/admin/page-ics-export.php' );		// Export ICS Feeds Settings page		//FixIn: 8.0
    require_once( WPBC_PLUGIN_DIR . '/core/admin/page-import-gcal.php' );       // Import from  Google Calendar Settings page

require_once( WPBC_PRO_PLUGIN_DIR . '/inc/_ps/admin/br-table-import-gcal-p.php' );  // Import gCal functions for settings page - resources table
require_once( WPBC_PRO_PLUGIN_DIR . '/inc/_ps/admin/br-table-export-feeds.php' );   // Export Feeds (for ics) functions for settings page - resources table			//FixIn: 8.0

// FixIn: 9.6.3.5.
require_once(WPBC_PRO_PLUGIN_DIR. '/inc/_ps/wpbc-export-csv_v2.php' );              // Export bookings to  CSV	v2.0		// Export for Ajax Booking Listing page

require_once(WPBC_PRO_PLUGIN_DIR. '/inc/_ps/admin/api-settings-p.php' );            // Settings page
require_once(WPBC_PRO_PLUGIN_DIR. '/inc/_ps/admin/activation-p.php' );              // Activate / Deactivate

if ( file_exists(WPBC_PRO_PLUGIN_DIR. '/inc/_bs/biz_s.php') ) {
    require_once(WPBC_PRO_PLUGIN_DIR. '/inc/_bs/biz_s.php' ); }

require_once( WPBC_PRO_PLUGIN_DIR . '/inc/_ps/admin/page-settings-up.php' );


if ( is_admin() ) {

	// FixIn: 8.4.7.18.
	global $wp_version;
	if ( version_compare( $wp_version, '4.9', '>=' ) ) {

		// WordPress version is greater than 4.9 and support Code highlighter.
		$is_use_codehighlighter = get_bk_option( 'booking_is_use_codehighlighter_booking_form' );

		if ( 'Off' !== $is_use_codehighlighter ) {
			require_once( WPBC_PRO_PLUGIN_DIR . '/inc/_ps/codemirror/class-codemirror.php' );
		}
	}

	if ( file_exists( WPBC_PRO_PLUGIN_DIR . '/inc/_ps/wpbc-check-updates.php' ) ) {            // Checking updates
		require_once( WPBC_PRO_PLUGIN_DIR . '/inc/_ps/wpbc-check-updates.php' );
		$wpbc_plugin_updater = new WPBC_PlUpdater( WPBC_PRO_FILE, 'https://wpbookingcalendar.com/check-update/booking.json', array( 'version'        => WPBC_PRO_VERSION_NUM,
																																'plugin_html_id' => 'booking-calendar',
		) );
	}
}


class wpdev_bk_personal   {

    var $current_booking_type;
    var $wpdev_bk_biz_s;
    var $current_edit_booking;
    var $countries_list;

	function __construct() {

		$this->current_booking_type = 1;
		$this->current_edit_booking = false;

		add_bk_filter( 'wpbc_get_booking_data', array( &$this, 'get_booking_data' ) );

		// Ajax POST request for updating remark.
		add_bk_action( 'wpdev_make_update_of_remark', array( &$this, 'wpdev_make_update_of_remark' ) );

		// Ajax POST request for updating remark.
		add_bk_action( 'wpdev_delete_booking_by_visitor', array( &$this, 'delete_booking_by_visitor' ) );


		add_action( 'wpbc_define_js_vars', array( &$this, 'wpbc_define_js_vars' ) );
		add_action( 'wpbc_enqueue_js_files', array( &$this, 'wpbc_enqueue_js_files' ) );
		add_action( 'wpbc_enqueue_css_files', array( &$this, 'wpbc_enqueue_css_files' ) );

		if ( class_exists( 'wpdev_bk_biz_s' ) ) {
			$this->wpdev_bk_biz_s = new wpdev_bk_biz_s();
		} else {
			$this->wpdev_bk_biz_s = false;
		}

		// FixIn: 8.9.4.9 // FixIn: 8.8.3.8.
		add_action( 'wpbc_country_list_loaded', array( $this, 'wpbc_define_country_list_after_load_country_file' ), 10, 1 );

		add_bk_filter( 'wpdev_booking_set_booking_edit_link_at_email', array( &$this, 'set_booking_edit_link_at_email' ) );

		// Check if this booking resource exist or not exist anymore.
		add_bk_filter( 'wpdev_is_booking_resource_exist', array( &$this, 'wpdev_is_booking_resource_exist' ) );

		add_bk_filter( 'get_sql_for_checking_new_bookings', array( &$this, 'get_sql_for_checking_new_bookings' ) );

		// Check Admin pages, if some user can be there.
		add_bk_filter( 'recheck_version', array( $this, 'recheck_version' ) );

		// Select booking resource.
		add_bk_filter( 'wpdev_get_booking_select_form', array( &$this, 'wpdev_get_booking_select_form' ) );

		// Show booking resource Title or Cost.
		add_bk_filter( 'wpbc_booking_resource_info', array( &$this, 'wpbc_booking_resource_info' ) );
	}


	/**
	 * Define country list after country file was loaded by Booking Calendar
	 */
	function wpbc_define_country_list_after_load_country_file() {
		// FixIn: 8.9.4.9  // FixIn: 8.8.3.8.
		global $wpbc_booking_country_list;

		$this->countries_list = $wpbc_booking_country_list;
	}


// S U P P O R T       F u n c t i o n s    //////////////////////////////////////////////////////////////////////////////////////////////////

	// FixIn: 9.6.3.5.

	function get_sql_for_checking_new_bookings( $sql_req ) {
		global $wpdb;

		$trash_bookings = ' AND bk.trash != 1 ';  // FixIn: 6.1.1.10  - check also  below usage of {$trash_bookings}.

		$sql_req = "SELECT bk.booking_id FROM {$wpdb->prefix}booking as bk
                    INNER JOIN {$wpdb->prefix}bookingtypes as bt
                    ON  bk.booking_type = bt.booking_type_id WHERE bk.is_new = 1 {$trash_bookings}";

		return $sql_req;
	}


	// Check if this booking resource exist or not exist anymore.
	function wpdev_is_booking_resource_exist( $blank, $bk_type_id, $is_echo ) {
		global $wpdb;
		$wp_q = $wpdb->prepare( "SELECT booking_type_id as id FROM {$wpdb->prefix}bookingtypes WHERE booking_type_id = %d ", $bk_type_id );
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
		$res = $wpdb->get_results( $wp_q );
		if ( count( $res ) == 0 ) {
			if ( $is_echo ) {
				?>
				<script type="text/javascript">
					if (document.getElementById('booking_form_div<?php echo esc_attr( $bk_type_id ); ?>') !== null)
						document.getElementById('booking_form_div<?php echo esc_attr( $bk_type_id ); ?>').innerHTML = '<?php echo esc_js(__( 'This booking resources does not exist', 'booking' )); ?>';
				</script> <?php
			}

			return false;
		} else {
			return true;
		}
	}


	// FixIn: 9.6.3.5.

// S H O R T C O D E    Select Booking form using the select box

    // Shortcode to  show cost  or Title of booking resource
    function wpbc_booking_resource_info( $return_data_info, $attr ) {

		if ( isset( $attr['resource_id'] ) ) {  $attr['type'] = $attr['resource_id']; }
        if ( isset( $attr['type'] ) ) 
            $my_boook_type = $attr['type'];
        else 
            $my_boook_type = 1;
                
        if ( isset( $attr['show'] ) )  
            $show_info = $attr['show'];
        else
            $show_info = 'title';
              
        
        $booking_resource_attr = get_booking_resource_attr( $my_boook_type );
        
        if ( ! empty($booking_resource_attr) ) {
            
            switch ( $show_info ) {
                case 'title':
                    if ( isset( $booking_resource_attr->title ) ) {
                        $bk_res_title = wpbc_lang( $booking_resource_attr->title );
                        return $bk_res_title;
                    }
                    break;
                    
                case 'cost':
                    if (  ( class_exists('wpdev_bk_biz_s') ) && ( isset ($booking_resource_attr->cost ) )  ) {
                        
                        $booking_cost = wpbc_get_cost_with_currency_for_user( $booking_resource_attr->cost, $my_boook_type );
                        
                        return $booking_cost;
                    }
                    break;
                    
                case 'capacity':
                    if (  ( class_exists('wpdev_bk_biz_l') )  ) {  
                        
                        if ( isset( $attr['date'] ) ) {                         //FixIn: 6.2.3.5.1 - Ability to  use shortcode like: [bookingresource type=1 show='capacity' date='2016-09-13']                         
                            //$availability = apply_bk_filter('wpbc_get_availability_for_date', $my_boook_type, $attr['date'] );
                            $temp_date = explode('-',$attr['date']);
                            $mydate = array();
                            $mydate['year'] = intval( $temp_date[0] );
                            $mydate['month'] = intval( $temp_date[1] );
                            $mydate['day'] = intval( $temp_date[2] );

							//TODO: make getting capacity  from  _wpbc var !! and then  remove this filter
                            return  '-=-';
                        }
                        
                        $number_of_child_resources = apply_bk_filter('wpbc_get_number_of_child_resources', $my_boook_type );        
                        return  $number_of_child_resources ;
                    }
                    break;


                default:
                    break;
            }            
        }
        
        return $return_data_info;
    }
    
    
    // shortcode for Selection  of booking resources 
	function wpdev_get_booking_select_form( $booking_select_form, $attr ) {
		global $wpdb;

	    if ( isset( $attr['nummonths'] ) ) {
		    $my_boook_count = $attr['nummonths'];
	    } else {
		    $my_boook_count = 1;
	    }

	    if ( isset( $attr['resource_id'] ) ) {
		    $attr['type'] = $attr['resource_id'];
	    }
	    if ( isset( $attr['type'] ) ) {
		    $my_boook_type = $attr['type'];
	    }

	    if ( isset( $attr['form_type'] ) ) {
		    $my_booking_form = $attr['form_type'];
	    } else {
		    $my_booking_form = 'standard';
	    }

	    if ( isset( $attr['selected_type'] ) ) {
		    $selected_booking_resource = $attr['selected_type'];
	    } else {
		    $selected_booking_resource = '';
	    }
	    // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
	    if ( isset( $_GET['resource_id'] ) ) {
		    $selected_booking_resource = sanitize_text_field( wp_unslash( $_GET['resource_id'] ) );  /* phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing */ /* FixIn: sanitize_unslash */
	    }


	    if ( isset( $attr['label'] ) ) {
		    $label = $attr['label'];
	    } else {
		    $label = '';
	    }

	    if ( isset( $attr['first_option_title'] ) ) {
		    $first_option_title = $attr['first_option_title'];
	    } else {
		    $first_option_title = __( 'Please Select', 'booking' );
	    }

	    $first_option_title = wpbc_lang( $first_option_title );
	    // FixIn: 10.3.0.4.
	    $booking_select_form .= '<div class="wpbc_resource_selection_block"><div class="resource_selection_div wpbc_container wpbc_form wpbc_container_booking_form"><div class="wpbc__field">';
	    if ( ! empty( $label ) ) {
		    $booking_select_form .= '<label for="calendar_type">' . $label . '</label>';
	    }

	    // FixIn: 8.6.1.9.
	    $resource_selection_class = "active_booking_form";
	    $resource_selection_class = apply_filters( 'wpbc_booking_resources_selection_class', $resource_selection_class );
		$booking_select_form .= '<span class="wpbc_wrap_select wpdev-form-control-wrap">';
		$booking_select_form .= '<select name="active_booking_form" class="' . $resource_selection_class . '" onchange=" jQuery(this).parents(\'.wpbc_resource_selection_block\').find(\'.bk_forms\').css(\'display\', \'none\');';        // FixIn: 10.0.0.9.
		$booking_select_form .= 'document.getElementById(\'hided_booking_form\' + this.value).style.display=\'block\';" >';

	    if ( ! empty( $first_option_title ) ) {
		    $booking_select_form .= ' <option value="select" ' . ( ( $selected_booking_resource == '' ) ? ' selected="selected" ' : '' ) . '>' . $first_option_title . '</option> ';
	    }

	    $my_selected_dates_without_calendar = '';

	    $start_month_calendar = false;
	    if ( isset( $attr['startmonth'] ) ) { // Set start month of calendar, fomrat: '2011-1'
		    $start_month_calendar = explode( '-', $attr['startmonth'] );
		    if ( ( is_array( $start_month_calendar ) ) && ( count( $start_month_calendar ) > 1 ) ) {
		    } else {
			    $start_month_calendar = false;
		    }
	    }

	    $bk_otions = array();
	    if ( isset( $attr['options'] ) ) {
		    $bk_otions = $attr['options'];
	    }


	    // Select the booking resources
	    if ( ! empty( $my_boook_type ) ) {
		    $where = ' WHERE booking_type_id IN (' . $my_boook_type . ') ';
	    } else {
		    $where = ' ';
	    }

       $or_sort = 'title_asc';
	    if ( class_exists( 'wpdev_bk_biz_l' ) ) {
		    $or_sort = 'prioritet';
	    }

	    if ( strpos( $or_sort, '_asc' ) !== false ) {                            // Order
		    $or_sort   = str_replace( '_asc', '', $or_sort );
		    $sql_order = " ORDER BY " . $or_sort . " ASC ";
	    } else {
		    $sql_order = " ORDER BY " . $or_sort . " DESC ";
	    }

		if ( class_exists( 'wpdev_bk_biz_m' ) ) {
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
			$types_list = $wpdb->get_results( "SELECT booking_type_id as id, title, default_form as form FROM {$wpdb->prefix}bookingtypes" . $where . $sql_order );
		} else {
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
			$types_list = $wpdb->get_results( "SELECT booking_type_id as id, title FROM {$wpdb->prefix}bookingtypes" . $where . $sql_order );
		}

       // Sort booking resources by order, which  set in the "type" parameter of booking select shortcode.
       if ( ! empty($my_boook_type) ) {
            $br_data_array = array();
            foreach ( $types_list as $br_data ) {
                $br_data_array[ $br_data->id ] = $br_data;
            }
            $br_ordered_array = array();
            $br_order = explode(',', $my_boook_type);
            foreach ( $br_order as $br_id ) {
                if ( isset( $br_data_array[ $br_id ] ) ) {
                    $br_ordered_array[] = $br_data_array[ $br_id ];
                }
            }
            $types_list = $br_ordered_array;
       }

       if ( ( empty($first_option_title) ) && empty( $selected_booking_resource) && (! empty($types_list)) ) {
           $selected_booking_resource = $types_list[0]->id;
       }

	    foreach ( $types_list as $tl ) {
		    if ( $selected_booking_resource == $tl->id ) {
			    $is_res_selected = ' selected="SELECTED" ';
		    } else {
			    $is_res_selected = '';
		    }
		    $bk_res_title        = wpbc_lang( $tl->title );
		    $booking_select_form .= ' <option ' . $is_res_selected . ' value="' . $tl->id . '">' . $bk_res_title . '</option>';
	    }
	    $booking_select_form .= ' </select></span></div></div>';

	    if ( isset( $attr['selected_dates'] ) ) {
		    $my_selected_dates_without_calendar = $attr['selected_dates'];
	    }
	   
       foreach ($types_list as $tl) {

	       if ( $selected_booking_resource == $tl->id ) {
		       $is_res_selected = 'display: block;';
	       } else {
		       $is_res_selected = 'display: none;';
	       }
           
        $booking_select_form .= '<div class="bk_forms" id="hided_booking_form'.$tl->id.'" style="'.$is_res_selected.'">';



        $booking_resource_ids = $tl->id;												// FixIn: 8.1.3.22.
        if ( isset( $attr['aggregate'] )  && (! empty( $attr['aggregate'] )) ) {
            $booking_resource_ids .= ';' . $attr['aggregate'];
        }
		   if ( ( isset( $tl->form ) ) && ( ! isset( $attr['form_type'] ) ) ) {
			   $booking_select_form .= apply_bk_filter( 'wpdevbk_get_booking_form', $booking_resource_ids, $my_boook_count, $tl->form, $my_selected_dates_without_calendar, $start_month_calendar, $bk_otions );
		   } else {
			   $booking_select_form .= apply_bk_filter( 'wpdevbk_get_booking_form', $booking_resource_ids, $my_boook_count, $my_booking_form, $my_selected_dates_without_calendar, $start_month_calendar, $bk_otions );
		   }

	       $booking_select_form .= '</div>';
       }

	   $booking_select_form .= '</div>';
       return $booking_select_form;
    }


//     H   A   S   H                          //HASH_EDIT /////////////////////////////////////////////////////////////////////////////////////////


    // Check email body for booking editing link and replace this shortcode by link
    function set_booking_edit_link_at_email($mail_body,$booking_id ){


                $edit_url_for_visitors = get_bk_option( 'booking_url_bookings_edit_by_visitors');
                $edit_url_for_visitors = wpbc_lang( $edit_url_for_visitors );
	    		$edit_url_for_visitors = trim( $edit_url_for_visitors );								// FixIn: 10.6.6.3.

                $url_bookings_listing_by_customer = get_bk_option( 'booking_url_bookings_listing_by_customer');			//FixIn: 8.1.3.5.1
                $url_bookings_listing_by_customer = wpbc_lang( $url_bookings_listing_by_customer );
	    		$url_bookings_listing_by_customer = trim( $url_bookings_listing_by_customer );        	// FixIn: 10.6.6.3.

                $my_hash_start_parameter = '&booking_hash=';
                if (strpos($edit_url_for_visitors,'?')===false) {
                    $my_hash_start_parameter = '';
                    if (substr($edit_url_for_visitors,-1,1) != '/' ) $my_hash_start_parameter .= '/';
                    $my_hash_start_parameter .= '?booking_hash=';
                }
                $edit_url_for_visitors .= $my_hash_start_parameter;
				$url_bookings_listing_by_customer .= $my_hash_start_parameter;											//FixIn: 8.1.3.5.1


                $my_booking_id_type = wpbc_hash__get_booking_hash__resource_id( $booking_id );
                $my_edited_bk_hash = '';
                if ($my_booking_id_type !== false) {
                    $my_edited_bk_hash    = $my_booking_id_type[0];
                    $my_boook_type        = $my_booking_id_type[1];
                    $edit_url_for_visitors .= $my_edited_bk_hash;
                    $url_bookings_listing_by_customer .= $my_edited_bk_hash;											//FixIn: 8.1.3.5.1
                } else {
                	$edit_url_for_visitors = '';
                	$url_bookings_listing_by_customer = '';																//FixIn: 8.1.3.5.1
                }

                $mail_body = str_replace('[visitorbookingediturl]', $edit_url_for_visitors /*'<a href= "'.$edit_url_for_visitors.'" >' . esc_html__('Edit booking' ,'booking') . '</a>' */ , $mail_body);

                $mail_body = str_replace('[visitorbookingcancelurl]', $edit_url_for_visitors . '&booking_cancel=1'   , $mail_body);

                $mail_body = str_replace('[visitorbookingpayurl]', 
                        $edit_url_for_visitors . '&booking_pay=1', 
                        //' <a href="'. $edit_url_for_visitors . '&booking_pay=1' .'" >' .__('link' ,'booking') .'</a> ' ,
                        $mail_body);

                $mail_body = str_replace('[bookinghash]',$my_edited_bk_hash,$mail_body);

                $mail_body = str_replace('[visitorbookingslisting]', $url_bookings_listing_by_customer, $mail_body);	//FixIn: 8.1.3.5.1


                // Check for URL parameter in the shortcodes
                $shortcode_params = wpbc_get_params_of_shortcode_in_string('visitorbookingslisting', $mail_body);		//FixIn: 8.1.3.5.1
                if (! empty($shortcode_params) ) {
                   if ( isset($shortcode_params[ 'url' ]) ) {
                      $shortcode_params[ 'url' ] = str_replace('"', '', $shortcode_params[ 'url' ]);
                      $shortcode_params[ 'url' ] = str_replace("'", '', $shortcode_params[ 'url' ]);

                      $my_hash_start_parameter = '&booking_hash=';
                      if (strpos($shortcode_params[ 'url' ],'?')===false) {
                            $my_hash_start_parameter = '';
                            if (substr($shortcode_params[ 'url' ],-1,1) != '/' ) $my_hash_start_parameter .= '/';
                            $my_hash_start_parameter .= '?booking_hash=';
                      }
                      $mail_body_temp = substr($mail_body, 0, ($shortcode_params['start']-1) );
                      if ($my_booking_id_type !== false) { // Check if the HASH Exist at all  there
                             $link_url = $shortcode_params[ 'url' ] . $my_hash_start_parameter . $my_edited_bk_hash ;
							 $mail_body_temp .= $this->wpbc_email_parse_a_links_params( $link_url , $shortcode_params );
                      }
                      $mail_body_temp .= substr($mail_body, ($shortcode_params['end']+1) );
                      $mail_body = $mail_body_temp;
                   }
                }

                // Check for URL parameter in the shortcodes
                $shortcode_params = wpbc_get_params_of_shortcode_in_string('visitorbookingediturl', $mail_body);
                if (! empty($shortcode_params) ) {
                   if ( isset($shortcode_params[ 'url' ]) ) {
                      $shortcode_params[ 'url' ] = str_replace('"', '', $shortcode_params[ 'url' ]);
                      $shortcode_params[ 'url' ] = str_replace("'", '', $shortcode_params[ 'url' ]);

                      $my_hash_start_parameter = '&booking_hash=';
                      if (strpos($shortcode_params[ 'url' ],'?')===false) {
                            $my_hash_start_parameter = '';
                            if (substr($shortcode_params[ 'url' ],-1,1) != '/' ) $my_hash_start_parameter .= '/';
                            $my_hash_start_parameter .= '?booking_hash=';
                      }
                      $mail_body_temp = substr($mail_body, 0, ($shortcode_params['start']-1) );
                      if ($my_booking_id_type !== false) { // Check if the HASH Exist at all  there
                             $link_url = $shortcode_params[ 'url' ] . $my_hash_start_parameter . $my_edited_bk_hash ;
							 $mail_body_temp .= $this->wpbc_email_parse_a_links_params( $link_url , $shortcode_params );
                      }
                      $mail_body_temp .= substr($mail_body, ($shortcode_params['end']+1) );
                      $mail_body = $mail_body_temp;
                   }
                }

                // Check for URL parameter in the shortcodes
                $shortcode_params = wpbc_get_params_of_shortcode_in_string('visitorbookingcancelurl', $mail_body);
                if (! empty($shortcode_params) ) {
                   if ( isset($shortcode_params[ 'url' ]) ) {
                      $shortcode_params[ 'url' ] = str_replace('"', '', $shortcode_params[ 'url' ]);
                      $shortcode_params[ 'url' ] = str_replace("'", '', $shortcode_params[ 'url' ]);

                      $my_hash_start_parameter = '&booking_hash=';
                      if (strpos($shortcode_params[ 'url' ],'?')===false) {
                            $my_hash_start_parameter = '';
                            if (substr($shortcode_params[ 'url' ],-1,1) != '/' ) $my_hash_start_parameter .= '/';
                            $my_hash_start_parameter .= '?booking_hash=';
                      }
                      $mail_body_temp = substr($mail_body, 0, ($shortcode_params['start']-1) );
                      if ($my_booking_id_type !== false) { // Check if the HASH Exist at all  there
                             $link_url = $shortcode_params[ 'url' ] . $my_hash_start_parameter . $my_edited_bk_hash . '&booking_cancel=1';
							 $mail_body_temp .= $this->wpbc_email_parse_a_links_params( $link_url , $shortcode_params );
                      }
                      $mail_body_temp .= substr($mail_body, ($shortcode_params['end']+1) );
                      $mail_body = $mail_body_temp;
                   }
                }

                // Check for URL parameter in the shortcodes
                $shortcode_params = wpbc_get_params_of_shortcode_in_string('visitorbookingpayurl', $mail_body);
                if (! empty($shortcode_params) ) {
                   if ( isset($shortcode_params[ 'url' ]) ) {
                      $shortcode_params[ 'url' ] = str_replace('"', '', $shortcode_params[ 'url' ]);
                      $shortcode_params[ 'url' ] = str_replace("'", '', $shortcode_params[ 'url' ]);

                      $my_hash_start_parameter = '&booking_hash=';
                      if (strpos($shortcode_params[ 'url' ],'?')===false) {
                            $my_hash_start_parameter = '';
                            if (substr($shortcode_params[ 'url' ],-1,1) != '/' ) $my_hash_start_parameter .= '/';
                            $my_hash_start_parameter .= '?booking_hash=';
                      }
                      $mail_body_temp = substr($mail_body, 0, ($shortcode_params['start']-1) );

					  if ($my_booking_id_type !== false) { // Check if the HASH Exist at all  there

						  $link_url = $shortcode_params['url'] . $my_hash_start_parameter . $my_edited_bk_hash . '&booking_pay=1';
						  $mail_body_temp .= $this->wpbc_email_parse_a_links_params( $link_url , $shortcode_params );
                      }
                      $mail_body_temp .= substr($mail_body, ($shortcode_params['end']+1) );
                      $mail_body = $mail_body_temp;
                   }
                }

                return $mail_body;
    }


	/**
	 * Parse html A tag  based on shortcode parameters from  email
	 *
	 * @param $link_url		string URL link
	 * @param $shortcode_params	array
	 *
	 * @return string
	 */
	function wpbc_email_parse_a_links_params( $link_url, $shortcode_params = array() ) {

		$link_content = '';

		if ( ( ! empty( $shortcode_params['type'] ) ) && ( 'link' == $shortcode_params['type'] ) ) {
			$link_content .= '<a href="';
		}

		$link_content .= $link_url;

		if ( ( ! empty( $shortcode_params['type'] ) ) && ( 'link' == $shortcode_params['type'] ) ) {
			$link_content .= '">';
			if ( ! empty( $shortcode_params['title'] ) ) {
				$link_content .= wpbc_lang( $shortcode_params['title'] );
			} else {
				$link_content .= $link_url;
			}
			$link_content .= '</a>';
		}

		return $link_content;
	}


// D e l e t e
    // Delete some bookings by visitor request of Cancellation (Ajax request)
    function delete_booking_by_visitor(){   global $wpdb;

		// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		make_bk_action( 'check_multiuser_params_for_client_side', $_POST['bk_type'] );

		$booking_hash = sanitize_text_field( wp_unslash( $_POST['booking_hash'] ) );  /* phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing */ /* FixIn: sanitize_unslash */
		// FixIn: 8.1.3.7.
		$my_boook_type = intval( $_POST['bk_type'] );  // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing

        /* In case if we are editing booking for "child booking resource",  so  at  the page we are having
         * booking resource ID for "parent booking resource - its our $in_page_booking_type
         * But  after  checking hash we are getting $my_boook_type_new for child booking resource.
         * For HTML we need to use $in_page_booking_type
         */
        $in_page_booking_type = $my_boook_type;

        $denyreason = __('The booking was canceled by the visitor.' ,'booking');

        $my_edited_bk_id = false;
        $my_booking_id_type = wpbc_hash__get_booking_id__resource_id( $booking_hash );




        if ($my_booking_id_type !== false) {
            $my_edited_bk_id        = $my_booking_id_type[0];
            $my_boook_type_new      = $my_booking_id_type[1];

            if ( ($my_boook_type_new == '') || ($my_boook_type_new == false) ) {

                ?>
                <script type="text/javascript">
                    document.getElementById('submiting<?php echo esc_attr( $my_boook_type ); ?>').innerHTML = '<div class=\"wpbc_after_booking_thank_you_section\"><div class=\"wpbc_ty__container\"><div class=\"wpbc_ty__header\"><?php echo '<strong>' . esc_js(__('Oops!' ,'booking') ). '</strong> ' . esc_js(__('We could not find your booking. The link you used may be incorrect or has expired. If you need assistance, please contact our support team.' ,'booking') ); ?></div></div></div>';
                    document.getElementById("submiting<?php echo esc_attr( $my_boook_type ); ?>" ).style.display="block";
                </script>
                <?php
                die;
            }
            $my_boook_type = $my_boook_type_new;
        } else {
                ?>
                <script type="text/javascript">
                    document.getElementById('submiting<?php echo esc_attr( $my_boook_type ); ?>').innerHTML = '<div class=\"wpbc_after_booking_thank_you_section\"><div class=\"wpbc_ty__container\"><div class=\"wpbc_ty__header\"><?php echo '<strong>' . esc_js(__('Oops!' ,'booking')) . '</strong> ' . esc_js(__('We could not find your booking. The link you used may be incorrect or has expired. If you need assistance, please contact our support team.' ,'booking') ); ?></div></div></div>';
                    document.getElementById("submiting<?php echo esc_attr( $my_boook_type ); ?>" ).style.display="block";
                </script>
                <?php
                die();
        }


        if ( ($my_edited_bk_id !=false) && ($my_edited_bk_id !='')) {
            $approved_id_str = $my_edited_bk_id;
            $is_send_emeils = 1;


			wpbc_send_email_trash( $approved_id_str, $is_send_emeils, $denyreason );
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter, WordPress.DB.PreparedSQL.InterpolatedNotPrepared
			if ( false === $wpdb->query( "UPDATE {$wpdb->prefix}booking SET trash = 1 WHERE booking_id IN ({$approved_id_str})" ) ) {  // FixIn: 10.12.1.5.
				?>
				<script type="text/javascript"> document.getElementById('submiting<?php echo esc_attr( $my_boook_type ); ?>').innerHTML = '<div style=&quot;height:20px;width:100%;text-align:center;margin:15px auto;&quot;><?php debuge_error( 'Error during deleting dates at DB', __FILE__, __LINE__ ); ?></div>'; </script> <?php
				die();
			}
            wpbc_hash__update_booking_hash( $approved_id_str, $my_boook_type );											// FixIn: 8.4.2.4.

	        do_action( 'wpbc_visitor_action__booking_trash', $approved_id_str, $my_boook_type );                      	// FixIn: 10.2.0.3.

            // Visitor cancellation
            ?> <script type="text/javascript">
                document.getElementById('submiting<?php echo esc_attr( $in_page_booking_type ); ?>').innerHTML = '<div class=\"wpbc_after_booking_thank_you_section\"><div class=\"wpbc_ty__container\"><div class=\"wpbc_ty__header\"><?php echo esc_js(__('The booking has been canceled successfully' ,'booking')); ?></div></div></div>';
                document.getElementById("booking_form_div<?php echo esc_attr( $in_page_booking_type ); ?>" ).style.display="none";
                wpbc_do_scroll('#booking_form<?php echo esc_attr( $in_page_booking_type ); ?>' );
               </script>
            <?php
            die();
        }
    }

	// C l i e n t     s i d e     f u n c t i o n s.

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Define JavaScripts Variables               //////////////////////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    function wpbc_define_js_vars( $where_to_load = 'both' ){ 

    }    
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Load JavaScripts Files                     //////////////////////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////   
    function wpbc_enqueue_js_files( $where_to_load = 'both' ){
    	// FixIn: 8.1.1.5.
    	// This script can  make conflict with grvity form masked input fields. If loaded this file: 'gform_masked_input'. $base_url . '/js/jquery.maskedinput.min.js'
    	if ( ! wp_script_is( 'gform_masked_input' ) ) {
        	// FixIn: 8.7.9.10.
        	wp_enqueue_script( 'wpbc-meio-mask', WPBC_PRO_PLUGIN_URL . '/inc/js/meiomask.js', array( 'wpbc_all' ), WPBC_PRO_VERSION_NUM, array( 'in_footer' => WPBC_PRO_JS_IN_FOOTER ) );
        }
        wp_enqueue_script( 'wpbc-personal',  WPBC_PRO_PLUGIN_URL . '/inc/js/personal.js', array( 'wpbc_all' ), WPBC_PRO_VERSION_NUM, array( 'in_footer' => WPBC_PRO_JS_IN_FOOTER ) );
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Load CSS Files                     //////////////////////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////   
    function wpbc_enqueue_css_files( $where_to_load = 'both' ){         
        
    }
            

// B o o k i n g     T y p e s              //////////////////////////////////////////////////////////////////////////////////////////////////


	function get_default_booking_resource_id() {

		if ( class_exists( 'wpdev_bk_multiuser' ) ) {                           // If MU
			$bk_multiuser = apply_bk_filter( 'get_default_bk_resource_for_user', false );
			if ( $bk_multiuser !== false ) {
				return $bk_multiuser;
			}
		}

		global $wpdb;
		$mysql = "SELECT booking_type_id as id FROM  {$wpdb->prefix}bookingtypes ORDER BY id ASC LIMIT 1";
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
		$types_list = $wpdb->get_results( $mysql );
		if ( count( $types_list ) > 0 ) {
			$types_list = $types_list[0]->id;
		} else {
			$types_list = 1;
		}

		return $types_list;
	}


// P A R S E   F o r m                      //////////////////////////////////////////////////////////////////////////////////////////////////
    function get_booking_form($my_boook_type, $my_booking_form = 'standard', $custom_params = array() ){    // FixIn: 6.0.1.5.

        $this->current_booking_type = $my_boook_type;

        // Get from the HASH booking data - BK RES  & BK ID ////////////////
        $my_edited_bk_id = false;
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
        if (isset($_GET['booking_hash'])) {
			$get_booking_hash = ( ( isset( $_GET['booking_hash'] ) ) ? sanitize_text_field( wp_unslash( $_GET['booking_hash'] ) ) : '' );  /* phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing */ /* FixIn: sanitize_unslash */
            $my_booking_id_type = wpbc_hash__get_booking_id__resource_id( $get_booking_hash );
            if ($my_booking_id_type !== false) {
                if (   ($my_booking_id_type[1] == '') ){

                } else {            
                    $my_boook_type        = $my_booking_id_type[1];
                    $my_edited_bk_id = $my_booking_id_type[0];
                    $this->current_booking_type = $my_booking_id_type[1];
                }
            }
        }

        // Assign the current BK ID
        if ($my_edited_bk_id !== false)  {$this->current_edit_booking = $this->get_booking_data($my_edited_bk_id);}
        else                             {$this->current_edit_booking =  false;}

		// FixIn: 9.4.3.12.
		if (
			    ( false !== $this->current_edit_booking )
			 && ( ! empty( $this->current_edit_booking['parsed_form']['wpbc_custom_booking_form' . $my_boook_type ] ) )
		){
			$my_booking_form = $this->current_edit_booking['parsed_form']['wpbc_custom_booking_form' . $my_boook_type ]['value'];

			// FixIn: 9.5.1.1.
			// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
			if ( ! empty( $_GET['booking_form'] ) ) {
				$my_booking_form = wpbc_clean_text_value( $_GET['booking_form'] );  // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
			}
		}

		// Get the Booking Form content.
		if ( 'standard' === $my_booking_form ) {

            // S T A N D A R D.
            $booking_form = get_bk_option( 'booking_form' );

            // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
            if ( isset( $_GET['booking_hash'] ) ) {                             // Edit Booking - in case,  if booking resource have default custom form
                
                $is_load_custom_form = true;
                //MU :: if resource of "Regular User" - then  GET STANDARD user form ( if ( get_bk_option( 'booking_is_custom_forms_for_regular_users' ) !== 'On' ) )
                if ( class_exists('wpdev_bk_multiuser') ) {

                    $booking_resource_user_id = apply_bk_filter('get_user_of_this_bk_resource', false, $my_boook_type );

                    $is_booking_resource_user_super_admin = apply_bk_filter('is_user_super_admin',  $booking_resource_user_id );

                    if (  ( ! $is_booking_resource_user_super_admin ) && ( get_bk_option( 'booking_is_custom_forms_for_regular_users' ) !== 'On' )  ){

                        // Get Form of Regular User
                        $is_load_custom_form = false;
                    }   
                }                

                if ( $is_load_custom_form ) {
                    $custom_form_name = apply_bk_filter( 'wpbc_get_default_custom_form', 'standard', $my_boook_type );
                    $my_booking_form = $custom_form_name;                           //FixIn: 5.4.2
                    if ( ( $custom_form_name != 'standard' ) && ( ! empty( $custom_form_name ) )  )
                        $booking_form = apply_bk_filter( 'wpdev_get_booking_form', $booking_form, $custom_form_name );
                }
            }
            
            // If we have the name of booking form in the GET, so then  load it
            // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
            if ( isset( $_GET['booking_form'] ) ) {
                $my_booking_form = wpbc_clean_text_value( $_GET['booking_form'] );  // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
                $booking_form    = apply_bk_filter( 'wpdev_get_booking_form', $booking_form, $my_booking_form );
            }

        } else {  // C U S T O M
            $booking_form = get_bk_option( 'booking_form' );
            $booking_form = apply_bk_filter( 'wpdev_get_booking_form', $booking_form, $my_booking_form );
        }
        ////////////////////////////////////////////////////////////////////


        // Check  for the Active Language in the Booking Form.
        $booking_form =  wpbc_lang( $booking_form );

        // FixIn: 6.0.1.5.
        foreach ( $custom_params as $custom_params_key => $custom_params_value ) {
            $booking_form = str_replace( $custom_params_key, $custom_params_value, $booking_form );
        }
        // FixIn: 6.0.1.5.


	    $booking_form = wpbc_bf__replace_custom_html_shortcodes( $booking_form );


        // Add one additional  date for editing,  if "last_checkout_day_available" is "On"								 // FixIn: 8.4.4.6.
        if ( 	( 'On' === get_bk_option( 'booking_last_checkout_day_available' ) )
				&& ( ! empty($this->current_edit_booking) )
				&& ( ! empty($this->current_edit_booking[ 'dates' ] ) )
		) {
			// Dates in format: ..., [2] => 2019-03-13 00:00:00, [3] => 2019-03-14 12:00:02
			$last_day = $this->current_edit_booking[ 'dates' ][ ( count( $this->current_edit_booking[ 'dates' ] ) - 1 ) ];
			$check_out = strtotime( $last_day );
			$check_out = strtotime( '+1 day', $check_out );
			$last_day = date_i18n( "Y-m-d 00:00:00", strtotime( $last_day ) );
			$this->current_edit_booking[ 'dates' ][ ( count( $this->current_edit_booking[ 'dates' ] ) - 1 ) ] = $last_day;
			$this->current_edit_booking[ 'dates' ][] = date_i18n( "Y-m-d H:i:s", $check_out );
        }

        // Check when we edit "child resource" -> need re-update ID in calendar and form elements to have parent resource			// FixIn: 6.1.1.9.
        if ( $this->current_edit_booking !==  false ) {
            // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
            if (    // FixIn: 10.10.1.2     ( ! isset( $_GET['resource_no_update'] ) )                                   					// FixIn: 9.4.2.3.
				     ( function_exists( 'wpbc_is_this_child_resource') )
					&& ( wpbc_is_this_child_resource( $my_boook_type ) )
			){
                $bk_parent_br_id = wpbc_get_parent_resource( $my_boook_type );        

                $this->current_edit_booking['parsed_form'];

				$new_booking_data = array();

				foreach ( $this->current_edit_booking['parsed_form'] as $my_key_old => $booking_data ) {

                    $new_booking_data[ $booking_data['element_name'] . $bk_parent_br_id ]  = $booking_data;
                }

				$this->current_edit_booking['parsed_form'] = $new_booking_data;

                $this->current_booking_type = $bk_parent_br_id;
                $my_boook_type = $bk_parent_br_id;     
            }   
        }
        
        // P A R S E     Booking Form
		// Deprecated: 2025-08-09
        // $return_res = $this->form_elements($booking_form);

		// NEW: 2025-08-09
		// === 1) Create the engine (adapter keeps your CAPTCHA & helpers working) ===
		if ( class_exists( 'WPBC_BFB_FormShortcodeEngine_Adapter' ) ) {
			$engine = new WPBC_BFB_FormShortcodeEngine_Adapter( $this );
		} else {
			$engine = new WPBC_FormShortcodeEngine_Adapter( $this );
		}

		// === 2) Pass runtime context used by rendering/parsing ===
		$engine->current_booking_type = $this->current_booking_type;
		$engine->countries_list       = $this->countries_list;          // reuse your list
		$engine->processing_unit_tag  = isset( $this->processing_unit_tag ) ? $this->processing_unit_tag : null;
		$engine->current_edit_booking = $this->current_edit_booking ?: array();
		$engine->posted_data          = isset( $this->posted_data ) ? $this->posted_data : array();

		// === 3) Replace the old call with the engine render ===
		// OLD:
		// $return_res = $this->form_elements( $booking_form );
		// NEW:
		$return_res = $engine->render( $booking_form );



        // Re-update HINT shortcodes: [cost_hint], ...   and 	add JS for Conditional sections: [condition name="weekday-condition" type="weekday" value="*"] ...  [/condition]
        $return_res = apply_bk_filter('wpbc_update_bookingform_content__after_load',$return_res, $this->current_booking_type, $my_booking_form);

		// Re-update other hints,  such  as availability times hint.
	    $return_res = apply_filters( 'wpbc_booking_form_content__after_load', 		$return_res, $this->current_booking_type, $my_booking_form );

		/**
		 *  Replace these shortcodes:
			0 = "/\[bookingresource\s*show='id'\s*]/"
			1 = "/\[bookingresource\s*show='title'\s*]/"
			2 = "/\[bookingresource\s*show='cost'\s*]/"
			3 = "/\[bookingresource\s*show='capacity'\s*]/"
			4 = "/\[bookingresource\s*show='maxvisitors'\s*]/"
 		*/
        $return_res = $this->replace_bookingresource_info_in_form( $return_res, $this->current_booking_type );  // FixIn: 5.4.5.4.

        // Is this parameter used anywhere ?
        if ( $my_edited_bk_id !== false ) {
			$return_res .= '<input name="edit_booking_id"  id="edit_booking_id" type="hidden" value="'.$my_edited_bk_id.'">';
		}

		// This parameter used for update AJX cost hints and during creation  of booking
        if ( $my_booking_form != 'standard' ) {
			$return_res .= '<input name="booking_form_type'.$my_boook_type.'"  id="booking_form_type'.$my_boook_type.'" type="hidden" value="'.$my_booking_form.'">';
		}

        // JavaScript for Selecting Dates in Calendar ------------------------------------------------------------------
        if ( $my_edited_bk_id !== false ){
			$return_res .= wpbc_get_dates_selection_js_code( $this->current_edit_booking['dates'], $my_boook_type );	// FixIn: 9.2.3.4.
        }

		// Prevent editing, if booked dates already in the past. (Front-end only).
		$admin_uri = ltrim( str_replace( get_site_url( null, '', 'admin' ), '', admin_url('admin.php?') ), '/' ) ;		// FixIn: 8.8.1.2.
		$server_request_uri = ( ( isset( $_SERVER['REQUEST_URI'] ) ) ? sanitize_text_field( $_SERVER['REQUEST_URI'] ) : '' );  /* phpcs:ignore WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.MissingUnslash */ /* FixIn: sanitize_unslash */
		if ( strpos( $server_request_uri, $admin_uri ) === false  ) {			// Only in front-end side
			if ( $my_edited_bk_id !== false ){
				foreach ( $this->current_edit_booking['dates'] as $b_date) {
					if ( wpbc_is_date_in_past($b_date) ) {
						$return_res =   '<div class="wpdevelop"><div class="alert alert-warning alert-danger">' .
											__('The booked dates already in the past', 'booking')
									  . '</div></div>'
									  . '<script type="text/javascript">'
									  . '  setTimeout( function(){ jQuery( ".hasDatepick" ).hide(); }, 500 ) ; '
									  . '</script>';
					}
				}
			}
        }

		$return_res = apply_filters( 'wpbc_replace_shortcodes_in_booking_form', $return_res, $this->current_booking_type, $my_booking_form );			// FixIn: 9.4.3.6.

        return $return_res;
    }

    
    /**
	 * Replace folowing shortcodes in the booking form at Booking > Settings > Fields page:
        [bookingresource show='id'] - to booking resource ID
        [bookingresource show='title'] - to booking resource Title
        [bookingresource show='cost'] - to  booking resource Cost
        [bookingresource show='capacity'] - to booking resource Capacity
        [bookingresource show='maxvisitors'] - to booking resource maximum  number of visitors per resource
     * @param string $return_form
     * @param int $bk_type
     * @return string
     */
    function replace_bookingresource_info_in_form( $return_form, $bk_type ) {   // FixIn: 5.4.5.4.
        
        $patterns = array();
        
        $parameters = array( 'id', 'title', 'cost', 'capacity' );
        foreach ( $parameters as $parameter ) {
            $patterns[] = '/\[bookingresource\s*show=\''. $parameter .'\'\\s*]/';
        }

        
        $replacements = array( $bk_type );
        
        $booking_resource_attr = get_booking_resource_attr( $bk_type );
        
        if ( ! empty($booking_resource_attr) ) {
            
            if ( isset( $booking_resource_attr->title ) ) {
                $bk_res_title = wpbc_lang( $booking_resource_attr->title );
                $replacements[] = $bk_res_title;
            } else $replacements[] = '';

            if (  ( class_exists('wpdev_bk_biz_s') ) && ( isset ($booking_resource_attr->cost ) )  ) {
                
                
                $replacements[] = wpbc_get_cost_with_currency_for_user( $booking_resource_attr->cost, $bk_type );
                
            } else $replacements[] = '';


        }
        $replaced_form = preg_replace( $patterns, $replacements, $return_form);
             

        return $replaced_form;
    }
    

    function get_booking_data($booking_id){
        global $wpdb;

        if (isset($booking_id)) $booking_id = $wpdb->prepare( " WHERE  bk.booking_id = %d " , $booking_id );
        else                    $booking_id = ' ';

        $sql = "SELECT * FROM {$wpdb->prefix}booking as bk
                INNER JOIN {$wpdb->prefix}bookingdates as dt
                ON    bk.booking_id = dt.booking_id
                ". $booking_id .
                " ORDER BY dt.booking_date ASC ";
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
		$result = $wpdb->get_results( $sql );
        $return = array( 'dates'=>array());
        foreach ($result as $res) { $return['dates'][] = $res->booking_date; }
        $return['form'] = $res->form;
        $return['type'] = $res->booking_type;
        $return['approved'] = $res->approved;
        $return['id'] = $res->booking_id;

        // Parse data from booking form ////////////////////////////////////
        $bktype = $res->booking_type;
        $parsed_form = $res->form;
        $parsed_form = explode('~',$parsed_form);

        $parsed_form_results  = array();

        foreach ($parsed_form as $field) {
            $elemnts = explode('^',$field);
            if ( count ( $elemnts ) < 3 ) { continue; }																	// FixIn: 8.2.1.3.
            $type = $elemnts[0];
            $element_name = $elemnts[1];
            $value = $elemnts[2];

            $count_pos = strlen( $bktype );
            //debuge(substr( $elemnts[1], 0, -1*$count_pos ))                ;
            $type_name = $elemnts[1];
            $type_name = str_replace('[]','',$type_name);
            if ($bktype == substr( $type_name,  -1*$count_pos ) ) $type_name = substr( $type_name, 0, -1*$count_pos );

            if ($type_name == 'email') { if ( ! isset($email_adress)) { $email_adress = $value; } }     // FixIn: 6.0.1.9.
            if ($type_name == 'name')  { $name_of_person = $value; }
            if ($type == 'checkbox') {
                if ($value == 'true')   { $value = 'on'; }
                else {
                    if (($value == 'false') || ($value == 'Off') || ( !isset($value) ) )  $value = '';
                }
            }
            $element_name = str_replace('[]','',$element_name);
            if ( isset($parsed_form_results[$element_name]) ) {
                if ($value !=='') $parsed_form_results[$element_name]['value'] .= ',' . $value;
            } else
                $parsed_form_results[$element_name] = array('value'=>$value, 'type'=> $type, 'element_name'=>$type_name );
        }
        $return['parsed_form'] = $parsed_form_results;
        ////////////////////////////////////////////////////////////////////
        if (isset($email_adress))   $return['email'] = $email_adress;
        if (isset($name_of_person)) $return['name']  = $name_of_person;

        return $return;
    }


    //     R  E   M   A   R   K   S      /////////////////////////////////////////////////////////////////////////////////////////

		// FixIn: 9.6.3.5.

	function wpdev_make_update_of_remark( $remark_id, $remark_text, $is_append = false ) {

		// Save notes only  if activated this option.  // FixIn: 9.9.0.41.
		if ( get_bk_option( 'booking_log_booking_actions' ) !== 'On' ) {
			return;
		}

		$my_remark = str_replace( '"', '', $remark_text );
		$my_remark = str_replace( "'", '', $my_remark );
		$my_remark = trim( wp_strip_all_tags( $my_remark ) );
		// $my_remark = substr($my_remark,0,75) . '...';

		global $wpdb;

		if ( $is_append ) {
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
			$my_remark .= "\n" . $wpdb->get_var( $wpdb->prepare( "SELECT remark FROM {$wpdb->prefix}booking  WHERE booking_id = %d ", $remark_id ) );
			// FixIn: 8.6.1.10 - added new line "\n".
		}

		$update_sql = $wpdb->prepare( "UPDATE {$wpdb->prefix}booking SET remark= %s WHERE booking_id= %d ", $my_remark, $remark_id );  // FixIn: 10.12.1.5.
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
		if ( false === $wpdb->query( $update_sql ) ) {
			echo '<div class="error_message ajax_message textleft" style="font-size:12px;font-weight:600;">';
			debuge_error( 'Error during updating remark of booking', __FILE__, __LINE__ );
			echo '</div>';

		}
	}



    // Check if user can be at some admin panel, which belong to specific booking resource
    function recheck_version($blank){ 

        $ver = get_bk_option('bk_version_data');      

        if ( $ver === false ) {
            ?>
            <div id="recheck_version">
                <div class="clear" style="height:10px;"></div>
                <script type="text/javascript">
                    function sendRecheck(order_num){

                        // Code geeted from  this function:  wpbc_admin_show_message( wpbc_message, 'info', 10000 );                                                               

                        var wpbc_message = ' <span class="wpdevelop"><span class="wpbc_icn_rotate_right wpbc_spin wpbc_ajax_icon"  aria-hidden="true"></span></span> '
                                            + '<?php echo esc_js( __('Sending request...' ,'booking') ) ; ?>';
                        var wpbc_alert_class = 'notice notice-info ';
                        jQuery('#ajax_working').html(   '<div id="wpbc_alert_message" class="wpbc_alert_message">' +
                                                            '<div ' 
                                                                + 'id="ajax_message"'           //Backward compatibility
                                                                + ' class="wpbc_inner_message ' + wpbc_alert_class + '"> ' +
                                                                '<a class="close" href="javascript:void(0)" onclick="javascript:jQuery(this).parent().hide();">&times;</a> ' + 
                                                                wpbc_message + 
                                                            '</div>' +
                                                        '</div>'
                                                    );
                        //jQuery('#wpbc_alert_message').animate( {opacity: 1}, 60000 ).fadeOut(500);        
                                                            
                        jQuery.ajax({                                           // Start Ajax Sending
                            url: '<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>',
                            type:'POST',
                            success: function (data, textStatus){if( textStatus == 'success')   jQuery('#ajax_respond').html( data );},
                            error:function (XMLHttpRequest, textStatus, errorThrown){window.status = 'Ajax sending Error status:'+ textStatus;alert(XMLHttpRequest.status + ' ' + XMLHttpRequest.statusText);if (XMLHttpRequest.status == 500) {alert('Please check at this page according this error:' + ' https://wpbookingcalendar.com/faq/#ajax-sending-error');}},
                            data:{
                                action : 'CHECK_BK_VERSION',
                                order_num:order_num,
                                wpbc_nonce: document.getElementById('wpbc_admin_panel_nonce').value 
                            }
                        });
                    }
                </script>
                <div style="margin:15px auto;" class="code_description wpdevelop">
                    <div class="shortcode_help_section well0">
                        <div style="width:auto;text-align: center;padding:10px;">
                            <span style="font-weight:600;font-size:1.1em;line-height:24px;margin-right:10px;" ><?php esc_html_e('Order number' ,'booking'); ?>:</span>
                            <input type="text" maxlength="20" value="" style="width:170px;" id="bk_order_number" name="bk_order_number" />
                            <input class="button" style="" type="button" value="<?php esc_attr_e('Register' ,'booking'); ?>" name="submit_advanced_resources_settings" onclick="javascript:sendRecheck(document.getElementById('bk_order_number').value);" />
                            <div class="clear" style="height:10px;"></div>
                            <span style="font-style: italic;text-shadow:0 1px 0 #fff;font-size:1em;"><?php esc_html_e('Please, enter order number of your purchased version, which you received to your billing email.' ,'booking'); ?></span>
                            <div class="clear" style="height:20px;"></div>
                            <span class="description" style="font-style: italic;font-size:1em;"><?php
								/* translators: 1: ... */
								echo wp_kses_post( sprintf( __( 'If you will get any difficulties or have a questions, please contact by email %s' ,'booking'),'<code><a href="mailto:activate@wpbookingcalendar.com">activate@wpbookingcalendar.com</a></code>') ); ?></span><br/>
                        </div>
                    </div>
                </div>
            </div>            
            <?php 
            return false;
        }
        return true;
    }

}
