<?php
/**
 * Functions for booking resources.
 *
 * This is a COMMERCIAL SCRIPT. We cannot guarantee the functionality and support of the Booking Calendar if any files have been modified by anyone other than wpdevelop.
 *
 * @package     Booking Calendar.
 * @author      wpdevelop, oplugins
 * @web-site    https://wpbookingcalendar.com/
 * @email       info@wpbookingcalendar.com
 *
 * @modified    2025-07-30
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Create a new booking resource and save in Database.
 *
 * @return void
 */
function wpbc_create_new_booking_resource( $params ){

	$defaults = array(
		'title' => 'Resource Name',
	);
	$params   = wp_parse_args( $params, $defaults );

	global $wpdb;

	$sql = $wpdb->prepare( 'INSERT INTO {$wpdb->prefix}bookingtypes (title) VALUES (%s)', $params['title'] );

	$num_rows = $wpdb->query( $sql );  // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter

	if ( false === $num_rows ) {
		debuge_error( 'Error inserting into DB', __FILE__, __LINE__ );
	}

	if ( 1 === $num_rows ) {
		do_action( 'wpbc_resource_created', $wpdb->insert_id );
	} else {
		do_action( 'wpbc_resources_created', $num_rows );
	}
	make_bk_action( 'wpbc_reinit_booking_resource_cache' );
}
