<?php
/**
 * Description
 *
 * @package     Booking Calendar.
 * @author      wpdevelop, oplugins
 * @web-site    https://wpbookingcalendar.com/
 * @email       info@wpbookingcalendar.com
 *
 * @modified    2025-08-09
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


class WPBC_FormShortcodeEngine_Adapter extends WPBC_FormShortcodeEngine {
	private $owner;

	public function __construct( $owner ) {
		$this->owner = $owner;
	}

	protected function canonicalize( $str ) {
		return method_exists( $this->owner, 'canonicalize' ) ? $this->owner->canonicalize( $str ) : $str;
	}

	protected function captchac_options( $options ) {
		return method_exists( $this->owner, 'captchac_options' ) ? $this->owner->captchac_options( $options ) : array();
	}

	protected function generate_captcha( $op ) {
		return method_exists( $this->owner, 'generate_captcha' ) ? $this->owner->generate_captcha( $op ) : false;
	}

	protected function captcha_tmp_url() {
		return method_exists( $this->owner, 'captcha_tmp_url' ) ? $this->owner->captcha_tmp_url() : '';
	}
}
