<?php /**
 * @version 1.0
 * @package Booking Calendar 
 * @category UI elements for Toolbar Booking Listing / Calendar Overview pages
 * @author wpdevelop
 *
 * @web-site https://wpbookingcalendar.com/
 * @email info@wpbookingcalendar.com 
 * 
 * @modified 2016-02-15
 * 
 * This is COMMERCIAL SCRIPT
 * We are not guarantee correct work and support of Booking Calendar, if some file(s) was modified by someone else then wpdevelop.
 */

if ( ! defined( 'ABSPATH' ) ) exit;                                             // Exit, if accessed directly


// ---------------------------------------------------------------------------------------------------------------------
//   S e a s o n      F i l t e r s      T a b l e
// ---------------------------------------------------------------------------------------------------------------------

/** Show Toolbar at  Booking > Resources page - Add New Resource */
function wpbc_add_new_seasonfilters_toolbar() {

	$submit_form_name = WPBC_Page_Settings__seasonfilters::ACTION_FORM;

	wpbc_clear_div();

	//  Toolbar ////////////////////////////////////////////////////////////////

	?><div id="toolbar_seasonfilters" style="position:relative;"><?php

		wpbc_bs_toolbar_sub_html_container_start();

		//  T o o l b a r
		?><div id="seasonfilters_toolbar_container" class="visibility_container clearfix-height" style="display:block;margin-top:-5px;"><?php

			?><div class="control-group wpbc-no-padding" style="margin:8px 15px 0 0;"><?php
				?><a href="javascript:void(0);"
					onclick="javascript:jQuery('#action_<?php echo esc_attr( $submit_form_name ); ?>').val('create_filter_range_days');jQuery('#<?php echo esc_attr( $submit_form_name ); ?>').trigger( 'submit' );"
					style="margin:0 15px 0 0;"
					 class="button button-primary tooltip_top" data-original-title="<?php esc_attr_e('Create dates filter' , 'booking'); ?>">
					 <span class="wpbc_icn_view_comfy" aria-hidden="true"></span>&nbsp;<span class="in-button-text"><?php
							esc_html_e('Create dates filter', 'booking');
				?></span></a><?php

				?><a href="javascript:void(0);"
					onclick="javascript:jQuery('#action_<?php echo esc_attr( $submit_form_name ); ?>').val('create_filter_conditional');jQuery('#<?php echo esc_attr( $submit_form_name ); ?>').trigger( 'submit' );"
					style="margin:0;"
					class="button tooltip_top" data-original-title="<?php esc_attr_e('Create conditional days filter' , 'booking'); ?>">
						<span class="wpbc_icn_rule" aria-hidden="true"></span>&nbsp;<span class="in-button-text"><?php
							esc_html_e('Create conditional days filter', 'booking');
				?></span></a><?php

			?></div><?php


			?><div class="control-group wpbc-no-padding" style="margin:-3px 0 -17px;float: right;"><?php

				wpbc_toolbar_search_by_id__top_form( array(
															'search_form_id' => 'wpbc_seasonfilters_search_form'
														  , 'search_get_key' => 'wh_search_id'
														  , 'is_pseudo'      => false
														  , 'container_style'=> ''		// FixIn: 10.0.0.29.
											) );
			?></div><?php

			wpbc_clear_div();

		   // wpbc_toolbar_expand_collapse_btn( 'advanced_booking_filter' );

		?></div><?php

		wpbc_bs_toolbar_sub_html_container_end();

	?></div><?php

	wpbc_clear_div();

}