<?php /**
 * @version 1.0
 * @package Booking Calendar
 * @category Flex Toolbar for Custom Forms
 * @author wpdevelop
 *
 * @web-site https://wpbookingcalendar.com/
 * @email info@wpbookingcalendar.com
 *
 * @modified 2024-08-13
 */

if ( ! defined( 'ABSPATH' ) ) exit;                                             // Exit, if accessed directly


/**
 *  UI Flex Elements   ->   ../includes/_toolbar_ui/flex_ui_elements.php
 */

// ---------------------------------------------------------------------------------------------------------------------
//  Toolbar with UI elements 	for 	"Custom  Forms"
// ---------------------------------------------------------------------------------------------------------------------

/**
 * Show toolbar content for selection  and creation  of the Custom Booking Forms
 *
 * @return void
 */
function wpbc_flex_toolbar__custom_forms( $is_show_add_new_custom_form = true ){

	// Check if MU user can be here
	$is_can = apply_bk_filter( 'multiuser_is_user_can_be_here', true, 'only_super_admin' );
	if ( ( ! $is_can ) && ( get_bk_option( 'booking_is_custom_forms_for_regular_users' ) !== 'On' ) ) {
		return;
	}

	// Check submit of 'Adding New Custom Form' and reload the page.
	$is_submited = wpbc_custom_forms__maybe_submit_new_custom_form();

	if ( $is_submited ) {
		return;
	}

	// Get Custom Booking Forms 		'Data array'
	$booking_forms_extended = wpbc_custom_forms__get_data_arr();

	?><div class="ui_group ui_group___custom_forms__selection"><?php

		?><div class="ui_element"><?php
			$on_change = 'wpbc_change_custom_booking_form_in_url__and_reload(this);';

			// Show DropDown list with Custom forms selection
			wpbc_flex_ui__dropdown_list__custom_forms( $booking_forms_extended, $on_change );

			// Delete Button
			// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
			if ( ( $is_show_add_new_custom_form ) && ( isset( $_GET['booking_form'] ) ) && ( 'standard' !== $_GET['booking_form'] ) ) {
				wpbc_flex_ui___custom_forms__delete_button();
			}

		?></div><?php

	?></div><?php

	if ( $is_show_add_new_custom_form ) {

		?><div class="ui_group ui_group___custom_forms__selection"><?php

			?><div class="ui_element"><?php
				wpbc_flex_ui___custom_forms__show_create_form_button();
			?></div><?php

		?></div><?php

		?><form action="" method="post"  name="post_settings_form_fields_new_form" id="post_settings_form_fields_new_form"><?php
		?><div class="ui_group ui_group___custom_forms__show_create_form_button" style="display:none;"><?php

			?><div class="ui_element"><?php
				wpbc_flex_ui___custom_forms__name_text();
			?></div><?php

			?><div class="ui_element"><?php
				wpbc_flex_ui___custom_forms__add_new_button();
			?></div><?php

			?><div class="ui_element"><?php
				wpbc_flex_ui___custom_forms__cancel_new_button();
			?></div><?php

		?></div><?php

		?></form><?php
	}
}


// ---------------------------------------------------------------------------------------------------------------------
//  UI Elements
// ---------------------------------------------------------------------------------------------------------------------

/**
 *  Show Dropdown List  - Custom  Booking Forms		selection
 */
function wpbc_flex_ui__dropdown_list__custom_forms( $booking_forms_extended, $on_change ) {

	$id = 'select_booking_form';

	// ? Maybe this:
	// $form_options = wpbc_toolbar__get_custom_forms__options_for_selection();

	$form_options = array();

	$form_options['standard'] = array(
										'title'    => __( 'Standard', 'booking' ),
										'id'       => '',
										'name'     => '',
										'style'    => 'padding:3px;border-bottom: 1px dashed #ccc;',
										'class'    => '',
										'disabled' => false,
										'selected' => false,
										'attr'     => array()
									);

	$form_options[ 'optgroup_cf_s' ] = array( 'optgroup' => true, 'close'  => false, 'title'  => '&nbsp;' . __('Custom Forms' ,'booking')  );
	foreach ( $booking_forms_extended as $cust_form ) {

		$form_options[ $cust_form['name'] ] = array(
													'title'    => wpbc_lang( $cust_form['name'] ),
													'id'       => '',
													'name'     => '',
													'style'    => '',
													'class'    => '',
													'disabled' => false,
													'selected' => ( ( isset( $_GET['booking_form'] ) ) && ( $_GET['booking_form'] == $cust_form['name'] ) ) ? true : false,  // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
													'attr'     => array()
												);
	}
	$form_options[ 'optgroup_cf_e' ] = array( 'optgroup' => true, 'close'  => true );


	$params_select = array(
		'id'       => $id, 									// HTML ID  of element
		'name'     => $id,
		'options'  => $form_options,
		'onchange' => $on_change
		// 'label' => __('Booking Form', 'booking') . ':'							// Label (optional)
		//	, 'style' => ''                     								// CSS of select element
		//	, 'class' => ''                     								// CSS Class of select element
		//	, 'multiple' => false
		//	, 'attr' => array()                 								// Any additional attributes, if this radio | checkbox element
		//	, 'disabled' => false
		//	, 'disabled_options' => array( 2, 30 )     							// If some options disabled, then it has to list here
		//	, 'value' => ( isset( $escaped_search_request_params[ 'next_days' ] ) ) ? $escaped_search_request_params[ 'next_days' ] : '183'	// Some Value from options array that selected by default
		//	, 'onfocus' =>  "console.log( 'ON FOCUS:', jQuery( this ).val(), 'in element:' , jQuery( this ) );"					// JavaScript code
	);

	wpbc_flex_label(
						array(
							'id'    => $id,
							'label' => __( 'Custom Form', 'booking' ) . ':',
							'style' => 'font-weight:600;'                     // CSS of select element
						)
					);

	wpbc_flex_select( $params_select );
}


	/**
	 * Show UI Button	-	"Show creation of new custom booking form section"
	 * @return void
	 */
	function wpbc_flex_ui___custom_forms__show_create_form_button(){

			$booking_action = 'wpbc_flex_ui___custom_forms__show_create_form_button';

			$el_id = 'ui_btn_' . $booking_action;

			$params  =  array(
				'type'             => 'button' ,
				'title'            => '',//__( 'Add New', 'booking' ) . '&nbsp;&nbsp;',  											// Title of the button
				'hint'             => array( 'title' =>  __('Add New Custom Form', 'booking'), 'position' => 'top' ),  	// Hint
				'link'             => 'javascript:void(0)',  																	// Direct link or skip  it
				'action'           => "jQuery('.ui_group___custom_forms__show_create_form_button' ).show();"
									. "jQuery('.ui_group___custom_forms__selection' ).hide();"
									. " setTimeout(function ( ) { jQuery('#booking_form_new_name').trigger( 'focus' ); } ,100); ",		  // Focus
				'icon' 			   => array(
											'icon_font' => 'wpbc_icn_add _circle_outline',
											'position'  => 'left',
											'icon_img'  => ''
										),
				'class'            => 'wpbc_ui_button 0wpbc_ui_button_primary',  																						// ''  | 'wpbc_ui_button_primary'
				'style'            => '',																						// Any CSS class here
				'mobile_show_text' => true,																						// Show  or hide text,  when viewing on Mobile devices (small window size).
				'attr'             => array( 'id' => $el_id )
			);

			wpbc_flex_button( $params );
	}


	/**
	 * Show UI Button	-	"Delete" 	 Custom Form
	 * @return void
	 */
	function wpbc_flex_ui___custom_forms__delete_button(){

		$user = wpbc_get_current_user();
		$user_bk_id = $user->ID;

		$booking_action = 'wpbc_flex_ui___custom_forms__delete_button';

		$el_id = 'ui_btn_' . $booking_action;

		$params  =  array(
			'type'             => 'button' ,
			'title'            => '',//__( 'Reset', 'booking' ) . '&nbsp;&nbsp;',  							// Title of the button
			'hint'             => array( 'title' => __( 'Delete selected booking form', 'booking' ), 'position' => 'top' ),  	// Hint
			'link'             => 'javascript:void(0)',  													// Direct link or skip  it
			'action'           => " if ( wpbc_are_you_sure('" . esc_js(__('Do you really want to delete selected booking form ?' ,'booking')) . "') ) { "
								  . " wpbc_delete_custom_booking_form( document.getElementById('select_booking_form').options[document.getElementById('select_booking_form').selectedIndex].value, " . $user_bk_id . " ); "
								  . "}"  ,
			'icon' 			   => array(
										'icon_font' => 'wpbc_icn_close0 wpbc_icn_delete_outline',
										'position'  => 'left',
										'icon_img'  => ''
									),
			'class'            => 'wpbc_ui_button wpbc_ui_button_danger0',  														// ''  | 'wpbc_ui_button_primary'
			'style'            => '',																		// Any CSS class here
			'mobile_show_text' => true,																		// Show  or hide text,  when viewing on Mobile devices (small window size).
			'attr'             => array( 'id' => $el_id )
		);

		wpbc_flex_button( $params );
	}


	/**
	 * Show UI Text	-	"Enter Name of custom form" 	Custom Form
	 */
	function wpbc_flex_ui___custom_forms__name_text(){

		$el_id = 'booking_form_new_name';

		$default_value = '';

		$params = array(
						'type'          => 'text'
						, 'id'          => $el_id
						, 'name'        => $el_id
						, 'label'       => ''
						, 'disabled'    => false
						, 'class'       => ''
						, 'style'       => 'min-width:210px;'
						, 'placeholder' => __('Type the name of booking form' ,'booking')
						, 'attr'        => array( 'maxlength' => '30' )
						, 'value' 		=> $default_value
						, 'onfocus' 	=> ''
		);

		wpbc_flex_text( $params );
	}


	/**
	 * Show UI Button	-	"Add New" 	Custom Form
	 * @return void
	 */
	function wpbc_flex_ui___custom_forms__add_new_button(){

			$booking_action = 'wpbc_flex_ui___custom_forms__add_new_button';

			$el_id = 'ui_btn_' . $booking_action;

			$params  =  array(
				'type'             => 'button' ,
				'title'            => __( 'Create', 'booking' ),  												// Title of the button
				'hint'             => array( 'title' =>  __('Add New Custom Form', 'booking'), 'position' => 'top' ),  	// Hint
				'link'             => 'javascript:void(0)',  																	// Direct link or skip  it
				'action'           => " document.forms['post_settings_form_fields_new_form'].submit(); " ,
				'icon' 			   => array(
											//'icon_font' => 'wpbc_icn_add _circle_outline',
											'position'  => 'right',
											'icon_img'  => ''
										),
				'class'            => 'wpbc_ui_button_primary',  																						// ''  | 'wpbc_ui_button_primary'
				'style'            => '',																						// Any CSS class here
				'mobile_show_text' => true,																						// Show  or hide text,  when viewing on Mobile devices (small window size).
				'attr'             => array( 'id' => $el_id )
			);

			wpbc_flex_button( $params );
	}


	/**
	 * Show UI Button	-	"Cancel" 	Creation  of new Custom Form
	 * @return void
	 */
	function wpbc_flex_ui___custom_forms__cancel_new_button(){

			$booking_action = 'wpbc_flex_ui___custom_forms__cancel_new_button';

			$el_id = 'ui_btn_' . $booking_action;

			$params  =  array(
				'type'             => 'button' ,
				'title'            => '',//__( 'Reset', 'booking' ) . '&nbsp;&nbsp;',  							// Title of the button
				'hint'             => array( 'title' => __( 'Cancel', 'booking' ), 'position' => 'top' ),  	// Hint
				'link'             => 'javascript:void(0)',  													// Direct link or skip  it
				'action'           => "jQuery('.ui_group___custom_forms__show_create_form_button' ).hide();"
									. "jQuery('.ui_group___custom_forms__selection' ).show();" ,
				'icon' 			   => array(
											'icon_font' => 'wpbc_icn_close',
											'position'  => 'left',
											'icon_img'  => ''
										),
				'class'            => 'wpbc_ui_button',  														// ''  | 'wpbc_ui_button_primary'
				'style'            => '',																		// Any CSS class here
				'mobile_show_text' => true,																		// Show  or hide text,  when viewing on Mobile devices (small window size).
				'attr'             => array( 'id' => $el_id )
			);

			wpbc_flex_button( $params );
	}





// ---------------------------------------------------------------------------------------------------------------------
// Get Data | Add new custom  Form
// ---------------------------------------------------------------------------------------------------------------------

/**
 * Get Custom Booking Forms 		Data array
 *
 * @return array|mixed|string
 *
 * 										[
 * 											[
 * 												'name'    => $new_name,
 * 												'form'    => $my_default_form,
 * 												'content' => $my_default_form_show
 * 											],
 *                           				...
 * 										]
 */
function wpbc_custom_forms__get_data_arr() {

	$booking_forms_extended = get_bk_option( 'booking_forms_extended' );

	if ( $booking_forms_extended === false ) {

		// No Forms, yet.
		$booking_forms_extended = array();

	} else {

		$booking_forms_extended = maybe_unserialize( $booking_forms_extended );

		if ( ! is_array( $booking_forms_extended ) ) {
			// Some error ?	// FixIn: 8.7.6.9.
			$booking_forms_extended = array();
		}

		// Check about possible issue - if the Name of Custom  form contain "+" symbol, it can generate issue of not loading custom form. We need to replace this symbol.
		$is_fix_exist = false;
		foreach ( $booking_forms_extended as $key => $value ) {

			if ( false !== strpos( $value['name'], '+' ) ) {
				$value['name']                          = str_replace( '+', 'plus', $value['name'] );
				$booking_forms_extended[ $key ]['name'] = $value['name'];
				$is_fix_exist                           = true;
			}
		}
		if ( $is_fix_exist ) {
			update_bk_option( 'booking_forms_extended', serialize( $booking_forms_extended ) );
			$booking_forms_extended = get_bk_option( 'booking_forms_extended' );
			$booking_forms_extended = maybe_unserialize( $booking_forms_extended );
		}
	}

	return $booking_forms_extended;
}


/**
 * Maybe Submit -  'Add New Custom Form'  and reload the page.
 *
 * This function set $_GET['booking_form'] = $new_name;
 *
 * @return bool
 */
function wpbc_custom_forms__maybe_submit_new_custom_form() {

	// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
	if ( ( isset( $_POST['booking_form_new_name'] ) ) && ( ! empty( $_POST['booking_form_new_name'] ) ) ) {

		// Form name no longer than 30 symbols.
		// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
		$new_name = substr( sanitize_text_field( wp_unslash( $_POST['booking_form_new_name'] ) ), 0, 30 );

		// Remove all symbols, which can  generate an issues.
		$new_name = wpbc_get_slug_format( $new_name );

		$_GET['booking_form'] = $new_name;

		// Get Default Forms
		$my_default_form      = str_replace( '\\n\\', '', wpbc_get_default_booking_form() );
		$my_default_form_show = str_replace( '\\n\\', '', wpbc_get_default_booking_form_show() );


		$booking_forms_extended = get_bk_option( 'booking_forms_extended' );

		if ( $booking_forms_extended === false ) {

			// First Time Creation -------------------------------------------------------------------------------------
			$booking_forms_extended = array(
												array(
													'name'    => $new_name,
													'form'    => $my_default_form,
													'content' => $my_default_form_show
												)
										);
		} else {

			// Append Custom form to exist forms -----------------------------------------------------------------------
			$booking_forms_extended = maybe_unserialize( $booking_forms_extended );

			if ( is_string( $booking_forms_extended ) ) {
				// Something was going wrong with  custom  forms. Its will  reset  custom  booking forms				// FixIn: 8.7.3.7.
				$booking_forms_extended = array();
			}

			// Get all exist custom names
			$exist_custom_forms_names = array();
			foreach ( $booking_forms_extended as $cust_form ) {
				$exist_custom_forms_names[] = $cust_form['name'];
			}

			// If new custom name not exist  then add this custom form.
			if ( ! in_array( $new_name, $exist_custom_forms_names ) ) {
				$booking_forms_extended[] = array(
													'name'    => $new_name,
													'form'    => $my_default_form,
													'content' => $my_default_form_show
												);
			}
		}

		// Save Changes
		update_bk_option( 'booking_forms_extended', serialize( $booking_forms_extended ) );

		// Show message
		wpbc_show_changes_saved_message();

		?><div style="padding: 0.5em 0;font-weight: 600;font-size: 13px;">Page reloading...&nbsp; &nbsp;<a href="javascript:void(0)" onclick="javascript:window.location.href = '<?php
			// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			echo ( wpbc_get_settings_url()  . '&tab=form&booking_form=' . $new_name ); ?>">Click to Reload</a></div><?php

		// Reload Page
		?><script type="text/javascript"> window.location.href = '<?php
				// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				echo ( wpbc_get_settings_url() . '&tab=form&booking_form=' . $new_name ); ?>'; </script><?php

		return  true;
	}

	return false;
}
