<?php /**
 * @version 1.0
 * @package Booking Calendar
 * @category  Custom Forms
 * @author wpdevelop
 *
 * @web-site https://wpbookingcalendar.com/
 * @email info@wpbookingcalendar.com
 *
 * @modified 2024-08-16
 */

if ( ! defined( 'ABSPATH' ) ) exit;                                             // Exit, if accessed directly


/**
 *  UI Flex Elements   ->   ../includes/_toolbar_ui/flex_ui_elements.php
 */

// ---------------------------------------------------------------------------------------------------------------------
//  Get Data 	for 	"Custom  Forms"
// ---------------------------------------------------------------------------------------------------------------------

/**
 * Get custom booking form FIELDS or DATA_SHOW. check description bellow
 *
 * @param string $default_return_form_content
 * @param string $custom_form_name
 * @param bool | string $serialized_form_content (optional)             default false
 * @param string $what_to_return (optional) { 'content' | 'form' }      default 'content'
 * @param bool $is_replace_simple_html (optional)                       default true
 *
 * @return string
 *
 *  get_bk_option( 'booking_forms_extended' )  -> contain array of all  custom  forms like this:
 * 			[
 *       		[   [name] => 'my-super-form-name',  [form] => '[calendar] ...', 	[content] => 'First Name:[name]... ' ],
 *       		[   [name] => 'other-form-name'   ,  [form] => '[calendar] ...', 	[content] => 'Other Name:[name]... ' ]
 *          ]
 *
 */
function wpbc_get_custom_booking_form( $default_return_form_content, $custom_form_name, $serialized_form_content = false, $what_to_return = 'content', $is_replace_simple_html = true ) {     // FixIn: 8.1.3.19.

	$custom_form_name = str_replace( '  ', ' ', $custom_form_name );

	if ( false === $serialized_form_content ) {
		$serialized_form_content = get_bk_option( 'booking_forms_extended' );
	}

	if ( ! empty( $serialized_form_content ) ) {

		$custom_form_content = maybe_unserialize( $serialized_form_content );

		if ( is_array( $custom_form_content ) ) {

			foreach ( $custom_form_content as $one_from ) {

				if ( isset( $one_from['name'] ) ) {

					$one_from['name'] = str_replace( '  ', ' ', $one_from['name'] );

					if ( ( $one_from['name'] == $custom_form_name ) && ( ( isset( $one_from[ $what_to_return ] ) ) ) ) {

						$booking_form_return = ( $is_replace_simple_html )
												? wpbc_bf__replace_custom_html_shortcodes( $one_from[ $what_to_return ] )
												: $one_from[ $what_to_return ];

						return $booking_form_return;
					}
				}
			}
        }
	}

	return $default_return_form_content;
}


/** Save Custom Booking Form */
function wpbc_make_save_custom_booking_form() {

	$booking_form = $booking_form_show = $new_name = '';

	// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
	if ( isset( $_GET['booking_form'] ) ) {
		$new_name = sanitize_text_field( wp_unslash( $_GET['booking_form'] ) );  /* phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing */ /* FixIn: sanitize_unslash */
	}
	// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
	if ( ! empty( $_POST['booking_form_new_name'] ) ) {
		$new_name = substr( sanitize_text_field( wp_unslash( $_POST['booking_form_new_name'] ) ), 0, 30 );  // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
	}

	// We can  not use here such code:
	// WPBC_Settings_API::validate_textarea_post_static( 'booking_form' );   or 	//wp_kses.
	// Important !!! instead of 'wp_kses_post'   		Use this: 		wpbc_form_escape_in_demo().
	// because it's will  remove also JavaScript,  which  possible to  use for wizard form  or in some other cases.

	// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
	$booking_form = ( isset( $_POST['booking_form'] ) ) ? trim( stripslashes( $_POST['booking_form'] ) ) : '';
	// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
	$booking_form_show = ( isset( $_POST['booking_form_show'] ) ) ? trim( stripslashes( $_POST['booking_form_show'] ) )
		: '';

	if ( wpbc_is_this_demo() ) {                                                                                        // FixIn: 9.7.3.3.1.
		$booking_form      = wpbc_form_escape_in_demo( $booking_form );
		$booking_form_show = wpbc_form_escape_in_demo( $booking_form_show );

		/**
		 * If we use any links or images or any  other URLs then  do  not save it in the live demos!
		 */
		$protocols = implode( '|', array_map( 'preg_quote', wp_allowed_protocols() ) );

		$is_exist_in_form = preg_match( '/(' . $protocols . '):/is', $booking_form );
		$is_exist_in_data = preg_match( '/(' . $protocols . '):/is', $booking_form_show );
		if ( ( $is_exist_in_form ) || ( $is_exist_in_data ) ) {
			// TODO: show error message of not ability to  save it.
			return;
		}
	}


	if ( ( ! empty( $new_name ) ) && ( ! empty( $booking_form ) ) && ( ! empty( $booking_form_show ) ) ) {

		$booking_forms_extended = get_bk_option( 'booking_forms_extended' );
		if ( false !== $booking_forms_extended ) {
			if ( is_serialized( $booking_forms_extended ) ) {
				$booking_forms_extended = unserialize( $booking_forms_extended );
			}
			$i = 0;
			// Check already exist names for rewrite it.
			foreach ( $booking_forms_extended as $value ) {
				if ( $value['name'] === $new_name ) {
					$booking_forms_extended[ $i ]['form']    = $booking_form;
					$booking_forms_extended[ $i ]['content'] = $booking_form_show;
					$i                                       = 'modified';
					break;
				}
				++$i;
			}
			if ( 'modified' !== $i ) {  // add new booking form.
				$booking_forms_extended[ count( $booking_forms_extended ) ] = array( 'name'    => $new_name,
																					 'form'    => $booking_form,
																					 'content' => $booking_form_show,
				);
			}

		} else {
			$booking_forms_extended = array( array( 'name'    => $new_name,
													'form'    => $booking_form,
													'content' => $booking_form_show,
											 ),
			);
		}

		update_bk_option( 'booking_forms_extended', serialize( $booking_forms_extended ) );
	}
}
add_bk_action('wpbc_make_save_custom_booking_form', 'wpbc_make_save_custom_booking_form' );


function wpbc_is_custom_booking_form_submitted__for_simple_form_mode() {
	// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
	if ( ( ( class_exists( 'wpdev_bk_biz_m' ) ) && ( isset( $_REQUEST['booking_form'] ) ) ) && ( ( ( ( isset( $_POST['booking_form_new_name'] ) ) && ( ! empty( $_POST['booking_form_new_name'] ) ) ) || ( ( isset( $_GET['booking_form'] ) ) && ( $_GET['booking_form'] !== 'standard' ) ) ) /* && ($_POST['select_booking_form'] !== 'standard') /**/ ) ) {
		return true;
	} else {
		return false;
	}
}

function wpbc_get_sanitized_custom_booking_form_name_from_url() {

	$custom_form_name = '';

	// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
	if ( ! empty( $_GET['booking_form'] ) ) {
		$custom_form_name = sanitize_text_field( wp_unslash( $_GET['booking_form'] ) );  /* phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing */ /* FixIn: sanitize_unslash */
	}
	// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
	if ( ! empty( $_POST['booking_form_new_name'] ) ) {
		// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$custom_form_name = substr( $_POST['booking_form_new_name'], 0, 30 );
	}

	$custom_form_name = wpbc_clean_text_value( $custom_form_name );

	return $custom_form_name;
}

function wpbc_save_custom_booking_form__for_simple_form_mode( $form_name, $simple_form_configuration ){

	if ( ( ! empty( $form_name ) ) && ( ! empty( $simple_form_configuration ) ) ) {

		$booking_forms_extended__simple_form_mode = get_bk_option( 'booking_forms_extended' );

        if ($booking_forms_extended__simple_form_mode !== false) {
	        $booking_forms_extended__simple_form_mode = maybe_unserialize( $booking_forms_extended__simple_form_mode );
            $i = 0;
            // Check already exist names for rewrite it
            foreach ($booking_forms_extended__simple_form_mode as $value) {
	            if ( $value['name'] == $form_name ) {
		            $booking_forms_extended__simple_form_mode[ $i ]['simple_form'] = $simple_form_configuration;
		            $booking_forms_extended__simple_form_mode[ $i ]['form']    = str_replace( '\\n\\', '', wpbc_simple_form__get_booking_form__as_shortcodes( $simple_form_configuration ) );;
		            $booking_forms_extended__simple_form_mode[ $i ]['content'] = str_replace( '\\n\\', '', wpbc_simple_form__get_form_show__as_shortcodes( $simple_form_configuration ) );
		            $i = 'modified';
		            break;
	            }
	            $i++;
            }
	        if ( $i !== 'modified' ) {  // add new booking form

		        $advanced_form      = str_replace( '\\n\\', '', wpbc_simple_form__get_booking_form__as_shortcodes( $simple_form_configuration ) );
		        $advanced_form_show = str_replace( '\\n\\', '', wpbc_simple_form__get_form_show__as_shortcodes(    $simple_form_configuration ) );

		        $booking_forms_extended__simple_form_mode[ count( $booking_forms_extended__simple_form_mode ) ] = array(
			        'name'        => $form_name,
			        'simple_form' => $simple_form_configuration,
			        'form'        => $advanced_form,
			        'content'     => $advanced_form_show
		        );
	        }

        } else {

			$advanced_form      = str_replace( '\\n\\', '', wpbc_simple_form__get_booking_form__as_shortcodes( $simple_form_configuration ) );
			$advanced_form_show = str_replace( '\\n\\', '', wpbc_simple_form__get_form_show__as_shortcodes(    $simple_form_configuration ) );

	        $booking_forms_extended__simple_form_mode = array(
																array(
																	'name' 		  => $form_name,
																	'simple_form' => $simple_form_configuration,
																	'form'        => $advanced_form,
																	'content'     => $advanced_form_show
																)
															);
        }

		update_bk_option( 'booking_forms_extended', serialize( $booking_forms_extended__simple_form_mode ) );
	}
}

function wpbc_get_custom_booking_form__for_simple_form_mode( $form_name ){

	$simple_form_configuration = wpbc_simple_form__visual__get_default_form();

	if ( ! empty( $form_name ) ) {

		$booking_forms_extended__simple_form_mode = get_bk_option( 'booking_forms_extended' );

		if ( $booking_forms_extended__simple_form_mode !== false ) {
			$booking_forms_extended__simple_form_mode = maybe_unserialize( $booking_forms_extended__simple_form_mode );
			foreach ( $booking_forms_extended__simple_form_mode as $value ) {
				if ( ( $value['name'] == $form_name ) && ( ! empty( $value['simple_form'] ) ) ) {
					return $value['simple_form'];
				}
			}
		}
	}

	return $simple_form_configuration;
}

/** Delete Custom Booking Form - run in Ajax request */
function wpbc_make_delete_custom_booking_form(){

    // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
    if (isset($_POST['formname'])) {

        $form_name = sanitize_text_field( wp_unslash( $_POST['formname'] ) );  /* phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing */ /* FixIn: sanitize_unslash */

        if ( !defined( 'WP_ADMIN' ) ) define( 'WP_ADMIN', true );               // this function is executed only in admin panel. In some servers, the WP_ADMIN constant is not defined, and thats can generate issue in MultiUser version, where will not select the specific user

        $booking_forms_extended = get_bk_option( 'booking_forms_extended' );
        if ( $booking_forms_extended !== false ) {

            $booking_forms_extended = maybe_unserialize( $booking_forms_extended );

            $booking_forms_extended_new = array();

            foreach ( $booking_forms_extended as $value ) {

                if ( $value['name'] == $form_name ) {
                    continue;  //skip it
                } else {
                    $booking_forms_extended_new[] = $value;
                }
            }

            update_bk_option( 'booking_forms_extended', serialize( $booking_forms_extended_new ) );
            ?><script type="text/javascript">
                    var my_message = '<?php echo  esc_js( __( 'Deleted', 'booking' )  ); ?>';
                    wpbc_admin_show_message( my_message, 'warning', 1000 );
                    window.location.href='<?php
						// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						echo ( wpbc_get_settings_url() ) . '&tab=form&booking_form=standard'; ?>';
                </script><?php
        } else {
            ?><script type="text/javascript">
                    var my_message = '<?php echo  esc_js( __( 'There are no extended booking forms', 'booking' )  ); ?>';
                    wpbc_admin_show_message( my_message, 'warning', 1000 );
                    window.location.href='<?php
						// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						echo ( wpbc_get_settings_url() ) . '&tab=form&booking_form=standard'; ?>';
                </script><?php
        }
    }
}
add_bk_action('wpbc_make_delete_custom_booking_form', 'wpbc_make_delete_custom_booking_form' );





// ---------------------------------------------------------------------------------------------------------------------
//  B u t t o n s   -  ADD NEW Booking page
// ---------------------------------------------------------------------------------------------------------------------


/** Selection  of Custom  booking forms */
function wpbc_in_settings__form_selection( $params = array() ) {

    $defaults = array(
                          'name'        => 'select_booking_form'
                        , 'title'       => __('Booking Form', 'booking')
                        , 'description' => __('Select default custom booking form' ,'booking')
                        , 'group'       => 'general'
                        , 'init_options' => array()                             // Init default list of options
                    );
    $params = wp_parse_args( $params, $defaults );


    // Check if we can be here  ////////////////////////////////////////////////
    $is_can = apply_bk_filter( 'multiuser_is_user_can_be_here', true, 'only_super_admin' );

	// Here we must  use 'get_option' instead of 'get_bk_option' because we always get  this option  from  the Super booking admin  user !!!
	if ( ( ! $is_can ) && ( get_option( 'booking_is_custom_forms_for_regular_users' ) !== 'On' ) ) {
		return;
	}


	// -----------------------------------------------------------------------------------------------------------------
    $booking_forms_extended = get_bk_option( 'booking_forms_extended' );
    if ( $booking_forms_extended !== false ) {

        $booking_forms_extended = maybe_unserialize( $booking_forms_extended );

//		if ( ! is_array( $booking_forms_extended ) ) {																		// FixIn: 7.2.1.2.
//			// Something wrong with  this custom  booking forms,  so  we will  try  to reset  it.
//			delete_bk_option( 'booking_forms_extended' );		// Delete custom form  option
//			$booking_forms_extended = array();
//		}

        ////////////////////////////////////////////////////////////////////////////
        // DropDown list with Custom Forms  ////////////////////////////////////////


        $form_options = $params['init_options'];

        $form_options['standard'] = array(
                                            'title' => __('Standard', 'booking')
                                            , 'class' => ''
                                            , 'attr' => array( 'style' => '' )
                                        );

        $form_options[ 'optgroup_cf_s' ] = array( 'optgroup' => true, 'close'  => false, 'title'  => '&nbsp;' . __('Custom Forms' ,'booking')  );

        foreach ( $booking_forms_extended as $cust_form ) {

            $form_options[ $cust_form['name'] ] = array(
                                            'title' => wpbc_lang( $cust_form['name'] )
                                            , 'attr' => array()
                                        );
        }

        $templates[ 'optgroup_cf_e' ] = array( 'optgroup' => true, 'close'  => true );

        ////////////////////////////////////////////////////////////////////////


        WPBC_Settings_API::field_select_row_static(   $params['name']
                                                    , array(
                                                              'type'              => 'select'
                                                            , 'title'             => $params['title']
                                                            , 'label'             => ''
                                                            , 'disabled'          => false
                                                            , 'disabled_options'  => array()
                                                            , 'multiple'          => false
                                                            , 'description'       => $params['description']
                                                            , 'description_tag'   => 'span'
                                                            , 'tr_class'          => $params['group'] . '_standard_section'
                                                            , 'group'             => $params['group']
                                                            , 'class'             => ''
                                                            , 'css'               => 'margin-right:10px;'
                                                            , 'only_field'        => false
                                                            , 'attr'              => array()
                                                            , 'value'             => ''
                                                            , 'options'           => $form_options
                                                        )
                                            );

    }
}

	function wpbc_toolbar__get_custom_forms__options_for_selection() {

		$form_options = array();
		$form_options['standard'] = array(
												  'title' => __('Standard', 'booking')
												, 'id' => ''
												, 'name' => ''
												, 'style' => 'padding:3px;border-bottom: 1px dashed #ccc;'
												, 'class' => ''
												, 'disabled' => false
												, 'selected' => false
												, 'attr' => array()
											);

		// Check if we can be here  ////////////////////////////////////////////////
		$is_can = apply_bk_filter( 'multiuser_is_user_can_be_here', true, 'only_super_admin' );
		if ( ( ! $is_can ) && ( get_bk_option( 'booking_is_custom_forms_for_regular_users' ) !== 'On' ) ) {
			return $form_options;
		}

		// Set Default custom booking form for specific selected booking resource.
		// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
		if ( isset( $_GET['booking_type'] ) ) {
			// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
			$my_booking_form_name = apply_bk_filter( 'wpbc_get_default_custom_form', 'standard', $_GET['booking_type'] );
			// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
			if ( ! isset( $_GET['booking_form'] ) )
				$_GET['booking_form'] = $my_booking_form_name;
		}

		////////////////////////////////////////////////////////////////////////////
		$booking_forms_extended = get_bk_option( 'booking_forms_extended' );
		if ( $booking_forms_extended !== false ) {

			$booking_forms_extended = maybe_unserialize( $booking_forms_extended );

			// Show DropDown list with Custom forms selection
			$form_options = wpbc_get_custom_forms_arr__for_options( $booking_forms_extended );

		}

		return $form_options;
	}

		/**
		 * Get array with Custom Forms - prepared for selectbox options
		 * @param $booking_forms_extended
		 *
		 * @return array
		 */
		function wpbc_get_custom_forms_arr__for_options( $booking_forms_extended  ) {

			$form_options = array();

			$form_options['standard'] = array(
												'title' => __('Standard', 'booking')
												, 'id' => ''
												, 'name' => ''
												, 'style' => 'padding:3px;border-bottom: 1px dashed #ccc;'
												, 'class' => ''
												, 'disabled' => false
												, 'selected' => false
												, 'attr' => array()
											);

			$form_options[ 'optgroup_cf_s' ] = array( 'optgroup' => true, 'close'  => false, 'title'  => '&nbsp;' . __('Custom Forms' ,'booking')  );

			foreach ( $booking_forms_extended as $cust_form ) {

				$form_options[ $cust_form['name'] ] = array(
												  'title' => wpbc_lang( $cust_form['name'] )
												, 'id' => ''
												, 'name' => ''
												, 'style' => ''
												, 'class' => ''
												, 'disabled' => false
												, 'selected' => ( ( isset( $_GET['booking_form'] ) ) && ( $_GET['booking_form'] === $cust_form['name'] ) ) ? true : false   // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
												, 'attr' => array()
											);
			}

			$form_options[ 'optgroup_cf_e' ] = array( 'optgroup' => true, 'close'  => true );

			 return $form_options;
		}


/** Selection  of Custom  booking forms */
function wpbc_toolbar_btn__form_selection( $params = array() ) {

    $defaults = array(
                          'on_change'   => false
                        , 'title'       => __('Booking Form', 'booking') . ':'
                    );
    $params = wp_parse_args( $params, $defaults );


    // Check if we can be here  ////////////////////////////////////////////////
    $is_can = apply_bk_filter( 'multiuser_is_user_can_be_here', true, 'only_super_admin' );
    if ( ( !$is_can ) && ( get_bk_option( 'booking_is_custom_forms_for_regular_users' ) !== 'On' ) )
        return;



    // Set Default custom booking form for specific selected booking resource //
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
    if ( isset( $_GET['booking_type'] ) ) {
		// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
        $my_booking_form_name = apply_bk_filter( 'wpbc_get_default_custom_form', 'standard', $_GET['booking_type'] );
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
        if ( ! isset( $_GET['booking_form'] ) )
            $_GET['booking_form'] = $my_booking_form_name;
    }

	// -----------------------------------------------------------------------------------------------------------------
    $booking_forms_extended = get_bk_option( 'booking_forms_extended' );
    if ( $booking_forms_extended !== false ) {

        $booking_forms_extended = maybe_unserialize( $booking_forms_extended );

        $parameter_name = 'booking_form';

        if ( $params['on_change'] === false ) {

            $link_base = wpbc_get_new_booking_url__base( array( $parameter_name ) ) . '&' . $parameter_name . '=' ;

            $on_change = 'location.href=\'' . $link_base . '\' + this.value;';

        } else {
            $on_change = $params['on_change'];
        }


        // Show DropDown list with Custom forms selection
        wpbc_dropdown_list_with_custom_forms( $booking_forms_extended, $on_change , $params );

    }
}


// ---------------------------------------------------------------------------------------------------------------------
//  B u t t o n s   -  ADD NEW Booking page
// ---------------------------------------------------------------------------------------------------------------------

/**
	 * Interface for selection / creation / deletion  of Custom forms at Booking > Settings > Fields page (and in Booking > Resources > Advanced cost page )
 *
 * @param boolean $is_show_add_new_custom_form - show or not "add new booking form fields
 */
function wpbc_toolbar_btn__custom_forms_in_settings_fields( $is_show_add_new_custom_form = true) {

    // Check  if user can  be here
    $is_can = apply_bk_filter('multiuser_is_user_can_be_here', true, 'only_super_admin');
    if ( (! $is_can) && ( get_bk_option( 'booking_is_custom_forms_for_regular_users' ) !== 'On' ) ) return;


	// -----------------------------------------------------------------------------------------------------------------
    // Add New Custom Form /////////////////////////////////////////////////////
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
    if ( ( isset($_POST['booking_form_new_name'] )) && ( ! empty( $_POST['booking_form_new_name'] ) ) ) {

		// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotValidated
		$new_name = substr( sanitize_text_field( wp_unslash( $_POST['booking_form_new_name'] ) ), 0, 30 );          // Form name no longer than 30 symbols.

        $new_name = wpbc_get_slug_format( $new_name );                                // Remove all symbols, which can  generate an issues.

        $_GET['booking_form'] = $new_name;

        // Get Default Forms
        $my_default_form      = str_replace( '\\n\\', '', wpbc_get_default_booking_form() ) ;
        $my_default_form_show = str_replace( '\\n\\', '', wpbc_get_default_booking_form_show() ) ;


        $booking_forms_extended = get_bk_option( 'booking_forms_extended');

        if ( $booking_forms_extended === false ) {                              // First Time Creation

            $booking_forms_extended = array( array('name'=>$new_name, 'form'=>$my_default_form, 'content'=>$my_default_form_show) );

        } else {                                                                // Append Custom form to exist forms

            $booking_forms_extended = maybe_unserialize($booking_forms_extended);

            // FixIn: 8.7.3.7.
	        if ( is_string( $booking_forms_extended ) ) {
		        // Something was going wrong with  custom  forms. Its will  reset  custom  booking forms
		        $booking_forms_extended = array();
	        }

            // Get all exist custom names
            $exist_custom_forms_names = array();
            foreach ( $booking_forms_extended as $cust_form ) {
                $exist_custom_forms_names[] = $cust_form['name'];
            }

            // If new custom name not exist  then add this custom form.
            if ( ! in_array( $new_name, $exist_custom_forms_names) )
                $booking_forms_extended[] = array( 'name' => $new_name, 'form' => $my_default_form, 'content' => $my_default_form_show );
        }

        // Save Changes
        update_bk_option( 'booking_forms_extended' , serialize($booking_forms_extended) );

        wpbc_show_changes_saved_message();

        // Reload Page
        ?><script type="text/javascript"> window.location.href='<?php
				// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				echo wpbc_get_settings_url() . '&tab=form&booking_form=' . $new_name; ?>'; </script><?php
    }


	// -----------------------------------------------------------------------------------------------------------------
    // Get Custom  Forms ///////////////////////////////////////////////////////

    $booking_forms_extended = get_bk_option( 'booking_forms_extended');

    if ( $booking_forms_extended === false ) {

        $booking_forms_extended = array();                                      // No Forms, yet.

    } else {

        $booking_forms_extended = maybe_unserialize($booking_forms_extended);

        if ( ! is_array( $booking_forms_extended  ) ) {
        	$booking_forms_extended = array();                                 // Some error ?	// FixIn: 8.7.6.9.
		}

        // Check  about possible issues ////////////////////////////////////////
        // If the Name of Custom  form contain "+" symbol, it can generate issue
        // of not loading custom form. We need to replace this symbol.
        $is_fix_exist = false;
        foreach ( $booking_forms_extended as $key => $value ) {

            if ( strpos( $value['name'], '+' ) !== false ) {
                $value['name'] = str_replace( '+', 'plus', $value['name'] );
                $booking_forms_extended[$key]['name'] = $value['name'];
                $is_fix_exist = true;
            }
        }
        if ( $is_fix_exist ) {
            update_bk_option( 'booking_forms_extended', serialize( $booking_forms_extended ) );
            $booking_forms_extended = get_bk_option( 'booking_forms_extended' );
            $booking_forms_extended = maybe_unserialize($booking_forms_extended);
        }
    }




	// -----------------------------------------------------------------------------------------------------------------
    // DropDown list with Custom Forms  ////////////////////////////////////////

	$on_change = 'wpbc_change_custom_booking_form_in_url__and_reload(this);';

    // Show DropDown list with Custom forms selection
    wpbc_dropdown_list_with_custom_forms( $booking_forms_extended, $on_change );

    if ( $is_show_add_new_custom_form ) {
        // Show Buttos for creation and delettion of custom booking forms.
        wpbc_buttons_add_new_custom_form();
    }

}


//TODO: Delete this function 2024-08-14
												/**
												 *
												 * Buttons for creation  new Custom Forms
												 */
												function wpbc_buttons_add_new_custom_form() {

													// D E L E T E  ////////////////////////////////////////////////////////////
													// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
													if (  (isset($_GET['booking_form'])) && ($_GET['booking_form'] != 'standard')  ) {  // If we load some custom form  so  then show Delete button  for this custom form

														$user = wpbc_get_current_user();
														$user_bk_id = $user->ID;

														$params = array(
																	  'label_for' => 'min_cost'                                 // "For" parameter  of label element
																	, 'label' => '' //__('Add New Field', 'booking')            // Label above the input group
																	, 'style' => ''                                             // CSS Style of entire div element
																	, 'items' => array(
																						array(
																							'type' => 'button'
																							, 'title' => __('Delete', 'booking')  // __('Reset', 'booking')
																							, 'hint' => array( 'title' => __('Delete selected booking form' ,'booking') , 'position' => 'top' )
																							, 'class' => 'button tooltip_top'
																							, 'font_icon' => 'wpbc_icn_delete_outline'
																							, 'icon_position' => 'right'
																							, 'action' => " if ( wpbc_are_you_sure('" . esc_js(__('Do you really want to delete selected booking form ?' ,'booking')) . "') ) { "
																										  . " wpbc_delete_custom_booking_form( document.getElementById('select_booking_form').options[document.getElementById('select_booking_form').selectedIndex].value, " . $user_bk_id . " ); "
																										  . "}"

																						)
																			)
																	);

														?><div class="control-group wpbc-no-padding"><?php
																wpbc_bs_input_group( $params );
														?></div><?php

													}

													?><form name="post_settings_form_fields_new_form" action="" method="post" id="post_settings_form_fields_new_form"><?php


														// Add New Custom Button
														$params = array(
																	  'label_for' => 'min_cost'                             // "For" parameter  of label element
																	, 'label' => '' //__('Add New Field', 'booking')        // Label above the input group
																	, 'style' => ''                                         // CSS Style of entire div element
																	, 'items' => array(
																						array(
																							'type' => 'button'
																							, 'title' => __('Add New Custom Form', 'booking')  // __('Reset', 'booking')
																							, 'hint' => array( 'title' => __('Add New Custom Form' ,'booking') , 'position' => 'top' )
																							, 'class' => 'button button-primary tooltip_top'
																							, 'font_icon' => 'wpbc_icn_add _circle_outline'
																							, 'attr' => array( 'id' => 'add_new_custom_form_name_button' )
																							, 'icon_position' => 'right'
																							, 'action' => " jQuery('#wpbc_create_new_custom_form_name_fields').show(); "
																										. "jQuery('#add_new_custom_form_name_button').hide();"
																										. " setTimeout(function ( ) { jQuery('#booking_form_new_name').trigger( 'focus' ); } ,100); "  // Focus		// FixIn: 8.7.11.12.

																						)
																			)
																	);

														?><div class="control-group wpbc-no-padding"><?php
																wpbc_bs_input_group( $params );
														?></div><?php


														// Create new form Text fields
														$params = array(
																	  'label_for' => 'min_cost'                             // "For" parameter  of label element
																	, 'label' => '' //__('Add New Field', 'booking')        // Label above the input group
																	, 'style' => ''                                         // CSS Style of entire div element
																	, 'items' => array(
																						array(
																							'type'          => 'text'
																							, 'id'          => 'booking_form_new_name'
																							, 'name'        => 'booking_form_new_name'
																							, 'attr' => array( 'maxlength' => '30' )
																							, 'label'       => ''
																							, 'disabled'    => false
																							, 'class'       => ''
																							, 'style'       => 'min-width:210px;'
																							, 'placeholder' => __('Type the name of booking form' ,'booking')
																							, 'attr'        => array()
																							, 'value' => ''
																							, 'onfocus' => ''
																						)
																						, array(
																							'type' => 'button'
																							, 'title' => __('Create', 'booking')  // __('Reset', 'booking')
																							, 'hint' => array( 'title' => __('Create new form' ,'booking') , 'position' => 'top' )
																							, 'class' => 'button button-primary tooltip_top'
																							, 'font_icon' => 'wpbc_icn_add _circle_outline'
																							, 'icon_position' => 'right'
																							, 'action' => " document.forms['post_settings_form_fields_new_form'].submit(); "
																						)
																						, array(
																							'type' => 'button'
																							, 'title' => __('Cancel', 'booking')  // __('Reset', 'booking')
																							, 'hint' => array( 'title' => __('Cancel' ,'booking') , 'position' => 'top' )
																							, 'class' => 'button tooltip_top'
																							, 'font_icon' => 'wpbc_icn_close'
																							, 'icon_position' => 'right'
																							, 'action' => " jQuery('#wpbc_create_new_custom_form_name_fields').hide(); "
																										. "jQuery('#add_new_custom_form_name_button').show();"
																						)
																			)
																	);

														?><div class="control-group wpbc-no-padding" id="wpbc_create_new_custom_form_name_fields"><?php
																wpbc_bs_input_group( $params );
														?></div><?php

													?></form><?php
												}

/** Show Selectbox with Custom Forms */
function wpbc_dropdown_list_with_custom_forms( $booking_forms_extended, $on_change , $params = array() ) {

    $defaults = array(
                          'on_change'   => false
                        , 'title'       => __('Booking Form', 'booking') . ':'
                    );
    $params = wp_parse_args( $params, $defaults );


	// -----------------------------------------------------------------------------------------------------------------
    // DropDown list with Custom Forms  ////////////////////////////////////////


    $form_options = array();

    $form_options['standard'] = array(
                                        'title' => __('Standard', 'booking')
                                        , 'id' => ''
                                        , 'name' => ''
                                        , 'style' => 'padding:3px;border-bottom: 1px dashed #ccc;'
                                        , 'class' => ''
                                        , 'disabled' => false
                                        , 'selected' => false
                                        , 'attr' => array()
                                    );

    $form_options[ 'optgroup_cf_s' ] = array( 'optgroup' => true, 'close'  => false, 'title'  => '&nbsp;' . __('Custom Forms' ,'booking')  );

    foreach ( $booking_forms_extended as $cust_form ) {

        $form_options[ $cust_form['name'] ] = array(
                                        'title' => wpbc_lang( $cust_form['name'] )
                                        , 'id' => ''
                                        , 'name' => ''
                                        , 'style' => ''
                                        , 'class' => ''
                                        , 'disabled' => false
                                        , 'selected' => ( (isset( $_GET['booking_form'] )) && ($_GET['booking_form'] == $cust_form['name']) ) ? true : false  // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
                                        , 'attr' => array()
                                    );
    }

    $templates[ 'optgroup_cf_e' ] = array( 'optgroup' => true, 'close'  => true );

    ////////////////////////////////////////////////////////////////////////

    $params = array(
                      'label_for' => 'select_booking_form'                        // "For" parameter  of label element
                    , 'label' => ''                                         // Label above the input group
                    , 'style' => ''                                         // CSS Style of entire div element
                    , 'items' => array(
                                    array(
                                        'type' => 'addon'
                                        , 'element' => 'text'               // text | radio | checkbox
                                        , 'text' => $params['title']
                                        , 'class' => ''                     // Any CSS class here
                                        , 'style' => 'font-weight:600;'    // CSS Style of entire div element
                                    )
                                    , array(
                                          'type' => 'select'
                                        , 'id' => 'select_booking_form'         // HTML ID  of element
                                        , 'name' => 'select_booking_form'         // HTML ID  of element
                                        , 'options' => $form_options            // Associated array  of titles and values
                                        //, 'disabled_options' => array( 'any' )      // If some options disbaled,  then its must list  here
                                        //, 'default' => 'specific'             // Some Value from optins array that selected by default
                                        , 'style' => ''                         // CSS of select element
                                        , 'class' => ''                         // CSS Class of select element
                                        , 'attr' => array()                     // Any  additional attributes, if this radio | checkbox element
                                        , 'onchange' => $on_change
                                    )
                    )
              );
    ?><div class="control-group wpbc-no-padding"><?php
            wpbc_bs_input_group( $params );
    ?></div><?php

}
