<?php /**
 * @version 1.0
 * @package WP Booking Calendar > Prices > Daily Costs page
 * @category Settings page
 * @author wpdevelop
 *
 * @web-site https://wpbookingcalendar.com/
 * @email info@wpbookingcalendar.com
 *
 * @modified 2016-09-09, 2024-03-27
 *
 * This is COMMERCIAL SCRIPT
 * We are not guarantee correct work and support of Booking Calendar, if some file(s) was modified by someone else then wpdevelop.
 */

if ( ! defined( 'ABSPATH' ) ) exit;                                             // Exit if accessed directly

require_once( WPBC_PRO_PLUGIN_DIR. '/inc/_bm/admin/page-cost-rate.php' );
require_once( WPBC_PRO_PLUGIN_DIR. '/inc/_bm/admin/page-cost-valuation.php' );
require_once( WPBC_PRO_PLUGIN_DIR. '/inc/_bm/admin/page-cost-deposit.php' );
require_once( WPBC_PRO_PLUGIN_DIR. '/inc/_bm/admin/page-cost-early-late-booking.php' );        								// FixIn: 8.2.1.17.

/**
 * Show Content
 *  Update Content
 *  Define Slug
 *  Define where to show
 */
class WPBC_Page_Settings__rcosts extends WPBC_Page_Structure {

    const SUBMIT_FORM = 'wpbc_rcosts';                                   // Main Form Name
    const ACTION_FORM = 'wpbc_rcosts_action';                            // Form for sub-actions: like Add New | Edit actions
    private $edit_resource_id = 0;


    public function in_page() {
        return 'wpbc-prices';			//FixIn: 9.8.15.2.4
    }


    public function tabs() {

        $tabs = array();

        $tabs[ 'cost' ] = array(
                              'title'       => __('Prices','booking') // __('Daily Costs','booking')             // Title of TAB  __('Daily Costs / Seasonal Rates','booking')            // Title of TAB
                            , 'hint'        => __('Customize booking costs by seasonal daily pricing and booking duration, with features for partial payments and early/late check-in discounts.', 'booking')                      // Hint
                            , 'page_title'  => __('Prices', 'booking')                                // Title of Page
                            //, 'link'      => ''                               // Can be skiped,  then generated link based on Page and Tab tags. Or can  be extenral link
                            //, 'position'  => 'left'                           // 'left'  ||  'right'  ||  ''
                            //, 'css_classes'=> ''                              // CSS class(es)
                            //, 'icon'      => ''                               // Icon - link to the real PNG img
                            , 'font_icon' => 'wpbc-bi-cash-coin wallet2 wpbc_icn_insert_chart_outlined0'        // CSS definition  of forn Icon
							, 'font_icon_right'                    => 'wpbc-bi-question-circle'
                            , 'default'   => true                              // Is this tab activated by default or not: true || false.		//FixIn: 9.8.15.2.4
                            //, 'disabled'  => false                            // Is this tab disbaled: true || false.
                            , 'hided'     => false                              // Is this tab hided: true || false.
                            , 'subtabs'   => array()
                    );

        return $tabs;
    }


    /** Show Content of Settings page */
    public function content() {

        $this->css();

        // Checking
        do_action( 'wpbc_hook_settings_page_header', 'costs_and_rates');              	// Define Notices Section and show some static messages, if needed

        if ( ! wpbc_is_mu_user_can_be_here('activated_user') ) return false;    		// Check if MU user activated, otherwise show Warning message.
        // if ( ! wpbc_is_mu_user_can_be_here('only_super_admin') ) return false;  		// User is not Super admin, so exit.  Basically its was already checked at the bottom of the PHP file, just in case.

        // Load Data
	    // $this->get_api()->validated_form_id = self::SUBMIT_FORM;             		// Define ID of Form for ability to  validate fields (like required field) before submit.

        //  S u b m i t   Main Form
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
        if ( isset( $_POST['is_form_sbmitted_'. self::SUBMIT_FORM ] ) ) {
																						// Nonce checking    {Return false if invalid, 1 if generated between, 0-12 hours ago, 2 if generated between 12-24 hours ago. }
            $nonce_gen_time = check_admin_referer( 'wpbc_settings_page_' . self::SUBMIT_FORM );  						// It stops show anything on submitting, if it not refers to the original page

            $this->update();															// Save Changes
        }


        echo '<span class="wpdevelop">';

			// JavaScript: Tooltips, Popover, Datepick (js & css)
			wpbc_js_for_bookings_page();

			// Toolbar
			wpbc_resource_cost_page__toolbar();

        echo '</span>';

        ?><div class="clear" style=""></div><?php

        wpbc_toolbar_search_by_id__top_form( array(
                                                    'search_form_id' => 'wpbc_booking_resources_search_form'
                                                  , 'search_get_key' => 'wh_resource_id'
                                                  , 'is_pseudo'      => false
                                            ) );

	    do_action( 'wpbc_hook_settings_page_before_content_table', 'costs_and_rates' );      							// Define Notices Section and show some static messages, if needed


        // -------------------------------------------------------------------------------------------------------------
        // Content
		// -------------------------------------------------------------------------------------------------------------
        ?><div class="clear" ></div>
        <span class="metabox-holder"><?php

			// ---------------------------------------------------------------------------------------------------------
            // Actions Form
            // ---------------------------------------------------------------------------------------------------------
            ?><form  name="<?php echo esc_attr( self::ACTION_FORM); ?>" id="<?php echo esc_attr( self::ACTION_FORM); ?>" action="<?php

                    // Need to  exclude 'edit_resource_id' parameter from  $_GET,  if we was using direct link for editing,  in case for edit other season filters....
                    $exclude_params = array( 'edit_resource_id' );
                    $only_these_parameters = false;// array( 'tab', 'page_num', 'wh_search_id' );
                    $is_escape_url = false;
                    $only_get = true;
					// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                    echo wpbc_get_params_in_url( wpbc_get_price_url( false, false ), $exclude_params, $only_these_parameters, $is_escape_url , $only_get );

                    ?>" method="post" autocomplete="off"><?php

               	// N o n c e   field, and key for checking   S u b m i t
               	wp_nonce_field( 'wpbc_settings_page_' . self::ACTION_FORM );

		        // Add hidden input SEARCH KEY field into  main form, if previosly was searching by ID or Title
		        wpbc_hidden_search_by_id_field_in_main_form( array( 'search_get_key' => 'wh_resource_id' ) );			// FixIn: 8.0.1.12.

				?><input type="hidden" name="is_form_sbmitted_<?php echo esc_attr( self::ACTION_FORM ); ?>" id="is_form_sbmitted_<?php echo esc_attr( self::ACTION_FORM ); ?>" value="1" /><?php
                ?><input type="hidden" name="action_<?php echo esc_attr( self::ACTION_FORM ); ?>"           id="action_<?php echo esc_attr( self::ACTION_FORM ); ?>"           value="-1" /><?php
                ?><input type="hidden" name="edit_resource_id_<?php echo esc_attr( self::ACTION_FORM ); ?>" id="edit_resource_id_<?php echo esc_attr( self::ACTION_FORM ); ?>" value="-1" /><?php

                $id_of_selected_resources = $this->wpbc_check_sub_actions();    // Check  "Adding New" season filter | Edit | Delete single exist  season filter.

                if ( ! empty( $id_of_selected_resources ) ) {

                    $this->edit_resource_id = explode( ',', $id_of_selected_resources );
                }
            ?></form><?php

			?><div class="clear"></div><?php

            // ---------------------------------------------------------------------------------------------------------
            // Main Form
            // ---------------------------------------------------------------------------------------------------------
            ?><form  name="<?php echo esc_attr( self::SUBMIT_FORM ); ?>" id="<?php echo esc_attr( self::SUBMIT_FORM ); ?>" action="" method="post" autocomplete="off"><?php

			   // N o n c e   field, and key for checking   S u b m i t
			   wp_nonce_field( 'wpbc_settings_page_' . self::SUBMIT_FORM );

				// Add hidden input SEARCH KEY field into  main form, if previously was searching by ID or Title
				wpbc_hidden_search_by_id_field_in_main_form( array( 'search_get_key' => 'wh_resource_id' ) );			// FixIn: 8.0.1.12.

                ?><input type="hidden" name="is_form_sbmitted_<?php echo esc_attr( self::SUBMIT_FORM ); ?>" id="is_form_sbmitted_<?php echo esc_attr( self::SUBMIT_FORM ); ?>" value="1" /><?php

				?><div id="wpbc_booking_resource_table"
					   class="wpbc_booking_resource_prices_table 	wpbc_booking_resource_table wpbc_settings_row wpbc_settings_row_right0"><?php

					$this->wpbc_resources_table__show();

				?></div><?php

		        if ( empty( $id_of_selected_resources ) ) {
			        $this->show_bulk_actions_ui();
		        }

			?></form><?php

		?></span>
        <?php

        do_action( 'wpbc_hook_settings_page_footer', 'costs_and_rates' );

        $this->enqueue_js();
    }


	/**
	 * Show Bulk actions UI - selectbox  for different actions
	 * @return void
	 */
	public function show_bulk_actions_ui(){
		?>
		<div class="clear"></div>
		<select id="bulk-action-selector-bottom" name="bulk-action">
			<option value="-1"><?php esc_html_e('Bulk Actions', 'booking'); ?></option>
			<option value="edit"><?php esc_html_e('Edit', 'booking'); ?></option>
			<option value="set_rate"><?php echo esc_html__('Set Rate', 'booking') . '&nbsp;&nbsp; - &nbsp;&nbsp;' . esc_html__( 'Seasonal Pricing', 'booking' ); ?></option>
			<option value="set_valuation"><?php echo esc_html__( 'Set Valuation Days', 'booking' ) . '&nbsp;&nbsp; - &nbsp;&nbsp;' . esc_html__( 'Duration-Based Costs', 'booking' ); ?></option>
			<option value="set_deposit"><?php echo esc_html__('Set Deposit Amount', 'booking') . '&nbsp;&nbsp; - &nbsp;&nbsp;' . esc_html__( 'Partial Payments', 'booking' ); ?></option>
			<option value="set_early_late_booking"><?php echo esc_html__('Early / Late Booking', 'booking') . '&nbsp;&nbsp; - &nbsp;&nbsp;' . esc_html__( 'Early / Late Check-in Discounts', 'booking' ); ?></option>		<?php //FixIn: 8.2.1.17 ?>
			<option value="delete"><?php esc_html_e('Delete', 'booking'); ?></option>
		</select>
		<a href="javascript:void(0);" onclick="javascript: jQuery('#<?php echo esc_attr( self::SUBMIT_FORM ); ?>').trigger( 'submit' );"
		   class="button button-primary wpbc_button_save wpbc_button_action" ><?php esc_html_e('Save Changes','booking'); ?></a>
		<a href="javascript:void(0);" class="button wpbc_button_set_cost wpbc_button_set_rate wpbc_button_action"
		   style="display:none;" ><?php esc_html_e('Configure','booking'); ?></a>
		<a href="javascript:void(0);" class="button wpbc_button_set_cost wpbc_button_set_valuation wpbc_button_action"
		   style="display:none;" ><?php esc_html_e('Configure','booking'); ?></a>
		<a href="javascript:void(0);" class="button wpbc_button_set_cost wpbc_button_set_deposit wpbc_button_action"
		   style="display:none;" ><?php esc_html_e('Configure','booking'); ?></a>
		<a href="javascript:void(0);" class="button wpbc_button_set_cost wpbc_button_set_early_late_booking wpbc_button_action"
		   style="display:none;" ><?php esc_html_e('Configure','booking'); ?></a>
		<a href="javascript:void(0);" class="button wpbc_button_delete wpbc_button_action" id="wpbc_button_delete"
		   style="display:none;background: #d9534f;border:#b92c28 1px solid;color:#eee;" ><?php esc_html_e('Delete','booking'); ?></a>
		<span class="wpbc_button_delete wpbc_button_action" style="display:none;">
			<div class="clear" style="height:10px;"></div>
			<div class="wpbc-settings-notice notice-warning" style="text-align:left;">
				<strong><?php esc_html_e('Note!' ,'booking'); ?></strong> <?php
					/* translators: 1: ... */
					echo wp_kses_post( sprintf( __( 'Please reassign exist booking(s) from selected resource(s) to other resources or delete exist booking(s) from  this resource(s). Otherwise you will have %1$slost bookings%2$s.', 'booking' )
							, '<a href="' . wpbc_get_menu_url('booking') . '&wh_booking_type" >','</a>') );
				?>
			</div>
			<div class="clear" ></div>
		</span>
		<?php
	}


	// -----------------------------------------------------------------------------------------------------------------
    //  S a v e  -  M a i n   F o r m
	// -----------------------------------------------------------------------------------------------------------------
	/**
	 * Save Changes
	 * @return void
	 */
    public function update() {

	    make_bk_action( 'wpbc_reinit_booking_resource_cache' );
		//        if (  ( wpbc_is_this_demo() ) ||  ( ! class_exists( 'wpdev_bk_personal' ) )  ) { return; }

        global $wpdb;

        $wpbc_br_table = new WPBC_BR_Table( 'resources_submit' );
        $linear_resources_for_one_page = $wpbc_br_table->get_linear_data_for_one_page();

	    // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
	    if ( isset( $_POST['bulk-action'] ) ) {
		    $submit_action = wpbc_clean_text_value( $_POST['bulk-action'] );  // phpcs:ignore WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
	    } else {
		    $submit_action = 'edit';
	    }

        $bulk_action_arr_id = array();

		// Edit   Titles | Costs  &   Options
        foreach ( $linear_resources_for_one_page as $resource_id => $resource ) {

            // Check posts of only visible on page booking resources
            // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
            if ( isset( $_POST['booking_resource_' . $resource_id ] ) ) {

                    switch ( $submit_action ) {

                        case 'delete':                                          // Delete

                            // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
                            if ( isset( $_POST['br-select-' . $resource_id ] ) )
                                    $bulk_action_arr_id[] = intval( $resource_id );
                            break;

                        default:                                                // Edit

							// "Num Per Page" -- Update number of booking resources per page						// FixIn: 9.9.0.22.
							// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
							if ( ! empty( $_POST['booking_resourses_num_per_page'] ) ) {
								$booking_resourses_num_per_page = intval( $_POST['booking_resourses_num_per_page'] );  // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
								if ( ( $booking_resourses_num_per_page > 0 ) && ( $booking_resourses_num_per_page < 501 ) ) {
									update_bk_option( 'booking_resourses_num_per_page', $booking_resourses_num_per_page );
								}
							}

							//  // Update Resource Property - Shortcode
							//	if ( isset( $_POST[ 'booking_resource_shortcode_' . $resource_id ] ) ) {
							//		$validated_shortcode_value = WPBC_Settings_API::validate_text_post_static( 'booking_resource_shortcode_' . $resource_id );
							//
							//		wpbc_save_resource_property( $resource_id, 'shortcode_default', $validated_shortcode_value );
							//	}

							// Title
							$validated_value = WPBC_Settings_API::validate_text_post_static( 'booking_resource_' . $resource_id );

							$sql_arr =  array(
												'sql'       => array(
																	  'start'   => "UPDATE {$wpdb->prefix}bookingtypes SET "
																	, 'params' => array( 'title = %s' )
																	, 'end'    => " WHERE booking_type_id = %d"
															)
												, 'values'  => array( $validated_value )
											);
							// Cost
							$validated_cost = WPBC_Settings_API::validate_text_post_static( 'booking_resource_cost_' . $resource_id );
							$validated_cost = str_replace(',', '.', $validated_cost );                  // In case,  if someone was used , instead of . for decimal
							$validated_cost = floatval( $validated_cost );
							$sql_arr['sql']['params'][] = 'cost = %s';
							$sql_arr['values'][]        = $validated_cost;

							// last parameter  for " WHERE booking_type_id = %d "
							$sql_arr['values'][] = intval( $resource_id );

							// SQL
							/* phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.PreparedSQLPlaceholders.UnfinishedPrepare */
							$sql = $wpdb->prepare( $sql_arr['sql']['start'] . implode( ', ', $sql_arr['sql']['params'] ) . $sql_arr['sql']['end'], $sql_arr['values'] );

							// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared
							if ( false === $wpdb->query( $sql ) ) {
								debuge_error( 'Error saving to DB', __FILE__, __LINE__ );
							}

							wpbc_show_changes_saved_message();

                            break;
                    }


                //}
            }

        }


		// Bulk Delete
        if ( ! empty( $bulk_action_arr_id ) ) {

			switch ( $submit_action ) {

				case 'delete':                                          // Delete

					// Check booking resources in demo that  does not possible to  delete						// FixIn: 9.4.2.2.
					if ( wpbc_is_this_demo() ) {
						$new_bulk_action_arr_id = array();
						foreach ( $bulk_action_arr_id as $resource_id ) {

							$maximum_safe_resource_id = 4;
							if ( class_exists( 'wpdev_bk_biz_l' ) ) {
								$maximum_safe_resource_id = 12;
							}
							if ( class_exists( 'wpdev_bk_multiuser' ) ) {
								$maximum_safe_resource_id = 17;
							}

							if ( $resource_id > $maximum_safe_resource_id ) {
								$new_bulk_action_arr_id[] = $resource_id;
							} else {
								wpbc_show_message( sprintf( 'Booking resource ID=%d can not be deleted, because this is demo.', $resource_id ), 5 );
							}
						}
						$bulk_action_arr_id = $new_bulk_action_arr_id;
					}
					if ( ! empty( $bulk_action_arr_id ) ) {
						$bulk_action_arr_id = implode( ',', $bulk_action_arr_id );
						$sql = "DELETE FROM {$wpdb->prefix}bookingtypes WHERE booking_type_id IN ({$bulk_action_arr_id})";

						// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared
						if ( false === $wpdb->query( $sql ) ) {
							debuge_error( 'Error during deleting items in DB', __FILE__, __LINE__ );
						}

						do_action( 'wpbc_deleted_booking_resources', $bulk_action_arr_id );                             // FixIn: 10.0.0.35.

						wpbc_show_message( __( 'Deleted', 'booking' ), 5 );
					}
				default:                                                // Edit
					break;
			}
        }


        make_bk_action( 'wpbc_reinit_booking_resource_cache' );
    }

	// -----------------------------------------------------------------------------------------------------------------
    //  S a v e  -  A c t i o n  s    F o r m
	// -----------------------------------------------------------------------------------------------------------------
    /**
	 * Show and Save Costs for: Rates, "Valuation days", Deposit
     *
     * @return boolean
     */
    public function wpbc_check_sub_actions(){

        $edit_resource_id = '';

        // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
        if ( isset( $_GET['edit_resource_id'] ) ) {                             // In case if we need to  open  direct  link for editing some filter

            $action     = 'set_rate';                                           // Default action  - settings rate - if we transfer from URL
            $edit_resource_id  = wpbc_clean_digit_or_csd( $_GET['edit_resource_id'] );  // phpcs:ignore WordPress.Security.NonceVerification.Missing, WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

        } else {

                // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
                if ( isset( $_POST['is_form_sbmitted_'. self::ACTION_FORM ] ) ) {

                    // Nonce checking    {Return false if invalid, 1 if generated between, 0-12 hours ago, 2 if generated between 12-24 hours ago. }
                    $nonce_gen_time = check_admin_referer( 'wpbc_settings_page_' . self::ACTION_FORM );  // Its stop show anything on submiting, if its not refear to the original page

                    // If we have wrong nonce,  so its will be stop executing here
                } else
                    return false;                                                       // If we do  not submit sub action,  then exit

                ////////////////////////////////////////////////////////////////////////

                // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
                if ( isset(   $_POST[ 'action_' .  self::ACTION_FORM ] ) ){
                    $action = sanitize_text_field( wp_unslash( $_POST[ 'action_' .  self::ACTION_FORM ] ) );  /* phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing */ /* FixIn: sanitize_unslash */
                }

                if ( empty( $action ) ) return  false;

                // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
                if ( isset( $_POST[ 'edit_resource_id_' .  self::ACTION_FORM ] ) ) {
                    $edit_resource_id = wpbc_clean_digit_or_csd( $_POST[ 'edit_resource_id_' .  self::ACTION_FORM ] );  // phpcs:ignore WordPress.Security.NonceVerification.Missing, WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
                }
        }
        ////////////////////////////////////////////////////////////////////////

        $rate_obj = false;
        $valuation_obj = false;
        $deposit_obj = false;
        $early_late_booking_obj = false;		// FixIn: 8.2.1.17.

        if ( ! empty( $edit_resource_id ) ) {

            switch ( $action ) {

                // Rates  ----------------------------------------------------------------------------------------------

                case 'update_sql_rate':
                    $rate_obj = new WPBC_Section_Rate(  $edit_resource_id
                                                        , array(
                                                                'action_form'   => self::ACTION_FORM
                                                            )
                                                    );
                    $rate_obj->update_sql();

                case 'set_rate':

                    if ($rate_obj === false)
                        $rate_obj = new WPBC_Section_Rate(  $edit_resource_id
                                                            , array(
                                                                    'action_form'   => self::ACTION_FORM
                                                                )
                                                        );
                    $rate_obj->display();

                    break;

                // "Valuation days" ------------------------------------------------------------------------------------
                case 'update_sql_valuation':
                    $valuation_obj = new WPBC_Section_Valuation(  $edit_resource_id
                                                        , array(
                                                                'action_form'   => self::ACTION_FORM
                                                            )
                                                    );
                    $valuation_obj->update_sql();

                case 'set_valuation':

                    if ($valuation_obj === false)
                        $valuation_obj = new WPBC_Section_Valuation(  $edit_resource_id
                                                            , array(
                                                                    'action_form'   => self::ACTION_FORM
                                                                )
                                                        );
                    $valuation_obj->display();

                    break;

                // Deposit  --------------------------------------------------------------------------------------------

                case 'update_sql_deposit':
                    $deposit_obj = new WPBC_Section_Deposit(  $edit_resource_id
                                                            , array(
                                                                'action_form'   => self::ACTION_FORM
                                                            )
                                                    );
                    $deposit_obj->update_sql();

                case 'set_deposit':

                    if ($deposit_obj === false)
                        $deposit_obj = new WPBC_Section_Deposit(  $edit_resource_id
                                                                , array(
                                                                    'action_form'   => self::ACTION_FORM
                                                                )
                                                        );
                    $deposit_obj->display();

                    break;


                // Early / Late Booking  -------------------------------------------------------------------------------			// FixIn: 8.2.1.17.

                case 'update_sql_early_late_booking':
                    $early_late_booking_obj = new WPBC_Section_Early_Late_Booking(  $edit_resource_id
                                                            , array(
                                                                'action_form'   => self::ACTION_FORM
                                                            )
                                                    );
                    $early_late_booking_obj->update_sql();

                case 'set_early_late_booking':

                    if ($early_late_booking_obj === false)
                        $early_late_booking_obj = new WPBC_Section_Early_Late_Booking(  $edit_resource_id
                                                                , array(
                                                                    'action_form'   => self::ACTION_FORM
                                                                )
                                                        );
                    $early_late_booking_obj->display();

                    break;

                default:
                    break;
            }
        }

        return $edit_resource_id;
    }


    // <editor-fold     defaultstate="collapsed"                        desc=" CSS  &   JS   "  >

		/** CSS for this page */
		private function css() {
			?>
			<style type="text/css">
				.wpbc-help-message {
					border:none;
				}
				/* Selectbox element in toolbar */
				.visibility_container select optgroup{
					color:#999;
					vertical-align: middle;
					font-style: italic;
					font-weight: 400;
				}
				.visibility_container select option {
					padding:5px;
					font-weight: 600;
				}
				.visibility_container select optgroup option{
					padding: 5px 20px;
					color:#555;
					font-weight: 600;
				}
				#wpbc_create_new_custom_form_name_fields {
					width: 360px;
					display:none;
				}
				@media (max-width: 399px) {
					#wpbc_create_new_custom_form_name_fields {
						width: 100%;
					}
				}

				.wpbc_2_fields_in_collumn input[type="text"],
				.wpbc_2_fields_in_collumn select {
					/*float: left;*/
					/*margin: 0 1% 0 0;*/
					/*width: 49%;                */
					flex: 0 1 auto;
					max-width: 50%;
				}
				.wpbc_2_fields_in_collumn select {
					margin: 0 0 0 1%;
				}
				.button.wpbc_in_table_button {
					margin: 3px 5px;
				}
				.wpbc_available_item_text {
					color: #5cb85c;
				}
				.wpbc_unavailable_item_text {
					color: #d9534f;
				}
				.label.wpbc_general_rcosts_item,
				.label.wpbc_rcosts_item {
					font-size:0.9em;
				}
				.wpbc_edited_resource_label .label {
					font-size:0.9em;
					font-style: normal;
					font-weight: 600;
				}
				.form-table .description {
					line-height: 2em;
				}
				.wpbc-help-message {
					border:none;
				}
				/* Selectbox element in toolbar */
				.visibility_container select optgroup{
					color:#999;
					vertical-align: middle;
					font-style: italic;
					font-weight: 400;
				}
				.visibility_container select option {
					padding:5px;
					font-weight: 600;
				}
				.visibility_container select optgroup option{
					padding: 5px 20px;
					color:#555;
					font-weight: 600;
				}
				#wpbc_create_new_custom_form_name_fields {
					width: 360px;
					display:none;
				}
				/* Valuation days */
				.wpbc_sortable_table .widefat.wpbc_vd_table td.sort{
					vertical-align: baseline;
				}
				.wpbc_sortable_table .widefat.wpbc_vd_table td.sort::before{
					vertical-align: middle;
				}
				.wpbc_page .wpdevelop .wpbc_vd_table .wpbc_vd_type_select {
					margin:1px 10px 4px 1px;
				}
				.wpbc_page .wpdevelop .wpbc_vd_table .wpbc_vd_days_fieldset{
					min-width:15em;
					margin:1px;
				}
				.wpbc_page .wpdevelop label.wpbc_vd_days_label,
				.wpbc_page .wpdevelop label.wpbc_vd_to_label {
					float: left;
					font-size: 1em;
					line-height: 1.8em;
					font-weight: 600;
					margin: 2px 1px 1px;
					padding-left: 5px;
					padding-right: 5px;
				}
				/* Valuation days */
				.wpdevelop.wpbc_resources_table .wpbc_vd_table > thead > tr > th,
				.wpdevelop.wpbc_resources_table .wpbc_vd_table > tbody > tr > th,
				.wpdevelop.wpbc_resources_table .wpbc_vd_table > tfoot > tr > th,
				.wpdevelop.wpbc_resources_table .wpbc_vd_table > thead > tr > td,
				.wpdevelop.wpbc_resources_table .wpbc_vd_table > tbody > tr > td,
				.wpdevelop.wpbc_resources_table .wpbc_vd_table > tfoot > tr > td {
					padding: 8px 0px;
				}
				@media (max-width: 782px) {
					.wpbc_page .wpdevelop .wpbc_vd_table .wpbc_vd_days_fieldset{
						clear:both;
					}
					.wpbc_resources_table .field-currency-cost {                    /* the same as .wpbc_resources_table th.wpbc_hide_mobile */
						display: none;
					}
					/* Valuation days */
					.wpdevelop.wpbc_resources_table .wpbc_vd_table > thead > tr > th,
					.wpdevelop.wpbc_resources_table .wpbc_vd_table > tbody > tr > th,
					.wpdevelop.wpbc_resources_table .wpbc_vd_table > tfoot > tr > th,
					.wpdevelop.wpbc_resources_table .wpbc_vd_table > thead > tr > td,
					.wpdevelop.wpbc_resources_table .wpbc_vd_table > tbody > tr > td,
					.wpdevelop.wpbc_resources_table .wpbc_vd_table > tfoot > tr > td {
						vertical-align: top;
						padding: 8px;
					}
					.wpbc_page .wpdevelop .wpbc_vd_table select,
					.wpbc_page .wpdevelop .wpbc_vd_table input[type="text"]{
						width:100% !important;
					}
					.wpbc_page .wpdevelop .wpbc_vd_table input[type="checkbox"]{
						margin:0;
					}
					.wpbc_page .wpdevelop .wpbc_vd_table .wpbc_vd_days_fieldset {
						min-width: auto;
					}
					.wpbc_page .wpdevelop .wpbc_vd_table label.wpbc_vd_days_label,
					.wpbc_page .wpdevelop .wpbc_vd_table label.wpbc_vd_to_label {
						font-size: 1.1em;
						line-height: 2em;
					}
				}
				@media (max-width: 399px) {
					.field-currency-cost {
						width:20%;
					}
					.field-currency-cost .field-currency {
						display:none;
					}
					.wpbc_2_fields_in_collumn input[type="text"],
					.wpbc_2_fields_in_collumn select {
						float: none;
						margin: 0 0 5px 0;
						width: 100%;
					}
					.wpbc_2_fields_in_collumn select {
						margin: 0;
					}

					#wpbc_create_new_custom_form_name_fields {
						width: 100%;
					}
				}
			</style>
			<?php
		}


		/**
		 * Add Custom JavaScript - for some specific settings options
		 *
		 * Executed After post content, after initial definition of settings,  and possible definition after POST request.
		 *
		 * @param type $menu_slug
		 */
		private function enqueue_js(){

			// JavaScript //////////////////////////////////////////////////////////////

			ob_start();

			?><script type="text/javascript"><?php 	// Its trick only for highlighting JavaScript code here. This line is not displaying.

			ob_clean();

			?> jQuery('#bulk-action-selector-bottom').on( 'change', function(){
					if ( jQuery('#bulk-action-selector-bottom option:selected').val() == 'delete' ) {
						jQuery('.wpbc_button_delete').show();
						jQuery('.wpbc_button_save').hide();
					} else {
						jQuery('.wpbc_button_delete').hide();
						jQuery('.wpbc_button_save').show();
					}
				} );
				jQuery('#wpbc_button_delete').on( 'click', function(){
					if ( wpbc_are_you_sure('<?php echo esc_js( __('Do you really want to do this ?' ,'booking') ); ?>') ) {
						jQuery('#wpbc_bresources').trigger( 'submit' );
					}
				} );
				jQuery('#bulk-action-selector-bottom').on( 'change', function(){
					jQuery('.wpbc_button_action').hide();
					if ( jQuery('#bulk-action-selector-bottom option:selected').val() == 'edit' )   { jQuery('.wpbc_button_save').show(); }
					if ( jQuery('#bulk-action-selector-bottom option:selected').val() == 'set_rate' )       { jQuery('.wpbc_button_set_rate').show(); }
					if ( jQuery('#bulk-action-selector-bottom option:selected').val() == 'set_valuation' )  { jQuery('.wpbc_button_set_valuation').show(); }
					if ( jQuery('#bulk-action-selector-bottom option:selected').val() == 'set_deposit' )    { jQuery('.wpbc_button_set_deposit').show(); }
					if ( jQuery('#bulk-action-selector-bottom option:selected').val() == 'set_early_late_booking' ) { jQuery('.wpbc_button_set_early_late_booking').show(); } <?php //FixIn: 8.2.1.17 ?>
					if ( jQuery('#bulk-action-selector-bottom option:selected').val() == 'delete' ) { jQuery('.wpbc_button_delete').show(); }
				} );
				jQuery('#wpbc_button_delete').on( 'click', function(){
					if ( wpbc_are_you_sure('<?php echo esc_js( __('Do you really want to do this ?' ,'booking') ); ?>') ) {
						jQuery('#<?php echo esc_attr( self::SUBMIT_FORM ); ?>').trigger( 'submit' );
					}
				} );
				jQuery('.wpbc_button_set_cost').on( 'click', function(){
					var cheked_elements = [];
					var selected_element = '';
						jQuery( '#<?php echo esc_attr( self::SUBMIT_FORM ); ?> .wpbc_selectable_body .check-column input[type=\'checkbox\']:checked' ).each(function() {
							selected_element = jQuery( this ).val();
							selected_element = selected_element.substr( 9 );
							cheked_elements.push( selected_element );
						});
					cheked_elements = cheked_elements.join( ',' );              // resources separator
					jQuery( '#edit_resource_id_<?php echo esc_attr( self::ACTION_FORM ); ?>' ).val( cheked_elements );
					jQuery( '#action_<?php echo esc_attr( self::ACTION_FORM ); ?>' ).val( jQuery('#bulk-action-selector-bottom option:selected').val() );
					jQuery('#<?php echo esc_attr( self::ACTION_FORM ); ?>').trigger( 'submit' );
				} );
			<?php

			$js_script = ob_get_contents();

			?></script><?php                                                        										// Its trick only for highlighting JavaScript code here. This line is not displaying.

			ob_end_clean();

			// It will not work,  if we are using something like jQuery(document).ready(function(){ ... - Need direct showing in PHP code.
			wpbc_enqueue_js( $js_script );                                          										// enqueue JS to  the footer of the page
		}

    // </editor-fold>


    // -----------------------------------------------------------------------------------------------------------------
    //   B o o k i n g      R e s o u r c e s      T a b l e
    // -----------------------------------------------------------------------------------------------------------------
    /** Show booking resources table */
    public function wpbc_resources_table__show() {
        // echo ( ( wpbc_is_this_demo() ) ? wpbc_get_warning_text_in_demo_mode() . '<div class="clear" style="height:20px;"></div>' : '' );

        $columns = array();
        $columns[ 'check' ] = array( 'title' => '<input type="checkbox" value="" id="br-select-all" name="resource_id_all" />'
                                        , 'class' => 'wpbc_flextable_col_check check-column'
                                    );
        $columns[ 'id' ] = array(         'title' =>__( 'ID', 'booking' )
                                        , 'style' => 'width:5em;'
                                        , 'class' => 'wpbc_flextable_col_id'
                                        , 'sortable' => true
                                    );
		$columns[ 'cost' ] = array(
									  'title' => __( 'Cost' , 'booking' ) 												//FixIn: 10.0.0.14 //. wpbc_get_per_day_night_title() // FixIn: 7.1.2.1.
									, 'style' => 'flex:0 1 11em;text-align:center;'
									, 'sortable' => true                         										// Sortable operation  on this field is SLOW, because it requires  converting types from varchar to decimal.
									, 'class' => 'wpbc_flextable_col_cost'
							);

        $columns[ 'title' ] = array(      'title' => __( 'Resource Name', 'booking' )
                                        , 'style' => 'flex: 1 1 auto;padding-left: 1%;'
                                        , 'class' => 'wpbc_flextable_col_title'
                                        , 'sortable' => true
                                    );
		$columns[ 'other' ] = array(      'title' => wpbc_resource_cost_page__get_dropdown_menu_view()//__( '...', 'booking' )
								, 'style' => 'border-left: none;'
								, 'sortable' => false
								, 'class' => 'wpbc_flextable_col_other'
							);

        $wpbc_br_table = new WPBC_BR_FlexTable(
                            'resources'
                            , array(
                                  'url_sufix'   =>  '#wpbc_resources_link'
                                , 'rows_func'   =>  array( $this, 'wpbc_resources_table__show_rows' )
                                , 'columns'     =>  $columns
                                , 'is_show_pseudo_search_form' => false
                            )
                        );

        $wpbc_br_table->display();
    }


    /**
	 * Show rows for booking resource table
     *
     * @param int $row_num
     * @param array $resource
     */
    public function wpbc_resources_table__show_rows( $row_num, $resource ) {

        $css_class = ' wpbc_resource_row';
        if ( class_exists( 'wpdev_bk_biz_l' ) ) {

                if ( intval($resource['count'] ) > 1 ) {
                    $css_class .= ' wpbc_resource_parent wpbc_resource_capacity' . $resource['count'] ;
                } else {

                    if ( empty( $resource['parent'] ) ) {
                        $css_class .= ' wpbc_resource_single';
                    } else {
                        $css_class .= ' wpbc_resource_child';
                    }
                }
        }
		// FixIn: 9.9.0.6.
        ?><div class="wpbc_flextable_row wpbc_resource_row_main wpbc_list_row wpbc_row<?php echo esc_attr( $css_class ); ?>" id="resource_<?php echo esc_attr( $resource['id'] ); ?>"><?php
			// =========================================================================================================
			// Checkbox
			// =========================================================================================================
			?><div class="wpbc_flextable_col wpbc_flextable_col_check check-column">
					<label class="screen-reader-text" for="br-select-<?php echo esc_attr( $resource['id' ] ); ?>"><?php echo esc_js(__('Select Booking Resource', 'booking')); ?></label>
					<input type="checkbox"  style="margin-top: 1px;"
								   id="br-select-<?php echo esc_attr( $resource['id' ] ); ?>"
								   name="br-select-<?php echo esc_attr( $resource['id' ] ); ?>"
								   value="resource_<?php echo esc_attr( $resource['id' ] ); ?>"
						/>
			</div><?php
			// =========================================================================================================
			// ID
			// =========================================================================================================
			?><div class="wpbc_flextable_col wpbc_flextable_col_id">
				<div class="wpbc_listing_col wpbc_col_booking_labels wpbc_col_labels wpbc_label_resource_id_container">
					<span class="wpbc_label wpbc_label_booking_id wpbc_label_resource_id">
						<?php echo esc_attr( $resource['id' ] ); ?>
					</span>
				</div>
			</div><?php

			// =========================================================================================================
			// COST field
			// =========================================================================================================
			?><div class="wpbc_flextable_col wpbc_resource_cost"><?php

					?><div class="wpbc_resource_field__switchable0 wpbc_resource_field__cost">
						<div class="wpbc_ajx_toolbar">
							<div class="ui_container ui_container_small">
								<div class="ui_group ui_group__cost_field">
									<?php do_action( 'wpbc_resources_table_show_col__cost_field', $row_num, $resource ); ?>
								</div>
							</div>
						</div>
					</div><?php

			?></div><?php

			// =========================================================================================================
			// Resource Title field
			// =========================================================================================================
			?><div class="wpbc_flextable_col wpbc_resource_name"><?php

				// =====================================================================================================
				// Folders
				// =====================================================================================================
				$resource_capacity   = ( ! empty( $resource['count'] ) ) ? $resource['count'] : 1;
				$resource_parent     = ( ! empty( $resource['parent'] ) ) ? $resource['parent'] : 0;
				$resource_last_child = ( ! empty( $resource['last_child'] ) ) ? $resource['last_child'] : 0;
				wpbc_flextable_reused_ui__folders_icons( $resource_parent, $resource_capacity, $resource_last_child );

				// =====================================================================================================
				// Title Text Field
				// =====================================================================================================
				?><div class="wpbc_flextable_col wpbc_flextable_col_title">
					<input type="text" class="large-text"
						   style="float:right;<?php echo ( ( ! empty( $resource['parent'] ) ) ? 'width:90%;font-weight:400;' : 'width:99%;font-weight:600;' ); ?>"
						     id="booking_resource_<?php echo esc_attr( $resource['id' ] ); ?>"
						   name="booking_resource_<?php echo esc_attr( $resource['id' ] ); ?>"
						   value="<?php echo esc_attr( $resource['title'] ); ?>"
					/>
				</div><?php

			?></div><?php

			// =========================================================================================================
			// Different Data	-	Pricing Buttons
			// =========================================================================================================
		    ?><div class="wpbc_flextable_col wpbc_flextable_col_other wpbc_other_resource_fields"><?php
		
					// =================================================================================================
					// Pricing Buttons
					// =================================================================================================
					?><div class="wpbc_resource_field__switchable wpbc_resource_field__extra__pricing_buttons">
						<div class="wpbc_ajx_toolbar">
							<div class="ui_container ui_container_small">
								<div class="ui_group ui_group__pricing_buttons">

									<div class="ui_element" >
										<a  class="wpbc_ui_control wpbc_ui_button wpbc_ui_button_danger0 tooltip_top"
											href="javascript:void(0);"
											onclick="javascript:jQuery('#action_<?php echo esc_attr( self::ACTION_FORM ); ?>').val('set_rate');
																jQuery('#edit_resource_id_<?php echo esc_attr( self::ACTION_FORM ); ?>').val('<?php echo esc_attr( $resource['id' ] ); ?>');
																jQuery('#<?php echo esc_attr( self::ACTION_FORM ); ?>').trigger( 'submit' );"
											title="<?php esc_html_e('Set different daily prices based on seasons' ,'booking'); ?>"
										><span class="in-button-text"><?php esc_html_e('Seasonal Pricing', 'booking'); ?>&nbsp;&nbsp;</span><i class="wpbc_icn_line_axis"></i></a>
									</div>
									<div class="ui_element" >
										<a  class="wpbc_ui_control wpbc_ui_button wpbc_ui_button_danger0 tooltip_top"
											href="javascript:void(0);"
											onclick="javascript:jQuery('#action_<?php echo esc_attr( self::ACTION_FORM ); ?>').val('set_valuation');
																jQuery('#edit_resource_id_<?php echo esc_attr( self::ACTION_FORM ); ?>').val('<?php echo esc_attr( $resource['id' ] ); ?>');
																jQuery('#<?php echo esc_attr( self::ACTION_FORM ); ?>').trigger( 'submit' );"
											title="<?php esc_attr_e('Set flexible costs based on the number of selected days, such as offering a discount for a week or longer stay' ,'booking'); ?>"
										><span class="in-button-text"><?php esc_html_e('Duration-Based Costs', 'booking'); ?>&nbsp;&nbsp;</span><i class="wpbc_icn_stacked_bar_chart"></i></a>
									</div>
									<div class="ui_element" >
										<a  class="wpbc_ui_control wpbc_ui_button wpbc_ui_button_danger0 tooltip_top"
											href="javascript:void(0);"
											onclick="javascript:jQuery('#action_<?php echo esc_attr( self::ACTION_FORM ); ?>').val('set_deposit');
																jQuery('#edit_resource_id_<?php echo esc_attr( self::ACTION_FORM ); ?>').val('<?php echo esc_attr( $resource['id' ] ); ?>');
																jQuery('#<?php echo esc_attr( self::ACTION_FORM ); ?>').trigger( 'submit' );"
											title="<?php esc_attr_e('Enable customers to pay a partial of the booking cost upfront.' ,'booking'); ?>"
										><span class="in-button-text"><?php esc_html_e('Partial Payments', 'booking'); ?>&nbsp;&nbsp;</span><i class="wpbc_icn_data_saver_off"></i></a>
									</div>
									<div class="ui_element" >
										<a  class="wpbc_ui_control wpbc_ui_button wpbc_ui_button_danger0 tooltip_top"
											href="javascript:void(0);"
											onclick="javascript:jQuery('#action_<?php echo esc_attr( self::ACTION_FORM ); ?>').val('set_early_late_booking');
																jQuery('#edit_resource_id_<?php echo esc_attr( self::ACTION_FORM ); ?>').val('<?php echo esc_attr( $resource['id' ] ); ?>');
																jQuery('#<?php echo esc_attr( self::ACTION_FORM ); ?>').trigger( 'submit' );"
											title="<?php esc_attr_e('Configure discounts based on the interval between the booking date and check-in day.' ,'booking'); ?>"
										><span class="in-button-text"><?php esc_html_e('Early / Late Check-in Discounts', 'booking'); ?>&nbsp;&nbsp;</span><i class="wpbc_icn_multiple_stop"></i></a>
									</div>

								</div>
							</div>
						</div>
					</div><?php

					// =================================================================================================
					// Labels
					// =================================================================================================
					?><div class="wpbc_resource_field__switchable wpbc_resource_field__extra__labels 		wpbc_flextable_labels">
						<div class="wpbc_ajx_toolbar">
							<div class="ui_container ui_container_small">
								<div class="ui_group ui_group__labels">
								<?php

									// Cost Label
									wpbc_flextable_reused_ui__label_cost( $resource['id'], $resource['cost'] );

									// Default Form
									$resource_default_form = ( ! empty( $resource['default_form'] ) ) ? $resource['default_form'] : '';
									wpbc_flextable_reused_ui__label_default_form( $resource_default_form );

									// Parent | Child | Single
									$resource_capacity = ( ! empty( $resource['count'] ) )  ? $resource['count']  : 1;
									$resource_parent   = ( ! empty( $resource['parent'] ) ) ? $resource['parent'] : 0;
									wpbc_flextable_reused_ui__label_parent_child( $resource_parent, $resource_capacity );

									// User Owner Label
									$resource_user_id = ( ! empty( $resource['users'] ) ) ? $resource['users'] : 0;
									wpbc_flextable_reused_ui__label_user_owner( $resource_user_id );
								?>
								</div>
							</div>
						</div>
					</div>

			</div>
		</div>
        <?php
    }

}
add_action('wpbc_menu_created', array( new WPBC_Page_Settings__rcosts() , '__construct') );    // Executed after creation of Menu



/**
 * Flex Table   -  H e a d e r    T a b s
 */
function wpbc_resource_cost_page__get_dropdown_menu_view() {

	ob_start();
	ob_clean();

	?><span class="wpbc_flextable_header_tabs__resources wpdevelop"><?php			// Class 'wpdevelop' here required for correct  showing dropdown menu in this Tabs

	wpbc_flextable_header_tabs_html_container_start();

	?><div style="margin:auto;"> <?php
		wpbc_bs_display_tab(   array(
											'title'         => __('Pricing', 'booking')
											, 'font_icon'   => 'wpbc_icn_line_axis'
											, 'hint' 		=> array( 'title' => __('Show Pricing Options' ,'booking') , 'position' => 'top' )
											, 'onclick'     =>  "jQuery('.wpbc_other_resource_fields.wpbc_flextable_col_other').show();"
																. "jQuery('.wpbc_resource_field__switchable').hide();"
																. "jQuery('.wpbc_resource_field__extra__pricing_buttons').show();"
																. "jQuery('.wpbc_flextable_header_tabs__resources .nav-tab').removeClass('nav-tab-active');"
																. "jQuery(this).addClass('nav-tab-active');"
																. "jQuery('.nav-tab i.icon-white').removeClass('icon-white');"
																. "jQuery('.nav-tab-active i').addClass('icon-white');"
											, 'default'     => true
											, 'attr'  => array( 'id' => 'flextable_header_tab__publish' )
							) );

		wpbc_bs_display_tab(   array(
										'title'         => __('Labels', 'booking')
										, 'font_icon'   => 'wpbc_icn_label0 wpbc-bi-tags'
										, 'hint' 		=> array( 'title' => __('Show Labels' ,'booking') , 'position' => 'top' )
										, 'onclick'     =>  "jQuery('.wpbc_other_resource_fields.wpbc_flextable_col_other').show();"
															. "jQuery('.wpbc_resource_field__switchable').hide();"
															. "jQuery('.wpbc_resource_field__extra__labels').show();"
															. "jQuery('.wpbc_flextable_header_tabs__resources .nav-tab').removeClass('nav-tab-active');"
															. "jQuery(this).addClass('nav-tab-active');"
															. "jQuery('.nav-tab i.icon-white').removeClass('icon-white');"
															. "jQuery('.nav-tab-active i').addClass('icon-white');"
										, 'default'     => false
										, 'attr'  => array( 'id' => 'flextable_header_tab__cost' )
						) );

		wpbc_bs_display_tab(   array(
										'title'         => ''//__('Hide', 'booking')
										, 'font_icon'   => 'wpbc_icn_label0  wpbc-bi-eye-slash'
										, 'hint' 		=> array( 'title' => __('Hide Column' ,'booking') , 'position' => 'top' )
										, 'onclick'     =>  "jQuery('.wpbc_other_resource_fields.wpbc_flextable_col_other').hide();"
															. "jQuery('.wpbc_flextable_header_tabs__resources .nav-tab').removeClass('nav-tab-active');"
															. "jQuery(this).addClass('nav-tab-active');"
															. "jQuery('.nav-tab i.icon-white').removeClass('icon-white');"
															. "jQuery('.nav-tab-active i').addClass('icon-white');"
										, 'default'     => false
										, 'attr'  => array( 'id' => 'flextable_header_tab__hide' )
						) );
		?></div><?php


		// -------------------------------------------------------------------------------------------------------------
		// ORDER BY options
		// -------------------------------------------------------------------------------------------------------------
		$sort_order_items_arr = array();
		$sort_font_icon = 'wpbc_icn_swap_vert';

		// Priority
		// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
		if ( class_exists( 'wpdev_bk_biz_l' ) ){
			// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
			if ( empty( $_GET['orderby'] ) ){
				$_GET['orderby'] = 'prioritet';
				$_GET['order'] = 'asc';
			}
			$sort_url =  wpbc_get_price_url( true, false ) .  '&orderby=prioritet'
							   . ( ( ( ! empty( $_GET['order'] ) ) && ( 'asc' === $_GET['order'] ) ) ? '&order=desc' : '&order=asc' )  // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
							   . '#wpbc_resources_link';

			$sort_icn = '';
			// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
			if ( ( ! empty( $_GET['orderby'] ) ) && ( 'prioritet' === $_GET['orderby'] ) ) {
				$sort_icn	= ( ( ( ! empty( $_GET['order'] ) ) && ( 'asc' === $_GET['order'] ) )   // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
									? ' <span aria-hidden="true" class="wpbc_icn_vertical_align_top"></span>'
									: ' <span aria-hidden="true" class="wpbc_icn_vertical_align_bottom"></span>'
								);
				  // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
				$sort_font_icon = ( ( ( ! empty( $_GET['order'] ) ) && ( 'asc' === $_GET['order'] ) ) ? 'wpbc_icn_vertical_align_top' : 'wpbc_icn_vertical_align_bottom' );
			}

			$sort_order_items_arr[] = array(
				'type'  => 'link',
				'title' => __( 'Priority', 'booking' ) . $sort_icn,
				'url'   => $sort_url
			);
		}

		// Users
		if ( class_exists( 'wpdev_bk_multiuser' ) ) {

			$is_can = apply_bk_filter( 'multiuser_is_user_can_be_here', true, 'only_super_admin' );
			if ( $is_can ) {

				$sort_url =  wpbc_get_price_url( true, false ) .  '&orderby=users'
								   . ( ( ( ! empty( $_GET['order'] ) ) && ( 'asc' === $_GET['order'] ) ) ? '&order=desc' : '&order=asc' )  // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
								   . '#wpbc_resources_link';

				$sort_icn = '';
				// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
				if ( ( ! empty( $_GET['orderby'] ) ) && ( 'users' === $_GET['orderby'] ) ) {
					$sort_icn	= ( ( ( ! empty( $_GET['order'] ) ) && ( 'asc' === $_GET['order'] ) )  // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
										? ' <span aria-hidden="true" class="wpbc_icn_vertical_align_top"></span>'
										: ' <span aria-hidden="true" class="wpbc_icn_vertical_align_bottom"></span>'
									);
					$sort_font_icon = ( ( ( ! empty( $_GET['order'] ) ) && ( 'asc' === $_GET['order'] ) ) ? 'wpbc_icn_vertical_align_top' : 'wpbc_icn_vertical_align_bottom' );  // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
				}

				$sort_order_items_arr[] = array(
					'type'  => 'link',
					'title' => __( 'Users', 'booking' ) . $sort_icn,
					'url'   => $sort_url
				);
			}
		}

		if ( ! empty( $sort_order_items_arr ) ) {

				wpbc_bs_dropdown_menu( array(
											'title'     => '',										//__( 'Options', 'booking' ) . '&nbsp;',
											'font_icon' => $sort_font_icon, 						//'wpbc_icn_more_vert0 wpbc_icn_swap_vert',
											'position'  => 'right',
											'style'   => 'margin-left: auto;',        				// Right align
											'items'     => $sort_order_items_arr
								));
		}
		// -------------------------------------------------------------------------------------------------------------


	wpbc_flextable_header_tabs_html_container_end();

	?></span><?php

	$content = ob_get_contents();
	ob_end_clean();

	return $content;
}


/**
 * Show Toolbar at  WP Booking Calendar > Prices > Daily Costs page
 *
 * @return void
 */
function wpbc_resource_cost_page__toolbar() {

	wpbc_clear_div();

	//  Toolbar --------------------------------------------------------------------------------------------------------

	?><div id="toolbar_booking_resources" style="position:relative;display: none;display: block;"><?php


		// <editor-fold     defaultstate="collapsed"                        desc=" T O P    T A B s "  >

		// Show Tabs only in for PS and BS versions other versions already  have it.
		//if ( ! class_exists( 'wpdev_bk_biz_m' ) ) {

			wpbc_bs_toolbar_tabs_html_container_start();

				wpbc_bs_display_tab(   array(
													'title'         => __('Options', 'booking')
													// , 'hint' => array( 'title' => __('Manage bookings' ,'booking') , 'position' => 'top' )
													, 'onclick'     =>    "jQuery('.ui_container_toolbar').hide();"
																		. "jQuery('.ui_container_options').show();"
																		. "jQuery('#toolbar_booking_resources .nav-tab').removeClass('nav-tab-active');"
																		. "jQuery(this).addClass('nav-tab-active');"
																		. "jQuery('.nav-tab i.icon-white').removeClass('icon-white');"
																		. "jQuery('.nav-tab-active i').addClass('icon-white');"
													, 'font_icon'   => 'wpbc_icn_tune'
													, 'default'     => true

									) );


				wpbc_bs_dropdown_menu_help();

			wpbc_bs_toolbar_tabs_html_container_end();
		//}
		// </editor-fold>

		$submit_form_name = 'wpbc_form_add_new_booking_resources';
		?><form  name="<?php echo esc_attr( $submit_form_name ); ?>" id="<?php echo esc_attr( $submit_form_name ); ?>" action="" method="post" autocomplete="off"><?php

			// N o n c e   field, and key for checking   S u b m i t
			wp_nonce_field( 'wpbc_settings_page_' . $submit_form_name );
			?><input type="hidden" name="is_form_sbmitted_<?php echo esc_attr( $submit_form_name ); ?>" id="is_form_sbmitted_<?php echo esc_attr( $submit_form_name ); ?>" value="1" /><?php


			////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			// New toolbar
			////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			?><div id="booking_resources_toolbar_container" class="wpbc_ajx_toolbar"><?php

				$selected_tab = 'add_resource_options';

				// Options
				?><div class="ui_container    ui_container_toolbar		ui_container_small    ui_container_options    ui_container_options_row_1"
					   style="<?php echo ( 'add_resource_options' == $selected_tab ) ? 'display: flex' : 'display: none' ?>;"><?php

					?><div class="ui_group"><?php

						wpbc_br__ui__toolbar_search_resource_by_keyword( array(
																				'url' => wpbc_get_price_url()
																			) );
					?></div><?php

				?></div><?php

			?></div><?php

		?></form><?php
	?></div><?php

	wpbc_clear_div();

}


/**
 * Show / Hide toolbar options - defined at  top Header line
 *
 * @param $page_tag
 * @param $active_page_tab
 * @param $active_page_subtab
 *
 * @return false|void
 */
function wpbc_show_search_dropdown_menu( $page_tag, $active_page_tab, $active_page_subtab ) {

	if ( ( 'wpbc-prices' !== $page_tag ) || ( 'cost' !== $active_page_tab ) ) {
		return false;
	}

	$sort_order_items_arr   = array();
	$sort_order_items_arr[] = array(
										'type'  => 'link',
										'title' => '<i class="menu_icon icon-1x wpbc-bi-eye"></i> &nbsp; &nbsp; ' . __( 'Show Toolbar', 'booking' ),
										'url'   => 'javascript:void(0);',
										'attr' => array( 'class'   => 'wpbc_toggle_toolbar_options',
										                 'onclick' => "javascript: jQuery( '#toolbar_booking_resources' ).toggle();jQuery( '.wpbc_toggle_toolbar_options').toggle(); "
										)
									);
	$sort_order_items_arr[] = array(
										'type'  => 'link',
										'title' => '<i class="menu_icon icon-1x wpbc-bi-eye-slash"></i> &nbsp; &nbsp; ' .__( 'Hide Toolbar', 'booking' ),
										'url'   => 'javascript:void(0);',
										'attr' => array( 'class'   => 'wpbc_toggle_toolbar_options',
														 'style'   => 'display:none;',
										                 'onclick' => "javascript: jQuery( '#toolbar_booking_resources' ).toggle();jQuery( '.wpbc_toggle_toolbar_options').toggle(); "
										)
									);
	?><span class="wpdevelop" style="align-self: flex-end;"><?php
		wpbc_bs_dropdown_menu( array(
									'title'     => '',                                        //__( 'Options', 'booking' ) . '&nbsp;',
									'font_icon' => 'wpbc_icn_more_vert',                        //'wpbc_icn_more_vert0 wpbc_icn_swap_vert',
									'position'  => 'right',
									//'style'   => 'margin-left: auto;',        			// Right align
									'items'     => $sort_order_items_arr
								) );
	?></span><?php
}
// add_bk_action('wpbc_h1_header_content_end', 'wpbc_show_search_dropdown_menu');