<?php /**
 * @version 1.0
 * @package Booking > Resources > Cost and rates page > "Rates" section
 * @category Settings page 
 * @author wpdevelop
 *
 * @web-site https://wpbookingcalendar.com/
 * @email info@wpbookingcalendar.com 
 * 
 * @modified 2016-09-10
 * 
 * This is COMMERCIAL SCRIPT
 * We are not guarantee correct work and support of Booking Calendar, if some file(s) was modified by someone else then wpdevelop.
 */

if ( ! defined( 'ABSPATH' ) ) exit;                                             // Exit if accessed directly

class WPBC_Section_Rate {
    
    const HTML_PREFIX     = 'rrate_';
    const HTML_SECTION_ID = 'set_rate';
    
    private $settings;
    private $loaded_meta_data = array();                                        /** array(    [filter]      => array ( [33] => On,      [29] => Off,    [27] => Off )
                                                                                            , [rate]        => array ( [33] => 100,     [29] => 0,      [27] => 0   )
                                                                                            , [rate_type]   => array ( [33] => curency, [29] => %,      [27] => %   )    )  */
    
    
    function __construct( $resource_id, $params ) {
        
        $defaults = array( 
                              'resource_id'     => 0
                            , 'resource_id_arr' => array()
                        );
        $params = wp_parse_args( $params, $defaults );
      
        if ( ! empty( $resource_id ) ) {
            
            $params[ 'resource_id_arr' ] = explode( ',', (string) $resource_id ); 
        
            $params[ 'resource_id' ]     = $params[ 'resource_id_arr' ][0];     // If we selected several booking resources, so by default we will show settings of first selected resource 
        }

        $this->settings = $params;
    }
    
    
    /** Show MetaBox */
    public function display() {
        
        ?><div class="clear" style="margin-top:20px;"></div><?php 
        ?><div id="wpbc_<?php echo esc_attr( self::HTML_PREFIX  . 'table_' . self::HTML_SECTION_ID ); ?>" class="wpbc_settings_row wpbc_settings_row_rightNO"><?php

            // Get data
            $resource_titles = array();                    
            $wpbc_br_cache = wpbc_br_cache();
            foreach ( $this->settings[ 'resource_id_arr' ] as $bk_res_id ) {
                
                $title_res = $wpbc_br_cache->get_resource_attr( $bk_res_id, 'title');
                if (! empty($title_res) ) {
                    $title_res =  wpbc_lang( $title_res );

                    $resource_titles[]= $title_res;
                }
            }
       
            if (  ( ! empty( $this->settings[ 'resource_id_arr' ] ) ) && ( ! empty( $resource_titles ) )  ){

	            echo '<div class="wpbc_round_white_panel">';
                    $this->seasonfilters_section( $resource_titles );
				echo '</div>';
                
                
            } else {
                wpbc_show_message_in_settings( __( 'Nothing Found', 'booking' ) . '.', 'warning', __('Error' ,'booking') . '.' );
            }
        
            ?><div class="clear" style="margin-top:20px;"></div><?php 
        ?></div><?php                         
    }

    
    /**
	 * Section Content, Define Headers
     * 
     * @param string $resource_titles
     */
    private function seasonfilters_section( $resource_titles ){

		// TODO: 2025-05-03 temp  fix of view edit filter.
		wpbc_add_css_to_hide_seasons();

		$resource_titles_text = array();
		foreach ( $resource_titles as $single_resource_title ) {
			$resource_titles_text[] = '<span class="wpbc_label label0 label-default0 label-info0" >' . $single_resource_title . '</span>';
		}
		$resource_titles_text = '<span class="wpdevelop0 wpbc_flextable_labels ">' . implode( ', ', $resource_titles_text ) . '</span>';

		?>
		<h3 class="header_for_cost_object_edit">
			<span>
			<?php
				echo esc_html__( 'Configure Seasonal Pricing for', 'booking' );
			?>
				<span class="in_header_container_for_resource_title">
				<?php
					echo esc_html( wp_strip_all_tags( $resource_titles_text ) );
				?>
				</span>
			</span>
			<a class="header_for_cost_object_edit__close" href="<?php echo esc_url( wpbc_get_back_button_url__for_seasons() ); ?>"><i class="wpbc_icn_close"></i></a>
		</h3>
		<?php


        ?><table class="form-table"><tbody>
            <tr valign="top" >
                <th scope="row" style="vertical-align:middle;">
                    <?php 
                    if ( count($resource_titles) > 1 ) esc_html_e('Resources', 'booking');
                    else esc_html_e('Resource', 'booking');
                    ?>
                </th>
                <td class="description wpbc_edited_resource_label">
                    <?php echo wp_kses_post( $resource_titles_text ); ?>
                    <?php                     
                    $wpbc_br_cache = wpbc_br_cache();
                    $resource_attr = $wpbc_br_cache->get_resource_attr( $this->settings['resource_id'] );
                    
                    $is_can = apply_bk_filter( 'multiuser_is_user_can_be_here', true, 'only_super_admin' );    

                    if ( ( $is_can ) && ( class_exists( 'wpdev_bk_multiuser' ) ) ) {
                        ?><span class="wpdevelop">
                        <a data-original-title="<?php echo esc_js( __('Hide season filters', 'booking') ); ?>" 
                           class="button wpbc_show_hide_children tooltip_left wpbc_seasonfilters_btn_to_hide" style="display:none;float:right;"
                           onclick="javascript: jQuery('.wpbc_seasonfilters_row_to_hide').addClass('hidden_items');jQuery(this).hide();jQuery('.wpbc_seasonfilters_btn_to_show').show();" 
                           href="javascript:void(0);" 
                           style="display: inline-block;"><span aria-hidden="true" class="wpbc_icn_visibility_off"></span></a>            
                        <a data-original-title="<?php echo esc_js( __('Show all exist season filters', 'booking') ); ?>" 
                           class="button wpbc_show_hide_children tooltip_left wpbc_seasonfilters_btn_to_show" style="float:right;"
                           onclick="javascript: jQuery('.wpbc_seasonfilters_row_to_hide').removeClass('hidden_items');jQuery(this).hide();jQuery('.wpbc_seasonfilters_btn_to_hide').show();" 
                           href="javascript:void(0);" 
                           style="display: inline-block;"><span aria-hidden="true" class="wpbc_icn_visibility"></span></a>
                        </span>
                        <?php
                    }                            
                    ?>
                    
                </td> 
            </tr>                
            <?php

        ?></tbody></table><?php

		$is_checked = false;
		$field_name  = self::HTML_PREFIX . 'select_all';
		$field_value = '';
		$field_title = '';
		$params_checkbox = array(
								  'id'       => $field_name 										// HTML ID  of element
								, 'name'     => $field_name
								, 'label'    => array( 'title' => wp_kses_post( $field_title ), 'position' => 'right' )
								, 'toggle_style' => '' 												// CSS of select element
								, 'class'    => 'wpbc_visible_but_out_screen' 													// CSS Class of select element
								, 'disabled' => ''
								, 'attr'     => array() 											// Any  additional attributes, if this radio | checkbox element
								, 'legend'   => wp_kses_post( $field_title )						// aria-label parameter
								, 'value'    => $field_value 										// Some Value from optins array that selected by default
								, 'selected' => $is_checked											// Selected or not

								//, 'onfocus' 	=>  "console.log( 'ON FOCUS:',  jQuery( this ).is(':checked') , 'in element:' , jQuery( this ) );"					// JavaScript code
								//, 'onchange' 	=> "wpbc_ajx_booking_send_search_request_with_params( {'ui_usr__send_emails': (jQuery( this ).is(':checked') ? 'send' : 'not_send') } );"					// JavaScript code
								//, 'hint' 		=> array( 'title' => __('Send email notification to customer about this operation' ,'booking') , 'position' => 'top' )
							);
		ob_start();
		ob_clean();

		wpbc_flex_toggle( $params_checkbox );
		$toggle_box_html = ob_get_contents();
		ob_end_clean();

	    $toggle_box_html = "<span style='display: flex;flex-flow: row wrap;justify-content: flex-start;align-items: center;'>"
	                       . $toggle_box_html
	                       . "<span>" . __('Enable / Disable', 'booking') . "</span>"
	                       . "</span>";


        ////////////////////////////////////////////////////////////////////
        // Season Filters Table     
        ////////////////////////////////////////////////////////////////////
        $columns = array();
        $columns[ 'id' ] = array(         'title' => __( 'ID', 'booking' )
                                        , 'style' => 'width:3em;'
                                        , 'class' => 'wpbc_hide_mobile'
                                        //, 'sortable' => true
                                    );
		$columns['check']   = array( 'title' => $toggle_box_html, 'class' => 'check-column' , 'style'=>'width: 6em;font-size: 10px;');
//        $columns[ 'check' ] = array( 'title' => '<input type="checkbox" value="" id="' . self::HTML_PREFIX . 'select_all" name="' . self::HTML_PREFIX . 'select_id_all" />'
//                                        , 'class' => 'check-column'
//                                    );

        $columns = apply_filters ('wpbc_' . self::HTML_SECTION_ID . '_sf_table_header__after_id' , $columns );


//        $columns[ 'enabled' ] = array(    'title' => __( 'Enabled', 'booking' )
//                                        , 'class' => 'wpbc_hide_mobile'
//                                        , 'style' => 'width:5em'
//                                        //, 'sortable' => true
//                                    );
        
        $columns[ 'rates' ] = array(    'title' => __( 'Rates', 'booking' )
                                        , 'style' => 'width:16em;text-align:center;'
                                        //, 'sortable' => true 
                                    );
        $columns[ 'final_cost' ] = array(    'title' => ucwords(strtolower( __( 'Seasonal price', 'booking' ) ))
                                        , 'style' => 'width:9em;'
                                        //, 'sortable' => true 
                                    );
        $columns[ 'title' ] = array(      'title' => __( 'Season', 'booking' )
                                        , 'style' => 'width:16%;'
                                        //, 'sortable' => true 
                                    );

        $columns[ 'info' ] = array(      'title' => __( 'Info', 'booking' )
                                        , 'style' => 'text-align:center;'
                                        , 'class' => 'wpbc_hide_mobile'
                                        //, 'sortable' => true 
                                    );

        $columns = apply_filters ('wpbc_seasonfilters_table_header__user_title' , $columns );                
        if ( isset($columns[ 'users' ] ) ) {
            $columns[ 'users' ][ 'sortable' ] = false;
        }

        $columns = apply_filters ('wpbc_' . self::HTML_SECTION_ID . '_sf_table_header__last' , $columns );        


        // We need to  load meatadata here (before WPBC_SF_Table_all_seasons ), because because after  saving data acn  be updated. Saving is processing before this function.
        $meta_data = wpbc_get_resource_meta( $this->settings[ 'resource_id' ], 'rates' );
        if ( count( $meta_data ) > 0 ) {                                        

            $this->loaded_meta_data = maybe_unserialize( $meta_data[0]->value );                        
        }  
        
        $wpbc_sf_table = new WPBC_SF_Table_all_seasons( 
                            'rate' 
                            , array(
                                  'url_sufix'   =>  '#wpbc_' . self::HTML_PREFIX . 'sf_table'  // Link to  scroll
                                , 'rows_func'   =>  array( $this, 'seasonfilters_table__show_rows' ) 
                                , 'columns'     =>  $columns
                                , 'is_show_pseudo_search_form' => false

                                , 'edit_booking_resource_id_arr'    => $this->settings[ 'resource_id_arr' ]
                            )
                        );

		$wpbc_sf_table->display();

		?>
        <div class="clear"></div>
        <p style="text-align: left;line-height:2em;padding:5px 15px;" class="wpbc-settings-notice notice-info">
			<strong><?php
				esc_html_e( 'Note!', 'booking' ); ?></strong> <?php
			/* translators: 1: ... */
			printf( __( 'Enter seasonal rate(s) (cost diference in %1$s from standard cost %2$s or a fixed cost) of the booking resource (%3$s) or %4$sAdd a new seasonal filter%5$s', 'booking' ),  // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				'<span style="font-weight:600;color:#F90;">%</span>', '<span style="font-weight:600;color:#F90;">' . $resource_attr['cost'] . '</span>', ' <span style="font-weight:600;color:#F90;">' .  // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					$resource_titles_text . '</span> ',    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				'<a class="button button-secondary" href="' . wpbc_get_price_url() . '" style="font-size: 0.95em;font-weight: 600;text-transform: lowercase;">',    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				'</a>' );  // FixIn: 9.8.15.2.5.
			?>
        </p>
        <div class="container_for_save_buttons">
			<span></span>
			<a href="<?php echo esc_url( wpbc_get_back_button_url__for_seasons() ); ?>" class="button button-secondary" ><?php echo wp_kses_post( __( 'Cancel and Go Back', 'booking' ) ); ?></a>&nbsp;&nbsp;
			<a href="javascript:void(0);"
			   class="button button-primary"
			   onclick="javascript: //if ( jQuery('#sfd_days_filter_name').val() == '') { wpbc_field_highlight( '#sfd_days_filter_name' );  return false; }
									jQuery('#action_<?php echo esc_js( $this->settings['action_form'] ); ?>').val('update_sql_rate');
									jQuery('#edit_resource_id_<?php echo esc_attr( $this->settings['action_form'] ); ?>').val('<?php echo esc_attr(  implode( ',', $this->settings[ 'resource_id_arr' ] ) ); ?>');
									jQuery(this).closest('form').trigger( 'submit' );"
				><?php esc_html_e('Save Changes', 'booking'); ?></a>
		</div>
        <?php            

    }


    /**
	 * Show   R O W S   for booking resource table
     * 
     * @param int $row_num
     * @param array $resource
     */
    public function seasonfilters_table__show_rows( $row_num, $item ) {

        $css_class = ' wpbc_seasonfilters_row';

        ?><tr class="wpbc_row<?php echo esc_attr( $css_class ); ?>  wpbc_<?php

                    if ( ! empty( $item['hidded'] ) ) {
                        echo ' hidden_items wpbc_seasonfilters_row_to_hide';
                    }

                    ?>" id="resource_<?php echo esc_attr( $item['id'] ); ?>">
					<td class="wpbc_hide_mobile"><?php echo esc_html( $item['id' ] ); ?></td>
					<?php

					?><th class="check-column"><?php

						if ( 1 ) {

							$is_checked = false;
							if (   ( isset( $this->loaded_meta_data['filter'] ) )
								&& ( isset( $this->loaded_meta_data['filter'][ $item['id' ] ] ) )
								&& ( $this->loaded_meta_data['filter'][ $item['id' ] ] == 'On' )
								) {
								$is_checked = true;
							}

							$field_id    = self::HTML_PREFIX . 'select_' . $item['id' ];
							$field_name  = self::HTML_PREFIX . 'select_' . $item['id' ];
							$field_value = self::HTML_PREFIX . 'id_' . $item['id' ];
							$field_title = '';
							$params_checkbox = array(
													  'id'       => $field_id 										// HTML ID  of element
													, 'name'     => $field_name
													, 'label'    => array( 'title' => wp_kses_post( $field_title ), 'position' => 'right' )
													, 'toggle_style' => '' 												// CSS of select element
													, 'class'    => 'wpbc_visible_but_out_screen' 													// CSS Class of select element
													, 'disabled' => ''
													, 'attr'     => array() 											// Any  additional attributes, if this radio | checkbox element
													, 'legend'   => wp_kses_post( $field_title )						// aria-label parameter
													, 'value'    => $field_value 										// Some Value from optins array that selected by default
													, 'selected' => $is_checked											// Selected or not

													//, 'onfocus' 	=>  "console.log( 'ON FOCUS:',  jQuery( this ).is(':checked') , 'in element:' , jQuery( this ) );"					// JavaScript code
													//, 'onchange' 	=> "wpbc_ajx_booking_send_search_request_with_params( {'ui_usr__send_emails': (jQuery( this ).is(':checked') ? 'send' : 'not_send') } );"					// JavaScript code
													//, 'hint' 		=> array( 'title' => __('Send email notification to customer about this operation' ,'booking') , 'position' => 'top' )
												);
							wpbc_flex_toggle( $params_checkbox );

						}
					?></th><?php
/*
                    ?><th class="check-column">
                            <label class="screen-reader-text" for="<?php echo esc_attr( self::HTML_PREFIX  . 'select_' . $item['id' ] ); ?>"><?php echo esc_js(__('Select Booking Resource', 'booking')); ?></label>
                            <input type="checkbox" 
                                           id="<?php 	echo esc_attr( self::HTML_PREFIX  . 'select_' . $item['id' ] ); ?>"
                                           name="<?php 	echo esc_attr( self::HTML_PREFIX  . 'select_' . $item['id' ] ); ?>"
                                           value="<?php echo esc_attr( self::HTML_PREFIX  . 'id_' . $item['id' ] ); ?>"
                                           <?php    
                                            $is_checked = false;
                                            if (   ( isset( $this->loaded_meta_data['filter'] ) ) 
                                                && ( isset( $this->loaded_meta_data['filter'][ $item['id' ] ] ) )  
                                                && ( $this->loaded_meta_data['filter'][ $item['id' ] ] == 'On' )  
                                                ) {
                                                $is_checked = true;
                                            }
                                            checked( $is_checked ); 
                                            ?>
                                />       
                    </th>
                    <?php
*/
                    do_action( 'wpbc_' . self::HTML_SECTION_ID . '_sf_table_show_col__after_id', $row_num, $item ); 
/*
                    ?><td style="text-align:left;" class="wpbc_hide_mobile">&nbsp;&nbsp;&nbsp;<?php 
                        if (  $is_checked ) 
                            echo '<span class="wpbc_icn_done_outline" aria-hidden="true"></span>';
                        else
                            echo '<span class="wpbc_icn_not_interested" aria-hidden="true"></span>'; 
                    ?>
                    </td><?php
*/
					?>
                    <td class="wpbc_2_fields_in_collumn"><fieldset><?php 
                            
                            $rate = 0;
                            if (       ( isset( $this->loaded_meta_data['rate'] ) ) 
                                    && ( isset( $this->loaded_meta_data['rate'][ $item['id' ] ] ) )                                  
                                ) {
                                $rate = $this->loaded_meta_data['rate'][ $item['id' ] ];
                            }
		                    // FixIn: 9.8.0.5.
                          ?><input type="text" 
                                   value="<?php echo esc_attr( $rate ); ?>"
                                   id="rate_<?php echo esc_attr( $item['id' ] ); ?>"
                                   name="rate_<?php echo esc_attr( $item['id' ] ); ?>"
                                /><?php 
                              
                            $rate_type = '%';
                            if (       ( isset( $this->loaded_meta_data['rate_type'] ) ) 
                                    && ( isset( $this->loaded_meta_data['rate_type'][ $item['id' ] ] ) )                                  
                                ) {
                                $rate_type = $this->loaded_meta_data['rate_type'][ $item['id' ] ];
                            }                            
                                
                            $currency = wpbc_get_currency_symbol_for_user( $this->settings['resource_id'] );    
                       
                            $price_period = wpbc_get_per_day_night_title();

							?><select name="rate_type_<?php echo esc_attr( $item['id'] ); ?>"
									  id="rate_type_<?php echo esc_attr( $item['id'] ); ?>">
								<option value="%" <?php selected( $rate_type, '%' ); ?> >%</option>
								<option value="curency" <?php selected( $rate_type, 'curency' ); ?> ><?php echo wp_kses_post( $currency . $price_period ); ?></option>
							</select>
						</fieldset>
                    </td>
                    <td><?php
                    
                    //Final Cost
                    
                        if ( $rate_type == 'curency') {
                           $rate_cost = floatval( $rate );
                        } else  {
                            
                            $wpbc_br_cache = wpbc_br_cache();
                            $resource_attr = $wpbc_br_cache->get_resource_attr( $this->settings['resource_id'] );
                                                
                            $rate_cost = ( $resource_attr['cost'] * floatval( $rate ) / 100 );
                        }
						// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						echo wpbc_get_cost_with_currency_for_user( $rate_cost, $this->settings['resource_id'] ) . $price_period;
                                        
                    ?></td>
                    <td>
						<a href="<?php echo esc_url( wpbc_get_price_url() . '&tab=filter&edit_season_id=' . $item['id'] . '&wh_search_id=' . $item['id'] ); ?>"
						   style="font-weight:600;"
						><?php echo esc_html( $item['title'] ); ?></a>
                    </td>
                    <td class="wpbc_hide_mobile" style="line-height: 2em;"><?php

                        if (  (  $is_checked ) && ( isset( $this->loaded_meta_data['general'] ) )  ){

                            echo '<span class="label label-default label-danger ' 
                                    . ( ( $this->loaded_meta_data[ 'general' ] == 'On' ) ? '' : 'hidden_items' ) 
                                    . ' wpbc_unavailable_item  wpbc_rcosts_item" >' . esc_html__('unavailable', 'booking' ) . '</span>';

                            echo '<span class="label label-default label-success ' 
                                    . ( ( $this->loaded_meta_data[ 'general' ] == 'Off' ) ? '' : 'hidden_items' ) 
                                    . ' wpbc_available_item wpbc_rcosts_item" >' . esc_html__('available', 'booking' )   . '</span>';
							echo '&nbsp;&nbsp;&nbsp;' ;

                        }
						// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						echo wpbc_get_filter_description( $item['filter'] );
                    ?></td>
                    <?php do_action( 'wpbc_seasonfilters_table_show_col__user_text',  $row_num, $item ); ?>
                    <?php do_action( 'wpbc_' . self::HTML_SECTION_ID . '_sf_table_show_show_col__last', $row_num, $item ); ?>
        </tr>
        <?php    
    }
    
           
    /** Save changes */
    public function update_sql() {
        
        // $validated_title = WPBC_Settings_API::validate_text_post_static( $html_prefix . 'days_filter_name' );        //  Validate Title

        $available_sf = new WPBC_SF_Table_all_seasons( 
                        'rate' 
                        , array(
                              'url_sufix'   =>  '#wpbc_' . self::HTML_PREFIX . 'sf_table'  // Link to  scroll
                            //, 'rows_func'   =>  array( $this, 'seasonfilters_table__show_rows' ) 
                            , 'columns'     =>  array()
                            , 'is_show_pseudo_search_form' => false
                            , 'edit_booking_resource_id_arr'    => $this->settings[ 'resource_id_arr' ]
                            
                        )
                    );
        
        $season_filters_for_br = $available_sf->get_linear_data_for_one_page();
        
        foreach ( $this->settings[ 'resource_id_arr' ] as $resource_id ) {      // Loop all  selected booking resources.
            
            $rcosts = array();
            $rcosts[ 'filter' ]     = array();
            $rcosts[ 'rate' ]       = array();
            $rcosts[ 'rate_type' ]  = array();

            
            // List  of season filters that  available (listed in table)  for this booking resource(s)
            // And Validate $_POST for saving
            foreach ( $season_filters_for_br as $season_filter_id => $season_filter_data) {

                // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
                if ( isset( $_POST[ 'rate_' . $season_filter_id ] ) ) {

	                // On | Off
	                // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
	                if ( isset( $_POST[ self::HTML_PREFIX . 'select_' . $season_filter_id ] ) ) {
		                $rcosts['filter'][ $season_filter_id ] = 'On';
	                } else {
		                $rcosts['filter'][ $season_filter_id ] = 'Off';
	                }

	                // Rate Value.
					// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
	                $rcosts['rate'][ $season_filter_id ] = str_replace( ',', '.', $_POST[ 'rate_' . $season_filter_id ] );                            // In case,  if someone was make mistake and use , instead of .

	                if ( false !== strpos( $rcosts['rate'][ $season_filter_id ], '=' ) ) {
		                $rcosts['rate'][ $season_filter_id ] = wpbc_sanitize_text_strong( $rcosts['rate'][ $season_filter_id ] );            // FixIn: 9.8.0.5.
	                } else {
		                $rcosts['rate'][ $season_filter_id ] = floatval( $rcosts['rate'][ $season_filter_id ] );
	                }


                        

                        // Rate Type
						// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotValidated
                        switch ( $_POST[ 'rate_type_' . $season_filter_id ] ) {
                            case 'curency':
                                $rcosts[ 'rate_type' ][ $season_filter_id ] = 'curency';
                                break;
                            default: 
                                $rcosts[ 'rate_type' ][ $season_filter_id ] = '%';
                                break;
                        }                        
                }
            }

            // Save new meta rcosts data     
            wpbc_save_resource_meta( $resource_id, 'rates', $rcosts );

            wpbc_show_changes_saved_message();   

            make_bk_action( 'wpbc_reinit_seasonfilters_cache' );                        
        }    
        
    }
}