<?php
/**
 * Main Loading.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}                                                                                    // Exit if accessed directly


require_once WPBC_PRO_PLUGIN_DIR . '/includes/activation/activation-pro.php';


/**
 * Load pro files,  after  loaded all PHP  files of Booking Calendar Free version.
 *
 * @return void
 */
function wpbc_pro_load_php_files() {
	if ( class_exists( 'wpdev_bk_personal' ) ) {
		// Echo 'Deactivate the old paid version  of Booking Calendar and enable the Booking Calendar Free version !
		return;
	}
	require_once WPBC_PRO_PLUGIN_DIR . '/inc/_ps/personal.php';
}
add_action( 'wpbc_loaded_php_files', 'wpbc_pro_load_php_files' );

// ---------------------------------------------------------------------------------------------------------------------
// ==  Go  ==
// ---------------------------------------------------------------------------------------------------------------------
// require_once WPBC_PLUGIN_DIR . '/core/wpbc.php';

//	if ( is_plugin_active( 'booking/wpdev-booking.php' ) || is_plugin_active_for_network( 'imagify/imagify.php' ) ) {
//		return $result;
//	}

/**
 * Disable showing update for this Booking Calendar Premium version.
 *
 * @param $request
 * @param $url
 *
 * @return array|mixed
 */
function wpbc_pro_hide_update_check( $request, $url ) {

	if ( ! is_string( $url ) ) {
		return $request;
	}

	if ( ! preg_match( '@^https?://api.wordpress.org/plugins/update-check(/|\?|$)@', $url ) || empty( $request['body']['plugins'] ) ) {
		// Not a plugin update request. Stop immediately.
		return $request;
	}

	/**
	 * Depending on the API version, the data can have several forms:
	 * - Can be serialized or JSON encoded,
	 * - Can be an object of arrays or an object of objects.
	 */
	$is_serialized = is_serialized( $request['body']['plugins'] );
	$basename      = plugin_basename( WPBC_PRO_FILE );
	$edited        = false;

	if ( $is_serialized ) {
		$plugins = maybe_unserialize( $request['body']['plugins'] );
	} else {
		$plugins = json_decode( $request['body']['plugins'] );
	}


	if ( ! empty( $plugins->plugins ) ) {
		if ( is_object( $plugins->plugins ) ) {
			if ( isset( $plugins->plugins->$basename ) ) {
				unset( $plugins->plugins->$basename );
				$edited = true;
			}
		} elseif ( is_array( $plugins->plugins ) ) {
			if ( isset( $plugins->plugins[ $basename ] ) ) {
				unset( $plugins->plugins[ $basename ] );
				$edited = true;
			}
		}
	}

	if ( ! empty( $plugins->active ) ) {
		$active_is_object = is_object( $plugins->active );

		if ( $active_is_object || is_array( $plugins->active ) ) {
			foreach ( $plugins->active as $key => $plugin_basename ) {
				if ( $plugin_basename !== $basename ) {
					continue;
				}
				if ( $active_is_object ) {
					unset( $plugins->active->$key );
				} else {
					unset( $plugins->active[ $key ] );
				}
				$edited = true;
				break;
			}
		}
	}

	if ( $edited ) {
		if ( $is_serialized ) {
			$request['body']['plugins'] = maybe_serialize( $plugins );
		} else {
			$request['body']['plugins'] = wp_json_encode( $plugins );
		}
	}

	return $request;
}
add_filter( 'http_request_args', 'wpbc_pro_hide_update_check', 5, 2 );


if ( class_exists( 'WPBC_BookingInstallPro' ) ) {                                                                    // Check if we need to run Install / Uninstal process.
	new WPBC_BookingInstallPro();
}
