<?php
/**
 * @package  Redsys Checkout Server  Integration
 * @category Payment Gateway for Booking Calendar 
 * @author wpdevelop
 * @version 2.0
 * @web-site https://wpbookingcalendar.com/
 * @email info@wpbookingcalendar.com 
 * 
 * @modified 2024-11-12
 *
 * Integration based on Redsys PHP library redsysHMAC256_API_PHP_7.0.0
 * Based on guide: https://pagosonline.redsys.es/conexion-redireccion.html   https://pagosonline.redsys.es/conexion-redireccion.html
 *
 *           2025-07-16: https://pagosonline.redsys.es/desarrolladores-inicio/documentacion-tipos-de-integracion/desarrolladores-redireccion/
 *
 */



if ( ! defined( 'ABSPATH' ) ) exit;                                             // Exit if accessed directly
                                                                                
if ( ! defined( 'WPBC_REDSYS_GATEWAY_ID' ) )        define( 'WPBC_REDSYS_GATEWAY_ID', 'redsys' );


//                                                                              <editor-fold   defaultstate="collapsed"   desc=" Gateway API " >

/** API  for  Payment Gateway  */
class WPBC_Gateway_API_REDSYS extends WPBC_Gateway_API  {

	/**
	 * Get payment Form
	 * @param string $output    - other active payment forms
	 * @param array $params     - input params                          array (
																				[id] => 514
																				[days_input_format] => 24.05.2019
																				[days_only_sql] => 2019-05-24
																				[dates_sql] => 2019-05-24 00:00:00
																				[check_in_date_sql] => 2019-05-24 00:00:00
																				[check_out_date_sql] => 2019-05-24 00:00:00
																				[dates] => 05/24/2019
																				[check_in_date] => 05/24/2019
																				[check_out_date] => 05/24/2019
																				[check_out_plus1day] => 05/25/2019
																				[dates_count] => 1
																				[days_count] => 1
																				[nights_count] => 1
																				[check_in_date_hint] => 05/24/2019
																				[check_out_date_hint] => 05/24/2019
																				[start_time_hint] => 00:00
																				[end_time_hint] => 00:00
																				[selected_dates_hint] => 05/24/2019
																				[selected_timedates_hint] => 05/24/2019
																				[selected_short_dates_hint] => 05/24/2019
																				[selected_short_timedates_hint] => 05/24/2019
																				[days_number_hint] => 1
																				[nights_number_hint] => 1
																				[siteurl] => http://beta
																				[resource_title] => Apartment#2
																				[bookingtype] => Apartment#2
																				[remote_ip] => 127.0.0.1
																				[user_agent] => Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0
																				[request_url] => http://beta/resource-id3/
																				[current_date] => 04/24/2019
																				[current_time] => 10:19
																				[cost_hint] => CURRENCY_SYMBOL140.00
																				[name] => John
																				[secondname] => Smith
																				[email] => user@beta.com
																				[phone] => test
																				[visitors] => 1
																				[children] => 0
																				[details] => test
																				[term_and_condition] => I Accept term and conditions
																				[booking_resource_id] => 3
																				[resource_id] => 3
																				[type_id] => 3
																				[type] => 3
																				[resource] => 3
																				[content] =>
																								First Name:John
																								Last Name:Smith
																								Email:user@beta.com
																								Phone:test
																								Adults: 1
																								Details:
																								 test
																				[moderatelink] => http://beta/wp-admin/admin.php?page=wpbc&tab=vm_booking_listing&wh_booking_id=514
																				[visitorbookingediturl] => http://beta/edit/?booking_hash=d4e19e315f8ed7903e38d1c8b2210356
																				[visitorbookingslisting] => http://beta/list-customer-bookings/?booking_hash=d4e19e315f8ed7903e38d1c8b2210356
																				[visitorbookingcancelurl] => http://beta/edit/?booking_hash=d4e19e315f8ed7903e38d1c8b2210356&booking_cancel=1
																				[visitorbookingpayurl] => http://beta/edit/?booking_hash=d4e19e315f8ed7903e38d1c8b2210356&booking_pay=1
																				[bookinghash] => d4e19e315f8ed7903e38d1c8b2210356
																				[db_cost] => 140.00
																				[db_cost_hint] => CURRENCY_SYMBOL140.00
																				[modification_date] =>  2019-04-24 10:19:23
																				[modification_year] => 2019
																				[modification_month] => 04
																				[modification_day] => 24
																				[modification_hour] => 10
																				[modification_minutes] => 19
																				[modification_seconds] => 23
																				[__form] => text^selected_short_timedates_hint3^05/24/2019~text^nights_number_hint3^1~text^cost_hint3^CURRENCY_SYMBOL140.00~text^name3^John~text^secondname3^Smith~email^email3^user@beta.com~text^phone3^test~selectbox-one^visitors3^1~selectbox-one^children3^0~textarea^details3^test~checkbox^term_and_condition3[]^I Accept term and conditions
																				[__nonce] => 155609396391.65



																				[__booking_form_type] => standard
																				[additional_description] =>
																				[payment_cost] => 140.00
																				[payment_cost_hint] => CURRENCY_SYMBOL140.00
																				[calc_total_cost] => 140.00
																				[calc_cost_hint] => CURRENCY_SYMBOL140.00

																				[calc_deposit_cost] => 140.00
																				[calc_deposit_hint] => CURRENCY_SYMBOL140.00
																				[calc_deposit_cost_hint] => CURRENCY_SYMBOL140.00
																				[calc_balance_cost] => 0.00
																				[calc_balance_hint] => CURRENCY_SYMBOL0.00
																				[calc_balance_cost_hint] => CURRENCY_SYMBOL0.00
																				[calc_original_cost] => 100.00
																				[calc_original_cost_hint] => CURRENCY_SYMBOL100.00
																				[calc_additional_cost] => 40.00
																				[calc_additional_cost_hint] => CURRENCY_SYMBOL40.00
																				[calc_coupon_discount] => 0.00
																				[calc_coupon_discount_hint] => CURRENCY_SYMBOL0.00
																				[payment_form_target] =>
																				[cost_in_gateway] => 140.00



																			)
	 * @return string        - you must  return  in format: return $output . $your_payment_form_content
	 */
	public function get_payment_form( $output, $params, $gateway_id = '' ) {

		// Check  if currently  is showing this Gateway
		if (
				   (  ( ! empty( $gateway_id ) ) && ( $gateway_id !== $this->get_id() )  )      // Does we need to show this Gateway
				|| ( ! $this->is_gateway_on() )                                                 // Payment Gateway does NOT active
		) return $output ;

		if ( version_compare( PHP_VERSION, '7.0' ) < 0 ) { 		return 'Redsys payment require PHP version 7.0 or newer!'; }		// FixIn: 8.4.7.20.

		if ( ! class_exists( 'WPBC_RedsysAPI' ) ) {
			require_once( dirname( __FILE__ ) . '/includes/index.php' );
		}


		// -------------------------------------------------------------------------------------------------------------
		// == Payment Options ==
		// -------------------------------------------------------------------------------------------------------------
		$op_prefix = 'booking_' . WPBC_REDSYS_GATEWAY_ID . '_';

		$payment_options = array();

		/**
	 	 * We need to open payment form in separate window, if this booking was made togather with other
         *  in booking form  was used several  calendars from  different booking resources.
         *  So we are having several  payment forms for each  booked resource.
         *  System transfer this parameter $params['payment_form_target'] = ' target="_blank" ';
         *  otherwise $params['payment_form_target'] = '';
         */
		$payment_options['payment_form_target'] = '';  																	// ' target="_blank" ';

		$payment_options['payment_button_title'] = get_bk_option( $op_prefix . 'payment_button_title' );     			// 'Pay via RedSys'
		$payment_options['payment_button_title'] = wpbc_lang( $payment_options['payment_button_title'] );

		//		$payment_options['subject'] = get_bk_option( 'booking_redsys_subject' );                            // 'Payment for booking %s on these day(s): %s'
		//		$payment_options['subject'] = wpbc_lang( $payment_options['subject'] );
		//		$payment_options['subject'] = wpbc_replace_booking_shortcodes( $payment_options['subject'], $params );
		//		$payment_options['subject'] = substr( $payment_options['subject'], 0, 499 );

		// -------------------------------------------------------------------------------------------------------------
		// URLs - Success & Failed URLs
		// -------------------------------------------------------------------------------------------------------------
		$edit_url_for_visitors = get_bk_option( 'booking_url_bookings_edit_by_visitors' );
		// Edit URL was NOT configured
		if ( site_url() == $edit_url_for_visitors ){ 			 return 'Redsys require correct configuration ' . ' <em>"URL to edit bookings" option</em>';}

		$hash_approve = wpbc_get_secret_hash( array( 'payment', WPBC_REDSYS_GATEWAY_ID, $params['bookinghash'], 'approve' ) );
		$payment_options['success_url'] = wpbc_get_1way_hash_url( $hash_approve );

		$hash_decline = wpbc_get_secret_hash( array( 'payment', WPBC_REDSYS_GATEWAY_ID, $params['bookinghash'], 'decline' ) );
		$payment_options['error_url'] = wpbc_get_1way_hash_url( $hash_approve );

		// -------------------------------------------------------------------------------------------------------------
		// 'Redsys' - Required params:
		// -------------------------------------------------------------------------------------------------------------
		/**
		 * == Test environments ==
		 * 							Doc: https://pagosonline.redsys.es/entornosPruebas.html
 		 *
		 *
		 *	Tests 	https://sis-t.redsys.es:25443/sis/realizarPago
		 *	Real 	https://sis.redsys.es/sis/realizarPago
		 *
		 * Type of integration 	Petition 	URL connection
		 * Administration module 	To obtain the data of access to the portal administration, they must contact their bank for that this be provided 	https://sis-t.redsys.es:25443/Candals
		 * REST 	InitiatesPetition 	https://sis-t.redsys.es:25443/sis/rest/initiationPetitionREST
		 * TreatPeticion 				https://sis-t.redsys.es:25443/sis/rest/trataPetitionREST
		 * SOAP 	InitiatesPetition 	https://sis-t.redsys.es:25443/sis/services/SerClsWSEntradaV2
		 * TreatPeticion 				https://sis-t.redsys.es:25443/sis/services/SerClsWSEntradaV2
		 * Redirection 					https://sis-t.redsys.es:25443/sis/realizePago
		 *
		 *
		 * Generic data is provided test for testing. To get the data specific to your trade, you must contact your entity - What's the deal?
		 * 1) Ds'Merchant-MerchantCode: It's the trade number the sole provided by your bank.
		 * -- The number of generic trades for the implementation of Test tests is 										999008881
		 * 2) The terminal number is the terminal provided by the bank.
		 * -- The number of generic terminals for the realization of Test tests is 										001
		 * 3) Clave Trade: It is a key unique signature supplied for your bank.
		 * -- The generic trade key to the implementation of test is 													sq7HjrUOBfKmC576ILgskD5srU870gJ7
		 * 4) NOTE: If an authentication code is requested, introduce 													123456
		 */

		$redsys_account_mode = get_bk_option( $op_prefix . 'account_mode' );
		if ( 'test' == $redsys_account_mode ) {
			$fuc      = get_bk_option( $op_prefix . 'merchantcode_test' );		// "999008881";
			$terminal = get_bk_option( $op_prefix     . 'terminal_test' );		// "1";
			$kc       = get_bk_option( $op_prefix . 'secretsha256_test' );		// "sq7HjrUOBfKmC576ILgskD5srU870gJ7"
			$post_URL = 'https://sis-t.redsys.es:25443/sis/realizarPago';		// test URL
		} else {
			$fuc      = get_bk_option( $op_prefix . 'merchantcode_live' );
			$terminal = get_bk_option( $op_prefix     . 'terminal_live' );
			$kc       = get_bk_option( $op_prefix . 'secretsha256_live' );
			$post_URL = 'https://sis.redsys.es/sis/realizarPago';				// real
		}

		// Check whether secret keys was assigned,  otherwise -- ERROR
		if ( empty( $fuc ) ) { 		return 'Wrong configuration in gateway settings.' . ' <em>Empty: "Commerce number (FUC)" option</em>'; }
		if ( empty( $terminal ) ) { return 'Wrong configuration in gateway settings.' . ' <em>Empty: "Terminal number " option</em>'; }
		if ( empty( $kc ) ) { 		return 'Wrong configuration in gateway settings.' . ' <em>Empty: "Encryption secret passphrase SHA-256" option</em>'; }


		$redsys_version = "HMAC_SHA256_V1";
		$check_currency = get_bk_option( $op_prefix . 'currency' );         	// "978";
		$id             = time();

		//$is_cents = wpbc_redsys__cents_factor( $check_currency );
		$amount = wpbc_redsys__amount_in_redsys( $params['cost_in_gateway'], $check_currency );			// "145";

		/**
		 * HELP: https://pagosonline.redsys.es/parametros-entrada-salida.html   on TRANSACTIONSTYPE

				0: Authorisation 	0
				1: Preauthorization 	1
				11: Replacement preauthorization 	11
				2: Confirmation 	2
				3: Return 	3
				7: Separate Preauthorization 	7
				8: Separate Confirmation 	8
				9: Cancellation 	9
				15: Paygold 	15
													Autentication Puce 	17		REST/SOAP
				34: Return without original 	34
													Betting Award 	37		REST/SOAP
				45: Payment annulment 	45
				46: Annulment of return 	46
				47: Separate confirmation annulment 	47
				48: Partial confirmation 	48
				51: Modification of the link (Paygold) 	51
		 */
		$trans  = "0";


		// -------------------------------------------------------------------------------------------------------------
		// Redsys  Redirection  API
		// -------------------------------------------------------------------------------------------------------------
		$miObj = new WPBC_RedsysAPI;

		$miObj->set_parameter( "DS_MERCHANT_AMOUNT", 		$amount );
		$miObj->set_parameter( "DS_MERCHANT_ORDER", 		$id );
		$miObj->set_parameter( "DS_MERCHANT_MERCHANTCODE", 	$fuc );
		$miObj->set_parameter( "DS_MERCHANT_CURRENCY", 		$check_currency );
		$miObj->set_parameter( "DS_MERCHANT_TRANSACTIONTYPE", $trans );
		$miObj->set_parameter( "DS_MERCHANT_TERMINAL", 		$terminal );
		$miObj->set_parameter( "DS_MERCHANT_MERCHANTURL", 	'' );
		$miObj->set_parameter( "DS_MERCHANT_URLOK", 		$payment_options['success_url'] );
		$miObj->set_parameter( "DS_MERCHANT_URLKO", 		$payment_options['error_url'] );
		// FixIn: 10.12.4.1
		$miObj->set_parameter( 'DS_MERCHANT_CONSUMERLANGUAGE', '001' );
		$miObj->set_parameter( 'DS_MERCHANT_PRODUCTDESCRIPTION', __( 'Booking', 'booking' ) . ' ' . $params['booking_id'] );


		// PSD 2 - check more here https://pagosonline.redsys.es/parametros-entrada-salida.html#entradaTable  related to DS_MERCHANT_EMV3DS .
		$miObj->set_parameter( 'DS_MERCHANT_EMV3DS', $this->get_psd2_info( $params ) );

		$redsys_params    = $miObj->create_merchant_parameters();
		$redsys_signature = $miObj->create_merchant_signature( $kc );

		// -------------------------------------------------------------------------------------------------------------
        ob_start();

        ?><div class="redsys_div wpbc-payment-form" style="text-align:left;clear:both;"><?php

        ?><form action="<?php echo esc_url( $post_URL ); ?>" <?php
		// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		echo $payment_options['payment_form_target']; ?> method="POST" id="redsysPayForm" name="redsysPayForm" style="text-align:left;" class="booking_redsysPayForm"><?php

		?><input type="hidden" name="Ds_SignatureVersion" value="<?php
	// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	echo $redsys_version; ?>" /><?php
		?><input type="hidden" name="Ds_MerchantParameters" value="<?php
	// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	echo $redsys_params; ?>" /><?php
		?><input type="hidden" name="Ds_Signature" value="<?php
	// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	echo $redsys_signature; ?>" /><?php

        ?><input type="submit" value="<?php
	// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	echo $payment_options[ 'payment_button_title' ]; ?>" class="wpbc_button_light wpbc_button_gw wpbc_button_gw_redsys" /><?php

        ?></form></div><?php

        $payment_form = ob_get_clean();

		return $output . $payment_form;


		// =================================================================================================================
		// ==  E N D  ======================================================================================================
		// =================================================================================================================

		// TEST Redsys  inSight
		if(0){

			?><div class="redsys_div wpbc-replace-ajax wpbc-payment-form" style="text-align:left;clear:both;"><?php

			// Please note! ajax_script will be replaced to script after form will show in page. If we use script directly  here, so then error at  the page will appear and its will not work

			?><div style="display:none;"><?php
			?><ajax_script src="https://sis-t.redsys.es:25443/sis/NC/sandbox/redsysV3.js"></ajax_script><?php
			?></div><?php

			/**
			 * Important !!! Do  not use in this script,  comments like  "// Some comment",  instead of that  use comments like "/ *  some comment * /"
			 *  It's because, during payment request,  all  this script become script in one ROW,  and all  JavaScript after // become commented !!!
			 */

			$is_immediate_redirection = false;

			if ( ! $is_immediate_redirection ) {

				?><div style="display:block;"><style type="text/css"> #redsys-hosted-pay-button { min-height: 440px; }  #redsys-hosted-pay-button img { max-height: 25px; } </style><?php	// FixIn: 8.5.1.2.
				?><div id="card-form"></div>
				<form name="datos">
					<input type="hidden" id="token" />
					<input type="hidden" id="errorCode" />
					<a href="javascript:alert(document.datos.token.value + '--' + document.datos.errorCode.value)"></a>
				</form><?php
				?><ajax_script>
					(function() { var a = setInterval( function() {  if ( 'function' !== typeof getInSiteFormJSON ) { return; } clearInterval( a );
						function merchantValidationEjemplo() {
							alert("This is my validation  text  here :)");
							return true;
						}
						window.addEventListener("message", function receiveMessage(event) {
							storeIdOper(event, "token", "errorCode", merchantValidationEjemplo);
						});
						function pedido() {
							return "pedido" + Math.floor((Math.random() * 1000) + 1);
						}
						var insiteJSON = {
							"id" : "card-form",
							"fuc" : "999008881",
							"terminal" : "1",
							"order" : pedido(),
							"idioma": "EN",
							"buttonValue": "Pagar - Pay Now",
							"mostrarLogoInsite": false,
							"estiloInsite" : "twoRows" <?php /**/ ?>
							<?php /* ?>"estiloInsite" : "inline" <?php /**/ ?>
						};
						getInSiteFormJSON(insiteJSON);
					 }, 500 ); })();
				</ajax_script><?php
				?></div><?php
			}
			?></div><?php

			$payment_form = ob_get_clean();

			return $output . $payment_form;

		}

		// =================================================================================================================
		// =================================================================================================================
		// =================================================================================================================


		$stripe__customer__arr = array();
		// <editor-fold     defaultstate="collapsed"                        desc="  ==  Billing  == "  >
		// -------------------------------------------------------------------------------------------------------------
		// Customer - Billing details  -  if configured at  the Booking > Settings > Payment page in "Billing form fields"			Check  here https://stripe.com/docs/api/customers/create
		// -------------------------------------------------------------------------------------------------------------
		if ( 'setup' == $stripe_session_params['mode'] ) {

			// Email
			$billing_field_name = (string) trim( get_bk_option( 'booking_billing_customer_email' ) );
			if ( ! empty( $params[ $billing_field_name ] ) ) {
				$stripe__customer__arr['email'] = $params[ $billing_field_name ];
			}
			if (   ( empty( $stripe__customer__arr['email'] ) )
				&& ( ! empty( $params['email'] ) )
			){
				$stripe__customer__arr['email'] = $params['email'];
			}

			// First Name
			$billing_field_name = (string) trim( get_bk_option( 'booking_billing_firstnames' ) );
			if ( isset( $params[ $billing_field_name ] ) ) {
				$stripe__customer__arr['name'] = $params[ $billing_field_name ];
			}
			// Last Name
			$billing_field_name = (string) trim( get_bk_option( 'booking_billing_surname' ) );
			if ( isset( $params[ $billing_field_name ] ) ) {
				$stripe__customer__arr['name']  .= ( empty( $stripe__customer__arr['name'] ) ) ? '' : ' ';
				$stripe__customer__arr['name'] .= $params[ $billing_field_name ];
			}
			// Phone
			$billing_field_name = (string) trim( get_bk_option( 'booking_billing_phone' ) );
			if ( isset( $params[ $billing_field_name ] ) ) {
				$stripe__customer__arr['phone'] = $params[ $billing_field_name ];
			}
			$stripe__customer__arr['address'] = array();
			// Address
			$billing_field_name = (string) trim( get_bk_option( 'booking_billing_address1' ) );
			if ( isset( $params[ $billing_field_name ] ) ) {
				$stripe__customer__arr['address']['line1'] = $params[ $billing_field_name ];
			}
			// City
			$billing_field_name = (string) trim( get_bk_option( 'booking_billing_city' ) );
			if ( isset( $params[ $billing_field_name ] ) ) {
				$stripe__customer__arr['address']['city'] = $params[ $billing_field_name ];
			}
			// Country
			$billing_field_name = (string) trim( get_bk_option( 'booking_billing_country' ) );
			if ( isset( $params[ $billing_field_name ] ) ) {
			   $stripe__customer__arr['address']['country'] = $params[ $billing_field_name ];		// https://stripe.com/docs/api/customers/create#create_customer-address-country  - Country  codes  Two-letter country code (ISO 3166-1 alpha-2). like here https://en.wikipedia.org/wiki/ISO_3166-2
			}
			// ZIP Code
			$billing_field_name = (string) trim( get_bk_option( 'booking_billing_post_code' ) );
			if ( isset( $params[ $billing_field_name ] ) ) {
				$stripe__customer__arr['address']['postal_code'] = $params[ $billing_field_name ];
			}
			// State
			$billing_field_name = (string) trim( get_bk_option( 'booking_billing_state' ) );
			if ( isset( $params[ $billing_field_name ] ) ) {
				$stripe__customer__arr['address']['state'] = $params[ $billing_field_name ];
			}
		}

		// -------------------------------------------------------------------------------------------------------------
		// </editor-fold>

	}

	/**
	 * Get parameters for defining DS_MERCHANT_EMV3DS
	 *
	 * @return void
	 */
	private function get_psd2_info( $params ) {

		$psd2_info__arr = array();

		// Email.
		$billing_field_name = (string) trim( get_bk_option( 'booking_billing_customer_email' ) );
		if ( ! empty( $params[ $billing_field_name ] ) ) {
			$psd2_info__arr['email'] = $params[ $billing_field_name ];
		}
		if (
			( empty( $psd2_info__arr['email'] ) ) && ( ! empty( $params['email'] ) ) ) {
			$psd2_info__arr['email'] = $params['email'];
		}

		// First Name.
		$billing_field_name = (string) trim( get_bk_option( 'booking_billing_firstnames' ) );
		if ( isset( $params[ $billing_field_name ] ) ) {
			$psd2_info__arr['name'] = $params[ $billing_field_name ];
		}
		// Last Name.
		$billing_field_name = (string) trim( get_bk_option( 'booking_billing_surname' ) );
		if ( isset( $params[ $billing_field_name ] ) ) {
			$psd2_info__arr['name'] .= ( empty( $psd2_info__arr['name'] ) ) ? '' : ' ';
			$psd2_info__arr['name'] .= $params[ $billing_field_name ];
		}
		// Phone.
		$billing_field_name = (string) trim( get_bk_option( 'booking_billing_phone' ) );
		if ( isset( $params[ $billing_field_name ] ) ) {
			$psd2_info__arr['phone'] = $params[ $billing_field_name ];
		}
		$psd2_info__arr['address'] = array();
		// Address.
		$billing_field_name = (string) trim( get_bk_option( 'booking_billing_address1' ) );
		if ( isset( $params[ $billing_field_name ] ) ) {
			$psd2_info__arr['address']['line1'] = $params[ $billing_field_name ];
		}
		// City.
		$billing_field_name = (string) trim( get_bk_option( 'booking_billing_city' ) );
		if ( isset( $params[ $billing_field_name ] ) ) {
			$psd2_info__arr['address']['city'] = $params[ $billing_field_name ];
		}
		// Country.
		$billing_field_name = (string) trim( get_bk_option( 'booking_billing_country' ) );
		if ( isset( $params[ $billing_field_name ] ) ) {
			$psd2_info__arr['address']['country'] = $params[ $billing_field_name ];
		}
		// ZIP Code.
		$billing_field_name = (string) trim( get_bk_option( 'booking_billing_post_code' ) );
		if ( isset( $params[ $billing_field_name ] ) ) {
			$psd2_info__arr['address']['postal_code'] = $params[ $billing_field_name ];
		}
		// State.
		$billing_field_name = (string) trim( get_bk_option( 'booking_billing_state' ) );
		if ( isset( $params[ $billing_field_name ] ) ) {
			$psd2_info__arr['address']['state'] = $params[ $billing_field_name ];
		}

		// -------------------------------------------------------------------------------------------------------------
		// Check  more here https://pagosonline.redsys.es/parametros-entrada-salida.html#entradaTable .
		$ds_emv3ds_arr = array();

		/**
		 * "Periodo de tiempo que el titular de la tarjeta ha tenido la cuenta en el comercio. Valores posibles:
		 * 01 = No account (guest check-out)
		 * 02 = Created during this transaction
		 * 03 = Less than 30 days
		 * 04 = 30-60 days
		 * 05 = More than 60 days
		 */
		$acct_info                 = array(
			'chAccAgeInd' => '01',
		);
		$ds_emv3ds_arr['acctInfo'] = $acct_info;

		// Billing data.
		if ( ! empty( $psd2_info__arr['email'] ) ) {
			$ds_emv3ds_arr['email'] = $this->clean_billing_data( $psd2_info__arr['email'] );
		}
		if ( ! empty( $psd2_info__arr['address']['city'] ) ) {
			$psd2_info__arr['address']['city'] = $this->clean_billing_data( $psd2_info__arr['address']['city'] );
		}
		if ( ! empty( $psd2_info__arr['address']['line1'] ) ) {
			$ds_emv3ds_arr['billAddrLine1'] = $this->clean_billing_data( $psd2_info__arr['address']['line1'] );
		}
		if ( ! empty( $psd2_info__arr['address']['postal_code'] ) ) {
			$ds_emv3ds_arr['billAddrPostCode'] = $this->clean_billing_data( $psd2_info__arr['address']['postal_code'] );
		}

		$ds_emv3ds_arr = wp_json_encode( $ds_emv3ds_arr );
		return $ds_emv3ds_arr;
	}


	/**
	 * Clean data for billing
	 *
	 * @param string $data_to_clean string to  clean.
	 *
	 * @return array|string|string[]
	 */
	private function clean_billing_data( $data_to_clean ) {

		$replace_table = array(
			'Á' => 'A',
			'À' => 'A',
			'Ä' => 'A',
			'É' => 'E',
			'È' => 'E',
			'Ë' => 'E',
			'Í' => 'I',
			'Ì' => 'I',
			'Ï' => 'I',
			'Ó' => 'O',
			'Ò' => 'O',
			'Ö' => 'O',
			'Ú' => 'U',
			'Ù' => 'U',
			'Ü' => 'U',
			'á' => 'a',
			'à' => 'a',
			'ä' => 'a',
			'é' => 'e',
			'è' => 'e',
			'ë' => 'e',
			'í' => 'i',
			'ì' => 'i',
			'ï' => 'i',
			'ó' => 'o',
			'ò' => 'o',
			'ö' => 'o',
			'ú' => 'u',
			'ù' => 'u',
			'ü' => 'u',
			'Ñ' => 'N',
			'ñ' => 'n',
			'&' => '-',
			'<' => ' ',
			'>' => ' ',
			'/' => ' ',
			'"' => ' ',
			"'" => ' ',
			'?' => ' ',
			'¿' => ' ',
			'º' => ' ',
			'ª' => ' ',
			'#' => ' ',
			'@' => ' ',
		);

		foreach ( $replace_table as $search => $replacement ) {
			$data_to_clean = str_replace( $search, $replacement, $data_to_clean );
		}

		return $data_to_clean;
	}


	/** Define settings Fields  */
	public function init_settings_fields() {

		if ( ! class_exists( 'WPBC_RedsysAPI' ) ) {
			require_once( dirname( __FILE__ ) . '/includes/index.php' );
		}

		$this->fields = array();

		// On | Off
		$this->fields['is_active'] = array(
									  'type'        => 'checkbox'
									, 'default'     => 'On'
									, 'title'       => __( 'Enable / Disable', 'booking' )
									, 'label'       => __( 'Enable this payment gateway', 'booking')
									, 'description' => ''
									, 'group'       => 'general'

								);

		// Switcher accounts - Test | Live
		$this->fields['account_mode'] = array(
									  'type' 		=> 'radio'
									, 'default' 	=> 'test'
									, 'title' 		=> __( 'Chose payment account', 'booking' )
									, 'description' => ''//__( 'Select TEST for the Test Server and LIVE in the live environment', 'booking' )
									, 'description_tag' => 'span'
									, 'css' 		=> ''
									, 'options' => array(
											 'test' => array( 'title' => __( 'TEST', 'booking' ), 'attr' => array( 'id' => 'redsys_mode_test' ) )
											,'live' => array( 'title' => __( 'LIVE', 'booking' ), 'attr' => array( 'id' => 'redsys_mode_live' ) )
										)
									, 'group' 		=> 'general'
		);

		// -------------------------------------------------------------------------------------------------------------
		// Start - Required Fields
		// -------------------------------------------------------------------------------------------------------------

		// Check  more here: https://pagosonline.redsys.es/entornosPruebas.html

		//-------------------------------
		// == Merchant Code ==
		//-------------------------------
		// Test
		$this->fields['merchantcode_test'] = array(
									  'type'        => 'text'
									, 'default'     => '999008881'
									//, 'placeholder' => ''
									, 'title'       => __( 'Commerce number (FUC)', 'booking' )
									, 'description' => __('Required', 'booking') . '.<br/>'
													   . sprintf( __( 'Commerce number (FUC) provided by your bank.', 'booking' ), 'Redsys' )
													   . ' ' . __('Default','booking') . ': <strong>999008881</strong>' . '<br>'					// FixIn: 10.9.4.1.
													   //. ( ( wpbc_is_this_demo() ) ? wpbc_get_warning_text_in_demo_mode() : '' )
									, 'description_tag' => 'span'
									, 'css'         => ''
									, 'disabled'         => wpbc_is_this_demo()											// FixIn: 10.9.4.1.
									, 'group'       => 'general'
									, 'tr_class'    => 'wpbc_sub_settings_grayed wpbc_sub_settings_mode_test'
									//, 'validate_as' => array( 'required' )
							);
		// Live
		$this->fields['merchantcode_live'] = array(
									  'type'        => 'text'
									, 'default'     => ( wpbc_is_this_demo() ? '999008881' : '' )
									//, 'placeholder' => ''
									, 'title'       => __( 'Commerce number (FUC)', 'booking' )
									, 'description' => __('Required', 'booking') . '.<br/>'
													   . sprintf( __( 'Commerce number (FUC) provided by your bank.', 'booking' ), 'Redsys' )
													   //. ( ( wpbc_is_this_demo() ) ? wpbc_get_warning_text_in_demo_mode() : '' )
									, 'description_tag' => 'span'
									, 'css'         => ''
									, 'group'       => 'general'
									, 'tr_class'    => 'wpbc_sub_settings_grayed wpbc_sub_settings_mode_live'
									//, 'validate_as' => array( 'required' )
							);
		//-------------------------------
		// == Merchant Code ==
		//-------------------------------
		// Test
		$this->fields['terminal_test'] = array(
									  'type'        => 'text'
									, 'default'     => '1'
									//, 'placeholder' => ''
									, 'title'       => __( 'Terminal number', 'booking' )
									, 'description' => __('Required', 'booking') . '.<br/>'
													   . sprintf( __( 'Terminal number provided by your bank.', 'booking' ), 'Redsys' )
													   //. ( ( wpbc_is_this_demo() ) ? wpbc_get_warning_text_in_demo_mode() : '' )
									, 'description_tag' => 'span'
									, 'css'         => ''
									, 'disabled'         => wpbc_is_this_demo()											// FixIn: 10.9.4.1.
									, 'group'       => 'general'
									, 'tr_class'    => 'wpbc_sub_settings_grayed wpbc_sub_settings_mode_test'
									//, 'validate_as' => array( 'required' )
							);
		// Live
		$this->fields['terminal_live'] = array(
									  'type'        => 'text'
									, 'default'     => ( wpbc_is_this_demo() ? '1' : '' )
									//, 'placeholder' => ''
									, 'title'       => __( 'Terminal number', 'booking' )
									, 'description' => __('Required', 'booking') . '.<br/>'
													   . sprintf( __( 'Terminal number provided by your bank.', 'booking' ), 'Redsys' )
													   //. ( ( wpbc_is_this_demo() ) ? wpbc_get_warning_text_in_demo_mode() : '' )
									, 'description_tag' => 'span'
									, 'css'         => ''
									, 'group'       => 'general'
									, 'tr_class'    => 'wpbc_sub_settings_grayed wpbc_sub_settings_mode_live'
									//, 'validate_as' => array( 'required' )
							);
		//-------------------------------
		// == Merchant Code ==
		//-------------------------------
		// Test
		$this->fields['secretsha256_test'] = array(
									  'type'        => 'text'
									, 'default'     => 'sq7HjrUOBfKmC576ILgskD5srU870gJ7'
									//, 'placeholder' => ''
									, 'title'       => __( 'Encryption secret passphrase SHA-256', 'booking' )
									, 'description' => __('Required', 'booking') . '.<br/>'
													   . sprintf( __( 'Encryption secret passphrase SHA-256 provided by your bank.', 'booking' ), 'Redsys' )
											. ' ' . __('Default','booking') . ': <strong>sq7HjrUOBfKmC576ILgskD5srU870gJ7</strong>' . '<br>'					// FixIn: 10.9.4.1.
											. '<div class="wpbc-settings-notice notice-info" style="text-align:left;"><strong>'
												. __('Note:' ,'booking') . '</strong> '
												. 'Testing at front-end side. Use following <strong>test</strong> card number <strong>4918 0191 6003 4602</strong> (Visa),'
												. ' a valid expiration date <strong>12/34</strong>, and CVC number <strong>123</strong>, to create a successful payment.'
												. '<br>If you need to test payments using other cards,'
												. ' use Redsys test cards from <a href="https://pagosonline.redsys.es/entornosPruebas.html" target="_blank">this page</a>.'
											. '</div>'
											. ( ( wpbc_is_this_demo() ) ? wpbc_get_warning_text_in_demo_mode() : '' )

									, 'description_tag' => 'span'
									, 'css'         => ''
									, 'disabled'         => wpbc_is_this_demo()		// FixIn: 10.9.4.1.
									, 'group'       => 'general'
									, 'tr_class'    => 'wpbc_sub_settings_grayed wpbc_sub_settings_mode_test'
									//, 'validate_as' => array( 'required' )
							);
		// Live
		$this->fields['secretsha256_live'] = array(
									  'type'        => 'text'
									, 'default'     => ( wpbc_is_this_demo() ? 'sq7HjrUOBfKmC576ILgskD5srU870gJ7' : '' )
									//, 'placeholder' => ''
									, 'title'       => __( 'Encryption secret passphrase SHA-256', 'booking' )
									, 'description' => __('Required', 'booking') . '.<br/>'
													   . sprintf( __( 'Encryption secret passphrase SHA-256 provided by your bank.', 'booking' ), 'Redsys' )
													   . ( ( wpbc_is_this_demo() ) ? wpbc_get_warning_text_in_demo_mode() : '' )
									, 'description_tag' => 'span'
									, 'css'         => ''
									, 'group'       => 'general'
									, 'tr_class'    => 'wpbc_sub_settings_grayed wpbc_sub_settings_mode_live'
									//, 'validate_as' => array( 'required' )
							);

		// -------------------------------------------------------------------------------------------------------------
		// End - Required Fields
		// -------------------------------------------------------------------------------------------------------------



		// Currency
		$currency_list = wpbc_redsys__get_currencies();

		$this->fields['currency'] = array(
									'type' => 'select'
									, 'default' => 978
									, 'title' => __('Accepted Currency', 'booking')
									, 'description' => __('The currency code that gateway will process the payment in.', 'booking')
													. '<div class="wpbc-settings-notice notice-info" style="text-align:left;"><strong>'
														. __('Note:' ,'booking') . '</strong> '
														. __('Setting the currency that is not supported by the payment processor will result in an error.' ,'booking')
													. '</div>'
									, 'description_tag' => 'span'
									, 'css' => ''
									, 'options' => $currency_list
									, 'group' => 'general'
							);

		//        // Payment Mode
		//        $this->fields['payment_mode'] = array(
		//                                    'type' 			=> 'select'
		//                                    , 'default' 	=> 'payment'
		//                                    , 'title' 		=> __('Payment mode', 'booking')
		//                                    , 'description' => __('Accept one-time payments for cards, iDEAL, and more,  or save payment details to charge your customers later.' ,'booking')
		//                                    , 'description_tag' => 'span'
		//                                    , 'css' 			=> ''
		//                                    , 'options' => array(
		//                                                            'payment' => __('Accept one-time payments', 'booking')
		//                                                          , 'setup'   => __('Save payment details to charge later', 'booking')
		//                                                    )
		//                                    , 'group' => 'general'
		//                            );


		// Payment Button Title
		$this->fields['payment_button_title'] = array(
								'type'          => 'text'
								, 'default'     => __('Pay via' ,'booking') .' Redsys'
								, 'placeholder' => __('Pay via' ,'booking') .' Redsys'
								, 'title'       => __('Payment button title' ,'booking')
								, 'description' => __('Enter the title of the payment button' ,'booking')
								,'description_tag' => 'p'
								, 'css'         => 'width:100%'
								, 'group'       => 'general'
								//, 'tr_class'    => 'wpbc_sub_settings_payment_button_title wpbc_sub_settings_grayed'
						);
		//$this->fields['description_hr'] = array( 'type' => 'hr' );

//		// Additional settings /////////////////////////////////////////////////
//		$this->fields['subject'] = array(
//								'type'          => 'textarea'
//								, 'default'     => sprintf( __( 'Payment for booking %1$s on these day(s): %2$s', 'booking' ),'[resource_title]','[dates]')
//								, 'placeholder' => sprintf( __( 'Payment for booking %1$s on these day(s): %2$s', 'booking' ),'[resource_title]','[dates]')
//								, 'title'       => __('Payment description at gateway website' ,'booking')
//								, 'description' => sprintf(__('Enter the service name or the reason for the payment here.' ,'booking'),'<br/>','</b>')
//													. '<br/>' .  __('You can use any shortcodes, which you have used in content of booking fields data form.' ,'booking')
//													// . '<div class="wpbc-settings-notice notice-info" style="text-align:left;"><strong>'
//													//    . __('Note:' ,'booking') . '</strong> '
//													//    . sprintf( __('This field support only up to %s characters by payment system.' ,'booking'), '255' )
//													//. '</div>'
//								,'description_tag' => 'p'
//								, 'css'         => 'width:100%'
//								, 'rows' => 2
//								, 'group'       => 'general'
//								, 'tr_class'    => 'wpbc_sub_settings_is_description_show wpbc_sub_settings_grayedNO'
//						);


		////////////////////////////////////////////////////////////////////
		// Return URL    &   Auto approve | decline
		////////////////////////////////////////////////////////////////////

		//  Success URL
		$this->fields['order_successful_prefix'] = array(
								'type'          => 'pure_html'
								, 'group'       => 'auto_approve_cancel'
								, 'html'        => '<tr valign="top" class="wpbc_tr_redsys_order_successful">
														<th scope="row">'.
															WPBC_Settings_API::label_static( 'redsys_order_successful'
																, array(   'title'=> __('Return URL after Successful order' ,'booking'), 'label_css' => '' ) )
														.'</th>
														<td><fieldset>' . '<code style="font-size:14px;">' .  get_option('siteurl') . '</code>'
								, 'tr_class'    => 'relay_response_sub_class'
						);
		$this->fields['order_successful'] = array(
								'type'          => 'text'
								, 'default'     => '/successful'
								, 'placeholder' => '/successful'
								, 'css'         => 'width:75%'
								, 'group'       => 'auto_approve_cancel'
								, 'only_field'  => true
								, 'tr_class'    => 'relay_response_sub_class'
						);
		$this->fields['order_successful_sufix'] = array(
								'type'          => 'pure_html'
								, 'group'       => 'auto_approve_cancel'
								, 'html'        =>    '<p class="description" style="line-height: 1.7em;margin: 0;">'
														. __('The URL where visitor will be redirected after completing payment.' ,'booking')
														/* translators: 1: ... */
														. '<br/>' . sprintf( __( 'For example, a URL to your site that displays a %1$s"Thank you for the payment"%2$s.', 'booking' ),'<b>','</b>')
													. '</p>
														   </fieldset>
														</td>
													</tr>'
								, 'tr_class'    => 'relay_response_sub_class'
						);

		//  Failed URL
		$this->fields['order_failed_prefix'] = array(
								'type'          => 'pure_html'
								, 'group'       => 'auto_approve_cancel'
								, 'html'        => '<tr valign="top" class="wpbc_tr_redsys_order_failed">
														<th scope="row">'.
															WPBC_Settings_API::label_static( 'redsys_order_failed'
																, array(   'title'=> __('Return URL after Failed order' ,'booking'), 'label_css' => '' ) )
														.'</th>
														<td><fieldset>' . '<code style="font-size:14px;">' .  get_option('siteurl') . '</code>'
								, 'tr_class'    => 'relay_response_sub_class'
						);
		$this->fields['order_failed'] = array(
								'type'          => 'text'
								, 'default'     => '/failed'
								, 'placeholder' => '/failed'
								, 'css'         => 'width:75%'
								, 'group'       => 'auto_approve_cancel'
								, 'only_field'  => true
								, 'tr_class'    => 'relay_response_sub_class'
						);
		$this->fields['order_failed_sufix'] = array(
								'type'          => 'pure_html'
								, 'group'       => 'auto_approve_cancel'
								, 'html'        =>    '<p class="description" style="line-height: 1.7em;margin: 0;">'
														. __('The URL where the visitor will be redirected after completing payment.' ,'booking')
														/* translators: 1: ... */
														. '<br/>' . sprintf( __( 'For example, the URL to your website that displays a %1$s"Payment Canceled"%2$s page.', 'booking' ),'<b>','</b>' )
													. '</p>
														   </fieldset>
														</td>
													</tr>'
								, 'tr_class'    => 'relay_response_sub_class'
						);
		// Auto Approve / Cancel
        $this->fields['is_auto_approve_cancell_booking'] = array(
                                      'type'        => 'checkbox'
                                    , 'default'     => 'Off'
                                    , 'title'       => __( 'Automatically approve/cancel booking', 'booking' )
                                    , 'label'       => __('Check this box to automatically approve bookings, when visitor makes a successful payment, or automatically cancel the booking, when visitor makes a payment cancellation.' ,'booking')
                                    , 'description' =>  '<div class="wpbc-settings-notice notice-warning" style="text-align:left;">'
                                                            . '<strong>' . esc_html__('Warning' ,'booking') . '!</strong> ' . __('This will not work, if the visitor leaves the payment page.' ,'booking')
                                                        . '</div>'
                                    , 'description_tag' => 'p'
                                    , 'group'       => 'auto_approve_cancel'
							        , 'tr_class'    => 'relay_response_sub_class'
                                );

	}


	/**
	 * Return info about Gateway
	 *
	 * @return array        Example: array(
											'id'      => 'redsys
										  , 'title'   => 'Redsys'
										  , 'currency'   => 'USD'
										  , 'enabled' => true
										);
	 */
	public function get_gateway_info() {

		$gateway_info = array(
					  'id'       => $this->get_id()
					, 'title'    => 'Redsys'
					, 'currency' => get_bk_option(  'booking_' . $this->get_id() . '_' . 'curency' )
					, 'enabled'  => $this->is_gateway_on()
		);
		return $gateway_info;
	}

    
    /**
 	 * Get payment Statuses of gateway
     * 
     * @return array
     */
    public function get_payment_status_array() {
        
        return array(
                          'ok'      => array( 'Redsys:OK' )
                        , 'pending' => array( 'Redsys:Pending' )
                        , 'unknown' => array( 'Redsys:Unknown' )
                        , 'error'   => array(   'Redsys:Failed',
												'Redsys:REJECTED',
												'Redsys:NOTAUTHED',
												'Redsys:MALFORMED',
												'Redsys:INVALID',
												'Redsys:ABORT',
												'Redsys:ERROR' )
                    ); 
    }

}



	/**
	 * Zero-decimal currencies: xxx, ...
	 * Add support of Zero-decimal currencies in  Redsys payment system
	 *
	 * @param $currency
	 *
	 * @return void
	 */
	function wpbc_redsys__cents_factor( $currency ) {

		$is_cents = 100;

		if ( ! empty( $currency ) ) {
			$check_currency = strtolower( $currency );
			if ( in_array(  $check_currency , array( /*'bif', 'mga' */ ) ) ) {
				$is_cents = 1;
			}
		}

		return $is_cents;
	}

	/**
	 * Get cost in CENTS (for some currencies) for Redsys Form		50.00	=>	5000
	 *
	 * @param float $plugin_amount
	 * @param string $currency
	 *
	 * @return int $cents_amount
	 */
	function wpbc_redsys__amount_in_redsys( $plugin_amount, $currency ) {

		$is_cents = wpbc_redsys__cents_factor( $currency );

		$cents_amount = intval( floatval( $plugin_amount ) * $is_cents );

		return $cents_amount;
	}

	/**
	 * Convert cost back from CENTS (in Redsys)  to  usual plugin cost 		5000	 =>	 50.00
	 *
	 * @param int $stripe_amount_in_cents
	 * @param string $currency
	 *
	 * @return float
	 */
	function wpbc_redsys__amount_in_plugin( $stripe_amount_in_cents, $currency ) {
		$is_cents = wpbc_redsys__cents_factor( $currency );
		return floatval( $stripe_amount_in_cents / $is_cents );
	}

//                                                                              </editor-fold>



//                                                                              <editor-fold   defaultstate="collapsed"   desc=" Settings  Page " >

/** Settings  Page  */
class WPBC_Settings_Page_Gateway_REDSYS extends WPBC_Page_Structure {

	public $gateway_api = false;

	/**
	 * Define interface for  Gateway  API
	 *
	 * @param string $selected_email_name - name of Email template
	 * @param array $init_fields_values - array of init form  fields data - this array  can  ovveride "default" fields and loaded data.
	 * @return object Email API
	 */
	public function get_api( $init_fields_values = array() ){

		if ( $this->gateway_api === false ) {
			$this->gateway_api = new WPBC_Gateway_API_REDSYS( WPBC_REDSYS_GATEWAY_ID , $init_fields_values );
		}

		return $this->gateway_api;
	}


	public function in_page() {                                                 // P a g e    t a g
        if (
			   ( 'On' == get_bk_option( 'booking_super_admin_receive_regular_user_payments' ) )								// FixIn: 9.2.3.8.
        	&& ( ! wpbc_is_mu_user_can_be_here( 'only_super_admin' ) )
        	// && ( ! wpbc_is_current_user_have_this_role('contributor') )
		){
	        return (string) wp_rand( 100000, 1000000 );        // If this User not "super admin",  then  do  not load this page at all
        }

		return 'wpbc-settings';
	}


	public function tabs() {                                                    // T a b s      A r r a y

		$tabs = array();

		$subtabs = array();

		// Checkbox Icon, for showing in toolbar panel does this payment system active
		// $is_data_exist = get_bk_option( 'booking_'. WPBC_REDSYS_GATEWAY_ID .'_is_active' );

		$subtabs[ WPBC_REDSYS_GATEWAY_ID ] = array(
							  'type'       => 'subtab'                                  // Required| Possible values:  'subtab' | 'separator' | 'button' | 'goto-link' | 'html'
							, 'title'      =>   'Redsys'       // Title of TAB
							/* translators: 1: ... */
							, 'page_title' => sprintf( __( '%s Settings', 'booking'), 'Redsys' )  // Title of Page
							/* translators: 1: ... */
							, 'hint' 	   => sprintf( __( 'Integration of %s payment system' ,'booking' ), 'Redsys' )    // Hint
							, 'link' => ''                                      // link
							, 'position' => ''                                  // 'left'  ||  'right'  ||  ''
							, 'css_classes' => ''                               // CSS class(es)
							//, 'icon' => 'http://.../icon.png'                 // Icon - link to the real PNG img
							//, 'font_icon' => 'wpbc_icn_mail_outline'   // CSS definition of Font Icon
														, 'default' =>  false                                // Is this sub tab activated by default or not: true || false.
							, 'disabled' => false                               // Is this sub tab deactivated: true || false.
							, 'checkbox'  => false                              // or definition array  for specific checkbox: array( 'checked' => true, 'name' => 'feature1_active_status' )   //, 'checkbox'  => array( 'checked' => $is_checked, 'name' => 'enabled_active_status' )
							, 'content' => 'content'                            // Function to load as conten of this TAB
							, 'font_icon' => 'wpbc-bi-credit-card-2-front'
							, 'show_checked_icon' 		=> true
							, 'checked_data' 			=> 'booking_'. WPBC_REDSYS_GATEWAY_ID .'_is_active'		// This is where we get content
						);

		$tabs[ 'payment' ]['subtabs'] = $subtabs;

		return $tabs;
	}


	/** Show Content of Settings page */
	public function content() {

		$this->css();

		////////////////////////////////////////////////////////////////////////
		// Checking
		////////////////////////////////////////////////////////////////////////

		do_action( 'wpbc_hook_settings_page_header', 'gateway_settings');       // Define Notices Section and show some static messages, if needed
		do_action( 'wpbc_hook_settings_page_header', 'gateway_settings_' . WPBC_REDSYS_GATEWAY_ID );

		if ( ! wpbc_is_mu_user_can_be_here('activated_user') ) return false;       // Check if MU user activated, otherwise show Warning message.
		// if ( ! wpbc_is_mu_user_can_be_here('only_super_admin') ) return false;  // User is not Super admin, so exit.  Basically its was already checked at the bottom of the PHP file, just in case.

        // -------------------------------------------------------------------------------------------------------------
        //  S u b m i t   Main Form
        // -------------------------------------------------------------------------------------------------------------
       $submit_form_name = 'wpbc_gateway_' . WPBC_REDSYS_GATEWAY_ID;               // Define form name
        // $this->maybe_update();												// It is run  from  parent CLASS before showing this content   on  Actual Selected by user Page


		// -------------------------------------------------------------------------------------------------------------
		// JavaScript: Tooltips, Popover, Datepick (js & css)
		// -------------------------------------------------------------------------------------------------------------
		echo '<span class="wpdevelop">';
			wpbc_js_for_bookings_page();
		echo '</span>';


		////////////////////////////////////////////////////////////////////////
		// Content
		////////////////////////////////////////////////////////////////////////
		?>
		<div class="clear"></div>

		<span class="metabox-holder">
			<form  name="<?php echo esc_attr( $submit_form_name ); ?>" id="<?php echo esc_attr( $submit_form_name ); ?>" action="" method="post" autocomplete="off">
				<?php

				// N o n c e   field, and key for checking   S u b m i t
				wp_nonce_field( 'wpbc_settings_page_' . $submit_form_name );

				?><input type="hidden" name="is_form_sbmitted_<?php echo esc_attr( $submit_form_name ); ?>" id="is_form_sbmitted_<?php echo esc_attr( $submit_form_name ); ?>" value="1" /><?php

				$edit_url_for_visitors = get_bk_option( 'booking_url_bookings_edit_by_visitors' );
				$message_type = ( site_url() == $edit_url_for_visitors ) ? 'error' : 'warning';

				?>
				<div class="wpbc-settings-notice notice-warning notice-helpful-info">
						<div>
							<strong><?php esc_html_e('Note!' ,'booking'); ?></strong><strong style="padding-left: 10px;">1.</strong>
							<?php
							/* translators: 1: ... */
							echo wp_kses_post( sprintf( __('Plugin support %s integration.' ,'booking')
							, '<a href="https://pagosonline.redsys.es/conexion-redireccion.html"  target="_blank" style="text-decoration:none;">Redsys Redirection</a>') ); ?>
						</div>
						<div style="padding-left: 42px;">
							<strong>2. <?php echo ( ( 'error' == $message_type ) ? esc_html__( 'Error' ,'booking').'! ' : '' ); ?></strong>
							<?php
								echo 'Redsys ';
								/* translators: 1: ... */
								echo wp_kses_post( sprintf( __( 'require correct  configuration of this option: %1$sURL to edit bookings%2$s', 'booking' )
									, '<strong><a href="https://wpbookingcalendar.com/faq/configure-editing-cancel-payment-bookings-for-visitors/#content">', '</a></strong>.'
									//, '<strong><a href="'. esc_url( wpbc_get_settings_url() ) .'#url_booking_edit">', '</a></strong>'
								) );
							?>
						</div>
						<div style="padding-left: 42px;">
							<strong>3. <?php echo ( ( 'error' == $message_type ) ? esc_html__( 'Error' ,'booking').'! ' : '' ); ?></strong>
							<?php
								/* translators: 1: ... */
								echo wp_kses_post( sprintf( __( 'Make test payments using these %1$stest card numbers%2$s', 'booking' )
									, '<strong><a href="https://pagosonline.redsys.es/desarrolladores-inicio/integrate-con-nosotros/tarjetas-y-entornos-de-prueba/" target="_blank">', '</a> ( 4548 8100 0000 0003 | 12/49 | 123 )</strong>.'
									//, '<strong><a href="'. esc_url( wpbc_get_settings_url() ) .'#url_booking_edit">', '</a></strong>'
								));
							?>
						</div>
				</div>
				<div class="clear"></div>
				<?php

				if ( version_compare( PHP_VERSION, '7.0' ) < 0 ) {
					echo '';
					?>
					<div class="wpbc-settings-notice notice-error" style="text-align:left;">
						<strong><?php esc_html_e('Error' ,'booking'); ?></strong>! <?php
							echo 'Redsys';
							/* translators: 1: ... */
							echo wp_kses_post( sprintf( __( 'require PHP version %s or newer!' ,'booking'), '<strong>7.0</strong>') );
						?>
					</div>
					<?php
				}
				?>
				<div class="clear"></div>
				<div class="metabox-holder">

					<div class="wpbc_settings_row wpbc_settings_row_left_NO" >
					<?php
						wpbc_open_meta_box_section( $submit_form_name . 'general', 'Redsys' );
							$this->get_api()->show( 'general' );
						wpbc_close_meta_box_section();
					?>
					</div>
					<div class="clear"></div>


					<div class="wpbc_settings_row wpbc_settings_row_left_NO" >
					<?php
						wpbc_open_meta_box_section( $submit_form_name . 'auto_approve_cancel', __('Advanced', 'booking')   );
							$this->get_api()->show( 'auto_approve_cancel' );
						wpbc_close_meta_box_section();
					?>
					</div>
					<div class="clear"></div>

				</div>

				<input type="submit" value="<?php esc_attr_e('Save Changes', 'booking'); ?>" class="button button-primary" />
			</form>
		</span>
		<?php

		$this->enqueue_js();
	}


	/**
	 * This function called from  PARENT CLASS  for actual selected tab.  Firstly it load data and then  Maybe Save changes.
	 * @return void
	 */
	public function maybe_update() {
        // -------------------------------------------------------------------------------------------------------------
        // Load Data
        // -------------------------------------------------------------------------------------------------------------
		// $this->check_compatibility_with_older_7_ver();
		$init_fields_values = array();
		$this->get_api( $init_fields_values );


        // -------------------------------------------------------------------------------------------------------------
        // Maybe Update Data
        // -------------------------------------------------------------------------------------------------------------
		$submit_form_name = 'wpbc_gateway_' . WPBC_REDSYS_GATEWAY_ID;               // Define form name

		$this->get_api()->validated_form_id = $submit_form_name;                // Define ID of Form for ability to  validate fields (like required field) before submit.

		// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
		if ( isset( $_POST['is_form_sbmitted_'. $submit_form_name ] ) ) {

			// Nonce checking    {Return false if invalid, 1 if generated between, 0-12 hours ago, 2 if generated between 12-24 hours ago. }
			$nonce_gen_time = check_admin_referer( 'wpbc_settings_page_' . $submit_form_name );  // Its stop show anything on submiting, if its not refear to the original page

			// Save Changes
			$this->update();
		}
	}


	/** Update Email template to DB */
	public function update() {

		// Get Validated Email fields
		$validated_fields = $this->get_api()->validate_post();

		$validated_fields = apply_filters( 'wpbc_gateway_redsys_validate_fields_before_saving', $validated_fields );   //Hook for validated fields.

		$this->get_api()->save_to_db( $validated_fields );

		wpbc_show_message ( __('Settings saved.', 'booking'), 5 );              // Show Save message
	}


	// <editor-fold     defaultstate="collapsed"                        desc=" CSS & JS  "  >

	/** CSS for this page */
	private function css() {
		?>
		<style type="text/css">
			.wpbc-help-message {
				border:none;
				margin:0 !important;
				padding:0 !important;
			}
		</style>
		<?php
	}


	/**
	 * Add Custon JavaScript - for some specific settings options
	 *      Executed After post content, after initial definition of settings,  and possible definition after POST request.
	 *
	 * @param type $menu_slug
	 */
	private function enqueue_js(){
		$js_script = '';

		//Show|Hide grayed section
		$js_script .= " 
						if ( ! jQuery('#redsys_mode_test').is(':checked') ) {   
							jQuery('.wpbc_sub_settings_mode_test').addClass('hidden_items'); 
						}
						if ( ! jQuery('#redsys_mode_live').is(':checked') ) {   
							jQuery('.wpbc_sub_settings_mode_live').addClass('hidden_items'); 
						}
					  ";
		// Hide|Show  on Click    Radio
		$js_script .= " jQuery('input[name=\"redsys_account_mode\"]').on( 'change', function(){    
								jQuery('.wpbc_sub_settings_mode_test,.wpbc_sub_settings_mode_live').addClass('hidden_items'); 
								if ( jQuery('#redsys_mode_test').is(':checked') ) {   
									jQuery('.wpbc_sub_settings_mode_test').removeClass('hidden_items');
								} else {
									jQuery('.wpbc_sub_settings_mode_live').removeClass('hidden_items');
								}
							} ); ";


		$js_script .= " jQuery('select[name=\"redsys_curency\"]').on( 'change', function(){    
						
                            var wpbc_selected_p_mode = jQuery('select[name=\"redsys_curency\"] option:selected').val(); 

							if ( 'EUR' == wpbc_selected_p_mode ) {   
								jQuery( '#redsys_payment_methods option' ).prop( 'disabled', false );
								jQuery( '#redsys_payment_methods option' ).removeClass('hidden_items');
							} else {
								jQuery( '#redsys_payment_methods' ).find( 'option' ).prop( 'selected', false );
								jQuery( '#redsys_payment_methods option:eq(0)').prop('selected', true);
									
								for( var oi = 2; oi < 9; oi++) {
									jQuery( '#redsys_payment_methods option:eq(' + oi + ')' ).prop( 'disabled', true );
								}
								jQuery('#redsys_payment_methods option:disabled').addClass('hidden_items'); 									
							}
						} ); ";


		// Eneque JS to  the footer of the page
		wpbc_enqueue_js( $js_script );
	}

	// </editor-fold>

}
add_action('wpbc_menu_created',  array( new WPBC_Settings_Page_Gateway_REDSYS() , '__construct') );    // Executed after creation of Menu



/**
 * Override VALIDATED fields BEFORE saving to DB
 * Description:
 * Check "Return URLs" and "Redsys Email"m, etc...
 *
 * @param array $validated_fields
 */
function wpbc_gateway_redsys_validate_fields_before_saving__all( $validated_fields ) {

	$validated_fields['order_successful'] = wpbc_make_link_relative( $validated_fields['order_successful'] );
	$validated_fields['order_failed']     = wpbc_make_link_relative( $validated_fields['order_failed'] );

	// FixIn: 10.9.4.1.
	//	$validated_fields['merchantcode_test'] = '999008881';
	//	$validated_fields['terminal_test']     = '1';
	//	$validated_fields['secretsha256_test'] = 'sq7HjrUOBfKmC576ILgskD5srU870gJ7';

	if ( wpbc_is_this_demo() ) {
		$validated_fields['account_mode']      = 'test';
		$validated_fields['merchantcode_live'] = '999008881';
		$validated_fields['terminal_live']     = '1';
		$validated_fields['secretsha256_live'] = 'sq7HjrUOBfKmC576ILgskD5srU870gJ7';
		$validated_fields['merchantcode_test'] = '999008881';
		$validated_fields['terminal_test']     = '1';
		$validated_fields['secretsha256_test'] = 'sq7HjrUOBfKmC576ILgskD5srU870gJ7';
		$validated_fields['currency']          = 978;
	}

	return $validated_fields;
}
add_filter( 'wpbc_gateway_redsys_validate_fields_before_saving', 'wpbc_gateway_redsys_validate_fields_before_saving__all', 10, 1 );   // Hook for validated fields.

//                                                                              </editor-fold>



//                                                                              <editor-fold   defaultstate="collapsed"   desc=" Activate | Deactivate " >

////////////////////////////////////////////////////////////////////////////////
// Activate | Deactivate
////////////////////////////////////////////////////////////////////////////////

/** A c t i v a t e */
function wpbc_booking_activate_REDSYS() {

	$op_prefix = 'booking_' . WPBC_REDSYS_GATEWAY_ID . '_';

	add_bk_option( $op_prefix . 'is_active',    		( ( wpbc_is_this_demo() || wpbc_is_this_beta() ) ? 'On' :  'Off' )  );
	add_bk_option( $op_prefix . 'account_mode',         'test'  );

	add_bk_option( $op_prefix . 'merchantcode_test', 													   '999008881' );
	add_bk_option( $op_prefix . 'merchantcode_live',	( ( wpbc_is_this_demo() || wpbc_is_this_beta() ) ? '999008881' : '' ) );
	add_bk_option( $op_prefix . 'terminal_test',	 													   '1' );
	add_bk_option( $op_prefix . 'terminal_live',		( ( wpbc_is_this_demo() || wpbc_is_this_beta() ) ? '1' : '' ) );
	add_bk_option( $op_prefix . 'secretsha256_test', 													   'sq7HjrUOBfKmC576ILgskD5srU870gJ7' );
	add_bk_option( $op_prefix . 'secretsha256_live',	( ( wpbc_is_this_demo() || wpbc_is_this_beta() ) ? 'sq7HjrUOBfKmC576ILgskD5srU870gJ7' : '' ) );

	add_bk_option( $op_prefix . 'currency',          	978 );
	add_bk_option( $op_prefix . 'payment_button_title' , __('Pay via' ,'booking') .' Redsys'  );
	/* translators: 1: ... */
	add_bk_option( $op_prefix . 'subject',      		 sprintf( __( 'Payment for booking %1$s on these day(s): %2$s', 'booking' ), '[resource_title]','[dates]') );
	add_bk_option( $op_prefix . 'order_successful',     '/successful' );
	add_bk_option( $op_prefix . 'order_failed',         '/failed' );
	add_bk_option( $op_prefix . 'is_auto_approve_cancell_booking' , 'Off' );
}
add_bk_action( 'wpbc_other_versions_activation',   'wpbc_booking_activate_REDSYS'   );


/** D e a c t i v a t e */
function wpbc_booking_deactivate_REDSYS() {

	$op_prefix = 'booking_' . WPBC_REDSYS_GATEWAY_ID . '_';

	delete_bk_option( $op_prefix . 'is_active' );
	delete_bk_option( $op_prefix . 'account_mode' );
	delete_bk_option( $op_prefix . 'merchantcode_test' );
	delete_bk_option( $op_prefix . 'merchantcode_live' );
	delete_bk_option( $op_prefix . 'terminal_test' );
	delete_bk_option( $op_prefix . 'terminal_live' );
	delete_bk_option( $op_prefix . 'secretsha256_test' );
	delete_bk_option( $op_prefix . 'secretsha256_live' );

	delete_bk_option( $op_prefix . 'currency' );

	delete_bk_option( $op_prefix . 'payment_button_title' );
	delete_bk_option( $op_prefix . 'subject' );
	delete_bk_option( $op_prefix . 'order_successful' );
	delete_bk_option( $op_prefix . 'order_failed' );
	delete_bk_option( $op_prefix . 'is_auto_approve_cancell_booking' );
}
add_bk_action( 'wpbc_other_versions_deactivation', 'wpbc_booking_deactivate_REDSYS' );

//                                                                              </editor-fold>


// Hook for getting gateway payment form to  show it after  booking process,  or for "payment request" after  clicking on link in email.
// Note,  here we generate new Object for correctly getting payment fields data of specific WP User  in WPBC MU version. 
add_filter( 'wpbc_get_gateway_payment_form', array( new WPBC_Gateway_API_REDSYS( WPBC_REDSYS_GATEWAY_ID ), 'get_payment_form' ), 10, 3 );



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// RESPONSE
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 *  Update Payment status of booking
 *
 * @param $booking_id
 * @param $status
 *
 * @return bool
 */
function wpbc_redsys_update_payment_status( $booking_id, $status ) {

	do_action( 'wpbc_booking_change_payment_status', 'redsys', $status, $booking_id );                           // FixIn: 10.1.3.5.
	do_action( 'wpbc_redsys_update_payment_status', $booking_id, $status );                                      // FixIn: 10.1.3.5.

	global $wpdb;

	// Update payment status.
	$update_sql = $wpdb->prepare( "UPDATE {$wpdb->prefix}booking SET pay_status = %s WHERE booking_id = %d;", $status, $booking_id );  // FixIn: 10.12.1.5.
	// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared
	if ( false === $wpdb->query( $update_sql ) ) {
		return false;
	}

	return true;
}


	/**
	 * Auto cancel booking and redirect
	 * @param $booking_id
	 * @param $redsys_error_code
	 */
	function wpbc_redsys_auto_cancel_booking( $booking_id , $redsys_error_code ){

		// Let's check whether the user wanted auto-approve or cancel
		$auto_approve = get_bk_option( 'booking_redsys_is_auto_approve_cancell_booking'  );
		if ( $auto_approve == 'On' ) {
			wpbc_auto_cancel_booking__after_payment( $booking_id );			// FixIn: 9.9.0.43.
		}

		$redsys_error_url   = get_bk_option( 'booking_redsys_order_failed' );

		$redsys_error_url = wpbc_make_link_absolute( $redsys_error_url );

		// if relay is active, this will point to some valid url the user entered. If not, it will point to the original gateway url
		// header ("Location: ". $redsys_error_url ."?error=".$redsys_error_code);

		wpbc_redirect( $redsys_error_url ."?error=".$redsys_error_code );
	}


	/**
	 * Auto approve booking and redirect
	 *
	 * @param $booking_id
	 */
	function wpbc_redsys_auto_approve_booking( $booking_id, $paid_amount_in_plugin ){

		// Let's check whether the user wanted auto-approve or cancel
		$auto_approve = get_bk_option( 'booking_redsys_is_auto_approve_cancell_booking'  );
		if ( $auto_approve == 'On' ) {
			wpbc_auto_approve_booking__after_payment( $booking_id );		// FixIn: 9.9.0.43.
		}


		$redsys_success_url = get_bk_option( 'booking_redsys_order_successful' );
		if ( empty( $redsys_success_url ) ) {
			$redsys_success_url = get_bk_option( 'booking_thank_you_page_URL' );
		}

		$redsys_success_url = wpbc_make_link_absolute( $redsys_success_url );
		$redsys_success_url .= ( ( false === strpos( $redsys_success_url, '?' ) ) ? '?' : '&' ) . 'paid_amount=' . $paid_amount_in_plugin;

		list( $booking_hash, $resource_id ) = wpbc_hash__get_booking_hash__resource_id( $booking_id );

		// FixIn: 9.9.0.37.
		$redsys_success_url .= '&booking_hash=' . $booking_hash;
		$redsys_success_url .= '&is_show_payment_form=Off';

		// if relay is active, this will point to some valid url the user entered. If not, it will point to the original gateway url
		// header ("Location: ". $redsys_success_url );


		//$booking_data = wpbc_db_get_booking_details( $booking_id );
		/*
		  stdClass Object (
							[booking_id] => 39
							[trash] => 0
							[sync_gid] =>
							[is_new] => 1
							[status] =>
							[sort_date] => 2021-12-09 09:00:01
							[modification_date] => 2021-11-29 08:53:47
							[form] => text^days_number_hint3^1~text^cost_hint3^&#36;250.00~selectbox-one^rangetime3^09:00 - 20:30~text^name3^John~text^secondname3^Smith~email^email3^john.smith@server.com~selectbox-one^visitors3^1~selectbox-one^children3^0
							[hash] => 63e2799db2739ca8f5701bb0d982e12f
							[booking_type] => 3
							[remark] =>
							[cost] => 250.00
							[pay_status] => Redsys:OK
							[pay_request] => 0
						)
		 */
		//$redsys_success_url .= '?booking_id=' . $booking_id . '&booking_cost=' . $booking_data->cost;
		wpbc_redirect( $redsys_success_url );

	}


/**
 * Parse 1 way secret HASH, usually  after  redirection from payment system
 * and make approve / decline specific booking.
 *
 * @param $parsed_response  Array
									(
										[0] => payment
										[1] => redsys
										[2] => ec1f2c35728603edee9bde65ff3ba665
										[3] => approve
									)
 */
function wpbc_payment_response__redsys( $parsed_response ) {

	list( $response_type, $response_source, $booking_hash, $response_action ) = $parsed_response;

	// Check if its response from Redsys
	if ( (  'payment' === $response_type ) && ( WPBC_REDSYS_GATEWAY_ID === $response_source ) ) {

		$booking_id          = 0;
		$booking_resource_id = 0;


		// FixIn: 2025-03-06.  Get ID of booking.
		if ( ! empty( $booking_hash ) ) {
			$my_booking_id_type = wpbc_hash__get_booking_id__resource_id( $booking_hash );
			if ( ! empty( $my_booking_id_type ) ) {
				list( $booking_id, $booking_resource_id ) = $my_booking_id_type;
			}
		}

		// FixIn: 8.7.9.3.
		// In MultiUser version, check if this booking relative to the booking resource, from  the "regular  user".
		if ( class_exists( 'wpdev_bk_multiuser' ) ) {

			if ( ! empty( $booking_resource_id ) ) {

				$user_id = apply_bk_filter( 'get_user_of_this_bk_resource', false, $booking_resource_id );

				$is_booking_resource_user_super_admin = apply_bk_filter( 'is_user_super_admin', $user_id );

				if ( 'On' === get_bk_option( 'booking_super_admin_receive_regular_user_payments' ) ) {                   // FixIn: 9.7.3.5.
					$is_booking_resource_user_super_admin = true;
					make_bk_action( 'make_force_using_this_user', - 999 );                                              // '-999' - This ID "by default" is the ID of super booking admin user
				}

				if ( ! $is_booking_resource_user_super_admin ) {
					// Reactivate data for "regular  user.
					make_bk_action( 'check_multiuser_params_for_client_side_by_user_id', $user_id );
				}
			}
		}


		// Get here list  of all  success payment sessions in Redsys !
		if ( version_compare( PHP_VERSION, '7.0' ) < 0 ) {
			echo 'Redsys payment require PHP version 7.0 or newer!';
			return;
		}

		if ( ! class_exists( 'WPBC_RedsysAPI' ) ) {
			require_once dirname( __FILE__ ) . '/includes/index.php';
		}


		// Se crea Objeto.
		$miObj = new WPBC_RedsysAPI;

		$is_payment_for_this_booking_exist = false;
		$paid_amount_in_plugin = 0;
		$error_message = '';
		$op_prefix = 'booking_' . WPBC_REDSYS_GATEWAY_ID . '_';

		$check_currency = get_bk_option( $op_prefix . 'currency' );            // "978"; .

		// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
		if ( ( ! empty( $_REQUEST['Ds_SignatureVersion'] ) ) && ( ! empty( $_REQUEST['Ds_MerchantParameters'] ) ) && ( ! empty( $_REQUEST['Ds_Signature'] ) ) ) {

			$version           = $_REQUEST['Ds_SignatureVersion'];     // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
			$datos             = $_REQUEST['Ds_MerchantParameters'];   // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
			$signatureRecibida = $_REQUEST['Ds_Signature'];            // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

			$decodec = $miObj->decode_merchant_parameters( $datos );

			$decodec_arr = get_object_vars( json_decode( $decodec ) );
			$paid_amount_in_plugin = $decodec_arr['Ds_Amount'];

			//		$localsecret       = $mi_obj->create_merchant_signature_notif( $usesecretsha256, $data );
			//		$total             = $mi_obj->get_parameter( 'Ds_Amount' );
			//		$ordermi           = $mi_obj->get_parameter( 'Ds_Order' );
			//		$dscode            = $mi_obj->get_parameter( 'Ds_MerchantCode' );
			//		$currency_code     = $mi_obj->get_parameter( 'Ds_Currency' );
			//		$response          = $mi_obj->get_parameter( 'Ds_Response' );
			//		$id_trans          = $mi_obj->get_parameter( 'Ds_AuthorisationCode' );
			//		$dsdate            = htmlspecialchars_decode( $mi_obj->get_parameter( 'Ds_Date' ) );
			//		$dshour            = htmlspecialchars_decode( $mi_obj->get_parameter( 'Ds_Hour' ) );
			//		$dstermnal         = $mi_obj->get_parameter( 'Ds_Terminal' );
			//		$dsmerchandata     = $mi_obj->get_parameter( 'Ds_MerchantData' );
			//		$dssucurepayment   = $mi_obj->get_parameter( 'Ds_SecurePayment' );
			//		$dscardcountry     = $mi_obj->get_parameter( 'Ds_Card_Country' );
			//		$dsconsumercountry = $mi_obj->get_parameter( 'Ds_ConsumerLanguage' );
			//		$dstransactiontype = $mi_obj->get_parameter( 'Ds_TransactionType' );
			//		$dsmerchantidenti  = $mi_obj->get_parameter( 'Ds_Merchant_Identifier' );
			//		$dscardbrand       = $mi_obj->get_parameter( 'Ds_Card_Brand' );
			//		$dsmechandata      = $mi_obj->get_parameter( 'Ds_MerchantData' );
			//		$dscargtype        = $mi_obj->get_parameter( 'Ds_Card_Type' );
			//		$dserrorcode       = $mi_obj->get_parameter( 'Ds_ErrorCode' );
			//		$dpaymethod        = $mi_obj->get_parameter( 'Ds_PayMethod' ); // D o R, D: Domiciliacion, R: Transferencia.
			//		$response          = intval( $response );
			//		$secretsha256      = get_transient( 'redsys_signature_' . sanitize_text_field( $ordermi ) );

			$redsys_account_mode = get_bk_option( $op_prefix . 'account_mode' );
			if ( 'test' === $redsys_account_mode ) {
				$kc = get_bk_option( $op_prefix . 'secretsha256_test' );
			} else {
				$kc = get_bk_option( $op_prefix . 'secretsha256_live' );
			}

			$firma = $miObj->create_merchant_signature_notif( $kc, $datos );

			if ( $firma === $signatureRecibida ) {
				$is_payment_for_this_booking_exist = true;			// 'Ok' :)
			} else {
				$is_payment_for_this_booking_exist = false;			// 'Ko' :(
			}


			$ds_response = intval( $decodec_arr['Ds_Response'] );

			// CODE DOCS: https://pagosonline.redsys.es/codigosRespuesta.html .
			if ( ( $ds_response >= 0 ) && ( $ds_response <= 99 ) ) {
				// Transacción autorizada para pagos y preautorizaciones  -> 'Transaction authorized for payments and pre-authorizations' .
				$error_message = '';
			} else {

				$response_action = 'decline';

				$ds_response_arr = wpbc_redsys__get_dsresponse();

				$ds_response_key = (string) $ds_response;

				if ( isset( $ds_response_arr[ $ds_response_key ] ) ) {
					$error_message = $ds_response_arr[ $ds_response_key ] . ' (' . $ds_response_key . ')';
				} else {

					$ds_error_arr = wpbc_redsys__get_dserrors();
					if ( isset( $ds_error_arr[ $ds_response_key ] ) ) {
						$error_message = $ds_error_arr[ $ds_response_key ] . ' (' . $ds_response_key . ')';
					} else {
						$error_message = 'Unknown response code: ' . $ds_response;
					}
				}
			}
		}


//debuge( $_REQUEST );
//die;
		$text_paid_amount = $paid_amount_in_plugin;

		if ( false === $is_payment_for_this_booking_exist ) {


			$error_message  = '| Ds_SignatureVersion:' . $_REQUEST['Ds_SignatureVersion'];        // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
			$error_message .= '| Ds_MerchantParameters:' . $_REQUEST['Ds_MerchantParameters'];   // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
			$error_message .= '| Ds_Signature:' . $_REQUEST['Ds_Signature'] . '|';               // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

			wpbc_db__add_log_info( explode( ',', $booking_id ),
						'Payment system response.' .
						' -- REDSYS -- | Error=Unknown-Redsys-Payment | ' . $response_action . ' | ' .
						wpbc_redsys__amount_in_plugin( $text_paid_amount, $check_currency ) . ' | ' .
						$error_message . '|'.
						'Response_ Ds_Signature = ' . sanitize_text_field($_REQUEST['Ds_Signature']). '|' .             // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
						'shoud be == Calculated Signature = ' . $firma. '|' .
						'decodec_arr = ' . json_encode( $decodec_arr )
			);

			// Not Paid,  yet.
			wpbc_redirect( get_home_url() . '?error=Unknown-Redsys-Payment' );
			return;
		}

		// Get booking ID.
		$my_booking_id_type = wpbc_hash__get_booking_id__resource_id( $booking_hash );
		if ( ! empty( $my_booking_id_type ) ) {

			list( $booking_id, $resource_id ) = $my_booking_id_type;

			$booking_data   = wpbc_db_get_booking_details( $booking_id );

			// Record log.
			wpbc_db__add_log_info( explode( ',', $booking_id ),
									'Payment system response.' .
									' -- REDSYS -- | ' . $response_action . ' | ' .
									wpbc_redsys__amount_in_plugin( $text_paid_amount, $check_currency ) . ' | ' .
									$error_message
			//									. $text_payment_status  . ' | ' 		// 'paid'
			//									. $text_session_status  . ' |'			// 'complete'
			);

			switch ( $response_action ) {

			    case 'approve':

					wpbc_redsys_update_payment_status( $booking_id , 'Redsys:OK');

					wpbc_redsys_auto_approve_booking( $booking_id , $paid_amount_in_plugin );

			        break;
			    case 'decline':

					wpbc_redsys_update_payment_status( $booking_id , 'Redsys:ERROR');

					wpbc_redsys_auto_cancel_booking( $booking_id, "Redsys payment failed." );

			        break;
			    default:
			       // Default
			}

		} else {
			// Error
			echo '<div class="wpbc_after_booking_thank_you_section"><div class="wpbc_ty__container"><div class="wpbc_ty__header"><strong>' . esc_html__('Oops!' ,'booking') . '</strong> ' . esc_html__('We could not find your booking. The link you used may be incorrect or has expired. If you need assistance, please contact our support team.' ,'booking') . '</div></div></div>';
		}
	}
}

add_bk_action( 'wpbc_payment_response', 'wpbc_payment_response__redsys' );