<?php
/**
 * @version     1.0
 * @package     General Settings API - Saving different options
 * @category    Settings API
 * @author      wpdevelop
 *
 * @web-site    https://wpbookingcalendar.com/
 * @email       info@wpbookingcalendar.com 
 * @modified    2016-02-28
 * 
 * This is COMMERCIAL SCRIPT
 * We are not guarantee correct work and support of Booking Calendar, if some file(s) was modified by someone else then wpdevelop.
 */

if ( ! defined( 'ABSPATH' ) ) exit;                                             // Exit if accessed directly


/**
	 * Range Days Selection - Settings ( Calendar ) page
 * 
 * @param array $fields 
 * @return array
 */
function wpbc_settings_calendar_range_days_selection__bs( $fields, $default_options_values ) {
    
    //  Days Selection - Override from General API Settings ////////////////////
    $field_options = array(
                                'single'   => array( 'title' => __('Single day' ,'booking'),    'attr' => array( 'id' => 'type_of_day_selections_single' ) )
                              , 'multiple' => array( 'title' => __('Multiple days' ,'booking'), 'attr' => array( 'id' => 'type_of_day_selections_multiple' ) )
                              , 'range'    => array( 'title' => __('Range days' ,'booking'),    'attr' => array( 'id' => 'type_of_day_selections_range' ) )
                        );        
    $fields['booking_type_of_day_selections'] = array(   
                                'type'          => 'radio'
                                , 'default'     => $default_options_values['booking_type_of_day_selections']   //'multiple'            
                                , 'title'       => __('Days selection in calendar', 'booking')
                                , 'description' => ''
                                , 'options'     => $field_options
                                , 'group'       => 'calendar'
                        );

	// -----------------------------------------------------------------------------------------------------------------
    //  Range Days Selection 
	// -----------------------------------------------------------------------------------------------------------------
    $field_options = array(
                              /* translators: 1: ... */
                              'fixed'   => array( 'title' =>  sprintf( __( 'Select a %1$sFIXED%2$s number of days with %3$s1 mouse click%4$s', 'booking' ),'<strong>','</strong>','<strong>','</strong>')
                                                , 'attr' =>  array( 'id' => 'range_selection_type_fixed' ) )
                            /* translators: 1: ... */
                            , 'dynamic' => array( 'title' =>  sprintf( __( 'Select a %1$sDYNAMIC%2$s range of days with %3$s2 mouse clicks%4$s', 'booking' ),'<strong>','</strong>','<strong>','</strong>')
                                                , 'attr' =>  array( 'id' => 'range_selection_type_dynamic' ) )
                        );

    $fields['booking_range_selection_type'] = array(   
                                'type'          => 'radio'
                                , 'default'     => $default_options_values['booking_range_selection_type']   //'multiple'            
                                , 'title'       => ''
                                , 'description' => '' 
                                , 'options'     => $field_options
                                , 'group'       => 'calendar'
                                , 'tr_class'    => 'wpbc_range_days_selection wpbc_sub_settings_grayed wpbc_range_days_selection_radio'
                        );

	// -----------------------------------------------------------------------------------------------------------------
    //  F i x e d 
	// -----------------------------------------------------------------------------------------------------------------
    // <editor-fold     defaultstate="collapsed"                        desc=" FIXED "  >
    $field_options = array();
    foreach ( range( 1, 180, 1) as $value ) {
        $field_options[ $value ] = $value;
    }

    $fields['booking_range_selection_days_count'] = array(   
                                'type'          => 'select'
                                , 'default'     => $default_options_values['booking_range_selection_days_count']   //'3'            
                                , 'title'       => __('Days selection number', 'booking')
                                /* translators: 1: ... */
                                , 'description' => sprintf( __( 'Type your %1$snumber of days for range selection%2$s', 'booking' ),'<b>','</b>')
                                , 'options'     => $field_options
                                , 'group'       => 'calendar'
                                , 'tr_class'    => 'wpbc_range_days_selection wpbc_sub_settings_grayed wpbc_range_fixed_selection'
                        );

    //  Start day of FIXED range  //////////////////////////////////////////////
    $field_options = array(
                              'specific' => array( 'title' => __('Specific day(s) of week', 'booking'), 'attr' =>  array( 'id' => 'range_fixed_start_day_specific_day' ) )
                            , '-1'       => array( 'title' => __('Any day of week', 'booking'),         'attr' =>  array( 'id' => 'range_fixed_start_day_any_day' ) )
                        );

    $fields['booking_range_start_day'] = array(   
                                'type'          => 'radio'
                                , 'default'     => $default_options_values['booking_range_start_day']   //'-1'            
                                , 'title'       => __('Start day of range', 'booking')
                                , 'description' => ''
                                , 'options'     => $field_options
                                , 'group'       => 'calendar'
                                , 'tr_class'    => 'wpbc_range_days_selection wpbc_sub_settings_grayed wpbc_range_fixed_selection'
                        );

    //  Start week days  of FIXED range  ///////////////////////////////////////
    $fields['booking_range_start_day_html_prefix'] = array(   
                                'type'          => 'pure_html'
                                , 'group'       => 'calendar'
                                , 'html'        => '<tr valign="top" class="wpbc_tr_set_gen_booking_range_start_day_week 
                                                                            wpbc_range_days_selection wpbc_sub_settings_grayed 
                                                                            wpbc_range_fixed_selection 
                                                                            wpbc_range_fixed_selection_week_days">
                                                        <th scope="row"></th>
                                                        <td><fieldset>'
                        );        
    $fields['booking_range_start_day0'] = array(  'label'  => __('Sunday' ,'booking'),   'type' => 'checkbox', 'default' => 'Off', 'only_field' => true, 'group' => 'calendar' );
    $fields['booking_range_start_day1'] = array(  'label'  => __('Monday' ,'booking'),   'type' => 'checkbox', 'default' => 'Off', 'only_field' => true, 'group' => 'calendar' );
    $fields['booking_range_start_day2'] = array(  'label'  => __('Tuesday' ,'booking'),  'type' => 'checkbox', 'default' => 'Off', 'only_field' => true, 'group' => 'calendar' );
    $fields['booking_range_start_day3'] = array(  'label'  => __('Wednesday' ,'booking'),'type' => 'checkbox', 'default' => 'Off', 'only_field' => true, 'group' => 'calendar' );
    $fields['booking_range_start_day4'] = array(  'label'  => __('Thursday' ,'booking'), 'type' => 'checkbox', 'default' => 'Off', 'only_field' => true, 'group' => 'calendar' );
    $fields['booking_range_start_day5'] = array(  'label'  => __('Friday' ,'booking'),   'type' => 'checkbox', 'default' => 'Off', 'only_field' => true, 'group' => 'calendar' );
    $fields['booking_range_start_day6'] = array(  'label'  => __('Saturday' ,'booking'), 'type' => 'checkbox', 'default' => 'Off', 'only_field' => true, 'group' => 'calendar' );
    $fields['booking_range_start_day_html_sufix'] = array(   
                                'type'          => 'pure_html'
                                , 'group'       => 'calendar'
                                , 'html'        => '          <p class="description">' 
                                                                . __('Select your start day of range selection at week' ,'booking') 
                                                        . '   </p>
                                                           </fieldset>
                                                        </td>
                                                    </tr>'            
                        );        
    // </editor-fold>
    
	// -----------------------------------------------------------------------------------------------------------------
    //  D y n a m i c
	// -----------------------------------------------------------------------------------------------------------------
    // <editor-fold     defaultstate="collapsed"                        desc=" DYNAMIC "  >
    $fields['booking_range_selection_days_count_dynamic_prefix'] = array( 'type' => 'pure_html', 'group' => 'calendar'
                                , 'html'        => '<tr valign="top" class="wpbc_tr_set_gen_booking_range_selection_days_count_dynamic 
                                                                            wpbc_range_days_selection wpbc_sub_settings_grayed 
                                                                            wpbc_range_dynamic_selection 
                                                                            wpbc_range_dynamic_selection_days_count">
                                                        <th scope="row">
                                                            <label class="wpbc-form-selectbox" for="set_gen_booking_range_selection_days_count_dynamic">' 
                                                            .   wp_kses_post(  __('Days selection number' ,'booking') ) 
                                                            . '</label>
                                                        </th>
                                                        <td><fieldset>'
                        );            
    $field_options = array();
	foreach ( range( 1, ( 365 * 3 ), 1 ) as $value ) {        // FixIn: 8.8.2.7.
        $field_options[ $value ] = $value;
    }
    //  Min num.  of days selections - DYNAMIC range  //////////////////////////
    $fields['booking_range_selection_days_count_dynamic_label'] = array( 
                                'type'    => 'pure_html'
                                , 'group' => 'calendar' 
                                , 'html'  => WPBC_Settings_API::label_static( 'set_gen_booking_range_selection_days_count_dynamic'
                                                                            , array(   'title'=> __('Min', 'booking'), 'label_css' => 'margin: 0.25em 0 !important;vertical-align: middle;' ) )
        );    
    $fields['booking_range_selection_days_count_dynamic'] = array(   
                                'type'          => 'select'
                                , 'default'     => $default_options_values['booking_range_selection_days_count_dynamic']   //'1'            
                                , 'title'       => __('Min', 'booking')
                                , 'description' => '' 
                                , 'options'     => $field_options
                                , 'group'       => 'calendar'
                                , 'tr_class'    => 'wpbc_range_days_selection wpbc_sub_settings_grayed wpbc_range_dynamic_selection'
                                , 'css'         => 'margin-right:20px'
                                , 'only_field'  => true
                        );
    //  Max num.  of days selections - DYNAMIC range  //////////////////////////
    $fields['booking_range_selection_days_max_count_dynamic_label'] = array( 
                                  'type'  => 'pure_html'
                                , 'group' => 'calendar'
                                , 'html'  => WPBC_Settings_API::label_static( 'set_gen_booking_range_selection_days_max_count_dynamic'
                                                                            , array(   'title'=> __('Max', 'booking'), 'label_css' => 'margin: 0.25em 0 !important;vertical-align: middle;' ) )
        );    
    $fields['booking_range_selection_days_max_count_dynamic'] = array(   
                                'type'          => 'select'
                                , 'default'     => $default_options_values['booking_range_selection_days_max_count_dynamic']   //'30'            
                                , 'title'       => __('Max', 'booking')
                                , 'description' => ''
                                , 'options'     => $field_options
                                , 'group'       => 'calendar'
                                , 'tr_class'    => 'wpbc_range_days_selection wpbc_sub_settings_grayed wpbc_range_dynamic_selection'
                                , 'only_field'  => true
                        );
    
    $fields['booking_range_selection_days_count_dynamic_sufix'] = array(   
                                'type'          => 'pure_html'
                                , 'group'       => 'calendar'
                                , 'html'        => '          <p class="description">' 
                                                                /* translators: 1: ... */
                                                                . sprintf( __( 'Select your %1$sminimum and maximum number of days for range selection%2$s', 'booking' ),'<b>','</b>')
                                                        . '   </p>
                                                           </fieldset>
                                                        </td>
                                                    </tr>'            
                        );        
    
    //  Specific num. of days selections - DYNAMIC range  //////////////////////    
    $fields['booking_range_selection_days_specific_num_dynamic'] = array(   
                                'type'          => 'text'
                                , 'default'     => $default_options_values['booking_range_selection_days_specific_num_dynamic']   //'1'
                                , 'title'       => __('Specific days selections' ,'booking')
                                , 'placeholder' =>  __('Example' ,'booking') . ': 7,14,21,28'
                                /* translators: 1: ... */
                                , 'description' => sprintf( __( 'Type your %1$sspecific%2$s days, which can be selected by visitors, or leave this value empty. It can be several days separated by comma (example: %3$s) or by dash (example: %4$s, its the same like this: %5$s) or combination (example:%6$s, its the same like this: %7$s)', 'booking' )
                                                          ,'<b>','</b>', '<code>7,14,21,28</code>', '<code>3-5</code>', '<code>3,4,5</code>', '<code>3-5,7,14</code>', '<code>3,4,5,7,14</code>')
                                , 'class'       => 'large-text'
                                , 'group'       => 'calendar'
                                , 'tr_class'    => 'wpbc_range_days_selection wpbc_sub_settings_grayed wpbc_range_dynamic_selection'
                        );
    
    
    //  Start day of DYNAMIC range  //////////////////////////////////////////////
    $field_options = array(
                              'specific' => array(
                                                  'title' => __('Specific day(s) of week', 'booking')
                                                , 'attr' =>  array( 'id' => 'range_dynamic_start_day_specific_day' )
                                            )
                            , '-1' => array(
                                                  'title' => __('Any day of week', 'booking')
                                                , 'attr' =>  array( 'id' => 'range_dynamic_start_day_any_day' )
                                            )
                        );

    $fields['booking_range_start_day_dynamic'] = array(   
                                'type'          => 'radio'
                                , 'default'     => $default_options_values['booking_range_start_day_dynamic']   //'-1'            
                                , 'title'       => __('Start day of range', 'booking')
                                , 'description' => ''
                                , 'options'     => $field_options
                                , 'group'       => 'calendar'
                                , 'tr_class'    => 'wpbc_range_days_selection wpbc_sub_settings_grayed wpbc_range_dynamic_selection'
                        );

    //  Start week days  of DYNAMIC range  /////////////////////////////////////
    $fields['booking_range_start_day_dynamic_html_prefix'] = array(   
                                'type'          => 'pure_html'
                                , 'group'       => 'calendar'
                                , 'html'        => '<tr valign="top" class="wpbc_tr_set_gen_booking_range_start_day_dynamic_week 
                                                                            wpbc_range_days_selection wpbc_sub_settings_grayed 
                                                                            wpbc_range_dynamic_selection 
                                                                            wpbc_range_dynamic_selection_week_days">
                                                        <th scope="row"></th>
                                                        <td><fieldset>'
                        );        
    $fields['booking_range_start_day_dynamic0'] = array(  'label'  => __('Sunday' ,'booking'),   'type' => 'checkbox', 'default' => 'Off', 'only_field' => true, 'group' => 'calendar' );
    $fields['booking_range_start_day_dynamic1'] = array(  'label'  => __('Monday' ,'booking'),   'type' => 'checkbox', 'default' => 'Off', 'only_field' => true, 'group' => 'calendar' );
    $fields['booking_range_start_day_dynamic2'] = array(  'label'  => __('Tuesday' ,'booking'),  'type' => 'checkbox', 'default' => 'Off', 'only_field' => true, 'group' => 'calendar' );
    $fields['booking_range_start_day_dynamic3'] = array(  'label'  => __('Wednesday' ,'booking'),'type' => 'checkbox', 'default' => 'Off', 'only_field' => true, 'group' => 'calendar' );
    $fields['booking_range_start_day_dynamic4'] = array(  'label'  => __('Thursday' ,'booking'), 'type' => 'checkbox', 'default' => 'Off', 'only_field' => true, 'group' => 'calendar' );
    $fields['booking_range_start_day_dynamic5'] = array(  'label'  => __('Friday' ,'booking'),   'type' => 'checkbox', 'default' => 'Off', 'only_field' => true, 'group' => 'calendar' );
    $fields['booking_range_start_day_dynamic6'] = array(  'label'  => __('Saturday' ,'booking'), 'type' => 'checkbox', 'default' => 'Off', 'only_field' => true, 'group' => 'calendar' );
    $fields['booking_range_start_day_dynamic_html_sufix'] = array(   
                                'type'          => 'pure_html'
                                , 'group'       => 'calendar'
                                , 'html'        => '          <p class="description">' 
                                                                . __('Select your start day of range selection at week' ,'booking') 
                                                        . '   </p>
                                                           </fieldset>
                                                        </td>
                                                    </tr>'            
                        );        
    // </editor-fold>
            
    $fields = wpbc_override_fields_in_settings_page__bs( $fields );             // Override "Specific number of Week Start days"                                
                    
    return $fields;
}
add_filter('wpbc_settings_calendar_range_days_selection', 'wpbc_settings_calendar_range_days_selection__bs' ,10, 2);


// FixIn: 10.1.5.4.


/**
	 * Check in/out  - Settings ( Calendar ) page
 * 
 * @param array $fields
 * @return array
 */
function wpbc_settings_calendar_check_in_out_times__bs( $fields, $default_options_values ) { 

	// FixIn: 8.1.3.28.
    $fields['booking_last_checkout_day_available'] = array(
                            'type'          => 'checkbox'
                            , 'default'     => $default_options_values['booking_last_checkout_day_available']   //'Off'
                            , 'title'       => __('Set check out date as available' ,'booking')
                            , 'label'       => __('Check this option, to remove last selected day of saving to booking.' ,'booking')

                            , 'group'       => 'calendar'
                            , 'tr_class'    => 'wpbc_recurrent_check_in_out_time_slots'
        );



	// FixIn: 9.3.1.8.
    $fields['booking_range_selection_time_is_active'] = array(   
                            'type'          => 'checkbox'
                            , 'default'     => $default_options_values['booking_range_selection_time_is_active']   //'Off'            
                            , 'title'       =>  __('Use changeover days' ,'booking')
                            , 'label'       => __('Check this option, to use changeover days during booking process. Check-in/out days will be marked with vertical or diagonal lines.' ,'booking')
							/* translators: 1: ... */
                            , 'description' => sprintf( __( '%1$s Important!%2$s This will overwrite any times selection in your booking form.', 'booking' ),'<b>','</b>')
										     . '<br/><div class="wpbc-settings-notice notice-info" style="text-align:left">'
                            				 /* translators: 1: ... */
                            				 . sprintf( __( '%1$s Note!%2$s This feature requires the range days selection mode to be enabled with a minimum of 2 days to select.', 'booking' ),'<b>','</b>')
											 . '</div>'
                            , 'group'       => 'calendar'
                            , 'tr_class'    => 'wpbc_recurrent_check_in_out_time_slots'
        );


	$times_arr = array();
	for ( $hh = 0; $hh < 24; $hh ++ ) {
		for ( $mm = 0; $mm < 60; $mm ++ ) {
			$time_slot = ( $hh < 10 ) ? '0' . $hh : $hh;
			$time_slot .= ':';
			$time_slot .= ( $mm < 10 ) ? '0' . $mm : $mm;
			$times_arr[$time_slot] = wpbc_time_localized($time_slot);
		}
	}
    $fields['booking_range_selection_start_time'] = array(
                            'type'          => 'select'
                            , 'default'     => $default_options_values['booking_range_selection_start_time']   //'12:00'
                            , 'title'         => __('Check-in time' ,'booking')
                            /* translators: 1: ... */
                            , 'description'   => //sprintf( __( 'Type your %1$sCheck-in%2$s time of booking', 'booking' ),'<b>','</b>') . '<br/>' .
												  __('Example' ,'booking') . ': <strong>'.wpbc_time_localized( '14:00' ) . '</strong>'                       // FixIn: 7.0.1.65.
                            , 'group'       => 'calendar'
                            , 'tr_class'    => 'wpbc_recurrent_check_in_out_time_slots wpbc_check_in_out_time_slots wpbc_sub_settings_grayed'
                            //, 'class'       => 'wpdev-validates-as-time'
                            , 'css'         => 'width:8em;'
							, 'options'     => $times_arr
                            , 'placeholder' => ''
                            , 'description_tag' => 'span'
        );    
    $fields['booking_range_selection_end_time'] = array(  
                            'type'          => 'select'
                            , 'default'     => $default_options_values['booking_range_selection_end_time']   //'10:00'
                            , 'title'         => __('Check-Out time' ,'booking')
                            /* translators: 1: ... */
                            , 'description'   => //sprintf( __( 'Type your %1$sCheck-Out%2$s time of booking', 'booking' ),'<b>','</b>') . '<br/>' .
												 __('Example' ,'booking') . ': <strong>'.wpbc_time_localized( '10:00' ) . '</strong>'                       // FixIn: 7.0.1.65.
                            , 'group'       => 'calendar'
                            , 'tr_class'    => 'wpbc_recurrent_check_in_out_time_slots wpbc_check_in_out_time_slots wpbc_sub_settings_grayed'
                            //, 'class'       => 'wpdev-validates-as-time'
                            , 'css'         => 'width:8em;'
							, 'options'     => $times_arr
                            , 'placeholder' => ''
                            , 'description_tag' => 'span'
        );    

    // FixIn: 7.0.1.24.
    $fields['booking_change_over_days_triangles'] = array(   
                            'type'          => 'checkbox'
                            , 'default'     => $default_options_values['booking_change_over_days_triangles']   //'Off'            
                            , 'title'       => __('Change over days as triangles' ,'booking')
                            , 'label'       => __('Check this option, to show change over days as triangles. ' ,'booking')
                            , 'description' => ''
                            , 'group'       => 'calendar'
                            , 'tr_class'    => 'wpbc_recurrent_check_in_out_time_slots wpbc_check_in_out_time_slots wpbc_sub_settings_grayed'
        );

	// FixIn: 8.9.4.10.
	$fields['hr_booking_change_over__is_excerpt_on_pages'] = array( 'type' => 'hr', 'group' => 'calendar', 'tr_class' => 'wpbc_advanced_co_settings  wpbc_check_in_out_time_slots wpbc_sub_settings_grayed' );
	$fields['booking_change_over__is_excerpt_on_pages'] = array(
							'type'          => 'checkbox'
							, 'default'     => $default_options_values['booking_change_over__is_excerpt_on_pages']         //'Off'
							, 'title'       => __('Do not use change over days on certain pages' ,'booking')
							, 'label'       => __('Activate the list of pages that do not use the change over days functionality.' ,'booking')
							, 'description' => ''
							, 'group'       => 'calendar'
							, 'tr_class'    => 'wpbc_advanced_co_settings  wpbc_check_in_out_time_slots wpbc_sub_settings_grayed'
							, 'is_demo_safe' => false //wpbc_is_this_demo()
		);
	$fields['booking_change_over__excerpt_on_pages'] = array(
							'type'          => 'textarea'
							, 'default'     => $default_options_values['booking_change_over__excerpt_on_pages']         //''
							, 'placeholder' => '/page-no-change-over/'
							, 'title'       => __('Relative URLs of pages where you shouldn\'t use the change over days functionality' ,'booking')
							/* translators: 1: ... */
							, 'description' => sprintf(__( 'Enter the relative URLs of the pages for which you do not want to use the change over days functionality. Enter one URL per line. Example: %s' ,'booking'),'<code>/page-no-change-over/</code>')
							,'description_tag' => 'p'
							, 'css'         => 'width:100%'
							, 'rows'        => 5
							, 'group'       => 'calendar'
							, 'tr_class'    => 'wpbc_advanced_co_settings wpbc_is_use_co_on_specific_pages wpbc_sub_settings_grayed hidden_items  wpbc_check_in_out_time_slots wpbc_sub_settings_grayed'
							, 'is_demo_safe' => false //wpbc_is_this_demo()
					);


    return $fields;
}
add_filter('wpbc_settings_calendar_check_in_out_times', 'wpbc_settings_calendar_check_in_out_times__bs' ,10, 2);            // Check In/Out Times








/**
	 * Auto cancellation / auto approval Settings - Settings ( Auto cancellation / auto approval ) page
 * 
 * @param array $fields
 * @return array
 */
function wpbc_settings_auto_cancelation_approval_section__bs( $fields, $default_options_values ) {
    
    
    $fields['booking_auto_approve_new_bookings_is_active'] = array(   
                            'type'          => 'checkbox'
                            , 'default'     => $default_options_values['booking_auto_approve_new_bookings_is_active']   //'Off'            
                            , 'title'       =>  __('Auto approve all new bookings' ,'booking')
                            /* translators: 1: ... */
                            , 'label'       => sprintf( __( 'Check this checkbox to %1$sactivate%2$s auto approve of all new pending bookings.', 'booking' ),'<b>','</b>')
                            , 'description' => ''
                            , 'group'       => 'auto_cancelation_approval'
        );

    //TODO: Test  thesse options. 2018-03-23
	// FixIn: 8.1.3.27.
    $fields['booking_auto_approve_bookings_when_import'] = array(
                            'type'          => 'checkbox'
                            , 'default'     => $default_options_values['booking_auto_approve_bookings_when_import']   //'Off'
                            , 'title'       =>  __('Auto approve bookings during import' ,'booking')
                            /* translators: 1: ... */
                            , 'label'       => sprintf( __( 'Check this checkbox to activate auto approve of all bookings %1$sduring import from external source(s)%2$s.', 'booking' ),'<b>','</b>')
                            , 'description' => ''
                            , 'group'       => 'auto_cancelation_approval'
        );
    $fields['booking_auto_approve_bookings_when_zero_cost'] = array(
                            'type'          => 'checkbox'
                            , 'default'     => $default_options_values['booking_auto_approve_bookings_when_zero_cost']   //'Off'
                            , 'title'       =>  __('Auto approve booking, if booking cost is zero' ,'booking')
                            /* translators: 1: ... */
                            , 'label'       => sprintf( __( 'Check this checkbox to activate auto approve of booking, %1$swhen cost of booking is zero%2$s.', 'booking' ),'<b>','</b>')
                            , 'description' => ''
                            , 'group'       => 'auto_cancelation_approval'
        );
    $fields['booking_auto_approve_bookings_if_added_in_admin_panel'] = array(
                            'type'          => 'checkbox'
                            , 'default'     => $default_options_values['booking_auto_approve_bookings_if_added_in_admin_panel']   //'Off'
                            , 'title'       =>  __('Auto approve bookings after creation booking in admin panel' ,'booking')
                            /* translators: 1: ... */
                            , 'label'       => sprintf( __( 'Check this checkbox to activate auto approve of booking, %1$sif booking was made in admin panel%2$s.', 'booking' ),'<b>','</b>')
                            , 'description' => ''
                            , 'group'       => 'auto_cancelation_approval'
        );

    $fields['hr_booking_auto_cancel_pending_unpaid_bk_is_active'] = array( 'type' => 'hr', 'group' => 'auto_cancelation_approval' );

    $fields['booking_auto_cancel_pending_unpaid_bk_is_active'] = array(   
                            'type'          => 'checkbox'
                            , 'default'     => $default_options_values['booking_auto_cancel_pending_unpaid_bk_is_active']   //'Off'            
                            , 'title'       =>  __('Auto-cancel bookings' ,'booking')
                            /* translators: 1: ... */
                            , 'label'       => sprintf( __( 'Check this box to %1$sactivate%2$s auto-cancellation for pending, unpaid bookings.', 'booking' ),'<b>','</b>')
                            , 'description' => ''
                            , 'group'       => 'auto_cancelation_approval'
        );       

    // Auto Cancel Sub Settings ////////////////////////////////////////////////
    // $field_options = array( 1 => '1 ' . __('hour' ,'booking') );             // FixIn: 7.0.1.25.
    $field_options = array( 
                              '0:15' => '15 ' . __('minutes' ,'booking')
                            , '0:30' => '30 ' . __('minutes' ,'booking')
                            , '0:45' => '45 ' . __('minutes' ,'booking')
                            ,      1 => '1 '  . __('hour' ,'booking')
                          );                                                    // FixIn: 7.0.1.25.
    
    for ( $i = 2; $i < 24; $i++ ){
        $field_options[ $i ] =  $i . ' ' . __('hours' ,'booking');
    }
    $field_options[ 24 ] =  '1 ' . __('day' ,'booking');
    for ($i = 2; $i < 32; $i++) {
        $field_options[ $i*24 ] =  $i . ' ' . __('days' ,'booking');
    }
    $fields['booking_auto_cancel_pending_unpaid_bk_time'] = array(   
                              'type'        => 'select'
                            , 'default'     => $default_options_values['booking_auto_cancel_pending_unpaid_bk_time']   //'24'            
                            , 'title'       =>__('Cancel bookings older' ,'booking')
                            , 'description' => __('Cancel only pending, unpaid bookings, which are older than this selection.' ,'booking')
                            , 'options'     => $field_options
                            , 'group'       => 'auto_cancelation_approval'
                            , 'tr_class'    => 'wpbc_sub_settings_grayed wpbc_sub_settings_auto_cancelation'
                    );
    $fields['booking_auto_cancel_pending_unpaid_bk_is_send_email'] = array(   
                            'type'          => 'checkbox'
                            , 'default'     => $default_options_values['booking_auto_cancel_pending_unpaid_bk_is_send_email']   //'On'            
                            , 'title'       =>  __('Cancellation email sent' ,'booking')
                            /* translators: 1: ... */
                            , 'label'       => sprintf( __( 'Check this box to %1$ssend%2$s cancellation email for this resource.', 'booking' ),'<b>','</b>')
                            , 'description' => ''
                            , 'group'       => 'auto_cancelation_approval'
                            , 'tr_class'    => 'wpbc_sub_settings_grayed wpbc_sub_settings_auto_cancelation'
        );       
    $fields['booking_auto_cancel_pending_unpaid_bk_email_reason'] = array(   
                                'type'          => 'textarea'
                                , 'default'     => $default_options_values['booking_auto_cancel_pending_unpaid_bk_email_reason']   //__('This booking canceled because we did not receive payment and the administrator did not approve it.' ,'booking')
                                , 'title'       => __('Reason for cancellation' ,'booking')
                                , 'placeholder' => __('Reason for cancellation' ,'booking')
                                /* translators: 1: ... */
                                , 'description' => sprintf( __( 'Type the reason for %1$scancellation%2$s for the email template.', 'booking' ),'<b>','</b>')
                                , 'css'         => 'width:100%'
                                , 'rows'        => 2
                                , 'group'       => 'auto_cancelation_approval'
                                , 'tr_class'    => 'wpbc_sub_settings_grayed wpbc_sub_settings_auto_cancelation'
                        );
    
    
    return $fields;
}
add_filter('wpbc_settings_auto_cancelation_approval_section', 'wpbc_settings_auto_cancelation_approval_section__bs' ,10, 2);        // Recurent Times        


////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////


/**
	 * SUPPORT FUNCTION - Override "Specific number of Week Start days" options for settings page
 * Description:
 * Options "range_start_day_dynamic0-6" and "range_start_day0-6" does not exist in the DB they  exist  only in settings page, 
 * So after loading from DB, we need to get values from  the "range_start_day" and "range_start_day_dynamic" 
 * and depend from this value set options "range_start_day_dynamic0-6" and "range_start_day0-6"
 *
 * @param array $fields
 * @return array
 */
function wpbc_override_fields_in_settings_page__bs( $fields ) {

    // FIXED
    $fixed_week_start = get_bk_option('booking_range_start_day');               // get_bk_option('booking_range_start_day') can be "-1" - any days or "2,3,5" - specific week days

    if ( $fixed_week_start != '-1' ) {                                      
        $fields['booking_range_start_day']['value'] = 'specific';            
        $fixed_week_start = explode( ',', $fixed_week_start );
    } else 
        $fixed_week_start = array();

    for ( $i = 0; $i < 7; $i++ ) {
        if ( in_array( $i, $fixed_week_start ) )    $fields['booking_range_start_day' . $i ]['value'] = 'On';
        else                                        $fields['booking_range_start_day' . $i ]['value'] = 'Off';
    } 

    // DYNAMIC
    $fixed_week_start = get_bk_option('booking_range_start_day_dynamic');               // get_bk_option('booking_range_start_day_dynamic') can be "-1" - any days or "2,3,5" - specific week days

    if ( $fixed_week_start != '-1' ) {                                      
        $fields['booking_range_start_day_dynamic']['value'] = 'specific';            
        $fixed_week_start = explode( ',', $fixed_week_start );
    } else 
        $fixed_week_start = array();

    for ( $i = 0; $i < 7; $i++ ) {
        if ( in_array( $i, $fixed_week_start ) )    $fields['booking_range_start_day_dynamic' . $i ]['value'] = 'On';
        else                                        $fields['booking_range_start_day_dynamic' . $i ]['value'] = 'Off';
    } 

    return $fields;
}


/**
	 * Override fields array  of Settings page,  AFTER saving to  DB. Some fields have to have different Values.
 * 
 * @param array $fields
 * @param string $page_id
 * @return array - fields
 */
function wpbc_fields_after_saving_to_db__bs( $fields, $page_id ) {
    if ( $page_id == 'set_gen' ) {
        $fields = wpbc_override_fields_in_settings_page__bs( $fields );         // Override "Specific number of Week Start days"                                
    }
    return $fields;
}
add_filter('wpbc_fields_after_saving_to_db', 'wpbc_fields_after_saving_to_db__bs', 10, 2);


/**
	 * Override VALIDATED fields BEFORE saving to DB
 * Description:
 * Range_start_day_dynamic0-6 and range_start_day0-6 does not exist in the DB
 * they  exist  only in settings page, so  need to  get  values from these options
 * and ovverride values to the "range_start_day" and "range_start_day_dynamic" if its required.
 * 
 * @param array $validated_fields
 */
function wpbc_settings_validate_fields_before_saving__bs( $validated_fields ) {
    
    // FIXED
    if ( $validated_fields['booking_range_start_day'] == '-1' ) {                       // Fixed - Any  week days        
        for ( $i = 0; $i < 7; $i++ ) {
            unset( $validated_fields[ 'booking_range_start_day' . $i ] );
        }
        
    } else {                                                                    // Fixed - Specific Week days
        $validated_fields['booking_range_start_day'] = array();
        for ( $i = 0; $i < 7; $i++ ) {
            if ( $validated_fields[ 'booking_range_start_day' . $i ] == 'On' )   $validated_fields['booking_range_start_day'][] = $i;             
            unset( $validated_fields[ 'booking_range_start_day' . $i ] );
        }
        $validated_fields['booking_range_start_day'] = implode( ',', $validated_fields['booking_range_start_day'] );
    }
    
    if ( $validated_fields['booking_range_start_day'] == '' )                           // If not selected any weekdays,  then  set as days selection "Any weekdays".
        $validated_fields['booking_range_start_day'] = '-1';
    
    
    // DYNAMIC
    if ( $validated_fields['booking_range_start_day_dynamic'] == '-1' ) {               // Dynamic - Any  week days        
        for ( $i = 0; $i < 7; $i++ ) {
            unset( $validated_fields[ 'booking_range_start_day_dynamic' . $i ] );
        }
        
    } else {                                                                    // Dynamic - Specific Week days
        $validated_fields['booking_range_start_day_dynamic'] = array();
        for ( $i = 0; $i < 7; $i++ ) {
            if ( $validated_fields[ 'booking_range_start_day_dynamic' . $i ] == 'On' )   $validated_fields['booking_range_start_day_dynamic'][] = $i;             
            unset( $validated_fields[ 'booking_range_start_day_dynamic' . $i ] );
        }
        $validated_fields['booking_range_start_day_dynamic'] = implode( ',', $validated_fields['booking_range_start_day_dynamic'] );
    }
    
    if ( $validated_fields['booking_range_start_day_dynamic'] == '' )                   // If not selected any weekdays,  then  set as days selection "Any weekdays".
        $validated_fields['booking_range_start_day_dynamic'] = '-1';
    
    


    
    return $validated_fields;
}
add_filter( 'wpbc_settings_validate_fields_before_saving', 'wpbc_settings_validate_fields_before_saving__bs', 10, 1 );   // Hook for validated fields.


/**
	 * JavaScript     at Bottom of Settings page
 * 
 * @param string $page_tag
 */
function wpbc_settings_enqueue_js__bs( $page_tag, $active_page_tab, $active_page_subtab ) {

    // Check if this correct  page /////////////////////////////////////////////
    
    if ( !(
               ( $page_tag == 'wpbc-settings')                                      // Load only at 'wpbc-settings' menu
		    // At ''general' tab
            && (  ( ! isset( $_GET['tab'] ) ) || ( $_GET['tab'] == 'general' )  )   // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
          )
      ) return;
  

    $js_script = '';

	// FixIn: 10.1.5.4.

    // Auto Cancellation section
    $js_script .= " if ( ! jQuery('#set_gen_booking_auto_cancel_pending_unpaid_bk_is_active').is(':checked') ) {
                        jQuery('.wpbc_sub_settings_auto_cancelation').addClass('hidden_items');
                    }
                    if ( ! jQuery('#set_gen_booking_auto_cancel_pending_unpaid_bk_is_send_email').is(':checked') ) {
                        jQuery('.wpbc_tr_set_gen_booking_auto_cancel_pending_unpaid_bk_email_reason').addClass('hidden_items');
                    }                    
                  ";                                                                         
                                                                                // Click on "Auto-cancel bookings"
    $js_script .= " jQuery('#set_gen_booking_auto_cancel_pending_unpaid_bk_is_active').on( 'change', function(){    
                            if ( this.checked ) { 
                                jQuery('.wpbc_sub_settings_auto_cancelation').removeClass('hidden_items');
                                if ( ! jQuery('#set_gen_booking_auto_cancel_pending_unpaid_bk_is_send_email').is(':checked') ) {
                                    jQuery('.wpbc_tr_set_gen_booking_auto_cancel_pending_unpaid_bk_email_reason').addClass('hidden_items');
                                }
                            } else {
                                jQuery('.wpbc_sub_settings_auto_cancelation').addClass('hidden_items');
                            }
                        } ); ";   
                                                                                // Click "Cancellation email sent"
    $js_script .= " jQuery('#set_gen_booking_auto_cancel_pending_unpaid_bk_is_send_email').on( 'change', function(){    
                            if ( this.checked ) { 
                                jQuery('.wpbc_tr_set_gen_booking_auto_cancel_pending_unpaid_bk_email_reason').removeClass('hidden_items');
                            } else {
                                jQuery('.wpbc_tr_set_gen_booking_auto_cancel_pending_unpaid_bk_email_reason').addClass('hidden_items');
                            }
                        } ); ";

	// Enqueue JS to  the footer of the page
    wpbc_enqueue_js( $js_script );
}
add_action( 'wpbc_after_settings_content',  'wpbc_settings_enqueue_js__bs', 10, 3 );



////////////////////////////////////////////////////////////////////////////////
// Booking Resources Table
////////////////////////////////////////////////////////////////////////////////

/**
	 * Get Price period (per/day or per/hour, per/nights) cost
 * 
 * @return string - link to Booking > Settings > Payment page with  title of price period
 */
function wpbc_get_per_day_night_title() {
    
    $price_period = get_bk_option( 'booking_paypal_price_period' );
    switch ( $price_period ) {
        case 'day': 
                    $price_period = ' / ' . __( 'day', 'booking' );
                    break;
        case 'night': 
                    $price_period = ' / ' . __( 'night', 'booking' );
                    break;
        case 'hour': 
                    $price_period = ' / ' . __( 'hour', 'booking' );
                    break;
        default:                                                                // 'fixed'
                    $price_period = '';
                    break;
    }
    $price_period = '<a style="font-size:1em;padding-bottom: 2px;border-bottom:1px dashed;" href="'. esc_url( wpbc_get_settings_url() ) . '&tab=payment#gateways_booking_paypal_price_period' .'">' . $price_period . '</a>';
    
    return $price_period;
}


/**
	 * Add Column Header to Resources Table -- Cost Fields
 * 
 * @param array $columns
 * @return array
 */
function wpbc_resources_table_header__cost_title__bs( $columns ) {

    $price_period = wpbc_get_per_day_night_title();
    
    $columns[ 'cost' ] = array(   
                                  'title' => __( 'Cost' , 'booking' ) . $price_period									// FixIn: 7.1.2.1.
                                , 'style' => 'width:8em;'
                                // , 'sortable' => true                         // Sortable opearation  on this field is SLOW, because its require converting types from varchar to decimal,  thats why its not activated by  default.
                        );
    return $columns;
}
add_filter( 'wpbc_resources_table_header__cost_title', 'wpbc_resources_table_header__cost_title__bs', 10, 1 );   // Hook for validated fields.


/**
	 * Show Column in Resources Table - Edit Cost
 * 
 * @param int $row_num
 * @param array $resource
 */
function wpbc_resources_table_show_col__cost_field__bs( $row_num, $resource ) {

	// Currency
	$currency     = wpbc_get_currency_symbol_for_user( $resource['id'] );
	$price_period = wpbc_get_cost_per_period_for_user( $resource['id'] );
	?>
	<div class="ui_element ui_cost_field">
		<!--div class="field-currency"><?php echo esc_html( $currency ); ?></div-->
		<label for="booking_resource_cost_<?php echo esc_attr( $resource['id' ] ); ?>"
		   class="wpbc_ui_control_label " style="padding:0;"><span style="font-weight:600;font-size:1.2em;"><?php echo esc_html( $currency ); ?></span></label>
		<input type="text"
			   value="<?php echo esc_js( $resource['cost'] ); ?>"
			   id="booking_resource_cost_<?php echo esc_attr( $resource['id' ] ); ?>"
			   name="booking_resource_cost_<?php echo esc_attr( $resource['id' ] ); ?>"
			   class="large-text wpbc_ui_control wpbc_ui_text"
			   style="margin-left: 5%;width: 70%;"
		/>
		<?php
			// FixIn: 10.0.0.14.
			switch ( $price_period ) {
				case 'day':
							echo '<span>/</span>';
							$price_period =   __( 'day', 'booking' );
							break;
				case 'night':
							echo '<span>/</span>';
							$price_period =   __( 'night', 'booking' );
							break;
				case 'hour':
							echo '<span>/</span>';
							$price_period =    __( 'hour', 'booking' );
							break;
				default:    echo '<span></span>';                                                            // 'fixed'
							$price_period =  __( 'fixed', 'booking' );
							break;
			}
			$price_period = '<a style="font-size:1em;padding-bottom: 2px;text-decoration-style:dotted;text-decoration-thickness: 1px;text-underline-offset: 4px;padding: 0;" 
								href="'. esc_url( wpbc_get_settings_url() ) . '&tab=payment#gateways_booking_paypal_price_period' .'">'
								. $price_period . '</a>';
		// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		echo $price_period;
		?>

	</div>
	<?php
}
add_action( 'wpbc_resources_table_show_col__cost_field',  'wpbc_resources_table_show_col__cost_field__bs', 10, 2 );


/**
	 * Show Column in Resources Table - Edit Cost
 * 
 * @param int $row_num
 * @param array $resource
 */
function wpbc_resources_table_show_col__cost_text__bs( $row_num, $resource ) {
    ?> 
    <td class="field-currency-cost">
        <?php  
            // Currency
            $currency = wpbc_get_currency_symbol_for_user( $resource['id' ] );
            $cost_text = wpbc_cost_show( $resource['cost'], array(  'currency' => 'CURRENCY_SYMBOL' ) );
            $cost_text = str_replace( 'CURRENCY_SYMBOL', $currency, $cost_text );
        ?>                
        <div class="field-currency"><?php echo esc_html( $cost_text ); ?></div>
    </td>
    <?php 
}
add_action( 'wpbc_resources_table_show_col__cost_text',  'wpbc_resources_table_show_col__cost_text__bs', 10, 2 );


/**
	 * Update SQL during Saving data at Booking > Resources page
 * 
 * @param array $sql            array(
                                                            'sql' => array(
                                                                                  'start'   => "UPDATE {$wpdb->prefix}bookingtypes SET "
                                                                                , 'params' => array( 'title = %s' )
                                                                                , 'end'    => " WHERE booking_type_id = %d"
                                                                        )
                                                            , 'values' => array(
                                                                                  $validated_value 
                                                                        )
                                                        )
 * @param int $resource_id
 * @param array $resource
 * @return string - updated SQL
 */
function wpbc_resources_table__update_sql_array__bs( $sql, $resource_id, $resource ) {
    
    // Validate Cost
    $validated_cost = WPBC_Settings_API::validate_text_post_static( 'booking_resource_cost_' . $resource_id );    
    $validated_cost = str_replace(',', '.', $validated_cost );                  // In case,  if someone was used , instead of . for decimal
    $validated_cost = floatval( $validated_cost );
    
    
    $sql['sql']['params'][] = 'cost = %s';
    $sql['values'][]        = $validated_cost;
    
    return $sql;
}
add_filter( 'wpbc_resources_table__update_sql_array', 'wpbc_resources_table__update_sql_array__bs', 10, 3 );   // Hook for validated fields.
add_filter( 'wpbc_resources_table__update_sql_cost_array', 'wpbc_resources_table__update_sql_array__bs', 10, 3 );   // Hook for validated fields.

/**
	 * Update SQL during Inserting data at Booking > Resources page
 * 
 * @param array $sql                                array(
                                                            'sql'       => array(
                                                                                  'start'      => "INSERT INTO {$wpdb->prefix}bookingtypes "
                                                                                , 'params'     => array( 'title' )    
                                                                                , 'param_types' => array( '%s' )    
                                                                        )
                                                            , 'values'  => array( $validated_title . $sufix )
                                                    )
 * @param array $params                             array( 'sufix' => $sufix )
 * @return array - updated SQL
 */
function wpbc_resources_table__add_new_sql_array__bs( $sql, $params ) {    
    return $sql;
}
add_filter( 'wpbc_resources_table__add_new_sql_array', 'wpbc_resources_table__add_new_sql_array__bs', 10, 2 );   // Hook for validated fields.