<?php
/**
 * Plugin Name: Booking Calendar Pro
 * Requires Plugins: booking
 * Plugin URI: https://wpbookingcalendar.com/demo/
 * Description: Premium version of <a href="https://wordpress.org/plugins/booking/"><strong>Booking Calendar</strong></a> plugin.
 * Version: 10.14.6
 * Author: wpdevelop, oplugins
 * Author URI: https://wpbookingcalendar.com/
 * Text Domain: booking
 * Domain Path: /languages
 * License: Commercial Plugin.
 * License URI: https://wpbookingcalendar.com/terms/
 * Requires at least: 6.5
 * Requires PHP: 5.6
 * Update URI: https://wpbookingcalendar.com/request-update/
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '<h3>Direct access to this file do not allow!</h3>' );                                                         // Exit if accessed directly.
}


if ( ! defined( 'WPBC_PRO_VERSION_TITLE' ) ) {
	define( 'WPBC_PRO_VERSION_TITLE', 'Booking Calendar Pro' );
}
if ( ! defined( 'WPBC_PRO_VERSION_NUM' ) ) {
	define( 'WPBC_PRO_VERSION_NUM', '10.14.6' );
}
if ( ! defined( 'WPBC_PRO_MIN_BC_VERSION' ) ) {
	define( 'WPBC_PRO_MIN_BC_VERSION', '10.14.6' );                                                                     // Minimum required Booking Calendar Free version.
}
if ( ! defined( 'WPBC_PRO_MINOR_UPDATE' ) ) {
	define( 'WPBC_PRO_MINOR_UPDATE', true );
}


// ---------------------------------------------------------------------------------------------------------------------
// PRIMARY URL CONSTANTS
// ---------------------------------------------------------------------------------------------------------------------

if ( ! defined( 'WPBC_PRO_FILE' ) ) {
	define( 'WPBC_PRO_FILE', __FILE__ );                                                                                // ..\home\siteurl\www\wp-content\plugins\plugin-name\wpdev-booking.php
}

if ( ! defined( 'WPBC_PRO_PLUGIN_FILENAME' ) ) {
	define( 'WPBC_PRO_PLUGIN_FILENAME', basename( __FILE__ ) );                                                         // wpdev-booking.php .
}

if ( ! defined( 'WPBC_PRO_PLUGIN_DIRNAME' ) ) {
	define( 'WPBC_PRO_PLUGIN_DIRNAME', plugin_basename( __DIR__ ) );                                                    // plugin-name .
}

if ( ! defined( 'WPBC_PRO_PLUGIN_DIR' ) ) {
	define( 'WPBC_PRO_PLUGIN_DIR', untrailingslashit( plugin_dir_path( WPBC_PRO_FILE ) ) );                             // ..\home\siteurl\www\wp-content\plugins\plugin-name
}

if ( ! defined( 'WPBC_PRO_PLUGIN_URL' ) ) {
	define( 'WPBC_PRO_PLUGIN_URL', untrailingslashit( plugins_url( '', WPBC_PRO_FILE ) ) );                             // https: //website.com/wp-content/plugins/plugin-name .
}

if ( ! defined( 'WPBC_PRO_MIN_WP_VERSION' ) ) {
	define( 'WPBC_PRO_MIN_WP_VERSION', '4.0' );                                                                         // Minimum required WP version.
}


if ( ! defined( 'WPBC_PRO_JS_IN_FOOTER' ) ) {
	define( 'WPBC_PRO_JS_IN_FOOTER', true );                                                                            // Load all  JavaScript files of plugin  at  footer or in header.
}

if ( ! defined( 'WP_PRO_MIN_WP_VERSION' ) ) {
	define( 'WP_PRO_MIN_WP_VERSION', '6.5' );                                                                           // Minimum required WP version.
}


// ---------------------------------------------------------------------------------------------------------------------
// Condition:  is installed "WordPress" >= 6.5
// ---------------------------------------------------------------------------------------------------------------------
global $wp_version;
$is_usable_wp_version = version_compare( $wp_version, WP_PRO_MIN_WP_VERSION, '>=' );  // $wp_version >= 6.5
if ( ! $is_usable_wp_version ) {

	add_action( 'admin_notices', 'wpbc_show_error__require_wp_6_5' );

	/**
	 * Show error notice about minimum WP version.
	 *
	 * @return void
	 */
	function wpbc_show_error__require_wp_6_5() {

		$message_type = 'error';
		$title        = ''; // __( 'Error', 'booking' ) . '!'; .

		global $wp_version;
		$message = sprintf(
			// translators: 1: Current Booking Calendar Pro version, 2: Minimum WordPress, 3: Current WordPress, 4: Install link.
			__( '%1$s require minimum %2$s version. You are using %3$s. Update %4$s.', 'booking' ),
			'<strong>' . WPBC_PRO_VERSION_TITLE . ' ' . WPBC_PRO_VERSION_NUM . '</strong> ',
			' <strong>WordPress ' . WP_PRO_MIN_WP_VERSION . '</strong>',
			' <strong>WordPress ' . $wp_version . '</strong>',
			' <a href="' . esc_url( self_admin_url( 'update-core.php' ) ) . '">WordPress</a>'   // current_user_can( 'update_core' ) .
		);


		$message_content  = '';
		$message_content .= '<div class="clear"></div>';
		$message_content .= '<div class="updated wpbc-settings-notice notice-' . esc_attr( $message_type ) . ' ' . esc_attr( $message_type ) . '" style="text-align:left;padding:10px;">';
		$message_content .= '<strong>' . esc_html( $title ) . '</strong> ';
		$message_content .= html_entity_decode( esc_js( $message ), ENT_QUOTES );
		$message_content .= '</div>';
		$message_content .= '<div class="clear"></div>';

		echo wp_kses_post( $message_content );
	}

	return; // Exit!
}


// ---------------------------------------------------------------------------------------------------------------------
// Condition:  is installed "Booking Calendar Free" ?
// ---------------------------------------------------------------------------------------------------------------------
add_action( 'plugins_loaded', 'wpbc_check_minimum_required_free_version' );
function wpbc_check_minimum_required_free_version(){


	$is_usable_bc_version = ( ( defined( 'WP_BK_VERSION_NUM' ) ) && ( version_compare( WP_BK_VERSION_NUM, WPBC_PRO_MIN_BC_VERSION, '>=' ) ) ); // WP_BK_VERSION_NUM >= 10.11.5 ?!
	//$is_usable_bc_version = true;
	if ( ! $is_usable_bc_version ) {

		add_action( 'admin_menu',    'wpbc_show_error___plugin_add_thickbox' );
		function wpbc_show_error___plugin_add_thickbox() {
			add_thickbox();
		}

		if ( class_exists( 'wpdev_bk_personal' ) ) {
			// If we have WP 6.5,  then  such  sitioan  of "no Booking Calendar Free version" must  not exist. But still  if we here, let  show error.
			add_action( 'admin_notices', 'wpbc_show_error__require_deactivate_old_paid_booking_calendar' );
		} else {
			// If we have WP 6.5,  then  such  sitioan  of "no Booking Calendar Free version" must  not exist. But still  if we here, let  show error.
			add_action( 'admin_notices', 'wpbc_show_error__require_booking_calendar_plugin' );

		}

		/**
		 * Show Error of requires the "Booking Calendar Free 11.0"  version.
		 *
		 * @return void
		 */
		function wpbc_show_error__require_booking_calendar_plugin() {

			$message_type = 'error';

			$title = ''; // __( 'Error', 'booking' ) . '!'; .

			$search_url_start = '<a href="' . esc_attr( self_admin_url( 'plugin-install.php?s=booking+calendar+by+oplugins&tab=search&type=term' ) ) . '">';
			$install_url = '<a  class="thickbox open-plugin-details-modal" href="' . esc_attr( self_admin_url( 'plugin-install.php?tab=plugin-information&plugin=booking&TB_iframe=true&width=772&height=435' ) ) . '" aria-label="Booking Calendar" data-title="Booking Calendar"><strong>Booking Calendar</strong></a>';

			$message = sprintf(
				// translators: 1: Current Booking Calendar Pro version, 2: Booking Calendar Free, 3: Free version number, 4: Install link, 5: Search link.
				__( '%1$s require %2$s version %3$s or newer. Install %4$s version or %5$ssearch%6$s plugin.', 'booking' ),
				'<strong>' . WPBC_PRO_VERSION_TITLE . ' ' . WPBC_PRO_VERSION_NUM . '</strong> ',
				'Booking Calendar Free',
				WPBC_PRO_MIN_BC_VERSION,
				$install_url,
				$search_url_start,
				'</a>'
			);

			echo '<style type="text/css"> .toplevel_page_wpbc .wpbc-settings-notice.notice-error { margin-top: 58px; margin-bottom: -30px; }	</style>';
			$message_content  = '';
			$message_content .= '<div class="clear"></div>';
			$message_content .= '<div class="updated wpbc-settings-notice notice-' . esc_attr( $message_type ) . ' ' . esc_attr( $message_type ) . '" style="text-align:left;padding:10px;">';
			$message_content .= '<strong>' . esc_html( $title ) . '</strong> ';
			$message_content .= html_entity_decode( esc_js( $message ), ENT_QUOTES );
			$message_content .= '</div>';
			$message_content .= '<div class="clear"></div>';

			echo wp_kses_post( $message_content );
			// echo wp_kses_post( sprintf( __( 'Install %s plugin.', 'booking' ), '<a  class="thickbox open-plugin-details-modal" target="_blank"  href="plugin-install.php?tab=plugin-information&plugin=booking-manager&TB_iframe=true&width=772&height=435" aria-label="Booking Manager" data-title="Booking Manager"><strong>Booking Manager</strong></a>' ) );
		}


		function wpbc_show_error__require_deactivate_old_paid_booking_calendar(){
			$message_type = 'error';
			$title = __( 'Error', 'booking' ) . '!';

			$version_type = 'Booking Calendar';
			if ( function_exists( 'wpbc_get_version_type__and_mu' ) ) {
				$version_type = wpbc_get_version_type__and_mu();

				switch ( $version_type ) {
					case 'personal':
						$version_type = 'Booking Calendar Personal';
						break;
					case 'biz_s':
						$version_type = 'Booking Calendar Business Small';
						break;
					case 'biz_m':
						$version_type = 'Booking Calendar Business Medium';
						break;
					case 'biz_l':
						$version_type = 'Booking Calendar Business Large';
						break;
					case 'multiuser':
						$version_type = 'Booking Calendar MultiUser';
						break;
					default:
						$version_type = 'Booking Calendar - Unknown';
				}
			}

			$message = sprintf(
				// translators: 1: Current Booking Calendar Pro version, 2: Booking Calendar.
				__( '%1$s requires that only one paid version of the plugin is active at a time. Please deactivate the old paid version: %2$s.', 'booking' ),
				'<strong>' . WPBC_PRO_VERSION_TITLE . ' ' . WPBC_PRO_VERSION_NUM . '</strong> ',
				'<strong><a href="' . esc_url( self_admin_url( 'plugins.php' ) ) . '">' . $version_type . ' ' . WP_BK_VERSION_NUM . '</a></strong> '
			);

			echo '<style type="text/css"> .toplevel_page_wpbc .wpbc-settings-notice.notice-error { margin-top: 58px; margin-bottom: -30px; }	</style>';
			$message_content  = '';
			$message_content .= '<div class="clear"></div>';
			$message_content .= '<div class="updated wpbc-settings-notice notice-' . esc_attr( $message_type ) . ' ' . esc_attr( $message_type ) . '" style="text-align:left;padding:10px;">';
			$message_content .= '<strong>' . esc_html( $title ) . '</strong> ';
			$message_content .= html_entity_decode( esc_js( $message ), ENT_QUOTES );
			$message_content .= '</div>';
			$message_content .= '<div class="clear"></div>';

			echo wp_kses_post( $message_content );
		}
		return; // Exit!
	}

}

require_once WPBC_PRO_PLUGIN_DIR . '/includes/auto-load.php';
